/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.certsrv.ug;

import com.netscape.admin.certsrv.AttrCellRenderer;
import com.netscape.admin.certsrv.CMSAdminUtil;
import com.netscape.admin.certsrv.EAdminException;
import com.netscape.admin.certsrv.LabelCellRenderer;
import com.netscape.admin.certsrv.connection.AdminConnection;
import com.netscape.admin.certsrv.ug.UserListDialog;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.JButtonFactory;
import com.sun.java.swing.BorderFactory;
import com.sun.java.swing.DefaultListModel;
import com.sun.java.swing.DefaultListSelectionModel;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JDialog;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JList;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JTable;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.ListCellRenderer;
import com.sun.java.swing.ListModel;
import com.sun.java.swing.ListSelectionModel;
import com.sun.java.swing.event.ListSelectionEvent;
import com.sun.java.swing.event.ListSelectionListener;
import com.sun.java.swing.table.TableCellRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class GroupEditor
extends JDialog
implements ActionListener,
ListSelectionListener {
    private String PREFIX = "GROUPEDITOR";
    private JFrame mParentFrame;
    private AdminConnection mConnection;
    private String mGroupName;
    private boolean mIsNewGroup = false;
    private ResourceBundle mResource;
    protected DefaultListModel mDataModel;
    protected UserListDialog mUserDialog;
    protected JScrollPane mScrollPane;
    protected JList mList;
    private JButton mOK;
    private JButton mCancel;
    private JButton mHelp;
    private JButton mAddUser;
    private JButton mDelete;
    private JTextField mGroupNameField;
    private JTextField mGroupDescField;
    private JLabel mGroupNameLabel;
    private static final String ADDHELPINDEX = "usersgroups-certsrv-add-group-dbox-help";
    private static final String EDITHELPINDEX = "usersgroups-certsrv-edit-group-dbox-help";
    private String mHelpToken;
    static /* synthetic */ Class class$com$netscape$admin$certsrv$CMSAdminResources;

    public GroupEditor(JFrame parent, AdminConnection conn) {
        super((Frame)parent, true);
        this.mParentFrame = parent;
        this.mConnection = conn;
        this.mDataModel = new DefaultListModel();
        this.mResource = ResourceBundle.getBundle((class$com$netscape$admin$certsrv$CMSAdminResources != null ? class$com$netscape$admin$certsrv$CMSAdminResources : (class$com$netscape$admin$certsrv$CMSAdminResources = GroupEditor.class$("com.netscape.admin.certsrv.CMSAdminResources"))).getName());
        ((Component)((Object)this)).setSize(360, 300);
        ((Dialog)((Object)this)).setTitle(this.mResource.getString(String.valueOf(this.PREFIX) + "_TITLE"));
        this.setLocationRelativeTo((Component)parent);
        this.getRootPane().setDoubleBuffered(true);
        this.setDisplay();
    }

    public void showDialog(String group, boolean isNew) {
        this.mGroupName = group;
        this.mIsNewGroup = isNew;
        this.mHelpToken = isNew ? ADDHELPINDEX : EDITHELPINDEX;
        this.mGroupDescField.setText("");
        this.mGroupNameField.setText("");
        this.mDataModel.clear();
        if (!this.mIsNewGroup) {
            this.mGroupNameField.setVisible(false);
            this.mGroupNameLabel.setVisible(true);
            this.mGroupNameLabel.setText(this.mGroupName);
        } else {
            this.mGroupNameField.setVisible(true);
            this.mGroupNameLabel.setVisible(false);
        }
        try {
            if (!this.mIsNewGroup) {
                this.refresh();
            }
        }
        catch (EAdminException ex) {
            CMSAdminUtil.showErrorDialog((JFrame)this.mParentFrame, (ResourceBundle)this.mResource, (String)ex.toString(), (int)0);
            return;
        }
        this.setButtons();
        ((Dialog)((Object)this)).show();
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource().equals(this.mOK)) {
            if (this.mIsNewGroup) {
                if (this.mGroupNameField.getText().trim().equals("")) {
                    CMSAdminUtil.showMessageDialog((JFrame)this.mParentFrame, (ResourceBundle)this.mResource, (String)this.PREFIX, (String)"NOGROUPNAME", (int)0);
                    return;
                }
                try {
                    this.mGroupName = this.mGroupNameField.getText().trim();
                    this.addGroup();
                }
                catch (EAdminException e) {
                    Debug.println((String)e.toString());
                    CMSAdminUtil.showErrorDialog((JFrame)this.mParentFrame, (ResourceBundle)this.mResource, (String)e.toString(), (int)0);
                    return;
                }
            }
            try {
                this.modifyGroup();
            }
            catch (EAdminException e) {
                Debug.println((String)e.toString());
                CMSAdminUtil.showErrorDialog((JFrame)this.mParentFrame, (ResourceBundle)this.mResource, (String)e.toString(), (int)0);
                return;
            }
            ((Component)((Object)this)).hide();
        }
        if (evt.getSource().equals(this.mCancel)) {
            Debug.println((String)"Cancel Pressed");
            ((Component)((Object)this)).hide();
        }
        if (evt.getSource().equals(this.mHelp)) {
            CMSAdminUtil.help((String)this.mHelpToken);
        }
        if (evt.getSource().equals(this.mAddUser)) {
            Vector<String> currentUser = new Vector<String>();
            int i = 0;
            while (i < this.mDataModel.getSize()) {
                currentUser.addElement((String)this.mDataModel.getElementAt(i));
                ++i;
            }
            try {
                NameValuePairs response = this.mConnection.search("ug", "users", new NameValuePairs());
                boolean hasNewUser = false;
                Enumeration e = response.getNames();
                while (e.hasMoreElements()) {
                    String entry = ((String)e.nextElement()).trim();
                    if (currentUser.indexOf(entry) != -1) continue;
                    hasNewUser = true;
                }
                if (!hasNewUser) {
                    CMSAdminUtil.showMessageDialog((JFrame)this.mParentFrame, (ResourceBundle)this.mResource, (String)this.PREFIX, (String)"ALLUSERS", (int)1);
                    return;
                }
            }
            catch (EAdminException e) {
                CMSAdminUtil.showErrorDialog((JFrame)this.mParentFrame, (ResourceBundle)this.mResource, (String)e.getMessage(), (int)0);
                return;
            }
            if (this.mUserDialog == null) {
                this.mUserDialog = new UserListDialog(this.mParentFrame, this.mConnection);
            }
            this.mUserDialog.showDialog(currentUser);
            if (!this.mUserDialog.isOK()) {
                return;
            }
            Vector selectedUser = this.mUserDialog.getSelectedUser();
            int i2 = 0;
            while (i2 < selectedUser.size()) {
                this.mDataModel.addElement((Object)((String)selectedUser.elementAt(i2)));
                ++i2;
            }
            this.refreshTable();
        }
        if (evt.getSource().equals(this.mDelete)) {
            if (this.mList.getSelectedIndex() < 0) {
                return;
            }
            int i = CMSAdminUtil.showConfirmDialog((JFrame)this.mParentFrame, (ResourceBundle)this.mResource, (String)this.PREFIX, (String)"DELETE", (int)2);
            if (i == 0) {
                this.deleteMember();
                Debug.println((String)"Member Deleted");
            }
            this.setButtons();
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        this.setButtons();
    }

    private void setDisplay() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel center = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        center.setLayout(gb);
        JPanel content = this.makeContentPane();
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        gbc.anchor = 11;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gb.setConstraints((Component)content, gbc);
        center.add((Component)content);
        JPanel action = this.makeActionPane();
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        gbc.anchor = 11;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbc.weightx = 1.0;
        gb.setConstraints((Component)action, gbc);
        center.add((Component)action);
        this.getContentPane().add("Center", (Component)center);
    }

    private void resizeButtons() {
        this.mAddUser = CMSAdminUtil.makeJButton((ResourceBundle)this.mResource, (String)this.PREFIX, (String)"ADDUSER", null, (ActionListener)this);
        this.mDelete = CMSAdminUtil.makeJButton((ResourceBundle)this.mResource, (String)this.PREFIX, (String)"DELETE", null, (ActionListener)this);
        JButton[] buttons = new JButton[]{this.mAddUser, this.mDelete};
        JButtonFactory.resize((JButton[])buttons);
    }

    private JPanel makeActionPane() {
        this.mOK = CMSAdminUtil.makeJButton((ResourceBundle)this.mResource, (String)this.PREFIX, (String)"OK", null, (ActionListener)this);
        this.mCancel = CMSAdminUtil.makeJButton((ResourceBundle)this.mResource, (String)this.PREFIX, (String)"CANCEL", null, (ActionListener)this);
        this.mHelp = CMSAdminUtil.makeJButton((ResourceBundle)this.mResource, (String)this.PREFIX, (String)"HELP", null, (ActionListener)this);
        JButton[] buttons = new JButton[]{this.mOK, this.mCancel, this.mHelp};
        return CMSAdminUtil.makeJButtonPanel((JButton[])buttons, (boolean)true);
    }

    private JPanel createMemberButtonPanel() {
        JButton[] buttons = new JButton[]{this.mAddUser, this.mDelete};
        return CMSAdminUtil.makeJButtonVPanel((JButton[])buttons);
    }

    private JPanel makeContentPane() {
        JPanel content = new JPanel();
        GridBagLayout gb3 = new GridBagLayout();
        content.setLayout(gb3);
        Insets insets = new Insets(6, 0, 6, 0);
        JPanel top = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        top.setLayout(gb);
        JLabel label1 = CMSAdminUtil.makeJLabel((ResourceBundle)this.mResource, (String)this.PREFIX, (String)"GROUPNAME", null);
        this.mGroupNameField = new JTextField();
        this.mGroupNameLabel = new JLabel();
        this.mGroupNameLabel.setVisible(false);
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 13;
        gbc.insets = new Insets(6, 6, 0, 0);
        top.add((Component)label1, gbc);
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(6, 6, 0, 9);
        top.add((Component)this.mGroupNameLabel, gbc);
        top.add((Component)this.mGroupNameField, gbc);
        JLabel dummy = new JLabel();
        dummy.setVisible(false);
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        top.add((Component)dummy, gbc);
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        JLabel label2 = CMSAdminUtil.makeJLabel((ResourceBundle)this.mResource, (String)this.PREFIX, (String)"GROUPDESC", null);
        this.mGroupDescField = new JTextField();
        CMSAdminUtil.addEntryField((JPanel)top, (JComponent)label2, (JComponent)this.mGroupDescField, (GridBagConstraints)gbc);
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        JLabel label3 = CMSAdminUtil.makeJLabel((ResourceBundle)this.mResource, (String)this.PREFIX, (String)"MEMBER", null);
        gbc.gridheight = 0;
        gbc.fill = 0;
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(6, 9, 6, 0);
        top.add((Component)label3, gbc);
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        gbc.anchor = 11;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.insets = CMSAdminUtil.DEFAULT_EMPTY_INSETS;
        gb3.setConstraints((Component)top, gbc);
        content.add((Component)top);
        JPanel bottom = new JPanel();
        GridBagLayout gb2 = new GridBagLayout();
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        bottom.setLayout(gb2);
        this.resizeButtons();
        this.mList = this.makeJList(this.mDataModel, 9);
        this.mList.addListSelectionListener((ListSelectionListener)this);
        this.mScrollPane = new JScrollPane((Component)this.mList, 22, 31);
        this.mList.setSelectionMode(0);
        this.mScrollPane.setBackground(Color.white);
        this.mScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        gbc.anchor = 11;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(6, 6, 6, 0);
        gb2.setConstraints((Component)this.mScrollPane, gbc);
        bottom.add((Component)this.mScrollPane);
        JPanel memberButtonPanel = this.createMemberButtonPanel();
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        gbc.anchor = 11;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(6, 0, 6, 9);
        gb2.setConstraints((Component)memberButtonPanel, gbc);
        bottom.add((Component)memberButtonPanel);
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        gbc.anchor = 11;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = CMSAdminUtil.DEFAULT_EMPTY_INSETS;
        gb3.setConstraints((Component)bottom, gbc);
        content.add((Component)bottom);
        return content;
    }

    protected void setLabelCellRenderer(JTable table, int index) {
        table.getColumnModel().getColumn(index).setCellRenderer((TableCellRenderer)new LabelCellRenderer(new JLabel()));
    }

    private void setButtons() {
        if (this.mList.getSelectedIndex() < 0) {
            this.mDelete.setEnabled(false);
        } else {
            this.mDelete.setEnabled(true);
        }
        CMSAdminUtil.repaintComp((JComponent)this.mDelete);
    }

    private void refresh() throws EAdminException {
        NameValuePairs config = new NameValuePairs();
        config.add("desc", "");
        config.add("user", "");
        config.add("group", "");
        NameValuePairs response = this.mConnection.read("ug", "groups", this.mGroupName, config);
        Debug.println((String)("Received Memebership: " + response.toString()));
        this.mGroupNameField.setText(this.mGroupName);
        this.mGroupDescField.setText(response.getValue("desc"));
        String user = response.getValue("user").trim();
        StringTokenizer tokenizer = new StringTokenizer(user, ",");
        while (tokenizer.hasMoreTokens()) {
            String user_str = tokenizer.nextToken().trim();
            this.mDataModel.addElement((Object)user_str);
        }
    }

    private void addGroup() throws EAdminException {
        NameValuePairs config = new NameValuePairs();
        config.add("desc", this.mGroupName);
        this.createUGString(config);
        this.mConnection.add("ug", "groups", this.mGroupName, config);
    }

    private void modifyGroup() throws EAdminException {
        NameValuePairs config = new NameValuePairs();
        config.add("desc", this.mGroupDescField.getText());
        this.createUGString(config);
        this.mConnection.modify("ug", "groups", this.mGroupName, config);
    }

    private void deleteMember() {
        Debug.println((String)"GroupEditor: deleteMember()");
        int i = this.mList.getSelectedIndex();
        try {
            this.mDataModel.removeElementAt(i);
        }
        catch (Exception e) {
            Debug.println((String)("GroupEditor: deleteMember()-" + e.toString()));
        }
        this.refreshTable();
    }

    private void createUGString(NameValuePairs config) {
        StringBuffer userBuf = new StringBuffer();
        if (this.mDataModel.getSize() > 0) {
            int i = 0;
            while (i < this.mDataModel.getSize()) {
                String data = (String)this.mDataModel.getElementAt(i);
                if (userBuf.length() > 0) {
                    userBuf.append(",");
                }
                userBuf.append(data);
                ++i;
            }
        }
        config.add("user", userBuf.toString());
    }

    private void refreshTable() {
    }

    public JList makeJList(DefaultListModel listModel, int visibleCount) {
        JList listbox = new JList((ListModel)listModel);
        listbox.setCellRenderer((ListCellRenderer)new AttrCellRenderer());
        listbox.setSelectionModel((ListSelectionModel)new DefaultListSelectionModel());
        listbox.setVisibleRowCount(visibleCount);
        if (listModel.size() != 0) {
            listbox.setSelectedIndex(0);
        }
        return listbox;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }
}

