/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv;

import com.netscape.admin.dirserv.CloneServer;
import com.netscape.admin.dirserv.DSACLEditor;
import com.netscape.admin.dirserv.DSAdminEvent;
import com.netscape.admin.dirserv.DSContentModel;
import com.netscape.admin.dirserv.DSFramework;
import com.netscape.admin.dirserv.DSPageFeeder;
import com.netscape.admin.dirserv.DSPreferencesTab;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IAuthenticationChangeListener;
import com.netscape.admin.dirserv.IDSAdminEventListener;
import com.netscape.admin.dirserv.StatusItemImageButton;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.task.CGITask;
import com.netscape.admin.dirserv.task.Remove;
import com.netscape.admin.dirserv.task.Start;
import com.netscape.admin.dirserv.task.Stop;
import com.netscape.management.client.IFrameworkInitializer;
import com.netscape.management.client.IMenuInfo;
import com.netscape.management.client.IMenuItem;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.IStatusItem;
import com.netscape.management.client.MenuItemSeparator;
import com.netscape.management.client.MenuItemText;
import com.netscape.management.client.StatusItemText;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.console.VersionInfo;
import com.netscape.management.client.preferences.IPreferencesTab;
import com.netscape.management.client.preferences.PreferenceManager;
import com.netscape.management.client.preferences.Preferences;
import com.netscape.management.client.topology.AbstractServerObject;
import com.netscape.management.client.topology.IRemovableServerObject;
import com.netscape.management.client.topology.NodeData;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.LDAPUtil;
import com.netscape.management.client.util.RemoteImage;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.UtilConsoleGlobals;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSchema;
import netscape.ldap.LDAPSearchResults;

public class DSAdmin
extends AbstractServerObject
implements IAuthenticationChangeListener,
IMenuInfo,
IRemovableServerObject {
    private ConsoleInfo _info;
    private ConsoleInfo _serverInfo;
    private DSFramework _framework = null;
    private DSPageFeeder _pagefeeder;
    private LDAPSchema _schema;
    private int _securityState = SECURITY_UNKNOWN;
    private StatusItemText _authid = null;
    private StatusItemImageButton _authButton = null;
    private RemoteImage _icImage = null;
    private boolean _initialized = false;
    private boolean _animate = false;
    private String _animText = "";
    protected Thread _updater = null;
    protected Vector _dsAdminEventListeners = new Vector();
    public static int SECURITY_UNKNOWN = 0;
    public static int SECURITY_DISABLE = 1;
    public static int SECURITY_ENABLE = 2;
    private static final String _imageName = "directory.gif";
    private static final String AUTH_ICON = "face.gif";
    private static final String AUTHUP = "authup.gif";
    private static final String AUTHDOWN = "authdown.gif";
    private static final String START = "start";
    private static final String STOP = "stop";
    public static ResourceSet resource = null;
    private static final String INSTANCE_DN = "cn=config";
    private boolean _removed = false;
    private String _bindDN = "cn=Directory Manager";
    private String _configAdminDN = null;

    public DSAdmin() {
        Debug.println((int)9, (String)"DSAdmin.DSAdmin: constructor");
    }

    public int getSecurityState() throws LDAPException {
        if (this._securityState == SECURITY_UNKNOWN) {
            LDAPConnection lDAPConnection = this.getServerInfo().getLDAPConnection();
            String[] stringArray = new String[]{"nsslapd-security"};
            LDAPEntry lDAPEntry = lDAPConnection.read(INSTANCE_DN, stringArray);
            String string = DSUtil.getAttrValue(lDAPEntry, stringArray[0]);
            this._securityState = string.equalsIgnoreCase("on") ? SECURITY_ENABLE : SECURITY_DISABLE;
        }
        return this._securityState;
    }

    public void setSecurityState(int n) {
        this._securityState = n;
    }

    public String getInstanceName() {
        return DSUtil.getInstanceName(this._serverInfo);
    }

    public void addDSAdminEventListener(IDSAdminEventListener iDSAdminEventListener) {
        this._dsAdminEventListeners.addElement(iDSAdminEventListener);
    }

    public void removeDSAdminEventListener(IDSAdminEventListener iDSAdminEventListener) {
        this._dsAdminEventListeners.removeElement(iDSAdminEventListener);
    }

    public void fireDSAdminEvent(int n) {
        DSAdminEvent dSAdminEvent = new DSAdminEvent(this, n);
        Enumeration enumeration = this._dsAdminEventListeners.elements();
        while (enumeration.hasMoreElements()) {
            IDSAdminEventListener iDSAdminEventListener = (IDSAdminEventListener)enumeration.nextElement();
            iDSAdminEventListener.processDSAdminEvent(dSAdminEvent);
        }
    }

    public void initialize(ConsoleInfo consoleInfo) {
        Debug.println((int)5, (String)("DSAdmin.initialize(): _removed=" + this._removed + " info=" + consoleInfo + " _info=" + this._info));
        if (!this.checkVersion(consoleInfo)) {
            return;
        }
        this._info = consoleInfo;
        this._info.setLDAPConnection((LDAPConnection)consoleInfo.getLDAPConnection().clone());
        DSUtil.setConfigConnection(this._info.getLDAPConnection());
        this._icImage = DSUtil.getPackageImage(_imageName);
        this._removed = false;
        resource = DSUtil._resource;
        this.getInfo(consoleInfo.getCurrentDN());
        super.initialize(consoleInfo);
        Debug.println((int)9, (String)("DSAdmin.initialize(): _nodeDataTable=" + this._nodeDataTable));
        Debug.println((int)9, (String)("DSAdmin.initialize(): serverProductName=" + this._nodeDataTable.get("serverProductName")));
        Debug.println((int)9, (String)("DSAdmin.initialize(): cn=" + this._nodeDataTable.get("cn")));
        Debug.println((int)9, (String)("DSAdmin.initialize(): name=" + this.getName()));
    }

    protected Vector initializeNodeDataVector(String[] stringArray) {
        int n;
        Vector vector = super.initializeNodeDataVector(stringArray);
        if (this._serverInfo != null && (n = this._serverInfo.getPort()) > 0) {
            String string = resource.getString("dsAdmin", "nsServerPort");
            vector.addElement(new NodeData("nsServerPort", string, (Object)Integer.toString(n)));
        }
        return vector;
    }

    public static String getAttrVal(LDAPEntry lDAPEntry, String string) {
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(string, LDAPUtil.getLDAPAttributeLocale());
        if (lDAPAttribute != null) {
            return LDAPUtil.flatting((LDAPAttribute)lDAPAttribute);
        }
        Debug.println((String)("Attribute " + string + " not found in " + lDAPEntry.getDN()));
        return null;
    }

    private void getInfo(String string) {
        Object object;
        Object object2;
        Object object3 = null;
        int n = 0;
        int n2 = 0;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        try {
            object2 = this._info.getLDAPConnection();
            if (object2 == null) {
                Debug.println((String)"DSAdmin.getInfo: No LDAP connection in _info");
                return;
            }
            Debug.println((int)9, (String)("DSAdmin.getInfo: Fetching " + string + " from " + this._info.getHost() + ":" + this._info.getPort()));
            object = object2.read(string);
            object3 = DSAdmin.getAttrVal(object, "serverHostName");
            String string5 = DSAdmin.getAttrVal(object, "nsServerPort");
            string2 = DSAdmin.getAttrVal(object, "nsBaseDN");
            this._bindDN = DSAdmin.getAttrVal(object, "nsBindDN");
            string3 = DSAdmin.getAttrVal(object, "nsServerID");
            string4 = DSAdmin.getAttrVal(object, "serverroot");
            if (object3 == null || string5 == null || string2 == null || string3 == null) {
                return;
            }
            try {
                n = Integer.parseInt(string5);
            }
            catch (Exception exception) {
                Debug.println((String)("DSAdmin.getInfo: Invalid nsServerPort - " + string5));
                return;
            }
            String string6 = DSAdmin.getAttrVal(object, "nsServerSecurity");
            if (string6 != null && string6.equalsIgnoreCase("on")) {
                string6 = DSAdmin.getAttrVal(object, "nsSecureServerPort");
                try {
                    n2 = Integer.parseInt(string6);
                    Debug.println((String)("DSAdmin.getInfo: using secure port " + n2));
                }
                catch (Exception exception) {
                    Debug.println((String)("DSAdmin.getInfo: Invalid nsSecureServerPort - " + string6));
                    n2 = 0;
                }
            }
            String string7 = "(uid=*)";
            String[] stringArray = new String[]{"uid"};
            String[] stringArray2 = LDAPDN.explodeDN((String)string, (boolean)false);
            String string8 = null;
            string8 = stringArray2 != null ? stringArray2[stringArray2.length - 1] : LDAPUtil.getConfigurationRoot();
            LDAPSearchResults lDAPSearchResults = object2.search(string8, 2, string7, stringArray, false);
            if (lDAPSearchResults != null && lDAPSearchResults.hasMoreElements() && (object = (LDAPEntry)lDAPSearchResults.nextElement()) != null) {
                this._configAdminDN = object.getDN();
                Debug.println((int)9, (String)("DSAdmin.getInfo: configAdminDN=" + this._configAdminDN));
            }
        }
        catch (Exception exception) {
            Debug.println((String)("DSAdmin.getInfo: Fetching " + string + " from " + this._info.getHost() + ":" + this._info.getPort() + ", " + exception));
        }
        this._serverInfo = (ConsoleInfo)this._info.clone();
        this._serverInfo.setHost((String)object3);
        this._serverInfo.setBaseDN(string2);
        if (!((String)object3).equalsIgnoreCase(this._info.getHost())) {
            try {
                object2 = DSUtil.canonicalHost((String)object3);
                object = DSUtil.canonicalHost(this._info.getHost());
                if (object2 != null && object != null && ((String)object2).equalsIgnoreCase((String)object)) {
                    object3 = object2;
                    this._info.setHost((String)object3);
                    Debug.println((int)9, (String)("DSAdmin.getInfo: setting console host to " + (String)object3));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        boolean bl = ((String)object3).equalsIgnoreCase(this._info.getHost());
        if (n2 == 0) {
            bl = bl && n == this._info.getPort();
        } else {
            boolean bl2 = bl = bl && n2 == this._info.getPort();
        }
        if (bl) {
            Debug.println((String)"DSAdmin.getInfo: cloning console connection");
            this._serverInfo.setLDAPConnection((LDAPConnection)this._info.getLDAPConnection().clone());
        } else if (n2 == 0) {
            this._serverInfo.setPort(n);
            this._serverInfo.setLDAPConnection(DSUtil.makeLDAPConnection(false));
        } else {
            this._serverInfo.setPort(n2);
            this._serverInfo.setLDAPConnection(DSUtil.makeLDAPConnection(true));
            Debug.println((String)("DSAdmin.getInfo: created an SSL connection to " + this._serverInfo.getHost() + ":" + this._serverInfo.getPort()));
        }
        Debug.println((String)("DSAdmin.getInfo: setting current DN to " + this._info.getCurrentDN()));
        this._serverInfo.put("AdminUsername", this._info.getAuthenticationDN());
        this._serverInfo.put("AdminUserPassword", this._info.getAuthenticationPassword());
        this._serverInfo.put("ServerInstance", string3);
        this._serverInfo.put("SIE", string3);
        this._serverInfo.put("InstallPath", string4);
        Debug.println((int)9, (String)("DSAdmin.getInfo: OS = " + this._info.getAdminOS()));
        Debug.println((int)9, (String)("DSAdmin.getInfo: admin URL = " + this._serverInfo.getAdminURL()));
        UtilConsoleGlobals.setAdminURL((String)this._serverInfo.getAdminURL());
        Debug.println((int)9, (String)("DSAdmin.getInfo initialized for " + this._info.getCurrentDN()));
        this.setShowServerStatus(true);
        this._initialized = true;
    }

    public ConsoleInfo getServerInfo() {
        return this._serverInfo;
    }

    public ConsoleInfo getConsoleInfo() {
        return this._info;
    }

    public void unselect(IPage iPage) {
        super.unselect(iPage);
        this.fireRemoveMenuItems(iPage, this);
    }

    public void select(IPage iPage) {
        Debug.println((String)("DSAdmin.select(): _removed=" + this._removed + " viewInstance=" + iPage + " _info=" + this._info));
        if (this._removed) {
            return;
        }
        super.select(iPage);
        Debug.println((int)9, (String)("DSAdmin.select(): viewInstance =" + this.getViewInstance()));
        this.fireAddMenuItems(iPage, this);
        if (this.getServerStatus() == 1) {
            this.fireDisableMenuItem(iPage, START);
        } else {
            this.fireDisableMenuItem(iPage, STOP);
        }
    }

    public String[] getMenuCategoryIDs() {
        return new String[]{"CONTEXT", "OBJECT"};
    }

    public IMenuItem[] getMenuItems(String string) {
        return new IMenuItem[]{new MenuItemText(START, resource.getString("menu", START), resource.getString("menu", "start-description")), new MenuItemText(STOP, resource.getString("menu", STOP), resource.getString("menu", "stop-description")), new MenuItemSeparator()};
    }

    public void actionMenuSelected(IPage iPage, IMenuItem iMenuItem) {
        if (iMenuItem.getID().equals(START)) {
            ConsoleInfo consoleInfo = this.getServerInfo();
            Start start = new Start();
            start.setConsoleInfo(consoleInfo);
            boolean bl = start.run(iPage);
            if (bl) {
                try {
                    LDAPConnection lDAPConnection = consoleInfo.getLDAPConnection();
                    lDAPConnection.connect(3, consoleInfo.getHost(), consoleInfo.getPort(), consoleInfo.getAuthenticationDN(), consoleInfo.getAuthenticationPassword());
                    DSUtil.setDefaultReferralCredentials(lDAPConnection);
                }
                catch (LDAPException lDAPException) {
                    // empty catch block
                }
                this.fireEnableMenuItem(iPage, STOP);
                this.fireDisableMenuItem(iPage, START);
            }
        } else if (iMenuItem.getID().equals(STOP)) {
            Stop stop = new Stop();
            ConsoleInfo consoleInfo = (ConsoleInfo)this.getServerInfo().clone();
            stop.setConsoleInfo(consoleInfo);
            boolean bl = stop.run(iPage);
            if (bl) {
                this.fireEnableMenuItem(iPage, START);
                this.fireDisableMenuItem(iPage, STOP);
            }
        }
    }

    public void authenticationChanged(String string, String string2, String string3, String string4) {
        Debug.println((String)("DSAdmin.authenticationChanged(): new bind DN = " + string2 + " old bind DN = " + string));
        this._serverInfo.setAuthenticationDN(string2);
        this._serverInfo.setAuthenticationPassword(string4);
        this.updateTitle();
        LDAPConnection lDAPConnection = this._serverInfo.getLDAPConnection();
        if (!string2.equalsIgnoreCase(lDAPConnection.getAuthenticationDN()) || !string4.equals(lDAPConnection.getAuthenticationPassword())) {
            try {
                Debug.println((int)5, (String)("DSAdmin.authenticationChanged(): newAuth " + string2 + " and/or password are not the same " + " as " + lDAPConnection.getAuthenticationDN()));
                if (lDAPConnection.isConnected()) {
                    Debug.println((int)5, (String)"DSAdmin.authenticationChanged(): ldc is already connected, reauthenticating");
                    lDAPConnection.authenticate(3, string2, string4);
                } else {
                    Debug.println((int)5, (String)"DSAdmin.authenticationChanged(): ldc is not connected, connecting");
                    DSUtil.reconnect(lDAPConnection);
                }
            }
            catch (LDAPException lDAPException) {
                Debug.println((String)("DSAdmin.authenticationChanged(): error: could not connect ldc " + DSUtil.format(lDAPConnection) + ":" + (Object)((Object)lDAPException)));
            }
        }
    }

    public void updateTitle() {
        String string;
        if (this._authid != null) {
            string = "";
            if (this._authButton.isSelected()) {
                string = resource.getString("statusbar", "auth", this._serverInfo.getAuthenticationDN());
                this._authButton.setToolTipText(null);
            } else {
                this._authButton.setToolTipText(this._serverInfo.getAuthenticationDN());
            }
            if (this._animate) {
                string = this._animText = DSUtil.getTTString() + "....";
            }
            this._authid.setState((Object)string);
            if (this._framework != null) {
                this._framework.changeStatusItemState((IStatusItem)this._authid);
            }
        }
        if (this._framework != null && !this._animate) {
            string = (String)this._serverInfo.get("ServerInstance");
            int n = string.indexOf(45);
            if (n > 0 && n < string.length() - 1) {
                string = string.substring(n + 1);
            }
            ((Frame)((Object)this._framework)).setTitle(this._serverInfo.getHost() + " - " + resource.getString("dialog", "configtitle") + " - " + string);
        }
    }

    private boolean startServer(IPage iPage, String string, int n, boolean bl) {
        JFrame jFrame = iPage.getFramework().getJFrame();
        LDAPConnection lDAPConnection = this.getServerInfo().getLDAPConnection();
        Debug.println((String)"DSAdmin.startServer(): begin");
        LDAPConnection lDAPConnection2 = lDAPConnection;
        synchronized (lDAPConnection2) {
            String[] stringArray;
            try {
                lDAPConnection.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            int n2 = 0;
            if (bl) {
                stringArray = new String[]{string, Integer.toString(n)};
                n2 = DSUtil.showConfirmationDialog((Component)jFrame, "start-server", stringArray, "general");
            }
            if (n2 == 0) {
                stringArray = new Start();
                ConsoleInfo consoleInfo = (ConsoleInfo)this._serverInfo.clone();
                consoleInfo.setHost(string);
                consoleInfo.setPort(n);
                consoleInfo.setLDAPConnection(lDAPConnection);
                stringArray.setConsoleInfo(consoleInfo);
                boolean bl2 = stringArray.run(iPage);
                if (bl2) {
                    try {
                        lDAPConnection.connect(string, n);
                        Debug.println((String)"DSAdmin.startServer(): end true");
                        boolean bl3 = true;
                        return bl3;
                    }
                    catch (LDAPException lDAPException) {
                        // empty catch block
                    }
                }
            }
        }
        Debug.println((String)"DSAdmin.startServer(): end false");
        return false;
    }

    public boolean run(IPage iPage) {
        boolean bl;
        String string;
        String string2;
        JFrame jFrame = iPage.getFramework().getJFrame();
        if (this._removed) {
            return false;
        }
        if (!this._initialized) {
            return false;
        }
        if (!this.checkVersion(this._info)) {
            return false;
        }
        Debug.println((String)"DSAdmin.run: begin");
        String string3 = this._serverInfo.getHost();
        int n = this._serverInfo.getPort();
        LDAPConnection lDAPConnection = this._serverInfo.getLDAPConnection();
        if (lDAPConnection == null) {
            System.err.println("DSAdmin.run: null LDAPConnection");
            return false;
        }
        boolean bl2 = false;
        LDAPConnection lDAPConnection2 = lDAPConnection;
        synchronized (lDAPConnection2) {
            if (!lDAPConnection.isConnected()) {
                try {
                    lDAPConnection.connect(string3, n);
                }
                catch (LDAPException lDAPException) {
                    Debug.println((String)("DSAdmin.run: connecting to " + string3 + ":" + n + ", " + (Object)((Object)lDAPException)));
                    bl2 = lDAPException.getLDAPResultCode() == 52 || lDAPException.getLDAPResultCode() == 81;
                }
            }
        }
        if (bl2 && !this.startServer(iPage, string3, n, true)) {
            return false;
        }
        try {
            string2 = lDAPConnection.getAuthenticationDN();
            string = lDAPConnection.getAuthenticationPassword();
            if (string2 == null) {
                string2 = this._info.getLDAPConnection().getAuthenticationDN();
            }
            if (string == null) {
                string = this._info.getLDAPConnection().getAuthenticationPassword();
            }
            lDAPConnection.authenticate(3, string2, string);
        }
        catch (LDAPException lDAPException) {
            string = this._configAdminDN;
            if (string == null || DSUtil.equalDNs(string, lDAPConnection.getAuthenticationDN())) {
                string = this._bindDN;
            }
            if (!(bl = DSUtil.reauthenticate(lDAPConnection, jFrame, null, string, null))) {
                Debug.println((String)("DSAdmin.run: user cancelled reauthentication to server " + DSUtil.format(lDAPConnection) + " after " + "trying to use auth DN " + string));
                return false;
            }
            this._serverInfo.setAuthenticationDN(lDAPConnection.getAuthenticationDN());
            this._serverInfo.setAuthenticationPassword(lDAPConnection.getAuthenticationPassword());
        }
        DSUtil.initialize(lDAPConnection, this._serverInfo.getAuthenticationDN());
        this.readServerRoot();
        ConsoleInfo.frame = null;
        this._pagefeeder = new DSPageFeeder(this, this._info, this._serverInfo);
        this._framework = new DSFramework(this, (IFrameworkInitializer)this._pagefeeder);
        this._framework.setHelpDirectory("slapd");
        ((JFrame)((Object)this._framework)).getAccessibleContext().setAccessibleDescription(resource.getString("dsAdmin", "framework-description"));
        this._pagefeeder.setFrame((JFrame)((Object)this._framework));
        this._pagefeeder.addPreferencesTab((IPreferencesTab)new DSPreferencesTab());
        this._authid = new StatusItemText("authid", "");
        string2 = PreferenceManager.getPreferenceManager((String)"Console", (String)"4.0");
        string = string2.getPreferences("General");
        bl = string.getBoolean("ShowBannerBar", true);
        this._authid.setForeground(bl ? Color.white : Color.black);
        this._authButton = new StatusItemImageButton("AUTH_BUTTON-" + this.toString(), (Icon)DSUtil.getPackageImage(AUTHUP), (Icon)DSUtil.getPackageImage(AUTHDOWN));
        this._authButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!DSAdmin.this._animate) {
                    DSAdmin.this.updateTitle();
                }
            }
        });
        this._authButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                int n;
                int n2 = mouseEvent.getModifiers();
                boolean bl = (n2 & (n = 1 | 2)) != 0;
                DSAdmin.this.setAnimation(bl);
            }
        });
        this._framework.addStatusItem(new AuthPanel(), "LF");
        this.updateTitle();
        return true;
    }

    public boolean run(IPage iPage, IResourceObject[] iResourceObjectArray) {
        return this.run(iPage);
    }

    private void setAnimation(boolean bl) {
        if (bl) {
            this.startUpdater();
        } else {
            this.stopUpdater();
        }
    }

    private void readServerRoot() {
        DSUtil.readServerRoot(this._info, this._serverInfo, null);
    }

    private void startUpdater() {
        this._animate = true;
        if (this._updater == null) {
            this._updater = new Thread(){

                public void run() {
                    while (DSAdmin.this._animate) {
                        DSAdmin.this.updateTitle();
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    DSAdmin.this._updater = null;
                }
            };
            this._updater.start();
        }
    }

    private void stopUpdater() {
        this._animate = false;
    }

    public void performAction(String string) {
        if (string.equalsIgnoreCase("acleditor")) {
            ConsoleInfo consoleInfo = this._info;
            consoleInfo.setAclDN(this._info.getCurrentDN());
            consoleInfo.setUserGroupDN("");
            DSACLEditor dSACLEditor = new DSACLEditor(consoleInfo);
            dSACLEditor.show();
        }
    }

    public Icon getIcon() {
        return this._icImage;
    }

    public int getServerStatus() {
        boolean bl;
        if (this._removed) {
            return 2;
        }
        int n = DSUtil.checkServerStatus(this._serverInfo);
        boolean bl2 = bl = n == 1;
        if (this.getViewInstance() != null) {
            this.fireDisableMenuItem(this.getViewInstance(), bl ? START : STOP);
            this.fireEnableMenuItem(this.getViewInstance(), bl ? STOP : START);
        }
        Debug.println((int)7, (String)("DSAdmin.getServerStatus(): end state = " + bl));
        return n;
    }

    public LDAPSchema getSchema() {
        return DSUtil.getSchema(this._serverInfo);
    }

    public synchronized void setSchema(LDAPSchema lDAPSchema) {
        DSUtil.setSchema(this._serverInfo, lDAPSchema);
    }

    public void dumpConsoleInfo() {
        DSUtil.dumpConsoleInfo(this._info);
    }

    public void dumpServerInfo() {
        DSUtil.dumpConsoleInfo(this._serverInfo);
    }

    public boolean isCloningEnabled() {
        return false;
    }

    public void cloneFrom(String string) {
        JFrame jFrame = UtilConsoleGlobals.getActivatedFrame();
        boolean bl = CloneServer.cloneServer(this._info.getLDAPConnection(), string, this._info.getCurrentDN(), jFrame);
    }

    public boolean removeServer() {
        JFrame jFrame = UtilConsoleGlobals.getActivatedFrame();
        Debug.println((String)"DSAdmin.removeServer: Removing server:");
        this._removed = true;
        this.dumpConsoleInfo();
        boolean bl = false;
        Remove remove = new Remove();
        Debug.println((int)9, (String)("DSAdmin.removeServer: remove task=" + (Object)((Object)remove)));
        ConsoleInfo consoleInfo = (ConsoleInfo)this._serverInfo.clone();
        remove.setConsoleInfo(consoleInfo);
        bl = ((CGITask)remove).run(null);
        String string = (String)this._serverInfo.get("ServerInstance");
        if (string == null) {
            string = "";
        }
        String[] stringArray = new String[]{string, ""};
        if (!bl) {
            this._removed = false;
            Debug.println((String)("DSAdmin:removeServer <" + string + ">"));
            stringArray[1] = resource.getString("dsAdmin", "remove-server-cgi-failed");
            DSUtil.showErrorDialog((Component)jFrame, "removeinstance", stringArray);
            return false;
        }
        LDAPConnection lDAPConnection = this._info.getLDAPConnection();
        String[] stringArray2 = new String[]{"*", "numsubordinates"};
        String string2 = this._info.getCurrentDN();
        Debug.println((String)("DSAdmin:removeServer:sieDN:" + string2));
        LDAPEntry lDAPEntry = null;
        try {
            lDAPEntry = lDAPConnection.read(string2, stringArray2);
        }
        catch (Exception exception) {
            Debug.println((String)("DSAdmin:removeServer <" + string2 + "> " + exception));
            stringArray[1] = exception.toString();
            DSUtil.showErrorDialog((Component)jFrame, "removeinstance", stringArray);
            this._removed = false;
            return false;
        }
        if (lDAPEntry != null) {
            try {
                bl = this.delete_sieTree(lDAPEntry);
            }
            catch (Exception exception) {
                Debug.println((String)"DSAdmin:removeServer:Unable to delete the tree");
                stringArray[1] = exception.toString();
                DSUtil.showErrorDialog((Component)jFrame, "removesie", stringArray);
                this._removed = false;
                return false;
            }
            bl = this.remove_serverInstance(string2);
        }
        if (!bl) {
            stringArray[1] = "";
            DSUtil.showErrorDialog((Component)jFrame, "removesie", stringArray);
        } else {
            DSUtil.showInformationDialog((Component)jFrame, "121", (String)null);
        }
        if (!bl) {
            this._removed = false;
        }
        return bl;
    }

    private boolean delete_sieTree(LDAPEntry lDAPEntry) throws LDAPException {
        LDAPConnection lDAPConnection = this._info.getLDAPConnection();
        boolean bl = false;
        String string = lDAPEntry.getDN();
        if (DSContentModel.entryHasChildren(lDAPEntry)) {
            LDAPSearchResults lDAPSearchResults = null;
            String[] stringArray = new String[]{"numsubordinates"};
            lDAPSearchResults = lDAPConnection.search(string, 1, "(objectClass=*)", stringArray, false);
            while (lDAPSearchResults.hasMoreElements()) {
                LDAPEntry lDAPEntry2 = (LDAPEntry)lDAPSearchResults.nextElement();
                bl = this.delete_sieTree(lDAPEntry2);
            }
        }
        lDAPConnection.delete(string);
        return true;
    }

    private boolean remove_serverInstance(String string) {
        LDAPSearchResults lDAPSearchResults = null;
        String string2 = (String)this._info.get("BaseDN");
        LDAPConnection lDAPConnection = this._info.getLDAPConnection();
        String[] stringArray = new String[]{"*", "uniquemember"};
        String string3 = "(&(objectclass=groupOfUniquenames)(uniquemember=" + string + "))";
        try {
            lDAPSearchResults = lDAPConnection.search(string2, 2, string3, stringArray, false);
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("Failed to search - " + lDAPException.toString()));
            return false;
        }
        LDAPEntry lDAPEntry = null;
        while (lDAPSearchResults.hasMoreElements()) {
            lDAPEntry = (LDAPEntry)lDAPSearchResults.nextElement();
            String string4 = lDAPEntry.getDN();
            this.remove_instanceFromEntry(lDAPConnection, string4, string);
        }
        return true;
    }

    private boolean remove_instanceFromEntry(LDAPConnection lDAPConnection, String string, String string2) {
        LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
        LDAPAttribute lDAPAttribute = new LDAPAttribute("uniquemember", string2);
        Debug.println((int)9, (String)("DSAdmin:remove_instanceFromEntry: Modifying entry:" + string));
        lDAPModificationSet.add(1, lDAPAttribute);
        try {
            lDAPConnection.modify(string, lDAPModificationSet);
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("Modifying " + string + ", " + (Object)((Object)lDAPException)));
            return false;
        }
        return true;
    }

    public static LDAPConnection getLDAPConnection(LDAPConnection lDAPConnection, String string, String string2, String string3, Hashtable hashtable) throws LDAPException, Exception {
        String string4;
        LDAPEntry lDAPEntry = null;
        String[] stringArray = new String[hashtable.size() + 4];
        int n = 0;
        stringArray[n++] = string2;
        stringArray[n++] = string3;
        stringArray[n++] = "nsServerSecurity";
        stringArray[n++] = "nsSecureServerPort";
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        lDAPEntry = lDAPConnection.read(string, stringArray);
        hashtable.put(string2, DSAdmin.getAttrVal(lDAPEntry, string2));
        hashtable.put(string3, DSAdmin.getAttrVal(lDAPEntry, string3));
        Enumeration enumeration2 = hashtable.keys();
        while (enumeration2.hasMoreElements()) {
            string4 = (String)enumeration2.nextElement();
            hashtable.put(string4, DSAdmin.getAttrVal(lDAPEntry, string4));
        }
        string4 = DSAdmin.getAttrVal(lDAPEntry, string2);
        int n2 = -1;
        int n3 = -1;
        String string5 = DSAdmin.getAttrVal(lDAPEntry, "nsServerSecurity");
        if (string5 != null && string5.equalsIgnoreCase("on")) {
            try {
                n3 = Integer.parseInt(DSAdmin.getAttrVal(lDAPEntry, "nsSecureServerPort"));
            }
            catch (Exception exception) {
                n3 = -1;
            }
        }
        if (n3 < 0) {
            try {
                n2 = Integer.parseInt(DSAdmin.getAttrVal(lDAPEntry, string3));
            }
            catch (Exception exception) {
                n2 = -1;
            }
        } else {
            n2 = n3;
        }
        LDAPConnection lDAPConnection2 = DSUtil.makeLDAPConnection(n3 >= 0);
        try {
            lDAPConnection2.connect(string4, n2, lDAPConnection.getAuthenticationDN(), lDAPConnection.getAuthenticationPassword());
        }
        catch (Exception exception) {
            Debug.println((String)("DSAdmin.getLDAPConnection(): could not connect to " + string4 + ":" + n2 + " as dn " + lDAPConnection.getAuthenticationDN() + ": will attempt " + "anonymous bind"));
            Debug.println((int)9, (String)("DSAdmin.getLDAPConnection(): exception " + exception));
            lDAPConnection2.connect(string4, n2, "", "");
        }
        return lDAPConnection2;
    }

    private IPage getViewInstance() {
        return this._viewInstance;
    }

    private boolean isLocalDirectoryManager() {
        Debug.println((String)"DSAdmin.isLocalDirectoryManager: begin");
        boolean bl = false;
        try {
            LDAPConnection lDAPConnection = this._serverInfo.getLDAPConnection();
            Debug.println((int)9, (String)("DSAdmin.isLocalDirectoryManager: ldc=" + DSUtil.format(lDAPConnection)));
            String[] stringArray = new String[]{"nsslapd-rootdn"};
            LDAPEntry lDAPEntry = lDAPConnection.read(INSTANCE_DN, stringArray);
            String string = DSAdmin.getAttrVal(lDAPEntry, "nsslapd-rootdn");
            if (string == null || string.length() == 0) {
                throw new LDAPException("No value for rootdn attribute", 32);
            }
            bl = DSUtil.equalDNs(lDAPConnection.getAuthenticationDN(), string);
        }
        catch (Exception exception) {
            Debug.println((String)("DSAdmin.isLocalDirectoryManager(): could not read cn=config from " + DSUtil.format(this._serverInfo.getLDAPConnection()) + " bound as " + this._serverInfo.getAuthenticationDN() + ":" + exception));
        }
        Debug.println((String)("DSAdmin.isLocalDirectoryManager: end status = " + bl));
        return bl;
    }

    private boolean checkVersion(ConsoleInfo consoleInfo) {
        String string = null;
        JFrame jFrame = UtilConsoleGlobals.getActivatedFrame();
        try {
            string = VersionInfo.getVersionNumber();
        }
        catch (Exception exception) {
            DSUtil.showErrorDialog((Component)jFrame, "neednewconsole", "4.0");
            return false;
        }
        try {
            Float f = new Float(string);
            return f != null && (double)f.floatValue() > 4.0;
        }
        catch (Exception exception) {
            DSUtil.showErrorDialog((Component)jFrame, "neednewconsole", string);
            return false;
        }
    }

    static {
        PreferenceManager preferenceManager = PreferenceManager.getPreferenceManager((String)"Console", (String)"4.0");
        Preferences preferences = preferenceManager.getPreferences("DS_MISCELLANEOUS");
        int n = preferences.getInt("CHANGE_INDICATOR_TYPE", 1);
        BlankPanel.setChangeIndicator(n);
    }

    class AuthPanel
    extends JPanel
    implements IStatusItem {
        AuthPanel() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.gridwidth = -1;
            this.add((Component)DSAdmin.this._authButton, gridBagConstraints);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets.left = 6;
            this.add((Component)DSAdmin.this._authid, gridBagConstraints);
        }

        public String getID() {
            return "AUTHPANEL";
        }

        public Component getComponent() {
            return this;
        }

        public void setState(Object object) {
            if (object instanceof Boolean) {
                DSAdmin.this._authButton.setSelected((Boolean)object);
            }
        }

        public Object getState() {
            return new Boolean(DSAdmin.this._authButton.isSelected());
        }

        public boolean isOpaque() {
            return false;
        }
    }
}

