/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.panel.GroupPanel;
import com.netscape.management.client.preferences.AbstractPreferencesTab;
import com.netscape.management.client.preferences.PreferenceManager;
import com.netscape.management.client.preferences.Preferences;
import com.netscape.management.client.util.MultilineLabel;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class DSPreferencesTab
extends AbstractPreferencesTab
implements ActionListener {
    Preferences _preferences;
    JPanel _contentPanel;
    JRadioButton _rbUseColor;
    JRadioButton _rbUseFontStyle;
    JRadioButton _rbUseNothing;
    ResourceSet _resource = DSUtil._resource;
    String _section = "DSPreferencesTab";
    public static final String PREFERENCES_GROUP = "DS_MISCELLANEOUS";
    public static final String PREFERENCES_CHANGE_INDICATOR = "CHANGE_INDICATOR_TYPE";

    public DSPreferencesTab() {
        this.setTitle(this._resource.getString(this._section, "title"));
        PreferenceManager preferenceManager = PreferenceManager.getPreferenceManager((String)"Console", (String)"4.0");
        this._preferences = preferenceManager.getPreferences(PREFERENCES_GROUP);
    }

    public void tabSelected() {
        this.buildContentPanel();
        this.setComponent(this._contentPanel);
        switch (this._preferences.getInt(PREFERENCES_CHANGE_INDICATOR, 1)) {
            case 1: {
                this._rbUseColor.setSelected(true);
                break;
            }
            case 2: {
                this._rbUseFontStyle.setSelected(true);
                break;
            }
            case 3: {
                this._rbUseNothing.setSelected(true);
            }
        }
        this.actionPerformed(null);
    }

    void buildContentPanel() {
        this._rbUseColor = new JRadioButton(this._resource.getString(this._section, "use-color"));
        this._rbUseColor.addActionListener(this);
        this._rbUseFontStyle = new JRadioButton(this._resource.getString(this._section, "use-font-style"));
        this._rbUseFontStyle.addActionListener(this);
        this._rbUseNothing = new JRadioButton(this._resource.getString(this._section, "use-nothing"));
        this._rbUseNothing.addActionListener(this);
        GroupPanel groupPanel = new GroupPanel(this._resource.getString(this._section, "group-title"), true);
        groupPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        MultilineLabel multilineLabel = new MultilineLabel(this._resource.getString(this._section, "desc"));
        groupPanel.add((Component)multilineLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.bottom = 0;
        groupPanel.add((Component)this._rbUseColor, gridBagConstraints);
        ++gridBagConstraints.gridy;
        groupPanel.add((Component)this._rbUseFontStyle, gridBagConstraints);
        ++gridBagConstraints.gridy;
        groupPanel.add((Component)this._rbUseNothing, gridBagConstraints);
        this._contentPanel = new JPanel();
        this._contentPanel.setLayout(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        this._contentPanel.add((Component)groupPanel, gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._rbUseColor);
        buttonGroup.add(this._rbUseFontStyle);
        buttonGroup.add(this._rbUseNothing);
    }

    public void okInvoked() {
        int n = this.getIndicatorTypeFromComponents();
        this._preferences.set(PREFERENCES_CHANGE_INDICATOR, n);
    }

    public void helpInvoked() {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        int n2 = this.getIndicatorTypeFromComponents();
        if (n2 != (n = this._preferences.getInt(PREFERENCES_CHANGE_INDICATOR, 1))) {
            this.fireStateChanged();
        }
        this.setRestartRequired(n2 != n);
    }

    int getIndicatorTypeFromComponents() {
        int n;
        if (this._rbUseColor.isSelected()) {
            n = 1;
        } else if (this._rbUseFontStyle.isSelected()) {
            n = 2;
        } else if (this._rbUseNothing.isSelected()) {
            n = 3;
        } else {
            int n2 = -1;
            throw new IllegalStateException("Bug");
        }
        return n;
    }
}

