/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv;

import com.netscape.admin.dirserv.DSExportImport;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.GenericProgressDialog;
import com.netscape.admin.dirserv.IEntryChangeListener;
import com.netscape.management.client.util.Debug;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;

public class DSSearchExportHelper
implements IEntryChangeListener,
Runnable,
ActionListener {
    private int _entryNumber = 0;
    private GenericProgressDialog _dlg;
    private String _base;
    private String _exportPath;
    private boolean _continue = true;
    private boolean _done = false;
    LDAPConnection _ldc;
    private String _section = "export";

    public DSSearchExportHelper(String string, LDAPConnection lDAPConnection, GenericProgressDialog genericProgressDialog, String string2) {
        this._exportPath = string;
        this._dlg = genericProgressDialog;
        this._ldc = lDAPConnection;
        this._base = string2;
        this.setupDialog();
    }

    protected void setupDialog() {
        String[] stringArray = new String[]{DSUtil.inverseAbreviateString(this._exportPath, 40)};
        this._dlg.addStep(DSUtil._resource.getString(this._section, "LDAPSearchMode-firstStep-title", stringArray));
        this._dlg.addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Cancel-GenericProgressDialog")) {
            this._continue = false;
            this._dlg.disableCancelButton();
            this._dlg.setTextInLabel(DSUtil._resource.getString(this._section, "LDAPMode-cancelled-title"));
            if (this._done) {
                this._dlg.closeCallBack();
            }
        } else if (actionEvent.getActionCommand().equals("Close-GenericProgressDialog")) {
            this._continue = false;
            if (this._done) {
                this._dlg.closeCallBack();
            }
        }
    }

    public boolean entryChanged(String string, String string2) {
        if (this._continue) {
            if (string != null) {
                ++this._entryNumber;
                if (this._entryNumber % 5 == 0) {
                    String[] stringArray = new String[]{String.valueOf(this._entryNumber), DSUtil.abreviateString(string, 30)};
                    this._dlg.setTextInLabel(DSUtil._resource.getString(this._section, "LDAPSearchMode-progressLabel-title", stringArray));
                }
            }
            return true;
        }
        return false;
    }

    public boolean entryChanged(String string) {
        return this.entryChanged(string, null);
    }

    public void run() {
        try {
            Thread.sleep(400L);
        }
        catch (Exception exception) {
            Debug.println((String)("DSSearchExportHelper.run: " + exception));
            exception.printStackTrace();
        }
        this.executeExport(this._exportPath, this._base);
    }

    private void executeExport(String string, String string2) {
        DSExportImport dSExportImport = new DSExportImport(this._ldc, string, string2, true);
        this._entryNumber = 0;
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        dSExportImport.addEntryChangeListener(this);
        dSExportImport.run();
        boolean bl = dSExportImport.getStatus();
        if (bl) {
            if (dSExportImport.getError() == 1) {
                this._dlg.closeCallBack();
            } else {
                this._dlg.stepCompleted(0);
                String[] stringArray = new String[]{Integer.toString(dSExportImport.getEntryCount())};
                this._dlg.setTextInLabel(DSUtil._resource.getString(this._section, "succeeded-msg", stringArray));
            }
        } else {
            Exception exception = dSExportImport.getException();
            Debug.println((String)("DSSearchExportHelper.executeExport " + exception));
            if (exception != null && exception instanceof LDAPException) {
                if (dSExportImport.getChainingSuffix() != null) {
                    String string3 = ((LDAPException)((Object)exception)).getLDAPErrorMessage();
                    String[] stringArray = new String[]{dSExportImport.getChainingName(), dSExportImport.getChainingSuffix(), ((LDAPException)((Object)exception)).errorCodeToString(), string3};
                    this._dlg.setTextInLabel(DSUtil._resource.getString(this._section, "failedinchaining-msg", stringArray));
                } else {
                    String string4;
                    String string5 = ((LDAPException)((Object)exception)).getLDAPErrorMessage();
                    String string6 = ((LDAPException)((Object)exception)).getMatchedDN();
                    if (string5 != null && string5.length() > 0) {
                        if (string6 != null && string6.length() > 0) {
                            String[] stringArray = new String[]{((LDAPException)((Object)exception)).errorCodeToString(), string5, string6};
                            string4 = DSUtil._resource.getString("general", "ldap-error-dn-msg", stringArray);
                        } else {
                            String[] stringArray = new String[]{((LDAPException)((Object)exception)).errorCodeToString(), string5};
                            string4 = DSUtil._resource.getString("general", "ldap-error-msg", stringArray);
                        }
                    } else {
                        string4 = ((LDAPException)((Object)exception)).errorCodeToString();
                    }
                    this._dlg.setTextInLabel(string4);
                }
            } else if (dSExportImport.getChainingSuffix() != null) {
                String[] stringArray = new String[]{dSExportImport.getChainingName(), dSExportImport.getChainingSuffix()};
                this._dlg.setTextInLabel(DSUtil._resource.getString(this._section, "failedinchainingnonldaperror-msg", stringArray));
            } else {
                this._dlg.setTextInLabel(DSUtil._resource.getString(this._section, "failed-msg"));
            }
        }
        this._done = true;
        this._dlg.waitForClose();
    }
}

