/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv;

import com.netscape.admin.dirserv.DSEntryDialog;
import com.netscape.admin.dirserv.DSResourceEditor;
import com.netscape.admin.dirserv.DSSchemaHelper;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.DatabaseConfig;
import com.netscape.admin.dirserv.DialogDisplayerAndDisposer;
import com.netscape.admin.dirserv.Helper;
import com.netscape.admin.dirserv.IAdapterInfo;
import com.netscape.admin.dirserv.UserGroupAdapter;
import com.netscape.admin.dirserv.propedit.ChooseObjectClassDialog;
import com.netscape.admin.dirserv.propedit.DSEntryPanel;
import com.netscape.admin.dirserv.propedit.DSPropertyModel;
import com.netscape.admin.dirserv.propedit.EntryPageDescription;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.ug.ResourceEditor;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ModalDialogUtil;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSchema;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.util.DN;
import netscape.ldap.util.RDN;

class EntryEditor
implements IAdapterInfo {
    LDAPConnection _ldc;
    LDAPSchema _schema;
    JFrame _frame;
    DatabaseConfig _databaseConfig;
    ResourceSet _resource = DSUtil._resource;
    String[] _allAttrs;
    String _editedObjectDn;
    LDAPEntry _createdObject;
    final String DEFAULT_NEW = this._resource.getString("EntryObject", "defaultnew");

    public EntryEditor(LDAPSchema lDAPSchema, JFrame jFrame, DatabaseConfig databaseConfig) {
        this._schema = lDAPSchema;
        this._frame = jFrame;
        this._databaseConfig = databaseConfig;
    }

    public boolean createUser(String string, LDAPConnection lDAPConnection) {
        this._createdObject = null;
        this._ldc = lDAPConnection;
        Vector vector = (Vector)ResourceEditor.getNewObjectClasses().get("newUserObjectClasses");
        return this.newPredefinedObject(vector, string);
    }

    public boolean createGroup(String string, LDAPConnection lDAPConnection) {
        this._createdObject = null;
        this._ldc = lDAPConnection;
        Vector vector = (Vector)ResourceEditor.getNewObjectClasses().get("newGroupObjectClasses");
        return this.newPredefinedObject(vector, string);
    }

    public boolean createOrganizationalUnit(String string, LDAPConnection lDAPConnection) {
        this._createdObject = null;
        this._ldc = lDAPConnection;
        Vector vector = (Vector)ResourceEditor.getNewObjectClasses().get("newOUObjectClasses");
        return this.newPredefinedObject(vector, string);
    }

    public boolean createCos(String string, LDAPConnection lDAPConnection) {
        this._createdObject = null;
        this._ldc = lDAPConnection;
        Vector<String> vector = new Vector<String>();
        vector.addElement("top");
        vector.addElement("ldapsubentry");
        vector.addElement("cossuperdefinition");
        return this.newPredefinedObject(vector, string);
    }

    public boolean createRole(String string, LDAPConnection lDAPConnection) {
        this._createdObject = null;
        this._ldc = lDAPConnection;
        Vector<String> vector = new Vector<String>();
        vector.addElement("top");
        vector.addElement("ldapsubentry");
        vector.addElement("nsroledefinition");
        return this.newPredefinedObject(vector, string);
    }

    public boolean createObject(String string, LDAPConnection lDAPConnection) {
        this._createdObject = null;
        this._ldc = lDAPConnection;
        boolean bl = false;
        ChooseObjectClassDialog chooseObjectClassDialog = new ChooseObjectClassDialog(this._frame, this._schema);
        chooseObjectClassDialog.show();
        ((Window)((Object)chooseObjectClassDialog)).dispose();
        if (!chooseObjectClassDialog.isCancel()) {
            LDAPEntry lDAPEntry;
            LDAPAttribute lDAPAttribute;
            String string2;
            String string3 = chooseObjectClassDialog.getSelectedValue();
            Vector vector = DSSchemaHelper.getObjectClassVector(string3, this._schema);
            if (this.isStandardObjectClass(vector.elements())) {
                bl = this.newPredefinedObject(vector, string);
                return bl;
            }
            Hashtable hashtable = new Hashtable();
            DSSchemaHelper.allRequiredAttributes(string3, this._schema, hashtable);
            Enumeration enumeration = hashtable.elements();
            LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
            String string4 = null;
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                lDAPAttribute = new LDAPAttribute(string2);
                if (string2.equalsIgnoreCase("objectclass")) {
                    vector = DSSchemaHelper.getObjectClassVector(string3, this._schema);
                    int n = vector.size() - 1;
                    while (n >= 0) {
                        lDAPAttribute.addValue((String)vector.elementAt(n));
                        --n;
                    }
                } else {
                    lDAPAttribute.addValue("");
                    if (string4 == null && !string2.equalsIgnoreCase("aci")) {
                        string4 = string2;
                    }
                }
                lDAPAttributeSet.add(lDAPAttribute);
            }
            if (string4 == null) {
                hashtable = new Hashtable();
                DSSchemaHelper.allOptionalAttributes(string3, this._schema, hashtable);
                enumeration = hashtable.elements();
                if (enumeration.hasMoreElements() && (string4 = (String)enumeration.nextElement()).equalsIgnoreCase("aci")) {
                    string4 = enumeration.hasMoreElements() ? (String)enumeration.nextElement() : null;
                }
            }
            if (string4 == null) {
                DSUtil.showErrorDialog((Component)this._frame, "noRDN", string3, "EntryObject");
                return false;
            }
            string2 = this.DEFAULT_NEW;
            lDAPAttribute = lDAPAttributeSet.getAttribute(string4);
            if (lDAPAttribute != null) {
                Debug.println((String)("EntryEditor.createObject: prefix attribute = " + lDAPAttribute));
                Enumeration enumeration2 = lDAPAttribute.getStringValues();
                if (enumeration2 != null && enumeration2.hasMoreElements()) {
                    string2 = (String)enumeration2.nextElement();
                    if (string2.length() < 1) {
                        string2 = this.DEFAULT_NEW;
                        lDAPAttributeSet.remove(string4);
                        lDAPAttributeSet.add(new LDAPAttribute(string4, string2));
                    }
                } else {
                    lDAPAttribute.addValue(string2);
                }
            } else {
                lDAPAttribute = new LDAPAttribute(string4, string2);
                lDAPAttributeSet.add(lDAPAttribute);
            }
            String string5 = string4 + "=" + string2;
            if (string != null && string.length() > 0) {
                lDAPEntry = new DN(string);
                lDAPEntry.addRDN(new RDN(string5));
                string5 = lDAPEntry.toRFCString();
            }
            if (this.addGeneric(lDAPEntry = new LDAPEntry(string5, lDAPAttributeSet), this._ldc)) {
                bl = true;
            }
        }
        return bl;
    }

    public boolean createRootObject(String string, LDAPConnection lDAPConnection) {
        boolean bl = false;
        boolean bl2 = false;
        if (!DSUtil.isLocalDirectoryManager(lDAPConnection)) {
            DSUtil.showInformationDialog((Component)this._frame, "addRootEntry-needtobedirectorymanager", (String[])null, "dscontentmodel");
            bl = true;
        }
        if (!bl) {
            ChooseObjectClassDialog chooseObjectClassDialog = new ChooseObjectClassDialog(this._frame, this._schema);
            chooseObjectClassDialog.show();
            ((Window)((Object)chooseObjectClassDialog)).dispose();
            if (!chooseObjectClassDialog.isCancel()) {
                Object object;
                String string2;
                String string3 = chooseObjectClassDialog.getSelectedValue();
                String[] stringArray = LDAPDN.explodeDN((String)string, (boolean)false);
                String string4 = stringArray[0].substring(0, stringArray[0].indexOf(61));
                String string5 = stringArray[0].substring(stringArray[0].indexOf(61) + 1);
                LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
                LDAPAttribute lDAPAttribute = new LDAPAttribute(string4);
                lDAPAttribute.addValue(string5);
                lDAPAttributeSet.add(lDAPAttribute);
                String[] stringArray2 = new String[]{"(targetattr != \"userPassword\") (version 3.0; acl \"Anonymous access\"; allow (read, search, compare)userdn = \"ldap:///anyone\";)", "(targetattr != \"nsroledn||aci\")(version 3.0; acl \"Allow self entry modification except for nsroledn and aci attributes\"; allow (write)userdn =\"ldap:///self\";)", "(targetattr = \"*\")(version 3.0; acl \"Configuration Adminstrator\"; allow (all) userdn = \"ldap:///" + this.getAdminDN(lDAPConnection) + "\";)", "(targetattr =\"*\")(version 3.0;acl \"Configuration Administrators Group\";allow (all) (groupdn = \"ldap:///cn=Configuration Administrators, ou=Groups, ou=TopologyManagement, o=NetscapeRoot\");)", "(targetattr = \"*\")(version 3.0; acl \"SIE Group\"; allow (all)groupdn = \"ldap:///" + string + "\";)"};
                lDAPAttribute = new LDAPAttribute("aci", stringArray2);
                lDAPAttributeSet.add(lDAPAttribute);
                Hashtable hashtable = new Hashtable();
                DSSchemaHelper.allRequiredAttributes(string3, this._schema, hashtable);
                Enumeration enumeration = hashtable.elements();
                while (enumeration.hasMoreElements()) {
                    string2 = (String)enumeration.nextElement();
                    if (string2.equalsIgnoreCase(string4)) continue;
                    lDAPAttribute = new LDAPAttribute(string2);
                    if (string2.equalsIgnoreCase("objectclass")) {
                        object = DSSchemaHelper.getObjectClassVector(string3, this._schema);
                        int n = ((Vector)object).size() - 1;
                        while (n >= 0) {
                            lDAPAttribute.addValue((String)((Vector)object).elementAt(n));
                            --n;
                        }
                    } else {
                        lDAPAttribute.addValue("");
                    }
                    lDAPAttributeSet.add(lDAPAttribute);
                }
                string2 = new LDAPEntry(string, lDAPAttributeSet);
                object = null;
                DSEntryDialog dSEntryDialog = this.doGenericDialog((LDAPEntry)string2, 0, lDAPConnection);
                if (dSEntryDialog != null) {
                    object = dSEntryDialog.getAttributes();
                }
                if (object == null) {
                    bl = true;
                }
                if (!bl) {
                    LDAPEntry lDAPEntry = new LDAPEntry(dSEntryDialog.getDN(), (LDAPAttributeSet)object);
                    bl2 = this.addObject(lDAPEntry, lDAPConnection);
                }
            }
        }
        return bl2;
    }

    public boolean editObject(String string, LDAPConnection lDAPConnection, boolean bl) {
        Object object;
        LDAPEntry lDAPEntry;
        boolean bl2 = false;
        this._editedObjectDn = null;
        this._ldc = lDAPConnection;
        if (this._allAttrs == null) {
            lDAPEntry = DSSchemaHelper.getOperationalAttributes(this._schema);
            String[] stringArray = null;
            if (lDAPEntry == null) {
                stringArray = new String[]{"*"};
            } else {
                stringArray = new String[((String[])lDAPEntry).length + 1];
                int n = 0;
                while (n < ((LDAPEntry)lDAPEntry).length) {
                    stringArray[n] = lDAPEntry[n];
                    ++n;
                }
                stringArray[((LDAPEntry)lDAPEntry).length] = "*";
            }
            this._allAttrs = stringArray;
        }
        lDAPEntry = null;
        boolean bl3 = false;
        try {
            lDAPEntry = this._ldc.read(string, this._allAttrs);
        }
        catch (LDAPException lDAPException) {
            object = new String[]{string, Helper.getLDAPErrorMessage(lDAPException)};
            DSUtil.showErrorDialog((Component)this._frame, "reading-object-error-title", "reading-object-error-msg", (String[])object, "EntryEditor");
            bl3 = true;
        }
        if (lDAPEntry != null) {
            LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("objectclass");
            if (!bl && this.isStandardObjectClass(lDAPAttribute.getStringValues())) {
                object = new ConsoleInfo();
                object.setUserLDAPConnection(this._ldc);
                object.setUserHost(this._ldc.getHost());
                object.setUserPort(this._ldc.getPort());
                object.setLDAPConnection(this._ldc);
                String string2 = this._databaseConfig.getRootSuffixForEntry(string);
                if (string2 != null) {
                    object.setUserBaseDN(string2);
                }
                DSResourceEditor dSResourceEditor = new DSResourceEditor(this._frame, (ConsoleInfo)object, lDAPEntry);
                String string3 = this._resource.getString("UserGroup", "Advanced-label");
                dSResourceEditor.registerAdvancedOption(new UserGroupAdapter((IAdapterInfo)this, string3, lDAPEntry, this._ldc));
                ((JDialog)((Object)dSResourceEditor)).getAccessibleContext().setAccessibleDescription(this._resource.getString("EntryEditor", "predefined-description"));
                dSResourceEditor.showModal();
                if (dSResourceEditor.getSaveStatus()) {
                    bl2 = true;
                    this._editedObjectDn = dSResourceEditor.getLDAPEntry().getDN();
                }
            } else {
                object = this.editGeneric(true, true, lDAPEntry, this._ldc);
                if (object != null) {
                    bl2 = true;
                    this._editedObjectDn = object.getDN();
                }
            }
        } else if (!bl3) {
            String[] stringArray = new String[]{string};
            DSUtil.showErrorDialog((Component)this._frame, "reading-object-no-rights-title", "reading-object-no-rights-msg", stringArray, "EntryEditor");
        }
        return bl2;
    }

    public LDAPEntry getCreatedObject() {
        return this._createdObject;
    }

    public String getEditedObjectDn() {
        return this._editedObjectDn;
    }

    private String getAdminDN(LDAPConnection lDAPConnection) {
        String string = "uid=admin,ou=Administrators, ou=TopologyManagement, o=NetscapeRoot";
        LDAPSearchConstraints lDAPSearchConstraints = (LDAPSearchConstraints)lDAPConnection.getSearchConstraints().clone();
        lDAPSearchConstraints.setMaxResults(0);
        String[] stringArray = new String[]{"uniquemember"};
        try {
            Enumeration enumeration;
            LDAPAttribute lDAPAttribute;
            LDAPEntry lDAPEntry = lDAPConnection.read("cn=Configuration Administrators, ou=Groups, ou=TopologyManagement, o=NetscapeRoot", stringArray, lDAPSearchConstraints);
            if (lDAPEntry != null && (lDAPAttribute = lDAPEntry.getAttribute("uniquemember")) != null && (enumeration = lDAPAttribute.getStringValues()) != null && enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("EntryEditor.getAdminDN(): " + (Object)((Object)lDAPException)));
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    private boolean isStandardObjectClass(Enumeration var1_1) {
        block1: {
            var2_2 = false;
            var3_3 = ResourceEditor.getResourceEditorExtension();
            if (var3_3 != null) ** GOTO lbl9
            Debug.println((String)"EntryEditor.isStandardObjectClass: No resourceEditorExtension in ConsoleInfo");
            break block1;
lbl-1000:
            // 1 sources

            {
                var4_4 = ((String)var1_1.nextElement()).toLowerCase();
                if (var3_3.get(var4_4) == null) continue;
                var2_2 = true;
lbl9:
                // 3 sources

                ** while (var1_1.hasMoreElements() && !var2_2)
            }
        }
        return var2_2;
    }

    protected boolean newPredefinedObject(Vector vector, String string) {
        boolean bl = false;
        ConsoleInfo consoleInfo = new ConsoleInfo();
        consoleInfo.setLDAPConnection(this._ldc);
        consoleInfo.setAuthenticationDN(this._ldc.getAuthenticationDN());
        consoleInfo.setAuthenticationPassword(this._ldc.getAuthenticationPassword());
        consoleInfo.setUserLDAPConnection(this._ldc);
        consoleInfo.setUserHost(this._ldc.getHost());
        consoleInfo.setUserPort(this._ldc.getPort());
        String string2 = this._databaseConfig.getRootSuffixForEntry(string);
        if (string2 != null) {
            consoleInfo.setUserBaseDN(string2);
        }
        consoleInfo.put("NewUserBaseDN", string);
        DSResourceEditor dSResourceEditor = null;
        try {
            dSResourceEditor = new DSResourceEditor(this._frame, consoleInfo, vector, string);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Debug.println((String)("EntryEditor.newPredefinedObject: got" + arrayIndexOutOfBoundsException + " while instantiating a resource editor"));
            JOptionPane.showMessageDialog(this._frame, this._resource.getString("EntryObject", "role-extension-error"), this._resource.getString("EntryObject", "role-extension-title"), 0);
            ModalDialogUtil.sleep();
        }
        if (dSResourceEditor != null) {
            String string3 = this._resource.getString("UserGroup", "Advanced-label");
            dSResourceEditor.registerAdvancedOption(new UserGroupAdapter((IAdapterInfo)this, string3, string, this._ldc));
            ((JDialog)((Object)dSResourceEditor)).getAccessibleContext().setAccessibleDescription(this._resource.getString("EntryEditor", "new-predefined-description"));
            dSResourceEditor.showModal();
            boolean bl2 = dSResourceEditor.getSaveStatus();
            ModalDialogUtil.disposeAndRaise((JDialog)((Object)dSResourceEditor), (Frame)this._frame);
            if (bl2) {
                bl = true;
                this._createdObject = dSResourceEditor.getLDAPEntry();
            }
        }
        return bl;
    }

    private boolean addGeneric(LDAPEntry lDAPEntry, LDAPConnection lDAPConnection) {
        LDAPAttributeSet lDAPAttributeSet = null;
        DSEntryDialog dSEntryDialog = this.doGenericDialog(lDAPEntry, 1, lDAPConnection);
        if (dSEntryDialog != null) {
            lDAPAttributeSet = dSEntryDialog.getAttributes();
        }
        if (lDAPAttributeSet == null) {
            return false;
        }
        LDAPEntry lDAPEntry2 = new LDAPEntry(dSEntryDialog.getDN(), lDAPAttributeSet);
        return this.addObject(lDAPEntry2, lDAPConnection);
    }

    private boolean addObject(LDAPEntry lDAPEntry, LDAPConnection lDAPConnection) {
        if (lDAPConnection == null) {
            Debug.println((String)"EntryEditor.addEntry: no LDAP connection");
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        while (!bl2) {
            try {
                lDAPConnection.add(lDAPEntry);
                this._createdObject = lDAPEntry;
                bl = true;
                bl2 = true;
            }
            catch (LDAPException lDAPException) {
                Debug.println((String)("EntryEditor.addObject() Adding " + lDAPEntry.getDN() + ", " + (Object)((Object)lDAPException)));
                if (lDAPException.getLDAPResultCode() == 50) {
                    DSUtil.showPermissionDialog((Component)this._frame, lDAPConnection);
                    continue;
                }
                if (lDAPException.getLDAPResultCode() == 32) {
                    DSUtil.showErrorDialog((Component)this._frame, "noParentForAdd", "", "EntryObject");
                    bl = false;
                    bl2 = true;
                    continue;
                }
                DSUtil.showLDAPErrorDialog(this._frame, lDAPException, "111-title");
                bl = false;
                bl2 = true;
            }
        }
        return bl;
    }

    private DSEntryDialog doGenericDialog(LDAPEntry lDAPEntry, int n, LDAPConnection lDAPConnection) {
        LDAPAttribute lDAPAttribute;
        LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
        int n2 = 0;
        LDAPSchema lDAPSchema = this.getSchema();
        Enumeration enumeration = lDAPAttributeSet.getAttributes();
        Vector<String> vector = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            lDAPAttribute = (LDAPAttribute)enumeration.nextElement();
            vector.addElement(lDAPAttribute.getName().toLowerCase());
        }
        lDAPAttribute = new String[vector.size()];
        String[] stringArray = new String[vector.size()];
        n2 = 0;
        while (n2 < ((LDAPAttribute)lDAPAttribute).length) {
            lDAPAttribute[n2] = (String)vector.elementAt(n2);
            ++n2;
        }
        DSUtil.trimAndBubbleSort((String[])lDAPAttribute, true);
        n2 = 0;
        while (n2 < ((LDAPAttribute)lDAPAttribute).length) {
            stringArray[n2] = lDAPAttribute[n2];
            ++n2;
        }
        EntryPageDescription entryPageDescription = new EntryPageDescription((String[])lDAPAttribute, stringArray);
        DSPropertyModel dSPropertyModel = new DSPropertyModel(this._schema, lDAPEntry, entryPageDescription);
        DSEntryPanel dSEntryPanel = new DSEntryPanel(dSPropertyModel, n, lDAPConnection);
        DSEntryDialog dSEntryDialog = new DSEntryDialog(this._frame, dSEntryPanel);
        ((Dialog)((Object)dSEntryDialog)).setTitle(this._resource.getString("EntryObject", "property-dialog-title", lDAPEntry.getDN()));
        ((JDialog)((Object)dSEntryDialog)).getAccessibleContext().setAccessibleDescription(this._resource.getString("EntryObject", "property-dialog-description", lDAPEntry.getDN()));
        ((Window)((Object)dSEntryDialog)).setLocationRelativeTo(this._frame);
        dSEntryDialog.pack();
        int n3 = ((Component)((Object)dSEntryDialog)).getHeight();
        int n4 = ((Component)((Object)dSEntryDialog)).getWidth();
        int n5 = this._frame.getHeight();
        int n6 = this._frame.getWidth();
        boolean bl = false;
        if (n5 < n3) {
            n3 = n5;
            bl = true;
        }
        if (n6 < n4) {
            n4 = n6;
            bl = true;
        }
        if (bl) {
            ((Component)((Object)dSEntryDialog)).setSize(n4, n3);
        }
        DialogDisplayerAndDisposer dialogDisplayerAndDisposer = new DialogDisplayerAndDisposer((JDialog)((Object)dSEntryDialog), this._frame);
        if (SwingUtilities.isEventDispatchThread()) {
            dialogDisplayerAndDisposer.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(dialogDisplayerAndDisposer);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (dSEntryDialog.isCancel()) {
            dSEntryDialog = null;
        }
        return dSEntryDialog;
    }

    public void setSchema(LDAPSchema lDAPSchema) {
        this._schema = lDAPSchema;
    }

    public LDAPSchema getSchema() {
        return this._schema;
    }

    public DSEntryDialog editGeneric(boolean bl, boolean bl2, LDAPEntry lDAPEntry, LDAPConnection lDAPConnection) {
        DSEntryDialog dSEntryDialog;
        block10: {
            int n = bl ? 1 : 0;
            dSEntryDialog = this.doGenericDialog(lDAPEntry, n, lDAPConnection);
            if (bl2 && dSEntryDialog != null) {
                DN dN;
                boolean bl3;
                LDAPModificationSet lDAPModificationSet = dSEntryDialog.getChanges();
                DN dN2 = new DN(lDAPEntry.getDN());
                boolean bl4 = bl3 = !dN2.equals(dN = new DN(dSEntryDialog.getDN()));
                if (bl3) {
                    try {
                        String string = dN.explodeDN(false)[0];
                        if (lDAPModificationSet != null && lDAPModificationSet.size() > 0) {
                            LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("nsuniqueid");
                            if (lDAPAttribute != null) {
                                String string2 = (String)lDAPAttribute.getStringValues().nextElement();
                                String string3 = "nsuniqueid=" + string2;
                                lDAPConnection.rename(lDAPEntry.getDN(), string3, false);
                                String string4 = dN2.getParent() != null ? string3 + ", " + dN2.getParent() : string3;
                                if (lDAPModificationSet != null && dSEntryDialog != null && !this.saveChanges(lDAPModificationSet, dSEntryDialog.getAttributes(), lDAPConnection, string4)) {
                                    String string5 = dN2.explodeDN(false)[0];
                                    lDAPConnection.rename(string4, string5, false);
                                    dSEntryDialog = null;
                                }
                                if (dSEntryDialog != null) {
                                    lDAPConnection.rename(string4, string, false);
                                }
                            }
                            break block10;
                        }
                        lDAPConnection.rename(lDAPEntry.getDN(), string, false);
                    }
                    catch (LDAPException lDAPException) {
                        String[] stringArray = new String[]{lDAPEntry.getDN(), Helper.getLDAPErrorMessage(lDAPException)};
                        DSUtil.showErrorDialog((Component)this._frame, "renaming-object-error-title", "renaming-object-error-msg", stringArray, "EntryEditor");
                    }
                } else if (lDAPModificationSet != null && !this.saveChanges(lDAPModificationSet, dSEntryDialog.getAttributes(), lDAPConnection, dSEntryDialog.getDN())) {
                    dSEntryDialog = null;
                }
            }
        }
        return dSEntryDialog;
    }

    boolean saveChanges(LDAPModificationSet lDAPModificationSet, LDAPAttributeSet lDAPAttributeSet, LDAPConnection lDAPConnection, String string) {
        boolean bl = true;
        if (lDAPModificationSet != null && lDAPModificationSet.size() > 0) {
            try {
                lDAPConnection.modify(string, lDAPModificationSet);
            }
            catch (LDAPException lDAPException) {
                Debug.println((String)("DSContentPage$EntryEditor.saveChanges Modifying " + string + ", " + (Object)((Object)lDAPException)));
                if (lDAPException.getLDAPResultCode() == 50) {
                    DSUtil.showPermissionDialog((Component)this._frame, lDAPConnection);
                    bl = false;
                }
                if (lDAPException.getLDAPResultCode() == 32) {
                    LDAPEntry lDAPEntry = new LDAPEntry(string, lDAPAttributeSet);
                    bl = this.addObject(lDAPEntry, lDAPConnection);
                }
                DSUtil.showLDAPErrorDialog(this._frame, lDAPException, "111-title");
                bl = false;
            }
        }
        return bl;
    }
}

