/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.browser;

import com.netscape.admin.dirserv.browser.AbstractNodeTask;
import com.netscape.admin.dirserv.browser.BasicNode;
import com.netscape.admin.dirserv.browser.BrowserController;
import com.netscape.admin.dirserv.browser.LDAPConnectionPool;
import com.netscape.admin.dirserv.browser.TaskAbandonException;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPInterruptedException;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPUrl;

class RefreshTask
extends AbstractNodeTask {
    public static final int QUEUED = 0;
    public static final int READING_LOCAL_ENTRY = 1;
    public static final int SOLVING_REFERRAL = 2;
    public static final int DETECTING_CHILDREN = 4;
    public static final int SEARCHING_CHILDREN = 5;
    public static final int FINISHED = 7;
    public static final int CANCELLED = 8;
    public static final int INTERRUPTED = 9;
    public static final int FAILED = 10;
    BrowserController _controller;
    int _state;
    boolean _recursive;
    LDAPEntry _localEntry;
    LDAPEntry _remoteEntry;
    LDAPUrl _remoteUrl;
    boolean _isLeafNode;
    Vector _childEntries = new Vector(50);
    boolean _differential;
    Exception _exception;
    Object _exceptionArg;

    public RefreshTask(BasicNode basicNode, BrowserController browserController, LDAPEntry lDAPEntry, boolean bl) {
        super(basicNode);
        this._controller = browserController;
        this._state = 0;
        this._recursive = bl;
        this._localEntry = lDAPEntry;
    }

    public LDAPEntry getLocalEntry() {
        return this._localEntry;
    }

    public LDAPEntry getRemoteEntry() {
        return this._remoteEntry;
    }

    public LDAPUrl getRemoteUrl() {
        return this._remoteUrl;
    }

    public boolean isLeafNode() {
        return this._isLeafNode;
    }

    public Vector getChildEntries() {
        return this._childEntries;
    }

    public boolean isDifferential() {
        return this._differential;
    }

    public Exception getException() {
        return this._exception;
    }

    public Object getExceptionArg() {
        return this._exceptionArg;
    }

    public LDAPEntry getDisplayedEntry() {
        LDAPEntry lDAPEntry = this._controller.getFollowReferrals() && this._remoteEntry != null ? this._remoteEntry : this._localEntry;
        return lDAPEntry;
    }

    public LDAPUrl getDisplayedUrl() {
        LDAPUrl lDAPUrl = this._controller.getFollowReferrals() && this._remoteUrl != null ? this._remoteUrl : this._controller.findUrlForLocalEntry(this.getNode());
        return lDAPUrl;
    }

    public boolean isInFinalState() {
        return this._state == 7 || this._state == 8 || this._state == 10 || this._state == 9;
    }

    public void run() {
        BasicNode basicNode = this.getNode();
        try {
            if (this._localEntry == null) {
                this.changeStateTo(1);
                this.runReadLocalEntry();
            }
            if (this._controller.getFollowReferrals() && RefreshTask.isReferralEntry(this._localEntry)) {
                this.changeStateTo(2);
                this.runSolveReferral();
            }
            if (basicNode.isLeaf()) {
                this.changeStateTo(4);
                this.runDetectChildren();
            }
            if (this._controller.nodeIsExpanded(basicNode) && this._recursive) {
                this.changeStateTo(5);
                this.runSearchChildren();
            }
            this.changeStateTo(7);
        }
        catch (TaskAbandonException taskAbandonException) {
            this._exception = taskAbandonException.getException();
            this._exceptionArg = taskAbandonException.getArg();
            try {
                this.changeStateTo(taskAbandonException.getState());
            }
            catch (TaskAbandonException taskAbandonException2) {
                // empty catch block
            }
        }
    }

    private void runReadLocalEntry() throws TaskAbandonException {
        BasicNode basicNode = this.getNode();
        LDAPConnection lDAPConnection = null;
        try {
            try {
                lDAPConnection = this._controller.findConnectionForLocalEntry(basicNode);
                this._localEntry = lDAPConnection.read(basicNode.getDN(), this._controller.getAttrsForRedSearch(), this._controller.getSearchConstraints());
                this.throwAbandonIfNeeded(null);
            }
            catch (LDAPException lDAPException) {
                this.throwAbandonIfNeeded((Exception)((Object)lDAPException));
                Object var5_4 = null;
                if (lDAPConnection != null) {
                    this._controller.releaseLDAPConnection(lDAPConnection);
                }
            }
            Object var5_3 = null;
            if (lDAPConnection != null) {
                this._controller.releaseLDAPConnection(lDAPConnection);
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (lDAPConnection != null) {
                this._controller.releaseLDAPConnection(lDAPConnection);
            }
            throw throwable;
        }
    }

    private void runSolveReferral() throws TaskAbandonException {
        int n = 0;
        String[] stringArray = this.getNode().getReferral();
        while (stringArray != null && n < 10) {
            this.readRemoteEntry(stringArray);
            stringArray = BrowserController.getReferral(this._remoteEntry);
            ++n;
        }
        if (stringArray != null) {
            this.throwAbandonIfNeeded((Exception)((Object)new LDAPException("Referral limit (" + n + ") reached", 97)));
        }
    }

    private void readRemoteEntry(String[] stringArray) throws TaskAbandonException {
        LDAPConnectionPool lDAPConnectionPool = this._controller.getConnectionPool();
        LDAPUrl lDAPUrl = null;
        LDAPEntry lDAPEntry = null;
        String string = null;
        Throwable throwable = null;
        String string2 = null;
        int n = 0;
        while (n < stringArray.length && lDAPEntry == null) {
            block14: {
                Object var14_13;
                LDAPConnection lDAPConnection = null;
                try {
                    try {
                        lDAPUrl = new LDAPUrl(stringArray[n]);
                        lDAPConnection = lDAPConnectionPool.getConnection(lDAPUrl);
                        string = lDAPUrl.getDN();
                        if (string == null || string.equals("")) {
                            string = this._remoteEntry != null ? this._remoteEntry.getDN() : this._localEntry.getDN();
                            lDAPUrl = new LDAPUrl(lDAPUrl.getHost(), lDAPUrl.getPort(), string, lDAPUrl.getAttributeArray(), lDAPUrl.getScope(), lDAPUrl.getFilter(), lDAPUrl.isSecure());
                        }
                        lDAPEntry = lDAPConnection.read(string, this._controller.getAttrsForBlackSearch(), this._controller.getSearchConstraints());
                        this.throwAbandonIfNeeded(null);
                    }
                    catch (LDAPInterruptedException lDAPInterruptedException) {
                        this.throwAbandonIfNeeded((Exception)((Object)lDAPInterruptedException));
                        var14_13 = null;
                        if (lDAPConnection != null) {
                            lDAPConnectionPool.releaseConnection(lDAPConnection);
                        }
                        break block14;
                    }
                    catch (MalformedURLException malformedURLException) {
                        throwable = malformedURLException;
                        string2 = stringArray[n];
                        var14_13 = null;
                        if (lDAPConnection != null) {
                            lDAPConnectionPool.releaseConnection(lDAPConnection);
                        }
                        break block14;
                    }
                    catch (LDAPException lDAPException) {
                        throwable = lDAPException;
                        string2 = stringArray[n];
                        var14_13 = null;
                        if (lDAPConnection != null) {
                            lDAPConnectionPool.releaseConnection(lDAPConnection);
                        }
                    }
                    var14_13 = null;
                    if (lDAPConnection != null) {
                        lDAPConnectionPool.releaseConnection(lDAPConnection);
                    }
                }
                catch (Throwable throwable2) {
                    var14_13 = null;
                    if (lDAPConnection != null) {
                        lDAPConnectionPool.releaseConnection(lDAPConnection);
                    }
                    throw throwable2;
                }
            }
            ++n;
        }
        if (lDAPEntry == null) {
            throw new TaskAbandonException(10, (Exception)throwable, string2);
        }
        this._remoteUrl = lDAPUrl;
        this._remoteEntry = lDAPEntry;
    }

    private void runDetectChildren() throws TaskAbandonException {
        if (this._controller.isShowContainerOnly() || !this.isNumSubOrdinatesUsable()) {
            this.runDetectChildrenManually();
        } else {
            LDAPEntry lDAPEntry = this.getDisplayedEntry();
            this._isLeafNode = BrowserController.getNumSubOrdinates(lDAPEntry) == 0;
        }
    }

    /*
     * Loose catch block
     */
    private void runDetectChildrenManually() throws TaskAbandonException {
        block13: {
            LDAPSearchResults lDAPSearchResults;
            LDAPConnection lDAPConnection;
            block14: {
                block12: {
                    BasicNode basicNode = this.getNode();
                    lDAPConnection = null;
                    lDAPSearchResults = null;
                    boolean bl = false;
                    Object var5_5 = null;
                    LDAPSearchConstraints lDAPSearchConstraints = (LDAPSearchConstraints)this._controller.getSearchConstraints().clone();
                    lDAPSearchConstraints.setMaxResults(1);
                    String[] stringArray = new String[]{"dn"};
                    lDAPConnection = this._controller.findConnectionForDisplayedEntry(basicNode);
                    lDAPSearchResults = lDAPConnection.search(this._controller.findBaseDNForChildEntries(basicNode), 1, this._controller.getChildSearchFilter(), stringArray, false, lDAPSearchConstraints);
                    this.throwAbandonIfNeeded(null);
                    if (lDAPSearchResults.hasMoreElements()) {
                        Object object = lDAPSearchResults.nextElement();
                        this._isLeafNode = !(object instanceof LDAPEntry);
                        break block12;
                    }
                    this._isLeafNode = true;
                }
                Object var10_10 = null;
                if (lDAPConnection == null) break block13;
                if (lDAPSearchResults == null) break block14;
                try {
                    lDAPConnection.abandon(lDAPSearchResults);
                }
                catch (LDAPException lDAPException) {
                    this.throwAbandonIfNeeded((Exception)((Object)lDAPException));
                }
            }
            this._controller.releaseLDAPConnection(lDAPConnection);
            {
                break block13;
                catch (LDAPException lDAPException) {
                    this.throwAbandonIfNeeded((Exception)((Object)lDAPException));
                    Object var10_11 = null;
                    if (lDAPConnection == null) break block13;
                    if (lDAPSearchResults != null) {
                        try {
                            lDAPConnection.abandon(lDAPSearchResults);
                        }
                        catch (LDAPException lDAPException2) {
                            this.throwAbandonIfNeeded((Exception)((Object)lDAPException2));
                        }
                    }
                    this._controller.releaseLDAPConnection(lDAPConnection);
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (lDAPConnection != null) {
                    if (lDAPSearchResults != null) {
                        try {
                            lDAPConnection.abandon(lDAPSearchResults);
                        }
                        catch (LDAPException lDAPException) {
                            this.throwAbandonIfNeeded((Exception)((Object)lDAPException));
                        }
                    }
                    this._controller.releaseLDAPConnection(lDAPConnection);
                }
                throw throwable;
            }
        }
    }

    private boolean isNumSubOrdinatesUsable() {
        boolean bl;
        LDAPEntry lDAPEntry = this.getDisplayedEntry();
        int n = BrowserController.getNumSubOrdinates(lDAPEntry);
        if (n == 0) {
            LDAPUrl lDAPUrl = this.getDisplayedUrl();
            bl = !this._controller.getNumSubordinateHacker().contains(lDAPUrl);
        } else {
            bl = true;
        }
        return bl;
    }

    /*
     * Loose catch block
     */
    private void runSearchChildren() throws TaskAbandonException {
        block17: {
            LDAPSearchResults lDAPSearchResults;
            LDAPConnection lDAPConnection;
            block18: {
                lDAPConnection = null;
                lDAPSearchResults = null;
                BasicNode basicNode = this.getNode();
                Object var4_4 = null;
                lDAPConnection = this._controller.findConnectionForDisplayedEntry(basicNode);
                lDAPSearchResults = lDAPConnection.search(this._controller.findBaseDNForChildEntries(basicNode), 1, this._controller.getChildSearchFilter(), this._controller.getAttrsForRedSearch(), false, this._controller.getSearchConstraints());
                while (lDAPSearchResults.hasMoreElements()) {
                    Object object = lDAPSearchResults.nextElement();
                    if (object instanceof LDAPEntry) {
                        this._childEntries.addElement(object);
                    } else if (object instanceof LDAPException) {
                        throw (LDAPException)((Object)object);
                    }
                    if (this._childEntries.size() >= 20) {
                        this.changeStateTo(5);
                        this._childEntries.removeAllElements();
                    }
                    this.throwAbandonIfNeeded(null);
                }
                Object var7_7 = null;
                if (lDAPConnection == null) break block17;
                if (lDAPSearchResults == null) break block18;
                try {
                    lDAPConnection.abandon(lDAPSearchResults);
                }
                catch (LDAPException lDAPException) {
                    this.throwAbandonIfNeeded((Exception)((Object)lDAPException));
                }
            }
            this._controller.releaseLDAPConnection(lDAPConnection);
            {
                break block17;
                catch (LDAPException lDAPException) {
                    if (lDAPException.getLDAPResultCode() != 4) {
                        this.throwAbandonIfNeeded((Exception)((Object)lDAPException));
                    }
                    Object var7_8 = null;
                    if (lDAPConnection == null) break block17;
                    if (lDAPSearchResults != null) {
                        try {
                            lDAPConnection.abandon(lDAPSearchResults);
                        }
                        catch (LDAPException lDAPException2) {
                            this.throwAbandonIfNeeded((Exception)((Object)lDAPException2));
                        }
                    }
                    this._controller.releaseLDAPConnection(lDAPConnection);
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (lDAPConnection != null) {
                    if (lDAPSearchResults != null) {
                        try {
                            lDAPConnection.abandon(lDAPSearchResults);
                        }
                        catch (LDAPException lDAPException) {
                            this.throwAbandonIfNeeded((Exception)((Object)lDAPException));
                        }
                    }
                    this._controller.releaseLDAPConnection(lDAPConnection);
                }
                throw throwable;
            }
        }
    }

    private void changeStateTo(int n) throws TaskAbandonException {
        int n2 = this._state;
        this._state = n;
        try {
            this._controller.invokeRefreshTaskDidProgress(this, n2, n);
        }
        catch (InterruptedException interruptedException) {
            this.throwAbandonIfNeeded(interruptedException);
        }
    }

    private void throwAbandonIfNeeded(Exception exception) throws TaskAbandonException {
        TaskAbandonException taskAbandonException = null;
        if (exception != null) {
            taskAbandonException = exception instanceof InterruptedException || exception instanceof LDAPInterruptedException ? new TaskAbandonException(9, exception, null) : new TaskAbandonException(10, exception, null);
        } else if (this.isCancelled()) {
            taskAbandonException = new TaskAbandonException(8, null, null);
        }
        if (taskAbandonException != null) {
            throw taskAbandonException;
        }
    }

    void dump() {
        System.out.println("=============");
        System.out.println("         node: " + this.getNode().getDN());
        System.out.println("   _recursive: " + this._recursive);
        System.out.println("_differential: " + this._differential);
        System.out.println("       _state: " + RefreshTask.stateToString(this._state));
        System.out.println("  _localEntry: " + this._localEntry);
        System.out.println(" _remoteEntry: " + this._remoteEntry);
        System.out.println("   _remoteUrl: " + this._remoteUrl);
        System.out.println("  _isLeafNode: " + this._isLeafNode);
        System.out.println("   _exception: " + this._exception);
        System.out.println("_exceptionArg: " + this._exceptionArg);
        System.out.println("=============");
    }

    static String stateToString(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "QUEUED";
                break;
            }
            case 1: {
                string = "READING_LOCAL_ENTRY";
                break;
            }
            case 2: {
                string = "SOLVING_REFERRAL";
                break;
            }
            case 4: {
                string = "DETECTING_CHILDREN";
                break;
            }
            case 5: {
                string = "SEARCHING_CHILDREN";
                break;
            }
            case 7: {
                string = "FINISHED";
                break;
            }
            case 8: {
                string = "CANCELLED";
                break;
            }
            case 9: {
                string = "INTERRUPTED";
                break;
            }
            case 10: {
                string = "FAILED";
                break;
            }
            default: {
                string = "INVALID (" + n + ")";
            }
        }
        return string;
    }

    static boolean isReferralEntry(LDAPEntry lDAPEntry) {
        Enumeration enumeration;
        boolean bl = false;
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("objectclass");
        if (lDAPAttribute != null && (enumeration = lDAPAttribute.getStringValues()) != null) {
            boolean bl2 = false;
            while (enumeration.hasMoreElements() && !bl2) {
                String string = (String)enumeration.nextElement();
                bl2 = string.equalsIgnoreCase("referral");
            }
            if (bl2) {
                bl = lDAPEntry.getAttribute("ref") != null;
            }
        }
        return bl;
    }
}

