/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.logging;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.logging.AccessLogData;
import com.netscape.admin.dirserv.logging.DSLogViewerModel;
import com.netscape.admin.dirserv.logging.LogDataClient;
import com.netscape.management.client.comm.CommClient;
import com.netscape.management.client.comm.CommRecord;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;

public class AccessLogViewerModel
extends DSLogViewerModel {
    static final int STATE_START = 0;
    static final int STATE_DATE = 1;
    static final int STATE_TIME = 2;
    static final int STATE_CONN = 3;
    static final int STATE_OP = 4;
    static final int STATE_FD = 5;
    static final int STATE_CONNECTING = 6;
    static final int STATE_DISCONNECTING = 7;
    static final int STATE_DETAIL = 8;
    private static String[] _columnIDs = new String[]{"date", "time", "connection", "operation", "details"};

    public AccessLogViewerModel(ConsoleInfo consoleInfo, String string) {
        super(consoleInfo, string);
        DSLogViewerModel._resource = DSUtil._resource;
        DSLogViewerModel._section = "accesslog-content";
        this.setLogFileName("Access");
        this.init(_columnIDs);
    }

    CommClient getCommClient() {
        return new AccessLogDataClient(this);
    }

    class AccessLogDataClient
    extends LogDataClient {
        public AccessLogDataClient(DSLogViewerModel dSLogViewerModel) {
            super(dSLogViewerModel);
        }

        protected AccessLogData parse(String string) {
            StringBuffer stringBuffer = new StringBuffer(string = DSLogViewerModel.unEscape(string));
            int n = stringBuffer.length();
            if (n < 40 || stringBuffer.charAt(0) != '[') {
                return null;
            }
            AccessLogData accessLogData = new AccessLogData();
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                char c = stringBuffer.charAt(n3);
                switch (n2) {
                    case 0: {
                        if (c != '[') break;
                        n2 = 1;
                        break;
                    }
                    case 1: {
                        if (c == ':') {
                            n2 = 2;
                            break;
                        }
                        accessLogData.date.append(c);
                        break;
                    }
                    case 2: {
                        if (c == ']') {
                            n2 = 3;
                            break;
                        }
                        if (c == '-') {
                            ++n3;
                            while (stringBuffer.charAt(n3) != ']') {
                                ++n3;
                            }
                            n2 = 3;
                            break;
                        }
                        accessLogData.time.append(c);
                        break;
                    }
                    case 3: {
                        if (c == ' ') {
                            if ((c = stringBuffer.charAt(++n3)) == 'o') {
                                n2 = 4;
                                break;
                            }
                            if (c == 'f') {
                                accessLogData.detail.append("CONNECT ");
                                accessLogData.detail.append(c);
                                n2 = 8;
                                break;
                            }
                            if (c == 'c') break;
                            n2 = 8;
                            accessLogData.detail.append(c);
                            break;
                        }
                        if (c < '0' || c > '9') break;
                        accessLogData.conn.append(c);
                        break;
                    }
                    case 4: {
                        if (c == ' ') {
                            if ((c = stringBuffer.charAt(++n3)) == 'f') {
                                accessLogData.detail.append("DISCONNECT ");
                            }
                            accessLogData.detail.append(c);
                            n2 = 8;
                            break;
                        }
                        if (c < '0' || c > '9') break;
                        accessLogData.op.append(c);
                        break;
                    }
                    case 8: {
                        accessLogData.detail.append(c);
                    }
                }
                ++n3;
            }
            return accessLogData;
        }

        public void replyHandler(InputStream inputStream, CommRecord commRecord) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            try {
                String string;
                AccessLogViewerModel.this.setNumRows(0);
                while ((string = bufferedReader.readLine()) != null) {
                    AccessLogData accessLogData = this.parse(string);
                    if (accessLogData == null) continue;
                    Object[] objectArray = new Object[]{accessLogData.date, accessLogData.time, accessLogData.conn, accessLogData.op, accessLogData.detail};
                    this._model.addRow(objectArray);
                }
            }
            catch (Exception exception) {
                Debug.println((String)exception.toString());
            }
            this.finish();
        }
    }
}

