/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.node;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.node.BackupResourceObject;
import com.netscape.admin.dirserv.node.DSResourceObject;
import com.netscape.admin.dirserv.node.DatabaseRootResourceObject;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.ChainingPluginPanel;
import com.netscape.admin.dirserv.panel.DatabaseExportPanel;
import com.netscape.admin.dirserv.panel.DatabaseImportPanel;
import com.netscape.admin.dirserv.panel.LDBMInstancePanel;
import com.netscape.admin.dirserv.panel.LDBMPluginPanel;
import com.netscape.admin.dirserv.panel.SimpleDialog;
import com.netscape.management.client.IMenuInfo;
import com.netscape.management.client.IMenuItem;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.MenuItemSeparator;
import com.netscape.management.client.MenuItemText;
import com.netscape.management.client.ResourcePage;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.RemoteImage;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchResults;

public class DatabasePluginObject
extends DSResourceObject
implements IMenuInfo,
ActionListener,
TreeExpansionListener {
    private LDAPEntry _entry = null;
    private boolean _isLeaf = false;
    private boolean _isLoaded = false;
    private boolean _isInitiallyExpanded = false;
    private static final String _dbinstImageName = "dbobj.gif";
    static final String IMPORT = "import";
    static final String EXPORT = "export";
    static final String DELETE = "delete_instance";
    static final String NEWDB = "newbackend";
    static final String INITIALIZE_BACKEND = "initializebackend";
    private static String _dbFilter;
    static final String REFRESH = "refresh";
    static final String RESTORE = "restore";
    protected String[] _categoryID;
    protected IMenuItem[] _contextMenuItems;
    protected IMenuItem[] _objectMenuItems;
    private String _pluginName;
    private boolean _isStandAloneConf;
    static final String CONFIG_MAPPING = "cn=mapping tree, cn=config";

    public DatabasePluginObject(String string, RemoteImage remoteImage, IDSModel iDSModel, LDAPEntry lDAPEntry, boolean bl) {
        super(string, remoteImage, null, iDSModel);
        Enumeration enumeration;
        Debug.println((String)("DatabasePluginObject() : entry =" + lDAPEntry.getDN()));
        this._entry = lDAPEntry;
        this._isLeaf = this._isStandAloneConf = bl;
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("nsslapd-pluginid");
        this._pluginName = lDAPAttribute == null ? string : ((enumeration = lDAPAttribute.getStringValues()).hasMoreElements() ? (String)enumeration.nextElement() : string);
    }

    public DatabasePluginObject(String string, RemoteImage remoteImage, IDSModel iDSModel, LDAPEntry lDAPEntry) {
        this(string, remoteImage, iDSModel, lDAPEntry, false);
    }

    public Component getCustomPanel() {
        if (this._panel == null) {
            this._panel = this._pluginName.compareTo("ldbm-backend") == 0 || this._pluginName.compareTo("ldbm database") == 0 ? new LDBMPluginPanel(this._model, this._entry) : (this._pluginName.compareTo("chaining database") == 0 ? new ChainingPluginPanel(this._model, this._entry) : new BlankPanel(this._model));
        }
        return this._panel;
    }

    public boolean run(IPage iPage) {
        Debug.println((String)("DatabasePluginObject.run(" + iPage.getClass().getName() + ")"));
        this.reload();
        if (super.getChildCount() != 0) {
            this.expandPath((ResourcePage)iPage);
        }
        this.refreshTree();
        return true;
    }

    public boolean run(IPage iPage, IResourceObject[] iResourceObjectArray) {
        return this.run(iPage);
    }

    public void reload() {
        Object object;
        this._model.fireChangeFeedbackCursor(null, 3);
        this.cleanTree();
        StringBuffer stringBuffer = new StringBuffer();
        RemoteImage remoteImage = DSUtil.getPackageImage(_dbinstImageName);
        LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
        LDAPAttribute lDAPAttribute = this._entry.getAttribute("nsslapd-pluginid");
        if (lDAPAttribute != null && (object = lDAPAttribute.getStringValues()).hasMoreElements()) {
            stringBuffer.append((String)object.nextElement());
        }
        object = stringBuffer.toString();
        this._isLeaf = true;
        if (!this._isStandAloneConf) {
            try {
                LDAPSearchResults lDAPSearchResults = lDAPConnection.search(this._entry.getDN(), 1, "objectclass=nsBackendInstance", null, false);
                while (lDAPSearchResults.hasMoreElements()) {
                    Object object2;
                    LDAPEntry lDAPEntry = (LDAPEntry)lDAPSearchResults.nextElement();
                    String string = lDAPEntry.getDN();
                    Debug.println((String)("Instance db: " + string));
                    LDAPAttribute lDAPAttribute2 = lDAPEntry.getAttribute("cn");
                    if (lDAPAttribute2 != null) {
                        this._isLeaf = false;
                        object2 = lDAPAttribute2.getStringValues();
                        if (object2.hasMoreElements()) {
                            string = (String)object2.nextElement();
                        }
                    }
                    if (((String)object).compareTo("ldbm-backend") != 0) continue;
                    object2 = new LdbmDatabaseObject(string, remoteImage, this._model, lDAPEntry);
                    ((DefaultMutableTreeNode)((Object)this)).add((MutableTreeNode)object2);
                }
            }
            catch (LDAPException lDAPException) {
                Debug.println((String)("DatabasePluginObject.reload: " + (Object)((Object)lDAPException)));
            }
        }
        this.refreshTree();
        this._isLoaded = true;
        this._model.fireChangeFeedbackCursor(null, 0);
    }

    public void select(IPage iPage) {
        if (!this.isLoaded()) {
            this.reload();
        }
        super.select(iPage);
    }

    public boolean isLoaded() {
        return this._isLoaded;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(REFRESH)) {
            this.reload();
            this.refreshTree();
        }
    }

    public String[] getMenuCategoryIDs() {
        if (this._categoryID == null) {
            this._categoryID = new String[]{"OBJECT", "CONTEXT"};
        }
        return this._categoryID;
    }

    public IMenuItem[] getMenuItems(String string) {
        if (string.equals("CONTEXT")) {
            if (this._contextMenuItems == null) {
                this._contextMenuItems = this.createMenuItems();
            }
            return this._contextMenuItems;
        }
        if (string.equals("OBJECT")) {
            if (this._objectMenuItems == null) {
                this._objectMenuItems = this.createMenuItems();
            }
            return this._objectMenuItems;
        }
        return null;
    }

    private IMenuItem[] createMenuItems() {
        if (!this._isStandAloneConf) {
            return new IMenuItem[]{new MenuItemText(NEWDB, DSResourceObject._resource.getString("menu", NEWDB), DSResourceObject._resource.getString("menu", "newbackend-description")), new MenuItemSeparator(), new MenuItemText(REFRESH, DSUtil._resource.getString("menu", REFRESH), DSUtil._resource.getString("menu", "refresh-description"))};
        }
        return new IMenuItem[]{new MenuItemText(REFRESH, DSUtil._resource.getString("menu", REFRESH), DSUtil._resource.getString("menu", "refresh-description"))};
    }

    public void actionMenuSelected(IPage iPage, IMenuItem iMenuItem) {
        if (iMenuItem.getID().equals(NEWDB)) {
            this._model.actionMenuSelected(iPage, iMenuItem);
            this._isLeaf = false;
            this.reload();
        }
    }

    public boolean isLeaf() {
        return this._isLeaf;
    }

    void refreshTree() {
        this._model.fireTreeStructureChanged(this);
    }

    private void expandPath(ResourcePage resourcePage) {
        TreePath treePath = new TreePath(((DefaultMutableTreeNode)((Object)this)).getPath());
        resourcePage.expandTreePath(treePath);
    }

    private void cleanTree() {
        ((DefaultMutableTreeNode)((Object)this)).removeAllChildren();
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        IResourceObject iResourceObject = (IResourceObject)treeExpansionEvent.getPath().getLastPathComponent();
        if (this.equals(iResourceObject) && !this._isInitiallyExpanded) {
            this._isInitiallyExpanded = true;
            Debug.println((String)"PluginResourceObject.treeExpanded: this");
            if (!this.isLoaded()) {
                this.reload();
            }
        }
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
    }

    class LdbmDatabaseObject
    extends DSResourceObject
    implements IMenuInfo {
        protected String[] _categoryID;
        protected IMenuItem[] _contextMenuItems;
        protected IMenuItem[] _objectMenuItems;
        private LDAPEntry _entry = null;
        private boolean _bckLoaded = false;
        private String _backendname;
        protected String _section = "";
        static final String SECTION = "deletedb";
        static final int YES = 0;
        static final int NO = 1;

        public LdbmDatabaseObject(String string, RemoteImage remoteImage, IDSModel iDSModel, LDAPEntry lDAPEntry) {
            super(string, remoteImage, null, iDSModel);
            this._entry = lDAPEntry;
            this._backendname = string;
        }

        public Component getCustomPanel() {
            if (this._panel == null) {
                this._panel = new LDBMInstancePanel(this._model, this._entry);
            }
            return this._panel;
        }

        public void deleteInstance(LDAPEntry lDAPEntry, String string) {
            Object object;
            String[] stringArray = new String[]{string};
            int n = DSUtil.showConfirmationDialog(null, "confirm-bck", stringArray, SECTION);
            if (n == 1) {
                return;
            }
            LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
            String string2 = lDAPEntry.getDN();
            Debug.println((String)"+++++++++++++++ Starting delete mapping tree ++++++++++");
            try {
                object = lDAPConnection.search(DatabasePluginObject.CONFIG_MAPPING, 2, "nsslapd-backend=" + string, null, false);
                while (object.hasMoreElements()) {
                    boolean bl = false;
                    LDAPEntry lDAPEntry2 = (LDAPEntry)object.nextElement();
                    String string3 = lDAPEntry2.getDN();
                    Debug.println((String)("Instance db: " + string3));
                    LDAPAttribute lDAPAttribute = lDAPEntry2.getAttribute("nsslapd-status");
                    if (lDAPAttribute != null) {
                        Debug.println((String)("Node type : " + lDAPAttribute.getStringValueArray()[0]));
                        bl = lDAPAttribute.getStringValueArray()[0].compareToIgnoreCase("backend") == 0;
                    } else {
                        bl = true;
                    }
                    LDAPAttribute lDAPAttribute2 = lDAPEntry2.getAttribute("nsslapd-backend");
                    Debug.println((String)(" attr_db:" + lDAPAttribute2));
                    if (lDAPAttribute2 != null && lDAPAttribute2.size() == 1 && bl) {
                        this.deleteTree(string3);
                        continue;
                    }
                    LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
                    LDAPAttribute lDAPAttribute3 = new LDAPAttribute("nsslapd-backend", string);
                    lDAPModificationSet.add(1, lDAPAttribute3);
                    String[] stringArray2 = new String[]{string, string3};
                    n = DSUtil.showConfirmationDialog(null, "confirm-mapping", stringArray2, SECTION);
                    if (n != 0) continue;
                    try {
                        lDAPConnection.modify(string3, lDAPModificationSet);
                    }
                    catch (LDAPException lDAPException) {
                        String[] stringArray3 = new String[]{string, string3, lDAPException.toString()};
                        DSUtil.showErrorDialog((Component)this._model.getFrame(), "mod-mapping", stringArray3, SECTION);
                    }
                }
            }
            catch (LDAPException lDAPException) {
                String[] stringArray4 = new String[]{string, lDAPException.toString()};
                DSUtil.showErrorDialog((Component)this._model.getFrame(), "search-mapping", stringArray4, SECTION);
            }
            if (this.deleteTree(string2)) {
                object = ((DefaultMutableTreeNode)((Object)this)).getParent();
                if (object instanceof DatabaseRootResourceObject) {
                    ((DatabaseRootResourceObject)object).reload();
                } else if (object instanceof DatabasePluginObject) {
                    ((DatabasePluginObject)object).reload();
                }
            }
        }

        private boolean deleteTree(String string) {
            return this.deleteTree(string, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean deleteTree(String string, boolean bl) {
            String[] stringArray2;
            LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
            Debug.println((String)("deleting : " + string));
            String[] stringArray = new String[]{string};
            int n = bl ? DSUtil.showConfirmationDialog(null, "confirm-inst", string, SECTION) : 0;
            if (n != 0) return false;
            try {
                LDAPSearchResults lDAPSearchResults = lDAPConnection.search(string, 1, "(|(objectclass=*)(objectclass=ldapsubentry))", null, false);
                while (lDAPSearchResults.hasMoreElements()) {
                    stringArray2 = (String[])lDAPSearchResults.nextElement();
                    String string2 = stringArray2.getDN();
                    this.deleteTree(string2, false);
                }
            }
            catch (LDAPException lDAPException) {
                String[] stringArray3 = new String[]{string, lDAPException.toString()};
                DSUtil.showErrorDialog((Component)this._model.getFrame(), "search-sub", stringArray3, SECTION);
                return false;
            }
            try {
                lDAPConnection.delete(string);
                Debug.println((String)("..........." + string + " deleted"));
                return true;
            }
            catch (LDAPException lDAPException) {
                stringArray2 = new String[]{string, lDAPException.toString()};
                DSUtil.showErrorDialog((Component)this._model.getFrame(), "remove", stringArray2, SECTION);
                return false;
            }
        }

        public void select(IPage iPage) {
            Debug.println((String)("LdbmDatabaseObject.select(" + iPage.getClass().getName() + ")"));
            if (!this._bckLoaded) {
                ((DefaultMutableTreeNode)((Object)this)).add((MutableTreeNode)((Object)new BackupResourceObject(this._model)));
                this._bckLoaded = true;
            }
        }

        public boolean run(IPage iPage) {
            Debug.println((String)("LdbmDatabaseObject.run(" + iPage.getClass().getName() + ")"));
            return true;
        }

        public String[] getMenuCategoryIDs() {
            if (this._categoryID == null) {
                this._categoryID = new String[]{"OBJECT", "CONTEXT"};
            }
            return this._categoryID;
        }

        public IMenuItem[] getMenuItems(String string) {
            if (string.equals("CONTEXT")) {
                if (this._contextMenuItems == null) {
                    this._contextMenuItems = this.createMenuItems();
                }
                return this._contextMenuItems;
            }
            if (string.equals("OBJECT")) {
                if (this._objectMenuItems == null) {
                    this._objectMenuItems = this.createMenuItems();
                }
                return this._objectMenuItems;
            }
            return null;
        }

        private IMenuItem[] createMenuItems() {
            return new IMenuItem[]{new MenuItemText(DatabasePluginObject.DELETE, DSResourceObject._resource.getString("menu", "delete"), DSResourceObject._resource.getString("menu", "delete-description"))};
        }

        public void actionMenuSelected(IPage iPage, IMenuItem iMenuItem) {
            if (iMenuItem.getID().equals(DatabasePluginObject.EXPORT)) {
                this.exportInstance(this._backendname);
            } else if (iMenuItem.getID().equals(DatabasePluginObject.IMPORT)) {
                this._model.actionMenuSelected(iPage, iMenuItem);
            } else if (iMenuItem.getID().equals(DatabasePluginObject.DELETE)) {
                this.deleteInstance(this._entry, this._backendname);
            } else if (iMenuItem.getID().equals(DatabasePluginObject.INITIALIZE_BACKEND)) {
                this.initializeBackend(this._backendname);
            }
        }

        private void initializeBackend(String string) {
            DatabaseImportPanel databaseImportPanel = new DatabaseImportPanel(this._model, string);
            SimpleDialog simpleDialog = new SimpleDialog(this._model.getFrame(), databaseImportPanel.getTitle(), 11, databaseImportPanel);
            simpleDialog.setComponent(databaseImportPanel);
            simpleDialog.setOKButtonEnabled(false);
            simpleDialog.setDefaultButton(1);
            simpleDialog.packAndShow();
        }

        private void exportInstance(String string) {
            DatabaseExportPanel databaseExportPanel = new DatabaseExportPanel(this._model, string);
            SimpleDialog simpleDialog = new SimpleDialog(this._model.getFrame(), databaseExportPanel.getTitle(), 11, databaseExportPanel);
            simpleDialog.setComponent(databaseExportPanel);
            simpleDialog.setOKButtonEnabled(false);
            simpleDialog.setDefaultButton(1);
            simpleDialog.packAndShow();
        }
    }
}

