/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.node;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.GenericProgressDialog;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.node.DSResourceObject;
import com.netscape.admin.dirserv.node.SuffixResourceObject;
import com.netscape.admin.dirserv.panel.DatabaseExportPanel;
import com.netscape.admin.dirserv.panel.DatabaseImportPanel;
import com.netscape.admin.dirserv.panel.LDBMInstancePanel;
import com.netscape.admin.dirserv.panel.SimpleDialog;
import com.netscape.management.client.IMenuInfo;
import com.netscape.management.client.IMenuItem;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.MenuItemSeparator;
import com.netscape.management.client.MenuItemText;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.RemoteImage;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;

public class LDBMDatabaseObject
extends DSResourceObject
implements IMenuInfo,
ActionListener {
    protected String[] _categoryID;
    protected IMenuItem[] _contextMenuItems;
    protected IMenuItem[] _objectMenuItems;
    private boolean _isLeaf = true;
    private boolean _isLoaded = false;
    private boolean _isInitiallyExpanded = false;
    private static final String _dbinstImageName = "dbobj.gif";
    private LDAPEntry _entry = null;
    private boolean _bckLoaded = false;
    private String _backendname;
    protected String _section = "";
    static final String SECTION = "deletedb";
    static final int YES = 0;
    static final int NO = 1;
    static final String IMPORT = "import";
    static final String EXPORT = "export";
    static final String DELETE = "delete_instance";
    static final String INITIALIZE_BACKEND = "initializebackend";
    static final String REFRESH = "refresh";
    static final String DISABLE = "Disabled";

    public LDBMDatabaseObject(String string, RemoteImage remoteImage, IDSModel iDSModel, LDAPEntry lDAPEntry) {
        super(string, remoteImage, null, iDSModel);
        this._entry = lDAPEntry;
        this._backendname = string;
        this._isLeaf = true;
    }

    public Component getCustomPanel() {
        if (this._panel == null) {
            this._panel = new LDBMInstancePanel(this._model, this._entry);
        }
        return this._panel;
    }

    public void deleteInstance(LDAPEntry lDAPEntry, String string) {
        String[] stringArray = new String[]{string};
        int n = DSUtil.showConfirmationDialog(null, "confirm-bck", stringArray, SECTION);
        if (n == 1) {
            return;
        }
        LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
        GenericProgressDialog genericProgressDialog = new GenericProgressDialog(this._model.getFrame(), true, 1, DSResourceObject._resource.getString(SECTION, "del-ldbm-title", stringArray), null, null);
        genericProgressDialog.addStep(DSResourceObject._resource.getString(SECTION, "del-ldbm-upd-suffix-label"));
        genericProgressDialog.addStep(DSResourceObject._resource.getString(SECTION, "del-ldbm-db-label"));
        try {
            erase_ldbm erase_ldbm2 = new erase_ldbm(lDAPConnection, lDAPEntry, string, genericProgressDialog);
            Thread thread = new Thread(erase_ldbm2);
            thread.start();
            genericProgressDialog.packAndShow();
        }
        catch (Exception exception) {
            Debug.println((String)("deleteInstance(): " + exception.toString()));
            return;
        }
    }

    public void select(IPage iPage) {
        super.select(iPage);
    }

    public boolean run(IPage iPage) {
        Debug.println((String)("LDBMDatabaseObject.run(" + iPage.getClass().getName() + ")"));
        return true;
    }

    public boolean isLoaded() {
        return this._isLoaded;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block4: {
            if (actionEvent.getActionCommand().equals(REFRESH)) {
                LDAPEntry lDAPEntry = null;
                LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
                try {
                    lDAPEntry = lDAPConnection.read(this._entry.getDN());
                }
                catch (LDAPException lDAPException) {
                    Debug.println((String)("LDBMDatabaseObject.actionPerformed() " + (Object)((Object)lDAPException)));
                    if (lDAPException.getLDAPResultCode() != 32) break block4;
                    TreeNode treeNode = ((DefaultMutableTreeNode)((Object)this)).getParent();
                    if (treeNode instanceof SuffixResourceObject) {
                        ((SuffixResourceObject)((Object)treeNode)).reload();
                        ((SuffixResourceObject)((Object)treeNode)).refreshTree();
                    }
                    this._panel = null;
                }
            }
        }
    }

    public String[] getMenuCategoryIDs() {
        if (this._categoryID == null) {
            this._categoryID = new String[]{"OBJECT", "CONTEXT"};
        }
        return this._categoryID;
    }

    public IMenuItem[] getMenuItems(String string) {
        if (string.equals("CONTEXT")) {
            if (this._contextMenuItems == null) {
                this._contextMenuItems = this.createMenuItems();
            }
            return this._contextMenuItems;
        }
        if (string.equals("OBJECT")) {
            if (this._objectMenuItems == null) {
                this._objectMenuItems = this.createMenuItems();
            }
            return this._objectMenuItems;
        }
        return null;
    }

    private IMenuItem[] createMenuItems() {
        return new IMenuItem[]{new MenuItemText(INITIALIZE_BACKEND, DSResourceObject._resource.getString("menu", INITIALIZE_BACKEND), DSResourceObject._resource.getString("menu", "initializebackend-description")), new MenuItemText(EXPORT, DSResourceObject._resource.getString("menu", "exportbackend"), DSResourceObject._resource.getString("menu", "exportbackend-description")), new MenuItemText(DELETE, DSResourceObject._resource.getString("menu", "delete"), DSResourceObject._resource.getString("menu", "delete-description")), new MenuItemSeparator(), new MenuItemText(REFRESH, DSUtil._resource.getString("menu", REFRESH), DSUtil._resource.getString("menu", "refresh-description"))};
    }

    public void actionMenuSelected(IPage iPage, IMenuItem iMenuItem) {
        if (iMenuItem.getID().equals(REFRESH)) {
            ((IMenuInfo)this._model).actionMenuSelected(iPage, iMenuItem);
        } else if (iMenuItem.getID().equals(EXPORT)) {
            this.exportInstance(this._backendname);
        } else if (iMenuItem.getID().equals(IMPORT)) {
            this._model.actionMenuSelected(iPage, iMenuItem);
        } else if (iMenuItem.getID().equals(DELETE)) {
            this.deleteInstance(this._entry, this._backendname);
        } else if (iMenuItem.getID().equals(INITIALIZE_BACKEND)) {
            this.initializeBackend(this._backendname);
        }
    }

    private void initializeBackend(String string) {
        DatabaseImportPanel databaseImportPanel = new DatabaseImportPanel(this._model, string);
        SimpleDialog simpleDialog = new SimpleDialog(this._model.getFrame(), databaseImportPanel.getTitle(), 11, databaseImportPanel);
        simpleDialog.setComponent(databaseImportPanel);
        simpleDialog.setOKButtonEnabled(false);
        simpleDialog.setDefaultButton(1);
        simpleDialog.packAndShow();
    }

    private void exportInstance(String string) {
        DatabaseExportPanel databaseExportPanel = new DatabaseExportPanel(this._model, string);
        SimpleDialog simpleDialog = new SimpleDialog(this._model.getFrame(), databaseExportPanel.getTitle(), 11, databaseExportPanel);
        simpleDialog.setComponent(databaseExportPanel);
        simpleDialog.setOKButtonEnabled(false);
        simpleDialog.setDefaultButton(1);
        simpleDialog.packAndShow();
    }

    class erase_ldbm
    implements Runnable {
        LDAPConnection _ldc;
        LDAPEntry _dbInst;
        String _backendname;
        GenericProgressDialog _dlg;

        public erase_ldbm(LDAPConnection lDAPConnection, LDAPEntry lDAPEntry, String string, GenericProgressDialog genericProgressDialog) {
            this._dlg = genericProgressDialog;
            this._ldc = lDAPConnection;
            this._backendname = string;
            this._dbInst = lDAPEntry;
        }

        public void run() {
            Object object;
            boolean bl = true;
            String string = DSUtil.getAttrValue(this._dbInst, "nsslapd-directory");
            String string2 = this._dbInst.getDN();
            try {
                object = this._ldc.search("cn=mapping tree, cn=config", 2, "nsslapd-backend=" + this._backendname, null, false);
                while (object.hasMoreElements()) {
                    LDAPAttribute lDAPAttribute;
                    LDAPModificationSet lDAPModificationSet;
                    boolean bl2 = false;
                    LDAPEntry lDAPEntry = (LDAPEntry)object.nextElement();
                    String string3 = lDAPEntry.getDN();
                    Debug.println((String)("Instance db: " + string3));
                    LDAPAttribute lDAPAttribute2 = lDAPEntry.getAttribute("nsslapd-state");
                    LDAPAttribute lDAPAttribute3 = lDAPEntry.getAttribute("nsslapd-backend");
                    if (lDAPAttribute2 != null) {
                        Debug.println((String)("Node type : " + lDAPAttribute2.getStringValueArray()[0]));
                        bl2 = lDAPAttribute2.getStringValueArray()[0].compareToIgnoreCase(LDBMDatabaseObject.DISABLE) != 0 && lDAPAttribute3.size() == 1;
                    }
                    Debug.println((String)(" attr_db:" + lDAPAttribute3));
                    if (lDAPAttribute3 != null && bl2) {
                        lDAPModificationSet = new LDAPModificationSet();
                        lDAPAttribute = new LDAPAttribute("nsslapd-state", LDBMDatabaseObject.DISABLE);
                        lDAPModificationSet.add(2, lDAPAttribute);
                        try {
                            this._ldc.modify(string3, lDAPModificationSet);
                        }
                        catch (LDAPException lDAPException) {
                            String[] stringArray = new String[]{this._backendname, string3, lDAPException.toString()};
                            DSUtil.showErrorDialog((Component)LDBMDatabaseObject.this._model.getFrame(), "mod-mapping-status", stringArray, LDBMDatabaseObject.SECTION);
                        }
                    }
                    lDAPModificationSet = new LDAPModificationSet();
                    lDAPAttribute = new LDAPAttribute("nsslapd-backend", this._backendname);
                    lDAPModificationSet.add(1, lDAPAttribute);
                    String[] stringArray = new String[]{this._backendname, string3};
                    try {
                        this._ldc.modify(string3, lDAPModificationSet);
                    }
                    catch (LDAPException lDAPException) {
                        String[] stringArray2 = new String[]{this._backendname, string3, lDAPException.toString()};
                        DSUtil.showErrorDialog((Component)LDBMDatabaseObject.this._model.getFrame(), "mod-mapping-db", stringArray2, LDBMDatabaseObject.SECTION);
                    }
                }
            }
            catch (LDAPException lDAPException) {
                String[] stringArray = new String[]{this._backendname, lDAPException.toString()};
                DSUtil.showErrorDialog((Component)LDBMDatabaseObject.this._model.getFrame(), "search-mapping", stringArray, LDBMDatabaseObject.SECTION);
                this._dlg.closeCallBack();
                return;
            }
            this._dlg.stepCompleted(0);
            object = ((DefaultMutableTreeNode)((Object)LDBMDatabaseObject.this)).getParent();
            if (object instanceof IResourceObject) {
                LDBMDatabaseObject.this._model.setSelectedNode((IResourceObject)object);
            }
            if (DSUtil.deleteTree(string2, this._ldc, false, this._dlg)) {
                if (object instanceof SuffixResourceObject) {
                    ((SuffixResourceObject)object).reload();
                    ((SuffixResourceObject)object).refreshReplication();
                }
                this._dlg.stepCompleted(1);
                try {
                    Thread.sleep(300L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this._dlg.closeCallBack();
                String[] stringArray = new String[]{this._backendname, string};
                DSUtil.showInformationDialog((Component)LDBMDatabaseObject.this._model.getFrame(), "del-warning", stringArray, LDBMDatabaseObject.SECTION);
            }
        }
    }
}

