/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.node;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.node.DSResourceObject;
import com.netscape.admin.dirserv.node.MonitorResourceObject;
import com.netscape.admin.dirserv.panel.ForwardingContainerPanel;
import com.netscape.admin.dirserv.panel.MonitorDatabasePanel;
import com.netscape.management.client.IResourceObject;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.util.DN;

public class MonitorDbResourceObject
extends DSResourceObject
implements ActionListener {
    String _dn;
    private static final String monitorIconName = "monitorobj.gif";
    private static final String monitorIconNameL = "monitorobjL.gif";

    public MonitorDbResourceObject(IDSModel iDSModel, String string) {
        super(new DN(string).explodeDN(true)[1], DSUtil.getPackageImage(monitorIconName), DSUtil.getPackageImage(monitorIconNameL), iDSModel);
        this._dn = string;
    }

    public Component getCustomPanel() {
        if (this._panel == null && this.reload()) {
            this._panel = new ForwardingContainerPanel(this._model, new MonitorDatabasePanel(this._model, this._dn), true);
            ((ForwardingContainerPanel)this._panel).getOKButton().setVisible(false);
            ((ForwardingContainerPanel)this._panel).getCancelButton().setVisible(false);
        }
        return this._panel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("refresh")) {
            this.reload();
            this.refreshTree();
        }
    }

    boolean reload() {
        LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
        if (lDAPConnection == null) {
            return false;
        }
        String[] stringArray = new String[]{"dn"};
        LDAPEntry lDAPEntry = null;
        try {
            lDAPEntry = lDAPConnection.read(this._dn, stringArray);
        }
        catch (LDAPException lDAPException) {
            TreeNode treeNode;
            if (lDAPException.getLDAPResultCode() == 32 && (treeNode = ((DefaultMutableTreeNode)((Object)this)).getParent()) instanceof MonitorResourceObject) {
                ((MonitorResourceObject)((Object)treeNode)).reload();
                ((MonitorResourceObject)((Object)treeNode)).refreshTree();
                this._model.setSelectedNode((IResourceObject)((MonitorResourceObject)((Object)treeNode)));
            }
            return false;
        }
        return true;
    }

    void refreshTree() {
        this._model.fireTreeStructureChanged(this);
    }
}

