/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.node;

import com.netscape.admin.dirserv.DSResourcePage;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.GenericProgressDialog;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.node.ChainingDatabaseObject;
import com.netscape.admin.dirserv.node.DSResourceObject;
import com.netscape.admin.dirserv.node.DataRootResourceObject;
import com.netscape.admin.dirserv.node.LDBMDatabaseObject;
import com.netscape.admin.dirserv.node.RootResourceObject;
import com.netscape.admin.dirserv.panel.MappingNodePanel;
import com.netscape.admin.dirserv.panel.MappingUtils;
import com.netscape.admin.dirserv.panel.NewChainingPanel;
import com.netscape.admin.dirserv.panel.NewLDBMPanel;
import com.netscape.admin.dirserv.panel.NewSuffixPanel;
import com.netscape.admin.dirserv.panel.SimpleDialog;
import com.netscape.admin.dirserv.panel.confirmDeleteSuffixPanel;
import com.netscape.admin.dirserv.panel.replication.ReplicationResourceObject;
import com.netscape.management.client.IMenuInfo;
import com.netscape.management.client.IMenuItem;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.MenuItemSeparator;
import com.netscape.management.client.MenuItemText;
import com.netscape.management.client.ResourcePage;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.RemoteImage;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPDN;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.util.DN;

public class SuffixResourceObject
extends DSResourceObject
implements IMenuInfo,
ActionListener,
TreeExpansionListener {
    protected String[] _categoryID;
    protected IMenuItem[] _contextMenuItems;
    protected IMenuItem[] _objectMenuItems;
    private LDAPEntry _entry = null;
    private boolean _isLeaf = false;
    private boolean _isLoaded = false;
    private boolean _isInitiallyExpanded = false;
    private static RemoteImage _icon = DSUtil.getPackageImage("split-16.gif");
    private static final String _mappingNodeImageName = "split-16.gif";
    static final String DELETE = "delete_map_node";
    static final String NEWMAPP = "newmappingnode";
    static final String NEWLDBM = "newldbm";
    static final String NEWCHAINING = "newchaining";
    static final String RESTORE = "restore";
    private MappingNodePanel _mainPanel = null;
    static final String CONFIG_MAPPING = "cn=mapping tree,cn=config";
    static final String SECTION = "mappingtree";
    static final int YES = 0;
    static final int NO = 1;
    private static final String _dbinstImageName = "dbobj.gif";
    private static final String _chinstImageName = "chobj.gif";

    public SuffixResourceObject(String string, IDSModel iDSModel, LDAPEntry lDAPEntry) {
        this(string, _icon, iDSModel, lDAPEntry);
    }

    public SuffixResourceObject(String string, RemoteImage remoteImage, IDSModel iDSModel, LDAPEntry lDAPEntry) {
        super(string, remoteImage, null, iDSModel);
        this._entry = lDAPEntry;
    }

    public Component getCustomPanel() {
        if (this._mainPanel == null) {
            this._mainPanel = new MappingNodePanel(this._model, this._entry);
        }
        this._panel = this._mainPanel;
        return this._mainPanel;
    }

    public boolean run(IPage iPage) {
        this.reload();
        if (super.getChildCount() != 0) {
            this.expandPath((ResourcePage)iPage);
        }
        this.refreshTree();
        return true;
    }

    public boolean run(IPage iPage, IResourceObject[] iResourceObjectArray) {
        return this.run(iPage);
    }

    public void reload() {
        this.cleanTree();
        this._isLeaf = true;
        this.addDB();
        this.addSuffix();
        this.refreshTree();
        if (this._mainPanel != null) {
            this._mainPanel.reload();
        }
        this._isLoaded = true;
    }

    private void addSuffix() {
        String string = LDAPDN.explodeDN((String)this._entry.getDN(), (boolean)true)[0];
        try {
            try {
                this._model.fireChangeFeedbackCursor(null, 3);
                LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
                LDAPSearchResults lDAPSearchResults = lDAPConnection.search("cn=mapping tree, cn=config", 1, "(nsslapd-parent-suffix=" + MappingUtils.Quote(string) + ")", null, false);
                while (lDAPSearchResults.hasMoreElements()) {
                    LDAPEntry lDAPEntry = (LDAPEntry)lDAPSearchResults.nextElement();
                    String string2 = lDAPEntry.getDN();
                    string2 = MappingUtils.unQuote(LDAPDN.explodeDN((String)lDAPEntry.getDN(), (boolean)true)[0]);
                    this._isLeaf = false;
                    SuffixResourceObject suffixResourceObject = new SuffixResourceObject(string2, this._model, lDAPEntry);
                    ((DefaultMutableTreeNode)((Object)this)).add((MutableTreeNode)((Object)suffixResourceObject));
                }
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() != 32) {
                    String[] stringArray = new String[]{string, lDAPException.toString()};
                    DSUtil.showErrorDialog((Component)this._model.getFrame(), "error-find-subsuffix", stringArray, SECTION);
                    Debug.println((String)("SuffixResourceObject.addSuffix: psRDN: " + string + "Error: " + lDAPException.toString()));
                }
                Object var8_10 = null;
                this._model.fireChangeFeedbackCursor(null, 0);
            }
            Object var8_9 = null;
            this._model.fireChangeFeedbackCursor(null, 0);
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            this._model.fireChangeFeedbackCursor(null, 0);
            throw throwable;
        }
    }

    private void addDB() {
        StringBuffer stringBuffer = new StringBuffer();
        RemoteImage remoteImage = DSUtil.getPackageImage(_dbinstImageName);
        RemoteImage remoteImage2 = DSUtil.getPackageImage(_chinstImageName);
        this._model.fireChangeFeedbackCursor(null, 3);
        LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
        String string = LDAPDN.explodeDN((String)this._entry.getDN(), (boolean)true)[0];
        String string2 = "(&(objectclass=nsBackendInstance)(nsslapd-suffix=" + MappingUtils.unQuote(string) + "))";
        try {
            try {
                LDAPSearchResults lDAPSearchResults = lDAPConnection.search("cn=plugins,cn=config", 2, string2, null, false);
                while (lDAPSearchResults.hasMoreElements()) {
                    Object object;
                    this._isLeaf = false;
                    LDAPEntry lDAPEntry = (LDAPEntry)lDAPSearchResults.nextElement();
                    String string3 = lDAPEntry.getDN();
                    Debug.println((String)("Instance db: " + string3));
                    LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("cn");
                    if (lDAPAttribute != null && (object = lDAPAttribute.getStringValues()).hasMoreElements()) {
                        string3 = (String)object.nextElement();
                    }
                    switch (DSUtil.DbType(lDAPConnection, lDAPEntry.getDN())) {
                        case 0: {
                            object = new LDBMDatabaseObject(string3, remoteImage, this._model, lDAPEntry);
                            ((DefaultMutableTreeNode)((Object)this)).add((MutableTreeNode)object);
                            break;
                        }
                        case 1: {
                            ChainingDatabaseObject chainingDatabaseObject = new ChainingDatabaseObject(string3, remoteImage2, this._model, lDAPEntry);
                            ((DefaultMutableTreeNode)((Object)this)).add((MutableTreeNode)((Object)chainingDatabaseObject));
                            break;
                        }
                        default: {
                            Debug.println((String)"SuffixResourceObject.addDB: unknown db type");
                        }
                    }
                }
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() != 32) {
                    String[] stringArray = new String[]{string, lDAPException.toString()};
                    DSUtil.showErrorDialog((Component)this._model.getFrame(), "error-find-db", stringArray, SECTION);
                }
                Object var14_16 = null;
                this._model.fireChangeFeedbackCursor(null, 0);
            }
            Object var14_15 = null;
            this._model.fireChangeFeedbackCursor(null, 0);
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            this._model.fireChangeFeedbackCursor(null, 0);
            throw throwable;
        }
    }

    public void select(IPage iPage) {
        if (!this.isLoaded()) {
            this.reload();
        }
        super.select(iPage);
    }

    public boolean isLoaded() {
        return this._isLoaded;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block6: {
            if (actionEvent.getActionCommand().equals("refresh")) {
                LDAPEntry lDAPEntry = null;
                LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
                try {
                    lDAPEntry = lDAPConnection.read(this._entry.getDN());
                    this.reload();
                    this.refreshTree();
                }
                catch (LDAPException lDAPException) {
                    Debug.println((String)("SuffixResourceObject.actionPerformed() " + (Object)((Object)lDAPException)));
                    if (lDAPException.getLDAPResultCode() != 32) break block6;
                    TreeNode treeNode = ((DefaultMutableTreeNode)((Object)this)).getParent();
                    if (treeNode instanceof SuffixResourceObject) {
                        ((SuffixResourceObject)((Object)treeNode)).reload();
                        ((SuffixResourceObject)((Object)treeNode)).refreshTree();
                    } else if (treeNode instanceof DataRootResourceObject) {
                        ((DataRootResourceObject)((Object)treeNode)).reload();
                        ((DataRootResourceObject)((Object)treeNode)).refreshTree();
                    }
                    this._mainPanel = null;
                }
            }
        }
    }

    public String[] getMenuCategoryIDs() {
        if (this._categoryID == null) {
            this._categoryID = new String[]{"OBJECT", "CONTEXT"};
        }
        return this._categoryID;
    }

    public IMenuItem[] getMenuItems(String string) {
        if (string.equals("CONTEXT")) {
            if (this._contextMenuItems == null) {
                this._contextMenuItems = this.createMenuItems();
            }
            return this._contextMenuItems;
        }
        if (string.equals("OBJECT")) {
            if (this._objectMenuItems == null) {
                this._objectMenuItems = this.createMenuItems();
            }
            return this._objectMenuItems;
        }
        return null;
    }

    private IMenuItem[] createMenuItems() {
        return new IMenuItem[]{new MenuItemText(NEWMAPP, DSResourceObject._resource.getString("menu", NEWMAPP), DSResourceObject._resource.getString("menu", "newmappingnode-description")), new MenuItemText(NEWLDBM, DSResourceObject._resource.getString("menu", NEWLDBM), DSResourceObject._resource.getString("menu", "newldbm-description")), new MenuItemText(NEWCHAINING, DSResourceObject._resource.getString("menu", NEWCHAINING), DSResourceObject._resource.getString("menu", "newchaining-description")), new MenuItemText(DELETE, DSResourceObject._resource.getString("menu", "delmappingnode"), DSResourceObject._resource.getString("menu", "delmappingnode-description")), new MenuItemSeparator(), new MenuItemText("refresh", DSUtil._resource.getString("menu", "refresh"), DSUtil._resource.getString("menu", "refresh-description"))};
    }

    public void actionMenuSelected(IPage iPage, IMenuItem iMenuItem) {
        if (iMenuItem.getID().equals("refresh")) {
            ((IMenuInfo)this._model).actionMenuSelected(iPage, iMenuItem);
        } else if (iMenuItem.getID().equals(NEWMAPP)) {
            this.create_mapping_node(this._entry);
            this.reload();
            this.refreshReplication();
        } else if (iMenuItem.getID().equals(NEWLDBM)) {
            int n;
            String string = this._entry.getDN();
            LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
            try {
                this._entry = lDAPConnection.read(string);
            }
            catch (LDAPException lDAPException) {
                String[] stringArray = new String[]{string, lDAPException.toString()};
                DSUtil.showErrorDialog((Component)this._model.getFrame(), "reload-suffix", stringArray, SECTION);
                return;
            }
            String[] stringArray = DSUtil.getAttrValues(this._entry, "nsslapd-backend");
            if (stringArray != null && (n = DSUtil.showConfirmationDialog((Component)this._model.getFrame(), "multiple-db", "", SECTION)) != 0) {
                return;
            }
            this.create_ldbm(this._entry);
            this.reload();
            this.refreshReplication();
        } else if (iMenuItem.getID().equals(NEWCHAINING)) {
            int n;
            String string = this._entry.getDN();
            LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
            try {
                this._entry = lDAPConnection.read(string);
            }
            catch (LDAPException lDAPException) {
                String[] stringArray = new String[]{string, lDAPException.toString()};
                DSUtil.showErrorDialog((Component)this._model.getFrame(), "reload-suffix", stringArray, SECTION);
                return;
            }
            String[] stringArray = DSUtil.getAttrValues(this._entry, "nsslapd-backend");
            if (stringArray != null && (n = DSUtil.showConfirmationDialog((Component)this._model.getFrame(), "multiple-db", "", SECTION)) != 0) {
                return;
            }
            this.create_chaining(this._entry);
            this.reload();
        } else if (iMenuItem.getID().equals(DELETE)) {
            DSResourcePage dSResourcePage = (DSResourcePage)iPage;
            TreeNode treeNode = ((DefaultMutableTreeNode)((Object)this)).getParent();
            if (treeNode instanceof IResourceObject) {
                this._model.setSelectedNode((IResourceObject)treeNode);
            }
            dSResourcePage.getTree().getSelectionModel().clearSelection();
            if (this.delete_suffix(this._entry) > 0) {
                if (treeNode instanceof SuffixResourceObject) {
                    ((SuffixResourceObject)((Object)treeNode)).reload();
                } else {
                    ((DataRootResourceObject)((Object)treeNode)).reload();
                }
            }
            this.refreshReplication(treeNode);
        }
    }

    public boolean isLeaf() {
        return this._isLeaf;
    }

    void refreshTree() {
        this._model.fireTreeStructureChanged(this);
    }

    private void expandPath(ResourcePage resourcePage) {
        TreePath treePath = new TreePath(((DefaultMutableTreeNode)((Object)this)).getPath());
        resourcePage.expandTreePath(treePath);
    }

    private void cleanTree() {
        ((DefaultMutableTreeNode)((Object)this)).removeAllChildren();
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        IResourceObject iResourceObject = (IResourceObject)treeExpansionEvent.getPath().getLastPathComponent();
        if (this.equals(iResourceObject) && !this._isInitiallyExpanded) {
            this._isInitiallyExpanded = true;
            if (!this.isLoaded()) {
                this.reload();
            }
        }
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
    }

    private void create_mapping_node(LDAPEntry lDAPEntry) {
        NewSuffixPanel newSuffixPanel = new NewSuffixPanel(this._model, lDAPEntry);
        SimpleDialog simpleDialog = new SimpleDialog(this._model.getFrame(), newSuffixPanel.getTitle(), 11, newSuffixPanel);
        simpleDialog.setComponent(newSuffixPanel);
        simpleDialog.setOKButtonEnabled(false);
        newSuffixPanel.init();
        simpleDialog.setFocusComponent(newSuffixPanel.getFocusComponent());
        ((JDialog)((Object)simpleDialog)).getAccessibleContext().setAccessibleDescription(DSUtil._resource.getString("mappingtree-new", "description"));
        simpleDialog.packAndShow();
    }

    private void create_ldbm(LDAPEntry lDAPEntry) {
        NewLDBMPanel newLDBMPanel = new NewLDBMPanel(this._model, lDAPEntry);
        SimpleDialog simpleDialog = new SimpleDialog(this._model.getFrame(), newLDBMPanel.getTitle(), 11, newLDBMPanel);
        simpleDialog.setComponent(newLDBMPanel);
        simpleDialog.setOKButtonEnabled(false);
        simpleDialog.setDefaultButton(1);
        ((JDialog)((Object)simpleDialog)).getAccessibleContext().setAccessibleDescription(DSUtil._resource.getString("newldbminst", "description"));
        simpleDialog.packAndShow();
    }

    private void create_chaining(LDAPEntry lDAPEntry) {
        NewChainingPanel newChainingPanel = new NewChainingPanel(this._model, lDAPEntry);
        SimpleDialog simpleDialog = new SimpleDialog(this._model.getFrame(), newChainingPanel.getTitle(), 11, newChainingPanel);
        simpleDialog.setComponent(newChainingPanel);
        simpleDialog.setOKButtonEnabled(false);
        simpleDialog.setDefaultButton(1);
        ((JDialog)((Object)simpleDialog)).getAccessibleContext().setAccessibleDescription(DSUtil._resource.getString(NEWCHAINING, "description"));
        simpleDialog.packAndShow();
    }

    private int delete_suffix(LDAPEntry lDAPEntry) {
        String[] stringArray;
        String string = lDAPEntry.getDN();
        String string2 = new DN(string).explodeDN(true)[0];
        String[] stringArray2 = new String[]{string2};
        confirmDeleteSuffixPanel confirmDeleteSuffixPanel2 = new confirmDeleteSuffixPanel(this._model, string);
        SimpleDialog simpleDialog = new SimpleDialog(this._model.getFrame(), confirmDeleteSuffixPanel2.getTitle(), 11, confirmDeleteSuffixPanel2);
        simpleDialog.setComponent(confirmDeleteSuffixPanel2);
        simpleDialog.setOKButtonEnabled(true);
        simpleDialog.setDefaultButton(1);
        ((JDialog)((Object)simpleDialog)).getAccessibleContext().setAccessibleDescription(DSResourceObject._resource.getString("confirmdeletesuffix", "description"));
        simpleDialog.packAndShow();
        int n = confirmDeleteSuffixPanel2.getReturn();
        LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
        StringBuffer stringBuffer = new StringBuffer();
        switch (n) {
            case 1: {
                this.del_all_suffix(lDAPConnection, string, stringBuffer);
                break;
            }
            case 2: {
                LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("nsslapd-parent-suffix");
                if (lDAPAttribute == null) {
                    this.del_1_suffix(lDAPConnection, string, null, true, stringBuffer);
                    break;
                }
                stringArray = lDAPAttribute.getStringValues();
                if (!stringArray.hasMoreElements()) break;
                this.del_1_suffix(lDAPConnection, string, (String)stringArray.nextElement(), true, stringBuffer);
            }
        }
        if (stringBuffer.toString().length() > 0) {
            stringArray = new String[]{stringBuffer.toString()};
            DSUtil.showInformationDialog((Component)this._model.getFrame(), "del-warning", stringArray, SECTION);
        }
        return n;
    }

    private int del_all_suffix(LDAPConnection lDAPConnection, String string, StringBuffer stringBuffer) {
        block3: {
            String string2 = new DN(string).explodeDN(true)[0];
            String string3 = "(&(objectclass=nsMappingTree)(nsslapd-parent-suffix=" + string2 + "))";
            try {
                LDAPSearchResults lDAPSearchResults = lDAPConnection.search(CONFIG_MAPPING, 1, string3, null, false);
                while (lDAPSearchResults != null && lDAPSearchResults.hasMoreElements()) {
                    Vector vector = new Vector();
                    LDAPEntry lDAPEntry = (LDAPEntry)lDAPSearchResults.nextElement();
                    String string4 = lDAPEntry.getDN();
                    this.del_all_suffix(lDAPConnection, string4, stringBuffer);
                }
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() == 32) break block3;
                String[] stringArray = new String[]{string2, lDAPException.toString()};
                DSUtil.showErrorDialog((Component)this._model.getFrame(), "error-del-find-subsuffix", stringArray, SECTION);
                return 0;
            }
        }
        return this.del_1_suffix(lDAPConnection, string, null, false, stringBuffer);
    }

    private int del_1_suffix(LDAPConnection lDAPConnection, String string, String string2, boolean bl, StringBuffer stringBuffer) {
        String string3 = new DN(string).explodeDN(true)[0];
        String[] stringArray = new String[]{string3};
        GenericProgressDialog genericProgressDialog = new GenericProgressDialog(this._model.getFrame(), true, 1, DSResourceObject._resource.getString(SECTION, "del-1-suffix-title", stringArray), null, null);
        genericProgressDialog.addStep(DSResourceObject._resource.getString(SECTION, "del-1-check-subsuffix-label"));
        genericProgressDialog.addStep(DSResourceObject._resource.getString(SECTION, "del-1-check-suffix-label"));
        genericProgressDialog.addStep(DSResourceObject._resource.getString(SECTION, "del-1-check-db-label"));
        try {
            erase_one_suffix erase_one_suffix2 = new erase_one_suffix(lDAPConnection, string, string2, bl, stringBuffer, genericProgressDialog);
            Thread thread = new Thread(erase_one_suffix2);
            thread.start();
            genericProgressDialog.packAndShow();
        }
        catch (Exception exception) {
            Debug.println((String)("GenericDeleter(): " + exception));
            exception.printStackTrace();
            return 0;
        }
        return 1;
    }

    private boolean isLeafMappingNode() {
        DN dN = new DN(this._entry.getDN());
        String string = LDAPDN.explodeDN((String)this._entry.getDN(), (boolean)true)[0];
        String string2 = "nsslapd-parent-suffix=" + MappingUtils.Quote(string);
        LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
        try {
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(CONFIG_MAPPING, 1, string2, null, false);
            return lDAPSearchResults == null || !lDAPSearchResults.hasMoreElements();
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("SuffixResourceObject.isLeafMappingNode() : error :" + (Object)((Object)lDAPException)));
            return false;
        }
    }

    public void refreshReplication() {
        this.refreshReplication((TreeNode)((Object)this));
    }

    private void refreshReplication(TreeNode treeNode) {
        if (treeNode == null) {
            return;
        }
        TreeNode treeNode2 = treeNode.getParent();
        while (treeNode2 != null) {
            if (treeNode2 instanceof RootResourceObject) break;
            treeNode2 = treeNode2.getParent();
        }
        if (treeNode2 != null) {
            ReplicationResourceObject replicationResourceObject = ((RootResourceObject)((Object)treeNode2)).getReplicationObject();
            if (replicationResourceObject != null) {
                replicationResourceObject.refreshReplicationNode();
            }
        } else {
            Debug.println((String)"SuffixResourceObject.refreshReplicationNode() No RootResourceObject found");
        }
    }

    class erase_one_suffix
    implements Runnable {
        LDAPConnection _ldc;
        String _dn2delete;
        String _dndady;
        boolean _changeChildren;
        GenericProgressDialog _dlg;
        StringBuffer _sbDBLoc;

        public erase_one_suffix(LDAPConnection lDAPConnection, String string, String string2, boolean bl, StringBuffer stringBuffer, GenericProgressDialog genericProgressDialog) {
            this._ldc = lDAPConnection;
            this._dn2delete = string;
            this._dndady = string2;
            this._changeChildren = bl;
            this._dlg = genericProgressDialog;
            this._sbDBLoc = stringBuffer;
        }

        public void run() {
            boolean bl;
            block19: {
                String string;
                LDAPEntry lDAPEntry;
                String[] stringArray;
                LDAPSearchResults lDAPSearchResults;
                String string2;
                Object object;
                block18: {
                    bl = true;
                    if (this._changeChildren) {
                        object = new DN(this._dn2delete).explodeDN(true)[0];
                        string2 = "(&(objectclass=nsMappingTree)(nsslapd-parent-suffix=" + (String)object + "))";
                        try {
                            lDAPSearchResults = this._ldc.search(SuffixResourceObject.CONFIG_MAPPING, 1, string2, null, false);
                            while (lDAPSearchResults != null && lDAPSearchResults.hasMoreElements()) {
                                stringArray = new Vector();
                                lDAPEntry = (LDAPEntry)lDAPSearchResults.nextElement();
                                string = lDAPEntry.getDN();
                                LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
                                if (this._dndady == null) {
                                    lDAPModificationSet.add(1, new LDAPAttribute("nsslapd-parent-suffix", (String)object));
                                } else {
                                    object = this._dndady;
                                    lDAPModificationSet.add(2, new LDAPAttribute("nsslapd-parent-suffix", this._dndady));
                                }
                                try {
                                    this._ldc.modify(string, lDAPModificationSet);
                                }
                                catch (LDAPException lDAPException) {
                                    String[] stringArray2 = new String[]{string, lDAPException.toString()};
                                    DSUtil.showErrorDialog((Component)SuffixResourceObject.this._model.getFrame(), "error-modify-subsuffix", stringArray2, SuffixResourceObject.SECTION);
                                    Debug.println((String)("SuffixResourceObject.del_1_suffix(): rdn2 delete or mod = " + (String)object));
                                    bl = false;
                                }
                            }
                        }
                        catch (LDAPException lDAPException) {
                            if (lDAPException.getLDAPResultCode() == 32) break block18;
                            stringArray = new String[]{object, lDAPException.toString()};
                            DSUtil.showErrorDialog((Component)SuffixResourceObject.this._model.getFrame(), "error-del-find-subsuffix", stringArray, SuffixResourceObject.SECTION);
                            bl = false;
                        }
                    }
                }
                if (bl) {
                    this._dlg.stepCompleted(0);
                } else {
                    this._dlg.closeCallBack();
                }
                if (!DSUtil.deleteTree(this._dn2delete, this._ldc, false, this._dlg)) {
                    object = new String[]{this._dn2delete};
                    DSUtil.showErrorDialog((Component)SuffixResourceObject.this._model.getFrame(), "error-remove", object, SuffixResourceObject.SECTION);
                    this._dlg.closeCallBack();
                    return;
                }
                this._dlg.stepCompleted(1);
                object = new DN(this._dn2delete).explodeDN(true)[0];
                string2 = "(&(objectclass=nsBackendInstance)(nsslapd-suffix=" + MappingUtils.unQuote((String)object) + "))";
                try {
                    lDAPSearchResults = this._ldc.search("cn=plugins,cn=config", 2, string2, null, false);
                    while (lDAPSearchResults != null && lDAPSearchResults.hasMoreElements()) {
                        stringArray = new Vector();
                        lDAPEntry = (LDAPEntry)lDAPSearchResults.nextElement();
                        string = DSUtil.getAttrValue(lDAPEntry, "nsslapd-directory");
                        if (string != null && string.trim().length() > 0) {
                            this._sbDBLoc.append(string);
                            this._sbDBLoc.append("\n");
                        }
                        DSUtil.deleteTree(lDAPEntry.getDN(), this._ldc, false, this._dlg);
                    }
                }
                catch (LDAPException lDAPException) {
                    if (lDAPException.getLDAPResultCode() == 32) break block19;
                    stringArray = new String[]{object, lDAPException.toString()};
                    DSUtil.showErrorDialog((Component)SuffixResourceObject.this._model.getFrame(), "error-del-find-subsuffix", stringArray, SuffixResourceObject.SECTION);
                    bl = false;
                }
            }
            if (bl) {
                this._dlg.stepCompleted(2);
                try {
                    Thread.sleep(300L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this._dlg.closeCallBack();
        }
    }
}

