/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.panel.MappingUtils;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.util.DN;

public class BackendPanel
extends JPanel {
    protected JComboBox _theChoice;
    protected LDAPConnection _ldc;
    protected GridBagConstraints _gbc;
    protected JLabel _label;
    protected final String SEPARATOR = " / ";
    protected Hashtable _htSuffixAndBackends;
    protected final String SUFFIX_ATTR = "nsslapd-suffix";
    protected final String BACKEND_ATTR = "cn";

    public BackendPanel(ConsoleInfo consoleInfo, JLabel jLabel) {
        this._ldc = consoleInfo.getLDAPConnection();
        this._label = jLabel;
        this.init();
    }

    public BackendPanel(ConsoleInfo consoleInfo) {
        this(consoleInfo, new JLabel(""));
    }

    public BackendPanel(ConsoleInfo consoleInfo, String string, String string2) {
        this(consoleInfo, UIFactory.makeJLabel(string, string2));
    }

    public BackendPanel(LDAPConnection lDAPConnection, JLabel jLabel) {
        this._ldc = lDAPConnection;
        this._label = jLabel;
        this.init();
    }

    public BackendPanel(LDAPConnection lDAPConnection) {
        this(lDAPConnection, new JLabel(""));
    }

    public BackendPanel(LDAPConnection lDAPConnection, String string, String string2) {
        this(lDAPConnection, UIFactory.makeJLabel(string, string2));
    }

    protected void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = this.getGBC();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = -1;
        if (this._label != null) {
            this.add((Component)this._label, gridBagConstraints);
        }
        this._theChoice = UIFactory.makeJComboBox(null, null);
        this._theChoice.setEditable(false);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this._theChoice, gridBagConstraints);
        try {
            boolean bl = false;
            String string = null;
            Vector vector = DSUtil.getLDBMInstanceList(this._ldc, bl, string);
            if (vector != null && vector.size() > 0) {
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    Object object;
                    Object e = enumeration.nextElement();
                    LDAPEntry lDAPEntry = null;
                    if (e instanceof Vector) {
                        object = (Vector)e;
                        lDAPEntry = (LDAPEntry)((Vector)object).elementAt(0);
                    } else {
                        lDAPEntry = (LDAPEntry)e;
                    }
                    object = DSUtil.getAttrValue(lDAPEntry, "nsslapd-suffix");
                    String string2 = DSUtil.getAttrValue(lDAPEntry, "cn");
                    this._theChoice.addItem(object);
                    if (this._htSuffixAndBackends == null) {
                        this._htSuffixAndBackends = new Hashtable();
                    }
                    Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                    hashtable.put("nsslapd-suffix", object);
                    hashtable.put("cn", string2);
                    String string3 = "" + (this._theChoice.getItemCount() - 1);
                    this._htSuffixAndBackends.put(string3, hashtable);
                }
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("BackendPanel.init: could not load backend instances from server " + DSUtil.format(this._ldc) + " exception: " + (Object)((Object)lDAPException)));
            lDAPException.printStackTrace();
        }
    }

    protected GridBagConstraints getGBC() {
        this.resetGBC();
        return this._gbc;
    }

    protected void resetGBC() {
        if (this._gbc == null) {
            this._gbc = new GridBagConstraints();
        }
        this._gbc.gridwidth = 1;
        this._gbc.gridheight = 1;
        this._gbc.fill = 0;
        this._gbc.ipady = 0;
        this._gbc.weightx = 1.0;
        this._gbc.weighty = 0.0;
        this._gbc.insets = this.getComponentInsets();
        this._gbc.insets.bottom = 0;
        this._gbc.insets.right = 0;
        this._gbc.anchor = 17;
        this._gbc.gridx = -1;
        this._gbc.gridy = -1;
    }

    protected Insets getComponentInsets() {
        return UIFactory.getComponentInsets();
    }

    public String getBackend() {
        if (this._htSuffixAndBackends != null && this._theChoice != null) {
            String string = String.valueOf(this._theChoice.getSelectedIndex());
            Hashtable hashtable = (Hashtable)this._htSuffixAndBackends.get(string);
            return (String)hashtable.get("cn");
        }
        return null;
    }

    public String getSuffix() {
        if (this._htSuffixAndBackends != null && this._theChoice != null) {
            String string = String.valueOf(this._theChoice.getSelectedIndex());
            Hashtable hashtable = (Hashtable)this._htSuffixAndBackends.get(string);
            return (String)hashtable.get("nsslapd-suffix");
        }
        return null;
    }

    public boolean setSelectedSuffix(String string) {
        if (this._htSuffixAndBackends != null) {
            string = MappingUtils.unQuote(string);
            DN dN = new DN(string);
            int n = 0;
            while (n < this._htSuffixAndBackends.size()) {
                String string2 = String.valueOf(n);
                String string3 = (String)((Hashtable)this._htSuffixAndBackends.get(string2)).get("nsslapd-suffix");
                DN dN2 = new DN(string3 = MappingUtils.unQuote(string3));
                if (dN2.equals(dN)) {
                    this._theChoice.setSelectedIndex(n);
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public boolean setSelectedBackend(String string) {
        if (this._htSuffixAndBackends != null) {
            int n = 0;
            while (n < this._htSuffixAndBackends.size()) {
                String string2 = String.valueOf(n);
                String string3 = (String)((Hashtable)this._htSuffixAndBackends.get(string2)).get("cn");
                if (string3.equals(string.trim())) {
                    this._theChoice.setSelectedIndex(n);
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public void setEnabled(boolean bl) {
        if (this._theChoice != null) {
            this._theChoice.setEnabled(bl);
        }
        if (this._label != null) {
            this._label.setEnabled(bl);
        }
        super.setEnabled(bl);
    }

    public Enumeration getAllSuffixes() {
        Vector vector = new Vector();
        if (this._htSuffixAndBackends != null) {
            int n = 0;
            while (n < this._htSuffixAndBackends.size()) {
                String string = String.valueOf(n);
                vector.add(((Hashtable)this._htSuffixAndBackends.get(string)).get("nsslapd-suffix"));
                ++n;
            }
        }
        return vector.elements();
    }

    public Enumeration getAllBackends() {
        Vector vector = new Vector();
        if (this._htSuffixAndBackends != null) {
            int n = 0;
            while (n < this._htSuffixAndBackends.size()) {
                String string = String.valueOf(n);
                vector.add(((Hashtable)this._htSuffixAndBackends.get(string)).get("cn"));
                ++n;
            }
        }
        return vector.elements();
    }
}

