/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.DSEntryConfirmPassword;
import com.netscape.admin.dirserv.panel.DSEntryDN;
import com.netscape.admin.dirserv.panel.DSEntryPassword;
import com.netscape.admin.dirserv.panel.DSEntrySet;
import com.netscape.admin.dirserv.panel.DSEntryText;
import com.netscape.admin.dirserv.panel.GroupPanel;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Enumeration;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.text.JTextComponent;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.util.DN;

public class ChainingInstanceAuthPanel
extends BlankPanel
implements SuiConstants {
    private IDSModel _model = null;
    private LDAPEntry _chEntry = null;
    private String _dnEntry;
    private JLabel _lSuffixText;
    private JLabel _lSuffixLabel;
    private JTextField _tfnsmultiplexorbinddn;
    private JLabel _lnsmultiplexorbinddn;
    private JPasswordField _pfConfirmPassword;
    private JPasswordField _pfnsmultiplexorcredentials;
    private JLabel _lnsmultiplexorcredentials;
    private JLabel _lConfirmPassword;
    private JTextField _tfnsfarmserverurl;
    private JLabel _lnsfarmserverurl;
    private JLabel _lcomment;
    private JLabel _lcommentNcLabel;
    private JLabel _lcommentNc;
    private JLabel _lcommentUsrLabel;
    private JLabel _lcommentUsr;
    private JLabel _lcommentAciLabel;
    private JLabel _lcommentAci;
    private JTextArea _tfaCommentAci;
    private boolean _isPasswdExist;
    private boolean _isBindDNExist;
    private boolean _isPasswdValid = true;
    private boolean _isBindDNValid = true;
    private boolean _isPasswdDirty = false;
    private boolean _isBindDNDirty = false;
    private boolean _isURLValid = true;
    private boolean _isURLDirty = false;
    private DSEntrySet entries;
    private String entrybind;
    private String entrypwd;
    private String entryurl;
    private static final String _section = "chaining-instance-auth";
    private static final String NSMULTIPLEXORBINDDN_ATTR = "nsmultiplexorbinddn";
    private static final String NSMULTIPLEXORCREDENTIALS_ATTR = "nsmultiplexorcredentials";
    private static final String NSFARMSERVERURL_ATTR = "nsfarmserverurl";
    private static final String SUFFIX_ATTR_NAM = "nsslapd-suffix";
    private static final String SUFFIX_ATTR_NULL = "";
    static final int DEFAULT_PADDING = 6;
    static final Insets DEFAULT_EMPTY_INSETS = new Insets(0, 0, 0, 0);
    static final Insets BOTTOM_INSETS = new Insets(6, 6, 6, 6);

    public ChainingInstanceAuthPanel(IDSModel iDSModel, LDAPEntry lDAPEntry) {
        super(iDSModel, _section);
        this._helpToken = "configuration-chaining-authentication-help";
        this._dnEntry = lDAPEntry.getDN();
        this._chEntry = lDAPEntry;
        this._model = iDSModel;
        this._refreshWhenSelect = false;
    }

    public void init() {
        if (this._isInitialized) {
            return;
        }
        this._myPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = this.getGBC();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.linkData();
        this.createAuthArea(this._myPanel);
        this.createComment(this._myPanel);
        this.checkComment();
        this.addBottomGlue();
        this._isInitialized = true;
    }

    private void createComment(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = this.getGBC();
        GroupPanel groupPanel = new GroupPanel(DSUtil._resource.getString(_section, "proxy-help-title"), true);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)groupPanel, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.anchor = 10;
        gridBagConstraints2.insets = new Insets(6, 6, 0, 6);
        gridBagConstraints2.ipadx = 0;
        gridBagConstraints2.ipady = 0;
        this._lcomment = this.makeJLabel(_section, "proxy-help-comment");
        this._lcomment.setLabelFor(groupPanel);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridwidth = 0;
        groupPanel.add((Component)this._lcomment, gridBagConstraints2);
        this._lcommentUsrLabel = this.makeJLabel(_section, "proxy-help-user");
        this._lcommentUsr = new JLabel();
        this._lcommentUsrLabel.setLabelFor(this._lcommentUsr);
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.anchor = 13;
        groupPanel.add((Component)this._lcommentUsrLabel, gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.gridwidth = 0;
        groupPanel.add((Component)this._lcommentUsr, gridBagConstraints2);
        this._lcommentNcLabel = this.makeJLabel(_section, "proxy-help-naming-context");
        this._lcommentNc = new JLabel();
        this._lcommentNcLabel.setLabelFor(this._lcommentNc);
        gridBagConstraints2.gridx = 0;
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.anchor = 13;
        groupPanel.add((Component)this._lcommentNcLabel, gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.gridwidth = 0;
        groupPanel.add((Component)this._lcommentNc, gridBagConstraints2);
        this._lcommentAciLabel = this.makeJLabel(_section, "proxy-help-aci");
        this._lcommentAci = new JLabel();
        this._tfaCommentAci = new JTextArea(3, 10);
        this._lcommentAciLabel.setLabelFor(this._tfaCommentAci);
        this._tfaCommentAci.setWrapStyleWord(true);
        this._tfaCommentAci.setEditable(false);
        this._tfaCommentAci.setBackground(Color.lightGray);
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.anchor = 12;
        groupPanel.add((Component)this._lcommentAciLabel, gridBagConstraints2);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().setView(this._tfaCommentAci);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridwidth = 0;
        groupPanel.add((Component)jScrollPane, gridBagConstraints2);
    }

    private void createAuthArea(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = this.getGBC();
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.anchor = 10;
        gridBagConstraints2.insets = new Insets(6, 6, 0, 6);
        gridBagConstraints2.ipadx = 0;
        gridBagConstraints2.ipady = 0;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.anchor = 13;
        jPanel2.add((Component)this._lSuffixLabel, gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.weightx = 1.0;
        jPanel2.add((Component)this._lSuffixText, gridBagConstraints2);
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.gridx = 0;
        this.addEntryField(jPanel2, gridBagConstraints2, (JComponent)this._lnsfarmserverurl, this._tfnsfarmserverurl);
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.gridx = 0;
        this.addEntryField(jPanel2, gridBagConstraints2, (JComponent)this._lnsmultiplexorbinddn, this._tfnsmultiplexorbinddn);
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.gridx = 0;
        this.addEntryField(jPanel2, gridBagConstraints2, (JComponent)this._lnsmultiplexorcredentials, this._pfnsmultiplexorcredentials);
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.insets = new Insets(6, 6, 6, 6);
        this.addEntryField(jPanel2, gridBagConstraints2, (JComponent)this._lConfirmPassword, this._pfConfirmPassword);
    }

    protected void addEntryField(JPanel jPanel, GridBagConstraints gridBagConstraints, JComponent jComponent, JComponent jComponent2, JLabel jLabel) {
        Component component;
        Component component2 = component = Box.createGlue();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        int n = UIFactory.getComponentSpace();
        gridBagConstraints.insets = new Insets(n, n, 0, n / 2);
        jPanel.add((Component)jComponent, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(n, 0, 0, 0);
        gridBagConstraints.gridwidth = component2 == jComponent2 ? 0 : 1;
        jPanel.add((Component)jComponent2, gridBagConstraints);
        if (jLabel != null) {
            ++gridBagConstraints.gridx;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(n, n / 2, 0, 0);
            gridBagConstraints.gridwidth = component2 == jLabel ? 0 : 1;
            jPanel.add((Component)jLabel, gridBagConstraints);
        }
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        jPanel.add(component, gridBagConstraints);
    }

    protected void addEntryField(JPanel jPanel, GridBagConstraints gridBagConstraints, JComponent jComponent, JComponent jComponent2) {
        this.addEntryField(jPanel, gridBagConstraints, jComponent, jComponent2, null);
    }

    private void linkData() {
        this._lSuffixLabel = this.makeJLabel(_section, "suffix");
        this._lSuffixText = new JLabel();
        if (this._chEntry.getAttribute(SUFFIX_ATTR_NAM) != null) {
            this._lSuffixText.setText(this._chEntry.getAttribute(SUFFIX_ATTR_NAM).getStringValueArray()[0]);
        } else {
            this._lSuffixText.setText(SUFFIX_ATTR_NULL);
        }
        this.entries = new DSEntrySet(false);
        this.setDSEntrySet(this.entries);
        this._tfnsmultiplexorbinddn = this.makeJTextField(_section, NSMULTIPLEXORBINDDN_ATTR);
        this._lnsmultiplexorbinddn = this.makeJLabel(_section, NSMULTIPLEXORBINDDN_ATTR);
        this._lnsmultiplexorbinddn.setLabelFor(this._tfnsmultiplexorbinddn);
        LDAPAttribute lDAPAttribute = this._chEntry.getAttribute(NSMULTIPLEXORBINDDN_ATTR);
        this._isBindDNExist = lDAPAttribute != null;
        DSEntryDN dSEntryDN = new DSEntryDN(SUFFIX_ATTR_NULL, this._tfnsmultiplexorbinddn, this._lnsmultiplexorbinddn, NSMULTIPLEXORBINDDN_ATTR, this._model);
        this.entries.add(this._dnEntry, NSMULTIPLEXORBINDDN_ATTR, dSEntryDN);
        this.setComponentTable(this._tfnsmultiplexorbinddn, dSEntryDN);
        this._pfnsmultiplexorcredentials = this.makeJPasswordField(20);
        this._lnsmultiplexorcredentials = this.makeJLabel(_section, NSMULTIPLEXORCREDENTIALS_ATTR);
        this._lnsmultiplexorcredentials.setLabelFor(this._pfnsmultiplexorcredentials);
        this._pfConfirmPassword = this.makeJPasswordField(20);
        this._lConfirmPassword = this.makeJLabel(_section, "confirmcredentials");
        this._lConfirmPassword.setLabelFor(this._pfConfirmPassword);
        LDAPAttribute lDAPAttribute2 = this._chEntry.getAttribute(NSMULTIPLEXORCREDENTIALS_ATTR);
        this._isPasswdExist = lDAPAttribute2 != null;
        DSEntryConfirmPassword dSEntryConfirmPassword = new DSEntryConfirmPassword(SUFFIX_ATTR_NULL, this._pfConfirmPassword, this._lConfirmPassword, this._pfnsmultiplexorcredentials, 1);
        this.setComponentTable(this._pfConfirmPassword, dSEntryConfirmPassword);
        DSEntryPassword dSEntryPassword = new DSEntryPassword(SUFFIX_ATTR_NULL, this._pfnsmultiplexorcredentials, this._lnsmultiplexorcredentials, dSEntryConfirmPassword, 1);
        this.setComponentTable(this._pfConfirmPassword, dSEntryPassword);
        this.entries.add(this._dnEntry, NSMULTIPLEXORCREDENTIALS_ATTR, dSEntryPassword);
        this._tfnsfarmserverurl = this.makeJTextField(_section, NSFARMSERVERURL_ATTR);
        this._lnsfarmserverurl = this.makeJLabel(_section, NSFARMSERVERURL_ATTR);
        this._lnsfarmserverurl.setLabelFor(this._tfnsfarmserverurl);
        DSEntryText dSEntryText = new DSEntryText(SUFFIX_ATTR_NULL, this._tfnsfarmserverurl, this._lnsfarmserverurl);
        this.entries.add(this._dnEntry, NSFARMSERVERURL_ATTR, dSEntryText);
        this.setComponentTable(this._tfnsfarmserverurl, dSEntryText);
        this.entrybind = this.getAttrVal(NSMULTIPLEXORBINDDN_ATTR);
        this.entrypwd = this.getAttrVal(NSMULTIPLEXORCREDENTIALS_ATTR);
        this.entryurl = this.getAttrVal(NSFARMSERVERURL_ATTR);
    }

    private void checkComment() {
        String string = this._tfnsmultiplexorbinddn.getText();
        String string2 = this._chEntry.getAttribute(SUFFIX_ATTR_NAM).getStringValueArray()[0];
        String string3 = "(version 3.0; acl\"proxy acl\"; allow(proxy) userdn=\"ldap:///" + string + "\";)";
        this._lcommentNc.setText(string2);
        this._lcommentUsr.setText(string);
        this._tfaCommentAci.setText(string3);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        super.changedUpdate(documentEvent);
        if (documentEvent.getDocument() == this._pfnsmultiplexorcredentials.getDocument() || documentEvent.getDocument() == this._pfConfirmPassword.getDocument()) {
            this._isPasswdExist = true;
        }
        this.modelUpdate();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        super.changedUpdate(documentEvent);
        this.modelUpdate();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        super.removeUpdate(documentEvent);
        this.modelUpdate();
    }

    private void modelUpdate() {
        this.checkValues();
        this.checkOkay();
        this.checkComment();
    }

    private void checkValues() {
        this._isBindDNValid = DN.isDN((String)this._tfnsmultiplexorbinddn.getText());
        if (this.entrybind == null) {
            this._isBindDNDirty = this._tfnsmultiplexorbinddn.getText().trim().length() != 0;
        } else {
            boolean bl = this._isBindDNDirty = this.entrybind.compareTo(this._tfnsmultiplexorbinddn.getText()) != 0;
        }
        if (this._isBindDNValid) {
            if (this._isBindDNDirty) {
                this.setChangeState(this._lnsmultiplexorbinddn, 2);
            } else {
                this.setChangeState(this._lnsmultiplexorbinddn, 1);
            }
        } else {
            this.setChangeState(this._lnsmultiplexorbinddn, 3);
        }
        String string = new String(this._pfnsmultiplexorcredentials.getPassword());
        String string2 = new String(this._pfConfirmPassword.getPassword());
        boolean bl = this._isPasswdValid = string.compareTo(string2) == 0;
        if (this.entrypwd == null) {
            this._isPasswdDirty = string.trim().compareTo(SUFFIX_ATTR_NULL) != 0;
        } else {
            boolean bl2 = this._isPasswdDirty = this.entrypwd.compareTo(string) != 0;
        }
        if (this._isPasswdValid) {
            if (this._isPasswdDirty) {
                this.setChangeState(this._lnsmultiplexorcredentials, 2);
                this.setChangeState(this._lConfirmPassword, 2);
            } else {
                this.setChangeState(this._lnsmultiplexorcredentials, 1);
                this.setChangeState(this._lConfirmPassword, 1);
            }
        } else {
            this.setChangeState(this._lnsmultiplexorcredentials, 3);
            this.setChangeState(this._lConfirmPassword, 3);
        }
        this._isURLDirty = this.entryurl.compareTo(this._tfnsfarmserverurl.getText()) != 0;
        this._isURLValid = this.valideChainingURL(this._tfnsfarmserverurl.getText());
        if (this._isURLValid) {
            if (this._isURLDirty) {
                this.setChangeState(this._lnsfarmserverurl, 2);
            } else {
                this.setChangeState(this._lnsfarmserverurl, 1);
            }
        } else {
            this.setChangeState(this._lnsfarmserverurl, 3);
        }
    }

    public boolean valideChainingURL(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        boolean bl = string.startsWith("ldap://") || string.startsWith("ldaps://");
        bl = bl && string.endsWith("/");
        return bl;
    }

    private void setOkay(boolean bl) {
        if (bl) {
            this.setValidFlag();
        } else {
            this.clearValidFlag();
        }
    }

    private String getAttrVal(String string) {
        Enumeration enumeration;
        LDAPAttribute lDAPAttribute;
        if (this._chEntry != null && (lDAPAttribute = this._chEntry.getAttribute(string)) != null && (enumeration = lDAPAttribute.getStringValues()) != null && enumeration.hasMoreElements()) {
            return (String)enumeration.nextElement();
        }
        return null;
    }

    private void checkDirtyFlag() {
        boolean bl;
        boolean bl2 = bl = this._isBindDNDirty || this._isPasswdDirty || this._isURLDirty;
        if (bl) {
            this.setDirtyFlag();
        } else {
            this.clearDirtyFlag();
        }
    }

    private void checkOkay() {
        boolean bl = this._isBindDNValid && this._isPasswdValid && this._isURLValid;
        this.checkDirtyFlag();
        this.setOkay(bl);
    }

    public void okCallback() {
        String[] stringArray;
        LDAPModificationSet lDAPModificationSet;
        boolean bl;
        String[] stringArray2;
        String string;
        LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
        if (this._isBindDNDirty) {
            string = this._tfnsmultiplexorbinddn.getText();
            stringArray2 = new String[]{string};
            bl = false;
            lDAPModificationSet = new LDAPModificationSet();
            if (string == null || string.length() == 0) {
                bl = true;
                lDAPModificationSet.add(1, new LDAPAttribute(NSMULTIPLEXORBINDDN_ATTR));
            } else if (!this._isBindDNExist) {
                lDAPModificationSet.add(0, new LDAPAttribute(NSMULTIPLEXORBINDDN_ATTR, stringArray2));
            } else {
                lDAPModificationSet.add(2, new LDAPAttribute(NSMULTIPLEXORBINDDN_ATTR, stringArray2));
            }
            try {
                lDAPConnection.modify(this._chEntry.getDN(), lDAPModificationSet);
                this.clearDirtyFlag();
                this._isBindDNDirty = false;
                this._isBindDNExist = !bl;
                this.entrybind = string;
            }
            catch (LDAPException lDAPException) {
                stringArray = new String[]{this._chEntry.getDN(), lDAPException.toString()};
                DSUtil.showErrorDialog((Component)this.getModel().getFrame(), "update-binddn-error", stringArray, _section);
            }
        }
        if (this._isPasswdDirty) {
            string = new String(this._pfnsmultiplexorcredentials.getPassword());
            stringArray2 = new String[]{string};
            bl = false;
            lDAPModificationSet = new LDAPModificationSet();
            if (string == null || string.length() == 0) {
                bl = true;
                lDAPModificationSet.add(1, new LDAPAttribute(NSMULTIPLEXORCREDENTIALS_ATTR));
            } else if (!this._isPasswdExist) {
                lDAPModificationSet.add(0, new LDAPAttribute(NSMULTIPLEXORCREDENTIALS_ATTR, stringArray2));
            } else {
                lDAPModificationSet.add(2, new LDAPAttribute(NSMULTIPLEXORCREDENTIALS_ATTR, stringArray2));
            }
            try {
                lDAPConnection.modify(this._chEntry.getDN(), lDAPModificationSet);
                this.clearDirtyFlag();
                this._isPasswdDirty = false;
                this._isPasswdExist = !bl;
                this.entrypwd = string;
            }
            catch (LDAPException lDAPException) {
                stringArray = new String[]{this._chEntry.getDN(), lDAPException.toString()};
                DSUtil.showErrorDialog((Component)this.getModel().getFrame(), "update-passwd-error", stringArray, _section);
            }
        }
        string = this._tfnsfarmserverurl.getText();
        stringArray2 = new String[]{string};
        if (this._isURLDirty) {
            LDAPModificationSet lDAPModificationSet2 = new LDAPModificationSet();
            lDAPModificationSet2.add(2, new LDAPAttribute(NSFARMSERVERURL_ATTR, stringArray2));
            try {
                lDAPConnection.modify(this._chEntry.getDN(), lDAPModificationSet2);
                this.clearDirtyFlag();
                this._isURLDirty = false;
                this._isURLValid = true;
                this.entryurl = string;
            }
            catch (LDAPException lDAPException) {
                String[] stringArray3 = new String[]{this._chEntry.getDN(), lDAPException.toString()};
                DSUtil.showErrorDialog((Component)this.getModel().getFrame(), "update-passwd-error", stringArray3, _section);
            }
        }
    }

    public void resetCallback() {
        this._isPasswdDirty = false;
        if (!this._isBindDNExist) {
            this._tfnsmultiplexorbinddn.setText(SUFFIX_ATTR_NULL);
        }
        if (!this._isPasswdExist) {
            ((JTextComponent)this._pfnsmultiplexorcredentials).setText(SUFFIX_ATTR_NULL);
            ((JTextComponent)this._pfConfirmPassword).setText(SUFFIX_ATTR_NULL);
        }
        super.resetCallback();
    }
}

