/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.ContainerPanel;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.RemoteImage;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class DSTabbedPanel
extends ContainerPanel {
    protected JTabbedPane _tabbedPane = new JTabbedPane();
    private static final String _tabImageName = "tab-gif";
    private static RemoteImage _markImage = null;

    public DSTabbedPanel(IDSModel iDSModel, boolean bl) {
        super(iDSModel, bl);
        this.add((Component)this._tabbedPane, "Center");
        this._tabbedPane.addChangeListener(this);
        this.setMinimumSize(new Dimension(1, 1));
    }

    public DSTabbedPanel(IDSModel iDSModel) {
        this(iDSModel, true);
    }

    protected void addTab(BlankPanel blankPanel) {
        this._tabbedPane.addTab(blankPanel.getTitle(), blankPanel);
        this._tabbedPane.addChangeListener(blankPanel);
        blankPanel.setParent(this);
    }

    protected BlankPanel getSelectedPanel() {
        return (BlankPanel)this._tabbedPane.getSelectedComponent();
    }

    public void select(IResourceObject iResourceObject, IPage iPage) {
        Debug.println((String)("DSTabbedPanel.select: " + this));
        super.select(iResourceObject, iPage);
        this._tabbedPane.invalidate();
        this._tabbedPane.validate();
    }

    public void unselect(IResourceObject iResourceObject, IPage iPage) {
    }

    public void okCallback() {
        int n = this._tabbedPane.getTabCount();
        int n2 = 0;
        while (n2 < n) {
            BlankPanel blankPanel = (BlankPanel)this._tabbedPane.getComponentAt(n2);
            if (blankPanel._isInitialized) {
                blankPanel.okCallback();
            }
            ++n2;
        }
        if (!this.isDirty()) {
            this.clearDirtyFlag();
        } else {
            Debug.println((String)"DSTabbedPanel.okCallback(): panels are still dirty after ok");
        }
    }

    public void resetCallback() {
        int n = this._tabbedPane.getTabCount();
        int n2 = 0;
        while (n2 < n) {
            BlankPanel blankPanel = (BlankPanel)this._tabbedPane.getComponentAt(n2);
            if (blankPanel._isInitialized) {
                blankPanel.resetCallback();
            }
            ++n2;
        }
        if (!this.isDirty()) {
            this.clearDirtyFlag();
        } else {
            Debug.println((String)"DSTabbedPanel.resetCallback(): panels are still dirty after reset");
        }
    }

    public boolean isDirty() {
        int n = this._tabbedPane.getTabCount();
        int n2 = 0;
        while (n2 < n) {
            BlankPanel blankPanel = (BlankPanel)this._tabbedPane.getComponentAt(n2);
            if (blankPanel.isDirty()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setDirtyFlag(JPanel jPanel) {
        if (!((BlankPanel)jPanel).getIconExist()) {
            if (_markImage == null) {
                String string = DSUtil._resource.getString("general", _tabImageName);
                _markImage = DSUtil.getPackageImage(string);
            }
            ((BlankPanel)jPanel).setIconExist(true);
            int n = this._tabbedPane.indexOfComponent(jPanel);
            this._tabbedPane.setIconAt(n, (Icon)_markImage);
            this._tabbedPane.invalidate();
            this._tabbedPane.validate();
            this._tabbedPane.repaint();
        }
        this.setDirtyFlag();
    }

    public void clearDirtyFlag(JPanel jPanel) {
        if (((BlankPanel)jPanel).getIconExist()) {
            ((BlankPanel)jPanel).setIconExist(false);
            int n = this._tabbedPane.indexOfComponent(jPanel);
            this._tabbedPane.setIconAt(n, null);
            this._tabbedPane.invalidate();
            this._tabbedPane.validate();
            this._tabbedPane.repaint();
        }
        if (!this.isModified()) {
            this.clearDirtyFlag();
        }
    }

    public void setValidFlag(JPanel jPanel) {
        if (this.isModified() && this.isValid()) {
            this.setValidFlag();
        }
    }

    public void clearValidFlag(JPanel jPanel) {
        this.clearValidFlag();
    }

    public boolean isModified() {
        int n = this._tabbedPane.getTabCount();
        int n2 = 0;
        while (n2 < n) {
            BlankPanel blankPanel = (BlankPanel)this._tabbedPane.getComponentAt(n2);
            if (blankPanel.isDirty()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isValid() {
        int n = this._tabbedPane.getTabCount();
        int n2 = 0;
        while (n2 < n) {
            BlankPanel blankPanel = (BlankPanel)this._tabbedPane.getComponentAt(n2);
            if (!blankPanel.isValid()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("refresh")) {
            int n = this._tabbedPane.getTabCount();
            int n2 = 0;
            while (n2 < n) {
                BlankPanel blankPanel = (BlankPanel)this._tabbedPane.getComponentAt(n2);
                if (blankPanel != null && blankPanel.isInitialized()) {
                    blankPanel.refresh();
                }
                ++n2;
            }
        } else {
            super.actionPerformed(actionEvent);
        }
    }
}

