/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSFileDialog;
import com.netscape.admin.dirserv.DSSearchExportHelper;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.GenericProgressDialog;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.ISubtreeSelectionDialog;
import com.netscape.admin.dirserv.panel.FilePanel;
import com.netscape.admin.dirserv.panel.MappingUtils;
import com.netscape.admin.dirserv.task.LDAPExport;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.Debug;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.util.DN;

public class DatabaseExportPanel
extends FilePanel {
    private boolean _globalExport = true;
    private boolean _isReplicaExport = false;
    private JTextField _subtreeText;
    private JRadioButton _rbWholeTree;
    private JRadioButton _rbSubtree;
    private ISubtreeSelectionDialog _sDialog;
    private String _backend;

    public DatabaseExportPanel(IDSModel iDSModel, ISubtreeSelectionDialog iSubtreeSelectionDialog) {
        super(iDSModel, "export");
        this._sDialog = iSubtreeSelectionDialog;
        this._helpToken = "configuration-database-export-dbox-help";
    }

    public DatabaseExportPanel(IDSModel iDSModel, String string) {
        this(iDSModel, string, false);
        this._helpToken = "configuration-database-export-single-dbox-help";
    }

    public DatabaseExportPanel(IDSModel iDSModel, String string, boolean bl) {
        super(iDSModel, "export", false, true);
        this._globalExport = false;
        this._backend = string;
        this._isReplicaExport = bl;
        if (this._isReplicaExport) {
            this._helpToken = "configuration-replication-export-help";
        }
    }

    public DatabaseExportPanel(IDSModel iDSModel, ISubtreeSelectionDialog iSubtreeSelectionDialog, boolean bl) {
        super(iDSModel, "export");
        this._sDialog = iSubtreeSelectionDialog;
        this._helpToken = "configuration-database-export-dbox-help";
        this._globalExport = bl;
    }

    public void init() {
        GridBagConstraints gridBagConstraints = this.getGBC();
        this._myPanel.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.createFileArea(jPanel);
        if (this._globalExport) {
            if (!(this.isLocal() || this._onlyRemote || this._onlyLocal)) {
                this.createSeparator(jPanel);
            }
            this.createOptionsArea(jPanel);
        }
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this._myPanel.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 1.0;
        this._myPanel.add(Box.createGlue(), gridBagConstraints);
        this._rbRemote.setSelected(!this._globalExport);
        this.setLocalState(this._globalExport);
        this.getAbstractDialog().setFocusComponent((JComponent)this._tfExport);
        this.getAbstractDialog().getAccessibleContext().setAccessibleDescription(this._resource.getString("export", "description"));
    }

    private void createOptionsArea(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = this.getGBC();
        gridBagConstraints.insets = this.getComponentInsets();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.optionsPanel(), gridBagConstraints);
    }

    private JPanel optionsPanel() {
        GridBagConstraints gridBagConstraints = this.getGBC();
        JPanel jPanel = new JPanel(new GridBagLayout());
        ButtonGroup buttonGroup = new ButtonGroup();
        this._rbWholeTree = this.makeJRadioButton(this._section, "whole-tree", true);
        buttonGroup.add(this._rbWholeTree);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 4;
        jPanel.add((Component)this._rbWholeTree, gridBagConstraints);
        this._rbSubtree = this.makeJRadioButton(this._section, "sub-tree", false);
        --gridBagConstraints.gridwidth;
        buttonGroup.add(this._rbSubtree);
        jPanel.add((Component)this._rbSubtree, gridBagConstraints);
        this._subtreeText = this.makeJTextField(this._section, "subtree");
        gridBagConstraints.weightx = 1.0;
        --gridBagConstraints.gridwidth;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this._subtreeText, gridBagConstraints);
        this._browseButton = this.makeJButton(this._section, "browse-subtree");
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this._browseButton, gridBagConstraints);
        this.setSubtreeState(false);
        return jPanel;
    }

    protected void setLocalState(boolean bl) {
        if (this.isLocal()) {
            return;
        }
        super.setLocalState(bl);
    }

    private void setSubtreeState(boolean bl) {
        this._subtreeText.setEnabled(bl);
        this._browseButton.setEnabled(bl);
        this.repaint();
    }

    protected void checkOkay() {
        String string = this._tfExport.getText();
        AbstractDialog abstractDialog = this.getAbstractDialog();
        if (abstractDialog != null) {
            boolean bl = string != null && string.length() > 0;
            abstractDialog.setOKButtonEnabled(bl);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this._bExport)) {
            File file;
            String string = this.getFilename();
            String[] stringArray = new String[]{"ldif"};
            String[] stringArray2 = new String[]{this._resource.getString("filefilter", "ldif-label")};
            String string2 = this.getDefaultPath(this.getModel());
            if ((string = string == null || string.trim().length() < 1 ? DSFileDialog.getFileName(false, stringArray, stringArray2, this, "*.ldif", string2) : ((file = new File(string)).isAbsolute() ? DSFileDialog.getFileName(string, false, stringArray, stringArray2, this) : DSFileDialog.getFileName(false, stringArray, stringArray2, this, string, string2))) != null) {
                this.setFilename(string);
            }
        } else if (actionEvent.getSource().equals(this._browseButton)) {
            ConsoleInfo consoleInfo = this.getModel().getServerInfo();
            this._sDialog.packAndShow();
            if (!this._sDialog.isOk()) {
                return;
            }
            this._subtreeText.setText(this._sDialog.getDN());
            this._subtreeText.repaint(1L);
        } else if (actionEvent.getSource().equals(this._rbWholeTree)) {
            this.setSubtreeState(false);
        } else if (actionEvent.getSource().equals(this._rbSubtree)) {
            this.setSubtreeState(true);
        } else if (actionEvent.getSource().equals(this._rbLocal)) {
            this.setLocalState(true);
            this.validate();
            this.repaint();
        } else if (actionEvent.getSource().equals(this._rbRemote)) {
            this.setLocalState(false);
            this.validate();
            this.repaint();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void okCallback() {
        Object object;
        Object object2;
        int n;
        File file;
        boolean bl = false;
        boolean bl2 = this._rbLocal.isSelected() || this.isLocal();
        String string = this._tfExport.getText().trim();
        if (string.trim().equals("") && !this.validateFilename()) {
            return;
        }
        File file2 = new File(string);
        if (!file2.isAbsolute()) {
            if (this.isLocal()) {
                string = DSFileDialog.getPath() != null ? DSFileDialog.getPath() + string : this.getDefaultPath(this.getModel()) + string;
                file = new File(string);
                string = file.getAbsolutePath();
            } else if (this._rbLocal.isSelected()) {
                if (DSFileDialog.getPath() != null) {
                    string = DSFileDialog.getPath() + string;
                } else {
                    file = new File(string);
                    string = file.getAbsolutePath();
                }
            }
        }
        if (this._rbRemote.isSelected() && string.indexOf(47) == -1 && string.indexOf(92) == -1) {
            string = this.getDefaultPath(this.getModel()) + string;
        }
        if (this.isLocal() || this._rbRemote.isSelected()) {
            Object[] objectArray;
            int n2;
            if (bl2 && DSUtil.fileExists(file2 = new File(string)) && (n2 = DSUtil.showConfirmationDialog((Component)this.getModel().getFrame(), "confirm-delete-export-file", DSUtil.inverseAbreviateString(string, 30), this._section)) != 0) {
                return;
            }
            Hashtable<String, LDAPAttribute> hashtable = new Hashtable<String, LDAPAttribute>();
            hashtable.put("nsFilename", new LDAPAttribute("nsFilename", string));
            hashtable.put("nsUseOneFile", new LDAPAttribute("nsUseOneFile", "TRUE"));
            if (this._isReplicaExport) {
                hashtable.put("nsExportReplica", new LDAPAttribute("nsExportReplica", "TRUE"));
            }
            String string2 = null;
            if (this._subtreeText != null && (string2 = this._subtreeText.getText()) != null && string2.length() > 0) {
                hashtable.put("nsIncludeSuffix", new LDAPAttribute("nsIncludeSuffix", string2));
            }
            if (this._backend != null && this._backend.length() > 0) {
                hashtable.put("nsInstance", new LDAPAttribute("nsInstance", this._backend));
                DSUtil.showInformationDialog((Component)this.getModel().getFrame(), "LDAPMode-FilePermisionWarning", "", this._section);
            } else {
                objectArray = MappingUtils.getBackendList(this.getModel().getServerInfo().getLDAPConnection(), 2);
                if (string2 != null && string2.length() > 0) {
                    int n3;
                    String[] stringArray;
                    Vector<String> vector = new Vector<String>();
                    DN dN = new DN(string2);
                    String string3 = MappingUtils.getSuffixForEntry(this.getModel().getServerInfo().getLDAPConnection(), string2);
                    if (string3 != null && (stringArray = MappingUtils.getBackendsForSuffix(this.getModel().getServerInfo().getLDAPConnection(), string3)) != null) {
                        n3 = 0;
                        while (n3 < stringArray.length) {
                            int n4 = 0;
                            while (n4 < objectArray.length) {
                                if (stringArray[n3].equalsIgnoreCase((String)objectArray[n4]) && vector.indexOf(stringArray[n3].toLowerCase()) < 0) {
                                    vector.addElement(stringArray[n3].toLowerCase());
                                }
                                ++n4;
                            }
                            ++n3;
                        }
                    }
                    if ((stringArray = MappingUtils.getSuffixList(this.getModel().getServerInfo().getLDAPConnection(), 2)) != null) {
                        n3 = 0;
                        while (n3 < stringArray.length) {
                            String[] stringArray2;
                            DN dN2 = new DN(stringArray[n3]);
                            if ((dN2.isDescendantOf(dN) || dN.equals(dN2)) && (stringArray2 = MappingUtils.getBackendsForSuffix(this.getModel().getServerInfo().getLDAPConnection(), stringArray[n3])) != null) {
                                int n5 = 0;
                                while (n5 < stringArray2.length) {
                                    int n6 = 0;
                                    while (n6 < objectArray.length) {
                                        if (stringArray2[n5].equalsIgnoreCase((String)objectArray[n6]) && vector.indexOf(stringArray2[n5].toLowerCase()) < 0) {
                                            vector.addElement(stringArray2[n5].toLowerCase());
                                        }
                                        ++n6;
                                    }
                                    ++n5;
                                }
                            }
                            ++n3;
                        }
                    }
                    if (vector.size() > 0) {
                        objectArray = new String[vector.size()];
                        vector.copyInto(objectArray);
                    }
                }
                if (objectArray != null && objectArray.length > 0) {
                    DSUtil.showInformationDialog((Component)this.getModel().getFrame(), "LDAPMode-FilePermisionWarningAndConfigNotExported", "", this._section);
                    hashtable.put("nsInstance", new LDAPAttribute("nsInstance", (String[])objectArray));
                } else {
                    Debug.println((String)"DatabaseExportPanel.okCallBack(): Could not find backends");
                    DSUtil.showErrorDialog((Component)this.getModel().getFrame(), "failed", "", this._section);
                    return;
                }
            }
            this.clearDirtyFlag();
            this.hideDialog();
            objectArray = new LDAPExport(this.getModel(), hashtable);
            return;
        }
        file = this.getModel().getServerInfo().getLDAPConnection();
        if (!DSUtil.isLocalDirectoryManager((LDAPConnection)file) && (n = DSUtil.showConfirmationDialog((Component)this.getModel().getFrame(), "ldapsearchExport-needtobedirectorymanager", (String[])null, this._section)) != 0) {
            return;
        }
        file2 = new File(string);
        if (DSUtil.fileExists(file2) && (n = DSUtil.showConfirmationDialog((Component)this.getModel().getFrame(), "confirm-delete-export-file", DSUtil.inverseAbreviateString(string, 30), this._section)) != 0) {
            return;
        }
        String string4 = string;
        if (File.separator.equals("\\")) {
            string4 = string4.replace('/', '\\');
        }
        file2 = new File(string4);
        Debug.println((String)("DatabaseExportPanel.okCallback: testing writability of " + string4));
        try {
            object2 = new FileOutputStream(file2);
            object = new byte[]{0};
            ((FileOutputStream)object2).write((byte[])object);
            try {
                ((FileOutputStream)object2).close();
                file2.delete();
            }
            catch (IOException iOException) {}
        }
        catch (IOException iOException) {
            DSUtil.showErrorDialog((Component)this.getModel().getFrame(), "unwritable", string4, this._section);
            return;
        }
        if (!DSUtil.reconnect((LDAPConnection)file)) {
            DSUtil.showErrorDialog((Component)this.getModel().getFrame(), "fetching-server-unavailable", "");
            this.clearDirtyFlag();
            return;
        }
        this.clearDirtyFlag();
        this.hideDialog();
        object2 = null;
        object = this._subtreeText.getText();
        if (object != null && object.length() > 0) {
            object2 = object;
        }
        String string5 = this._resource.getString("export", "title");
        GenericProgressDialog genericProgressDialog = new GenericProgressDialog(this.getModel().getFrame(), true, 0, string5);
        DSSearchExportHelper dSSearchExportHelper = new DSSearchExportHelper(string, this.getModel().getServerInfo().getLDAPConnection(), genericProgressDialog, (String)object2);
        try {
            Thread thread = new Thread(dSSearchExportHelper);
            thread.start();
            genericProgressDialog.packAndShow();
        }
        catch (Exception exception) {
            Debug.println((String)("DatabaseExportPanel.okCallBack: " + exception));
            exception.printStackTrace();
        }
    }

    public void resetCallback() {
        this.clearDirtyFlag();
        this.hideDialog();
    }

    public String getTitle() {
        String string;
        if (this._backend != null) {
            String[] stringArray = new String[]{this._backend};
            string = this._resource.getString("export-partition", "title", stringArray);
        } else {
            string = this._resource.getString("export", "title");
        }
        return string;
    }
}

