/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.DefaultResourceModel;
import com.netscape.admin.dirserv.GenericProgressDialog;
import com.netscape.admin.dirserv.GlobalConstants;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.CenterAlignedHeaderRenderer;
import com.netscape.admin.dirserv.panel.CheckBoxTableCellRenderer;
import com.netscape.admin.dirserv.panel.CheckboxTableKeyListener;
import com.netscape.admin.dirserv.panel.IndexAttrUtility;
import com.netscape.admin.dirserv.panel.LabelTableCellRenderer;
import com.netscape.admin.dirserv.panel.NewIndexPanel;
import com.netscape.admin.dirserv.panel.SimpleDialog;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.admin.dirserv.task.LDAPBasicProgressDialog;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.UITools;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSchema;
import netscape.ldap.LDAPSearchResults;

public class DefaultIndexManagementPanel
extends BlankPanel {
    private static final String ADD = "add";
    private static final String DELETE = "delete";
    private static final String RDN_MONITOR = "cn=monitor,";
    private static final int SUCCESS = 0;
    private static final int FAILURE = 1;
    private static final int MODIFYAGAIN = 2;
    private static final String _section = "default-index";
    private static final String DN_PREFIX = "cn=default indexes, index,cn=config,cn=ldbm database,cn=plugins,cn=config";
    private static final String[] FILTERS = new String[]{"approx", "eq", "pres", "sub"};
    private static final String[] OCLASSES = new String[]{"top", "nsIndex"};
    private String[] headers = null;
    private JTable _indexTableUser = null;
    private Hashtable _attributes = null;
    private Hashtable _changedAttributes = null;
    private Hashtable _newAttributes = null;
    private Hashtable _matchingRules = null;
    private IndexAttrTableModel _userDataModel = null;
    private int numColumns;
    private JButton _bAdd;
    private JButton _bDelete;
    private String _dnEntry = null;
    private String _conf_prefix = null;
    LDAPBasicProgressDialog _statusProgressDialog;
    GenericProgressDialog _progressDialog;
    private boolean _taskCancelled = false;
    private Vector _addedEntries = null;
    Component _comp;
    String _msg;
    String _arg;

    public DefaultIndexManagementPanel(IDSModel iDSModel) {
        this(iDSModel, DN_PREFIX);
        Debug.println((String)"DefaultIndexManagementPanel() : default applied");
    }

    public DefaultIndexManagementPanel(IDSModel iDSModel, String string) {
        super(iDSModel, _section, false);
        this._helpToken = "configuration-database-default-indexes-help";
        this._dnEntry = string;
        this._conf_prefix = this.isPluginEntry(string) ? "cn=config," : "";
        Debug.println((String)("IndexManagementPanel() dnEntry:" + string));
        this._refreshWhenSelect = false;
    }

    public void init() {
        this._attributes = new Hashtable();
        this._changedAttributes = new Hashtable();
        this._newAttributes = new Hashtable();
        this._matchingRules = new Hashtable();
        this._myPanel.setLayout(new GridBagLayout());
        this.resetGBC();
        this._gbc.fill = 1;
        this._gbc.gridwidth = 0;
        this._gbc.gridheight = -1;
        this._gbc.weighty = 1.0;
        this._gbc.insets = new Insets(0, 0, 0, 0);
        this._myPanel.add((Component)this.createIndexTable(this._myPanel), this._gbc);
        this._bAdd = this.makeJButton(_section, ADD);
        this._bAdd.setActionCommand(ADD);
        this._bDelete = this.makeJButton(_section, DELETE);
        this._bDelete.setActionCommand(DELETE);
        this._bDelete.setEnabled(false);
        JButton[] jButtonArray = new JButton[]{this._bAdd, this._bDelete};
        JPanel jPanel = UIFactory.makeJButtonPanel(jButtonArray);
        this.resetGBC();
        this._gbc.gridwidth = 0;
        this._gbc.fill = 2;
        this._gbc.weightx = 1.0;
        this._gbc.weighty = 0.0;
        this._gbc.insets = new Insets(UIFactory.getDifferentSpace(), 0, 0, 0);
        this._myPanel.add((Component)jPanel, this._gbc);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.modelUpdate();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.modelUpdate();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.modelUpdate();
    }

    private void modelUpdate() {
        int n = this._indexTableUser.getEditingRow();
        int n2 = this._indexTableUser.getEditingColumn();
        if (n != -1 && n2 != -1) {
            this.setValidFlag();
            this.setDirtyFlag();
        }
    }

    protected JTable createTable(IndexAttrTableModel indexAttrTableModel) {
        Serializable serializable;
        JTable jTable = new JTable(indexAttrTableModel);
        jTable.setColumnSelectionAllowed(false);
        jTable.addKeyListener(new CheckboxTableKeyListener());
        int n = 0;
        while (n < this.numColumns) {
            int n2 = Integer.parseInt(DSUtil._resource.getString(_section, "index-table-columnwidth-" + n));
            serializable = jTable.getColumn(this.headers[n]);
            ((TableColumn)serializable).setPreferredWidth(n2);
            ((TableColumn)serializable).setHeaderRenderer((TableCellRenderer)((Object)new CenterAlignedHeaderRenderer()));
            if (n > 0 && n < this.numColumns - 1) {
                ((TableColumn)serializable).setCellRenderer(new CheckBoxTableCellRenderer());
            }
            ++n;
        }
        TableColumn tableColumn = jTable.getColumn(this.headers[this.numColumns - 1]);
        serializable = new JTextField();
        ((JTextComponent)serializable).getDocument().addDocumentListener(this);
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor((JTextField)serializable);
        defaultCellEditor.setClickCountToStart(1);
        tableColumn.setCellEditor(defaultCellEditor);
        tableColumn.setCellRenderer(new LabelTableCellRenderer());
        return jTable;
    }

    protected JComponent createIndexTable(JPanel jPanel) {
        int n = UIFactory.getDifferentSpace();
        this.numColumns = Integer.parseInt(DSUtil._resource.getString(_section, "table-columns"));
        this._attributes = this.getIndexedAttributes();
        this.constructDataModel(false);
        EmptyBorder emptyBorder = new EmptyBorder(0, 0, 0, 0);
        JLabel jLabel = this.makeJLabel(_section, "user");
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(emptyBorder);
        this._indexTableUser = this.createTable(this._userDataModel);
        this._indexTableUser.getAccessibleContext().setAccessibleDescription(this.getTitle());
        this._indexTableUser.getSelectionModel().setSelectionMode(0);
        this._indexTableUser.getSelectionModel().addListSelectionListener(this);
        this._indexTableUser.setAutoResizeMode(1);
        this._indexTableUser.setRequestFocusEnabled(false);
        Insets insets = new Insets(0, 0, 0, 0);
        this.resetGBC();
        this._gbc.gridwidth = 0;
        this._gbc.insets = insets;
        jPanel2.add((Component)jLabel, this._gbc);
        JScrollPane jScrollPane = new JScrollPane(this._indexTableUser);
        jScrollPane.setBorder(UITools.createLoweredBorder());
        this.resetGBC();
        this._gbc.weightx = 1.0;
        this._gbc.weighty = 1.0;
        this._gbc.fill = 1;
        this._gbc.gridwidth = 0;
        this._gbc.insets = insets;
        jPanel2.add((Component)jScrollPane, this._gbc);
        return jScrollPane;
    }

    private void constructDataModel(boolean bl) {
        Enumeration enumeration = this._attributes.keys();
        if (!bl) {
            this._userDataModel = new IndexAttrTableModel();
            this.headers = new String[this.numColumns];
            int n = 0;
            while (n < this.numColumns) {
                this.headers[n] = DSUtil._resource.getString(_section, "index-table-columnheading-" + n);
                this._userDataModel.addColumn(this.headers[n]);
                ++n;
            }
        } else {
            this._userDataModel.removeAllRows();
        }
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.fillRow(this._userDataModel, string);
        }
    }

    public boolean refresh() {
        this._attributes = this.getIndexedAttributes();
        this.constructDataModel(true);
        this._changedAttributes.clear();
        this._newAttributes.clear();
        this.clearDirtyFlag();
        int n = this._indexTableUser.getSelectedRow();
        if (n >= 0) {
            this._bDelete.setEnabled(true);
        } else {
            this._bDelete.setEnabled(false);
        }
        return true;
    }

    public void resetCallback() {
        int n;
        if (this.isDirty()) {
            this._attributes = this.getIndexedAttributes();
            this.constructDataModel(true);
            this._changedAttributes.clear();
            this._newAttributes.clear();
            this.clearDirtyFlag();
        }
        if ((n = this._indexTableUser.getSelectedRow()) >= 0) {
            this._bDelete.setEnabled(true);
        } else {
            this._bDelete.setEnabled(false);
        }
    }

    private Vector getNewIndexesInVector(Hashtable hashtable) {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Vector vector2 = (Vector)hashtable.get(string);
            int n = vector2.size();
            if (n < 1) continue;
            String string2 = string + ":";
            int n2 = 0;
            while (n2 < n) {
                string2 = string2 + (String)vector2.elementAt(n2);
                if (n2 < n - 1) {
                    string2 = string2 + ',';
                }
                ++n2;
            }
            String string3 = (String)this._matchingRules.get(string);
            if (string3 != null && (string3 = string3.trim()).length() > 0) {
                string2 = string2 + ":" + string3;
            }
            vector.addElement(string2);
        }
        return vector;
    }

    private String getNewIndexes(Hashtable hashtable) {
        String string = "";
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Vector vector = (Vector)hashtable.get(string2);
            int n = vector.size();
            if (n < 1) continue;
            string = string + string2 + ":";
            int n2 = 0;
            while (n2 < n) {
                string = string + (String)vector.elementAt(n2);
                if (n2 < n - 1) {
                    string = string + ',';
                }
                ++n2;
            }
            String string3 = (String)this._matchingRules.get(string2);
            if (string3 != null && (string3 = string3.trim()).length() > 0) {
                string = string + ":" + string3;
            }
            string = string + ' ';
        }
        return string.trim();
    }

    public void okCallback() {
        Object object;
        Object[] objectArray;
        Object object2;
        if (!this.isDirty()) {
            return;
        }
        TableCellEditor tableCellEditor = this._indexTableUser.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
        }
        if (BlankPanel.requiresConfirmation(GlobalConstants.PREFERENCES_CONFIRM_DELETE_INDEX)) {
            int n;
            Object object3;
            object2 = this._changedAttributes.keys();
            boolean bl = false;
            String string = "";
            objectArray = new Vector();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                object3 = (Vector)this._changedAttributes.get(object);
                if (((Vector)object3).size() >= 1) continue;
                bl = true;
                string = string + (String)object + ' ';
                objectArray.addElement(object);
            }
            if (bl && (n = DSUtil.showConfirmationDialog((Component)this.getModel().getFrame(), "confirm-delete", string.trim(), _section)) != 0) {
                object3 = objectArray.elements();
                while (object3.hasMoreElements()) {
                    this.fillRow(this._userDataModel, (String)object3.nextElement());
                }
                return;
            }
        }
        object2 = this.getNewIndexesInVector(this._newAttributes);
        Vector vector = this.getNewIndexesInVector(this._changedAttributes);
        int n = 0;
        while (n < vector.size()) {
            ((Vector)object2).addElement(vector.elementAt(n));
            ++n;
        }
        objectArray = new String[((Vector)object2).size()];
        if (((Vector)object2).size() > 0) {
            ((Vector)object2).copyInto(objectArray);
            object = DSUtil._resource.getString(_section, "title");
            this._progressDialog = new GenericProgressDialog(this.getModel().getFrame(), true, 1, (String)object, null, this);
            this._progressDialog.addStep(DSUtil._resource.getString(_section, "LDAPMode-firstStep-title"));
            this._statusProgressDialog = new LDAPBasicProgressDialog(this.getModel().getFrame(), DSUtil._resource.getString(_section, "LDAPMode-Status-title"), true, null, this);
        } else {
            if (this._changedAttributes.size() < 1) {
                this.resetCallback();
                return;
            }
            object = DSUtil._resource.getString(_section, "title");
            this._progressDialog = new GenericProgressDialog(this.getModel().getFrame(), true, 1, (String)object, null, this);
            this._progressDialog.addStep(DSUtil._resource.getString(_section, "LDAPMode-deleteStep-title"));
        }
        object = new Thread(new IndexRunnable((String[])objectArray));
        try {
            ((Thread)object).start();
            this._progressDialog.packAndShow();
        }
        catch (Exception exception) {
            Debug.println((String)("IndexManagementPanel.okCallBack(): " + exception));
        }
        int n2 = this._indexTableUser.getSelectedRow();
        if (n2 >= 0) {
            this._bDelete.setEnabled(true);
        } else {
            this._bDelete.setEnabled(false);
        }
    }

    private void cleanUpEntries() {
        Enumeration enumeration = this._newAttributes.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Vector vector = (Vector)this._newAttributes.get(string);
            if (vector.size() <= 0) continue;
            String string2 = "cn=" + string + "," + this._conf_prefix + this._dnEntry;
            IndexAttrUtility.deleteAttribute(this.getModel(), string2);
        }
    }

    protected void addAttribute() {
        Vector vector = this.getAvailAttributes();
        Object[] objectArray = null;
        String string = null;
        if (vector != null) {
            NewIndexPanel newIndexPanel = new NewIndexPanel((IDSModel)new DefaultResourceModel(), vector);
            SimpleDialog simpleDialog = new SimpleDialog(this.getModel().getFrame(), newIndexPanel.getTitle(), 11, newIndexPanel);
            simpleDialog.setComponent(newIndexPanel);
            simpleDialog.setOKButtonEnabled(false);
            simpleDialog.setDefaultButton(1);
            ((JDialog)((Object)simpleDialog)).getAccessibleContext().setAccessibleDescription(DSUtil._resource.getString(_section, "selectAttribute-description"));
            simpleDialog.packAndShow();
            objectArray = newIndexPanel.getSelectedItems();
        }
        if (objectArray != null) {
            int n = objectArray.length - 1;
            int n2 = 0;
            while (n2 < objectArray.length) {
                string = (String)objectArray[n2];
                Vector<Boolean> vector2 = new Vector<Boolean>();
                this.initRow(string, vector2);
                vector2.setElementAt(new Boolean(true), 2);
                vector2.setElementAt(new Boolean(true), 3);
                this.dumpVector("addAttribute " + string, vector2);
                this._userDataModel.addRow(vector2);
                Vector<String> vector3 = new Vector<String>();
                vector3.addElement(FILTERS[1]);
                vector3.addElement(FILTERS[2]);
                if (!this._changedAttributes.containsKey(string)) {
                    this._newAttributes.put(string, vector3);
                } else {
                    this._changedAttributes.put(string, vector3);
                }
                if (n2 == n) {
                    int n3 = this._userDataModel.getRowIndex(string);
                    this._indexTableUser.setRowSelectionInterval(n3, n3);
                    this.setDirtyFlag();
                    this.setValidFlag();
                }
                ++n2;
            }
        }
    }

    protected void deleteAttribute() {
        int n = this._indexTableUser.getSelectedRow();
        if (n >= 0) {
            this._userDataModel.removeRow(n);
            this.setDirtyFlag();
            this.setValidFlag();
        }
    }

    private void cancel() {
        this._progressDialog.setTextInLabel(DSUtil._resource.getString(_section, "LDAPMode-cancelled-title"));
        this.cleanUpEntries();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    DefaultIndexManagementPanel.this.resetCallback();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._progressDialog.closeCallBack();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = listSelectionEvent.getFirstIndex();
        int n2 = listSelectionEvent.getLastIndex();
        int n3 = this._indexTableUser.getSelectionModel().getMaxSelectionIndex();
        boolean bl = n <= n3 && n3 <= n2;
        this._bDelete.setEnabled(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        TableCellEditor tableCellEditor;
        Object object = actionEvent.getSource();
        this._bAdd.setEnabled(false);
        this._bDelete.setEnabled(false);
        if (((JButton)object).getActionCommand().equals(ADD)) {
            this.getModel().setWaitCursor(true);
            tableCellEditor = this._indexTableUser.getCellEditor();
            if (tableCellEditor != null) {
                tableCellEditor.stopCellEditing();
            }
            this.addAttribute();
            this.getModel().setWaitCursor(false);
        } else if (((JButton)object).getActionCommand().equals(DELETE)) {
            tableCellEditor = this._indexTableUser.getCellEditor();
            if (tableCellEditor != null) {
                tableCellEditor.stopCellEditing();
            }
            this.deleteAttribute();
        } else if (actionEvent.getActionCommand().equals("Show_Logs-GenericProgressDialog")) {
            Debug.println((String)"IndexManagement.actionPerformed: SHOW_LOGS");
            if (this._statusProgressDialog != null) {
                this._statusProgressDialog.pack();
                this._statusProgressDialog.setLocationRelativeTo(this._progressDialog);
                ((Component)this._statusProgressDialog).setLocation(this._progressDialog.getWidth(), this._progressDialog.getHeight());
                this._statusProgressDialog.show();
            }
        } else if (actionEvent.getActionCommand().equals("Close-GenericProgressDialog")) {
            Debug.println((String)"IndexManagement.actionPerformed: CLOSE");
            if (this._statusProgressDialog != null) {
                this._statusProgressDialog.hide();
            }
            this._progressDialog.closeCallBack();
        } else if (actionEvent.getActionCommand().equals("Close")) {
            if (this._statusProgressDialog != null) {
                this._statusProgressDialog.hide();
                this._statusProgressDialog.dispose();
            }
        } else if (actionEvent.getActionCommand().equals("Cancel-GenericProgressDialog")) {
            this._progressDialog.disableCancelButton();
            this._taskCancelled = true;
        }
        this._bAdd.setEnabled(true);
        int n = this._indexTableUser.getSelectedRow();
        if (n >= 0) {
            this._bDelete.setEnabled(true);
        } else {
            this._bDelete.setEnabled(false);
        }
    }

    private void dumpVector(String string, Vector vector) {
    }

    private Vector getAvailAttributes() {
        LDAPSchema lDAPSchema = this.getModel().getSchema();
        if (lDAPSchema == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        Vector vector2 = this._userDataModel.getColumn(0);
        int n = 0;
        while (n < vector2.size()) {
            vector2.setElementAt(((String)vector2.elementAt(n)).toLowerCase(), n);
            ++n;
        }
        this.dumpVector("User", vector2);
        Enumeration enumeration = lDAPSchema.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (vector2.indexOf(string) >= 0) continue;
            if (vector.size() == 0) {
                vector.addElement(string);
                continue;
            }
            int n2 = 0;
            while (n2 < vector.size()) {
                if (string.compareTo((String)vector.elementAt(n2)) < 0) {
                    vector.insertElementAt(string, n2);
                    break;
                }
                ++n2;
            }
            if (n2 != vector.size()) continue;
            vector.insertElementAt(string, n2);
        }
        return vector;
    }

    private void fillRow(IndexAttrTableModel indexAttrTableModel, String string) {
        Vector vector = (Vector)this._attributes.get(string);
        this.dumpVector("fillRow in " + string, vector);
        Vector<Object> vector2 = new Vector<Object>();
        if (vector != null) {
            String string2;
            this.initRow(string, vector2);
            this.dumpVector("fillRow after initRow " + string, vector2);
            int n = 0;
            while (n < vector.size()) {
                string2 = (String)vector.elementAt(n);
                int n2 = 0;
                while (n2 < FILTERS.length) {
                    if (string2.equals(FILTERS[n2])) {
                        vector2.setElementAt(new Boolean(true), n2 + 1);
                        break;
                    }
                    ++n2;
                }
                if (n2 == FILTERS.length) {
                    System.err.println("IndexManagementPanel.fillRow: unkown index type <" + string2 + ">");
                }
                ++n;
            }
            string2 = (String)this._matchingRules.get(string);
            if (string2 == null) {
                string2 = "";
            }
            vector2.setElementAt(string2, this.headers.length - 1);
            this.dumpVector("fillRow out " + string, vector2);
            indexAttrTableModel.addRow(vector2);
        }
    }

    private void initRow(String string, Vector vector) {
        vector.addElement(string);
        int n = 1;
        while (n < this.headers.length - 1) {
            vector.addElement(new Boolean(false));
            ++n;
        }
        vector.addElement("");
    }

    private boolean isPluginEntry(String string) {
        boolean bl = false;
        LDAPConnection lDAPConnection = this.getModel().getServerInfo().getLDAPConnection();
        try {
            String[] stringArray = new String[]{"objectclass"};
            LDAPEntry lDAPEntry = lDAPConnection.read(string, stringArray);
            LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("objectclass");
            if (lDAPAttribute != null && lDAPAttribute.size() > 0) {
                Enumeration enumeration = lDAPAttribute.getStringValues();
                while (!bl && enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    Debug.println((String)("****** IndexManagementPanel.isPluginEntry() value :" + string2));
                    boolean bl2 = bl = string2 != null && string2.compareToIgnoreCase("nsSlapdPlugin") == 0;
                }
            } else {
                bl = false;
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("****** IndexManagementPanel.isPluginEntry() error reading :" + string + " Error is " + lDAPException.toString()));
            return false;
        }
        return bl;
    }

    private Hashtable getIndexedAttributes() {
        LDAPConnection lDAPConnection = this.getModel().getServerInfo().getLDAPConnection();
        String string = this._conf_prefix + this._dnEntry;
        Hashtable hashtable = new Hashtable();
        String[] stringArray = new String[]{"cn", "nsindextype", "nssystemindex", "nsmatchingrule"};
        try {
            Debug.println((String)("getIndexedAttributes() search base :" + string));
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(string, 1, "objectclass=nsIndex", null, false);
            while (lDAPSearchResults.hasMoreElements()) {
                LDAPEntry lDAPEntry = (LDAPEntry)lDAPSearchResults.nextElement();
                String string2 = this.getAttribute(lDAPEntry, stringArray[0]);
                Debug.println((String)("getIndexedAttributes() index cn:" + string2));
                LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(stringArray[1]);
                if (lDAPAttribute == null) continue;
                Vector<String> vector = new Vector<String>();
                Enumeration enumeration = lDAPAttribute.getStringValues();
                while (enumeration.hasMoreElements()) {
                    vector.addElement((String)enumeration.nextElement());
                }
                String string3 = this.getAttribute(lDAPEntry, stringArray[3]);
                if (string3 != null) {
                    this._matchingRules.put(string2, string3);
                }
                if (string2.equals("default")) continue;
                hashtable.put(string2, vector);
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("IndexManagementPanel.createIndexTable: " + (Object)((Object)lDAPException)));
            hashtable.clear();
        }
        return hashtable;
    }

    private String getAttribute(LDAPEntry lDAPEntry, String string) {
        Enumeration enumeration;
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(string);
        String string2 = "";
        if (lDAPAttribute != null && (enumeration = lDAPAttribute.getStringValues()).hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
        }
        return string2;
    }

    static /* synthetic */ void access$900(DefaultIndexManagementPanel defaultIndexManagementPanel, boolean bl) {
        defaultIndexManagementPanel.constructDataModel(bl);
    }

    class ErrorMessageDisplayer
    implements Runnable {
        public ErrorMessageDisplayer(Component component, String string, String string2) {
            DefaultIndexManagementPanel.this._comp = component;
            DefaultIndexManagementPanel.this._msg = string;
            DefaultIndexManagementPanel.this._arg = string2;
        }

        public void run() {
            DSUtil.showInformationDialog(DefaultIndexManagementPanel.this._comp, DefaultIndexManagementPanel.this._msg, DefaultIndexManagementPanel.this._arg, DefaultIndexManagementPanel._section);
        }
    }

    class IndexAttrTableModel
    extends AbstractTableModel {
        protected Vector _columnNames = new Vector();
        protected Vector _tableColumns = new Vector();

        IndexAttrTableModel() {
        }

        public int getColumnCount() {
            return this._columnNames.size();
        }

        public int getRowCount() {
            if (this.getColumnCount() > 0) {
                Vector vector = (Vector)this._tableColumns.elementAt(0);
                return vector.size();
            }
            return 0;
        }

        public String getColumnName(int n) {
            if (n >= this._columnNames.size()) {
                return "";
            }
            return (String)this._columnNames.elementAt(n);
        }

        public Object getValueAt(int n, int n2) {
            if (this.getColumnCount() > 0) {
                Vector vector = (Vector)this._tableColumns.elementAt(n2);
                return vector.elementAt(n);
            }
            return null;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 != 0;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public void setValueAt(Object object, int n, int n2) {
            if (this.isCellEditable(n, n2)) {
                Vector vector = (Vector)this._tableColumns.elementAt(n2);
                vector.setElementAt(object, n);
                Vector<String> vector2 = new Vector<String>();
                int n3 = 1;
                while (n3 < DefaultIndexManagementPanel.this.headers.length - 1) {
                    if (((Boolean)this.getValueAt(n, n3)).equals(new Boolean("true"))) {
                        vector2.addElement(FILTERS[n3 - 1]);
                    }
                    ++n3;
                }
                String string = (String)this.getValueAt(n, 0);
                if (DefaultIndexManagementPanel.this._newAttributes.containsKey(string)) {
                    DefaultIndexManagementPanel.this._newAttributes.put(string, vector2);
                } else {
                    DefaultIndexManagementPanel.this._changedAttributes.put(string, vector2);
                }
                if (n2 == DefaultIndexManagementPanel.this.headers.length - 1) {
                    DefaultIndexManagementPanel.this._matchingRules.put(string, object);
                }
                DefaultIndexManagementPanel.this.setDirtyFlag();
                DefaultIndexManagementPanel.this.setValidFlag();
            }
        }

        void removeRow(int n) {
            int n2 = 0;
            while (n2 < this._tableColumns.size()) {
                Vector vector = (Vector)this._tableColumns.elementAt(n2);
                if (n2 == 0) {
                    String string = (String)vector.elementAt(n);
                    if (DefaultIndexManagementPanel.this._newAttributes.containsKey(string)) {
                        DefaultIndexManagementPanel.this._newAttributes.remove(string);
                    } else {
                        DefaultIndexManagementPanel.this._changedAttributes.put(string, new Vector());
                    }
                }
                vector.removeElementAt(n);
                ++n2;
            }
            this.fireTableRowsDeleted(n, n);
        }

        void removeAllRows() {
            int n = 0;
            while (n < this._tableColumns.size()) {
                Vector vector = (Vector)this._tableColumns.elementAt(n);
                vector.removeAllElements();
                ++n;
            }
            this.fireTableRowsDeleted(0, this._tableColumns.size());
        }

        void insertRowAt(Vector vector, int n) {
            int n2 = 0;
            while (n2 < vector.size()) {
                Vector vector2 = (Vector)this._tableColumns.elementAt(n2);
                vector2.insertElementAt(vector.elementAt(n2), n);
                ++n2;
            }
            this.fireTableRowsInserted(n, n);
        }

        void addRow(Vector vector) {
            int n = 0;
            Vector vector2 = (Vector)this._tableColumns.elementAt(0);
            String string = (String)vector.elementAt(0);
            while (n < vector2.size() && !((String)vector2.elementAt(n)).equals("") && string.compareTo((String)vector2.elementAt(n)) > 0) {
                ++n;
            }
            int n2 = 0;
            while (n2 < vector.size()) {
                vector2 = (Vector)this._tableColumns.elementAt(n2);
                vector2.insertElementAt(vector.elementAt(n2), n);
                ++n2;
            }
            this.fireTableRowsInserted(n, n);
        }

        void addColumn(String string) {
            this._columnNames.addElement(string);
            this._tableColumns.addElement(new Vector());
        }

        int getRowIndex(String string) {
            Vector vector = (Vector)this._tableColumns.elementAt(0);
            int n = 0;
            while (n < vector.size()) {
                if (string.equals((String)vector.elementAt(n))) {
                    return n;
                }
                ++n;
            }
            return 0;
        }

        Vector getColumn(int n) {
            return (Vector)this._tableColumns.elementAt(n);
        }
    }

    class IndexRunnable
    implements Runnable {
        String[] _attrNames = null;

        IndexRunnable(String[] stringArray) {
            this._attrNames = stringArray;
        }

        public void run() {
            LDAPEntry lDAPEntry;
            Object object;
            Object[] objectArray;
            Object object2;
            Vector vector;
            String string;
            boolean bl = true;
            DefaultIndexManagementPanel.this._addedEntries = null;
            Enumeration enumeration = DefaultIndexManagementPanel.this._changedAttributes.keys();
            while (bl && enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                vector = (Vector)DefaultIndexManagementPanel.this._changedAttributes.get(string);
                object2 = "cn=" + string + "," + DefaultIndexManagementPanel.this._conf_prefix + DefaultIndexManagementPanel.this._dnEntry;
                if (DefaultIndexManagementPanel.this._taskCancelled) {
                    DefaultIndexManagementPanel.this.cancel();
                    DefaultIndexManagementPanel.this._taskCancelled = false;
                    return;
                }
                Debug.println((String)("IndexRunnable.run() : deleting dn :" + (String)object2));
                DefaultIndexManagementPanel.this._progressDialog.setTextInLabel(DSUtil._resource.getString(DefaultIndexManagementPanel._section, "delete-entry-title", (String)object2));
                if (vector.size() < 1) {
                    if (!IndexAttrUtility.deleteAttribute(DefaultIndexManagementPanel.this.getModel(), (String)object2)) continue;
                    DefaultIndexManagementPanel.this._attributes = DefaultIndexManagementPanel.this.getIndexedAttributes();
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(this){
                            private final /* synthetic */ IndexRunnable this$1;
                            {
                                this.this$1 = indexRunnable;
                            }

                            public void run() {
                                DefaultIndexManagementPanel.access$900(IndexRunnable.access$800(this.this$1), true);
                            }
                        });
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    DefaultIndexManagementPanel.this._changedAttributes.remove(string);
                    continue;
                }
                objectArray = new String[vector.size()];
                vector.copyInto(objectArray);
                object = (String)DefaultIndexManagementPanel.this._matchingRules.get(string);
                if (object != null && ((String)(object = ((String)object).trim())).length() < 1) {
                    object = null;
                }
                Debug.print((String)("IndexManagement.addAttribute: " + string + " < "));
                int n = 0;
                while (n < objectArray.length) {
                    Debug.print((String)((String)objectArray[n] + " "));
                    ++n;
                }
                if (object != null) {
                    Debug.println((String)("> < " + (String)object + " "));
                }
                Debug.println((String)">");
                lDAPEntry = new LDAPModificationSet();
                lDAPEntry.add(1, new LDAPAttribute("nsindextype"));
                lDAPEntry.add(2, new LDAPAttribute("nsmatchingrule"));
                lDAPEntry.add(0, new LDAPAttribute("nsindextype", (String[])objectArray));
                if (object != null) {
                    lDAPEntry.add(0, new LDAPAttribute("nsmatchingrule", (String)object));
                }
                if (DefaultIndexManagementPanel.this._taskCancelled) {
                    DefaultIndexManagementPanel.this.cancel();
                    DefaultIndexManagementPanel.this._taskCancelled = false;
                    return;
                }
                Debug.println((String)("IndexManagement.okCallback: modifying dn:" + (String)object2));
                DefaultIndexManagementPanel.this._progressDialog.setTextInLabel(DSUtil._resource.getString(DefaultIndexManagementPanel._section, "modify-entry-title", (String)object2));
                if (!IndexAttrUtility.modifyAttributes(DefaultIndexManagementPanel.this.getModel(), (String)object2, (LDAPModificationSet)lDAPEntry)) {
                    Debug.println((String)("IndexManagementPanel.okCallback: failed to modify " + (String)object2));
                    DefaultIndexManagementPanel.this._progressDialog.setTextInLabel(DSUtil._resource.getString(DefaultIndexManagementPanel._section, "modify-entry-error-title", DSUtil.abreviateString((String)object2, 20)));
                    try {
                        SwingUtilities.invokeAndWait(new ErrorMessageDisplayer(DefaultIndexManagementPanel.this._progressDialog, "errorupdatingentries", DSUtil.abreviateString((String)object2, 20)));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    bl = false;
                    continue;
                }
                DefaultIndexManagementPanel.this._changedAttributes.remove(string);
            }
            enumeration = DefaultIndexManagementPanel.this._newAttributes.keys();
            while (bl && enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                vector = (Vector)DefaultIndexManagementPanel.this._newAttributes.get(string);
                if (vector.size() <= 0) continue;
                object2 = new String[vector.size()];
                vector.copyInto((Object[])object2);
                objectArray = "cn=" + string + "," + DefaultIndexManagementPanel.this._conf_prefix + DefaultIndexManagementPanel.this._dnEntry;
                object = new LDAPAttributeSet();
                object.add(new LDAPAttribute("objectclass", OCLASSES));
                object.add(new LDAPAttribute("nsSystemIndex", "false"));
                object.add(new LDAPAttribute("cn", string));
                object.add(new LDAPAttribute("nsindextype", (String[])object2));
                String string2 = (String)DefaultIndexManagementPanel.this._matchingRules.get(string);
                if (string2 != null && (string2 = string2.trim()).length() > 0) {
                    object.add(new LDAPAttribute("nsmatchingrule", string2));
                }
                lDAPEntry = new LDAPEntry((String)objectArray, (LDAPAttributeSet)object);
                if (DefaultIndexManagementPanel.this._taskCancelled) {
                    DefaultIndexManagementPanel.this.cancel();
                    DefaultIndexManagementPanel.this._taskCancelled = false;
                    return;
                }
                Debug.println((String)("IndexManagementPanel.okCallback(): adding dn:" + (String)objectArray));
                DefaultIndexManagementPanel.this._progressDialog.setTextInLabel(DSUtil._resource.getString(DefaultIndexManagementPanel._section, "add-entry-title", (String)objectArray));
                if (!IndexAttrUtility.addAttribute(DefaultIndexManagementPanel.this.getModel(), lDAPEntry)) {
                    Debug.println((String)("IndexManagementPanel.okCallback: failed to add " + (String)objectArray));
                    bl = false;
                } else {
                    DefaultIndexManagementPanel.this._newAttributes.remove(string);
                }
                if (bl) continue;
                DefaultIndexManagementPanel.this._progressDialog.setTextInLabel(DSUtil._resource.getString(DefaultIndexManagementPanel._section, "add-entry-error-title", DSUtil.abreviateString((String)objectArray, 20)));
                try {
                    SwingUtilities.invokeAndWait(new ErrorMessageDisplayer(DefaultIndexManagementPanel.this._progressDialog, "errorupdatingentries", DSUtil.abreviateString((String)objectArray, 20)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (bl) {
                DefaultIndexManagementPanel.this._progressDialog.stepCompleted(0);
                DefaultIndexManagementPanel.this._progressDialog.setTextInLabel(DSUtil._resource.getString(DefaultIndexManagementPanel._section, "LDAPMode-finished-title"));
            } else {
                DefaultIndexManagementPanel.this._progressDialog.setTextInLabel(DSUtil._resource.getString(DefaultIndexManagementPanel._section, "error-cleanup-title"));
                DefaultIndexManagementPanel.this._progressDialog.disableCancelButton();
                DefaultIndexManagementPanel.this.cleanUpEntries();
                DefaultIndexManagementPanel.this._progressDialog.setTextInLabel(DSUtil._resource.getString(DefaultIndexManagementPanel._section, "LDAPMode-endError-title"));
            }
            try {
                SwingUtilities.invokeAndWait(new Runnable(this){
                    private final /* synthetic */ IndexRunnable this$1;
                    {
                        this.this$1 = indexRunnable;
                    }

                    public void run() {
                        IndexRunnable.access$800(this.this$1).resetCallback();
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            DefaultIndexManagementPanel.this._progressDialog.enableButtons(true);
            DefaultIndexManagementPanel.this._progressDialog.closeCallBack();
        }

        static /* synthetic */ DefaultIndexManagementPanel access$800(IndexRunnable indexRunnable) {
            return indexRunnable.DefaultIndexManagementPanel.this;
        }
    }
}

