/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.DSFileField;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.event.DocumentEvent;

public abstract class FilePanel
extends BlankPanel {
    protected DSFileField _tfExport;
    protected JButton _bExport;
    protected JButton _browseButton;
    protected JRadioButton _rbLocal;
    protected JRadioButton _rbRemote;
    protected ResourceSet _resource = DSUtil._resource;
    protected String _section = null;
    protected boolean _onlyLocal = false;
    protected boolean _onlyRemote = false;

    public FilePanel(IDSModel iDSModel, String string) {
        super(iDSModel, string);
        this._section = string;
    }

    public FilePanel(IDSModel iDSModel, String string, boolean bl, boolean bl2) {
        super(iDSModel, string);
        this._section = string;
        this._onlyLocal = bl;
        this._onlyRemote = bl2;
    }

    protected void createFileArea(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = this.getGBC();
        gridBagConstraints.gridwidth = 0;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        ButtonGroup buttonGroup = new ButtonGroup();
        this._rbLocal = this.makeJRadioButton(this._section, "local-file", true);
        buttonGroup.add(this._rbLocal);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 3;
        this._rbRemote = this.makeJRadioButton(this._section, "remote-file", false);
        buttonGroup.add(this._rbRemote);
        JLabel jLabel = this._onlyLocal ? (!super.isLocal() ? this.makeJLabel(this._section, "filename-onlylocal") : this.makeJLabel(this._section, "filename")) : (this._onlyRemote ? (!this.isLocal() ? this.makeJLabel(this._section, "filename-onlyremote") : this.makeJLabel(this._section, "filename")) : this.makeJLabel(this._section, "filename"));
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        --gridBagConstraints.gridwidth;
        this._tfExport = new DSFileField(this, this._section, "filename", "", 25, DSFileField.FILE);
        jLabel.setLabelFor(this._tfExport);
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this._tfExport, gridBagConstraints);
        this._bExport = this.makeJButton(this._section, "browse-file");
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)this._bExport, gridBagConstraints);
        if (!(this.isLocal() || this._onlyRemote || this._onlyLocal)) {
            JPanel jPanel3 = new JPanel(new GridBagLayout());
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 3;
            jPanel3.add((Component)this._rbLocal, gridBagConstraints);
            --gridBagConstraints.gridwidth;
            jPanel3.add((Component)this._rbRemote, gridBagConstraints);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 0;
            jPanel3.add(Box.createHorizontalGlue(), gridBagConstraints);
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            jPanel2.add((Component)jPanel3, gridBagConstraints);
        }
    }

    protected void createSeparator(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = this.getGBC();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)new JSeparator(), gridBagConstraints);
    }

    protected boolean isLocal() {
        return super.isLocal() || this._onlyLocal;
    }

    protected void checkOkay() {
    }

    protected String getFilename() {
        return this._tfExport.getText().trim();
    }

    protected void setFilename(String string) {
        this._tfExport.setText(string.trim());
    }

    protected boolean validateFilename() {
        return this._tfExport.dsValidate();
    }

    protected boolean getLocalState() {
        return !this._rbRemote.isSelected();
    }

    protected void setLocalState(boolean bl) {
        if (this._bExport != null) {
            this._bExport.setEnabled(bl);
            this.repaint();
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        super.changedUpdate(documentEvent);
        this.checkOkay();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        super.removeUpdate(documentEvent);
        this.checkOkay();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        super.insertUpdate(documentEvent);
        this.checkOkay();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this._rbLocal)) {
            this.setLocalState(true);
        } else if (actionEvent.getSource().equals(this._rbRemote)) {
            this.setLocalState(false);
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void resetCallback() {
        this.clearDirtyFlag();
    }

    protected String getDefaultPath(IDSModel iDSModel) {
        return DSUtil.getDefaultLDIFPath(iDSModel.getServerInfo());
    }
}

