/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSFileDialog;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.ContainerPanel;
import com.netscape.admin.dirserv.panel.DSEntryBoolean;
import com.netscape.admin.dirserv.panel.DSEntryCombo;
import com.netscape.admin.dirserv.panel.DSEntryFile;
import com.netscape.admin.dirserv.panel.DSEntryInteger;
import com.netscape.admin.dirserv.panel.DSEntrySet;
import com.netscape.admin.dirserv.panel.GroupPanel;
import com.netscape.admin.dirserv.panel.LogContentPanel;
import com.netscape.admin.dirserv.panel.SimpleDialog;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import netscape.ldap.LDAPException;

public abstract class LogPanel
extends BlankPanel {
    protected static final String LOG_DN = "cn=config";
    protected String LOG_ATTR_NAME;
    protected String LOG_PER_DIR_ATTR_NAME;
    protected String LOG_SIZE_ATTR_NAME;
    protected String ROTATION_TIME_ATTR_NAME;
    protected String ROTATION_UNITS_ATTR_NAME;
    protected String MAX_DISK_SPACE_ATTR_NAME;
    protected String MIN_FREE_SPACE_ATTR_NAME;
    protected String MAX_DAYS_OLD_ATTR_NAME;
    protected String EXPIRATION_UNITS_ATTR_NAME;
    protected String ENABLED_ATTR_NAME;
    protected String LOG_BASE_NAME;
    protected static final String[] RCOMBO_ENTRIES = new String[]{"minute", "hour", "day", "week", "month"};
    protected static final String[] ECOMBO_ENTRIES = new String[]{"day", "week", "month"};
    protected JCheckBox _cbEnabled;
    protected JButton _bView = null;
    protected JTextField _tfLog = null;
    protected JButton _bLog = null;
    protected JTextField _tfLogsPerDir;
    protected JTextField _tfLogSize;
    protected JTextField _tfRotationTime;
    protected JComboBox _cbRotationUnits;
    protected JTextField _tfMaxDiskSpace;
    protected JTextField _tfMinFreeSpace;
    protected JTextField _tfMaxDaysOld;
    protected JLabel _lMaxDiskSpace;
    protected JLabel _lLogSize;
    protected JComboBox _cbExpirationUnits;
    protected ResourceSet _resource = DSUtil._resource;
    protected static final String _section = "log";

    public LogPanel(IDSModel iDSModel) {
        this(iDSModel, null, true);
    }

    public LogPanel(IDSModel iDSModel, String string) {
        this(iDSModel, string, true);
    }

    public LogPanel(IDSModel iDSModel, String string, boolean bl) {
        super(iDSModel, string, bl);
    }

    public void init() {
        this._myPanel.setLayout(new GridBagLayout());
    }

    protected void postInit() {
        Rectangle rectangle = this._myPanel.getVisibleRect();
        Debug.println((String)("LogPanel.postInit: visible = " + rectangle));
    }

    protected void createEnableArea() {
        this._cbEnabled = this.makeJCheckBox(_section, "loggingEnabled");
        this._bView = this.makeJButton(_section, "viewLog");
        DSEntryBoolean dSEntryBoolean = new DSEntryBoolean("off", this._cbEnabled){

            public void show() {
                super.show();
                LogPanel.this.enableFields(LogPanel.this._cbEnabled.isSelected());
            }
        };
        DSEntrySet dSEntrySet = this.getDSEntrySet();
        dSEntrySet.add(LOG_DN, this.ENABLED_ATTR_NAME, dSEntryBoolean);
        this.setComponentTable(this._cbEnabled, dSEntryBoolean);
        GridBagConstraints gridBagConstraints = this.getGBC();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        int n = UIFactory.getDifferentSpace();
        int n2 = UIFactory.getSeparatedSpace();
        gridBagConstraints.insets = new Insets(0, n2, 0, 3);
        this._myPanel.add((Component)this._cbEnabled, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this._myPanel.add(Box.createGlue(), gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        this._myPanel.add((Component)this._bView, gridBagConstraints);
    }

    protected void createConfigArea() {
        this._tfLog = this.makeJTextField(_section, "logDirectory");
        this._tfLog.getAccessibleContext().setAccessibleDescription(this._resource.getString(_section, "log-logDirectory-title"));
        this._bLog = this.makeJButton(_section, "browse");
        GroupPanel groupPanel = new GroupPanel(this._resource.getString(_section, "log-logDirectory-title"));
        this._tfLogsPerDir = this.makeNumericalJTextField(_section, "LogsPerDir");
        JLabel jLabel = this.makeJLabel(_section, "LogsPerDir");
        jLabel.setLabelFor(this._tfLogsPerDir);
        this._tfLogSize = this.makeNumericalJTextField(_section, "LogSize");
        this._lLogSize = this.makeJLabel(_section, "LogSize");
        this._lLogSize.setLabelFor(this._tfLogSize);
        this._tfRotationTime = this.makeNumericalJTextField(_section, "RotationTime");
        JLabel jLabel2 = this.makeJLabel(_section, "RotationTime");
        jLabel2.setLabelFor(this._tfRotationTime);
        this._cbRotationUnits = this.makeJComboBox(_section, "RotationUnits", null);
        jLabel2.setLabelFor(this._cbRotationUnits);
        this._tfMaxDiskSpace = this.makeNumericalJTextField(_section, "MaxDiskSpace");
        this._lMaxDiskSpace = this.makeJLabel(_section, "MaxDiskSpace");
        this._lMaxDiskSpace.setLabelFor(this._tfMaxDiskSpace);
        this._tfMinFreeSpace = this.makeNumericalJTextField(_section, "MinFreeSpace");
        JLabel jLabel3 = this.makeJLabel(_section, "MinFreeSpace");
        jLabel3.setLabelFor(this._tfMinFreeSpace);
        this._tfMaxDaysOld = this.makeNumericalJTextField(_section, "MaxDaysOld");
        JLabel jLabel4 = this.makeJLabel(_section, "MaxDaysOld");
        jLabel4.setLabelFor(this._tfMaxDaysOld);
        this._cbExpirationUnits = this.makeJComboBox(_section, "ExpirationUnits", null);
        jLabel4.setLabelFor(this._cbExpirationUnits);
        if (!this.isLocal()) {
            this._bLog.setEnabled(false);
        }
        DSEntrySet dSEntrySet = this.getDSEntrySet();
        DSEntryFile dSEntryFile = new DSEntryFile(null, this._tfLog, groupPanel, true, this.isLocal());
        dSEntrySet.add(LOG_DN, this.LOG_ATTR_NAME, dSEntryFile);
        this.setComponentTable(this._tfLog, dSEntryFile);
        DSEntryInteger dSEntryInteger = new DSEntryInteger(null, (JComponent)this._tfLogsPerDir, jLabel, -1, 1000, 1);
        dSEntrySet.add(LOG_DN, this.LOG_PER_DIR_ATTR_NAME, dSEntryInteger);
        this.setComponentTable(this._tfLogsPerDir, dSEntryInteger);
        DSEntryInteger dSEntryInteger2 = new DSEntryInteger(null, (JComponent)this._tfLogSize, this._lLogSize, -1, 100000, 1);
        dSEntrySet.add(LOG_DN, this.LOG_SIZE_ATTR_NAME, dSEntryInteger2);
        this.setComponentTable(this._tfLogSize, dSEntryInteger2);
        DSEntryInteger dSEntryInteger3 = new DSEntryInteger(null, (JComponent)this._tfRotationTime, jLabel2, -1, 1000, 1);
        dSEntrySet.add(LOG_DN, this.ROTATION_TIME_ATTR_NAME, dSEntryInteger3);
        this.setComponentTable(this._tfRotationTime, dSEntryInteger3);
        DSEntryCombo dSEntryCombo = new DSEntryCombo(RCOMBO_ENTRIES, this._cbRotationUnits, jLabel2, true);
        dSEntrySet.add(LOG_DN, this.ROTATION_UNITS_ATTR_NAME, dSEntryCombo);
        this.setComponentTable(this._cbRotationUnits, dSEntryCombo);
        DSEntryInteger dSEntryInteger4 = new DSEntryInteger(null, (JComponent)this._tfMaxDiskSpace, this._lMaxDiskSpace, -1, 100000, 1);
        dSEntrySet.add(LOG_DN, this.MAX_DISK_SPACE_ATTR_NAME, dSEntryInteger4);
        this.setComponentTable(this._tfMaxDiskSpace, dSEntryInteger4);
        DSEntryInteger dSEntryInteger5 = new DSEntryInteger(null, (JComponent)this._tfMinFreeSpace, jLabel3, -1, 100000, 1);
        dSEntrySet.add(LOG_DN, this.MIN_FREE_SPACE_ATTR_NAME, dSEntryInteger5);
        this.setComponentTable(this._tfMinFreeSpace, dSEntryInteger5);
        DSEntryInteger dSEntryInteger6 = new DSEntryInteger(null, (JComponent)this._tfMaxDaysOld, jLabel4, -1, 1000, 1);
        dSEntrySet.add(LOG_DN, this.MAX_DAYS_OLD_ATTR_NAME, dSEntryInteger6);
        this.setComponentTable(this._tfMaxDaysOld, dSEntryInteger6);
        DSEntryCombo dSEntryCombo2 = new DSEntryCombo(ECOMBO_ENTRIES, this._cbExpirationUnits, jLabel4, true);
        dSEntrySet.add(LOG_DN, this.EXPIRATION_UNITS_ATTR_NAME, dSEntryCombo2);
        this.setComponentTable(this._cbExpirationUnits, dSEntryCombo2);
        GridBagConstraints gridBagConstraints = this.getGBC();
        JPanel jPanel = this._myPanel;
        gridBagConstraints = this.getGBC();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets.bottom = UIFactory.getDifferentSpace();
        gridBagConstraints.fill = 2;
        groupPanel.add((Component)this._tfLog, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        groupPanel.add((Component)this._bLog, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.fill = 2;
        groupPanel.add(Box.createGlue(), gridBagConstraints);
        gridBagConstraints = this.getGBC();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)groupPanel, gridBagConstraints);
        groupPanel = new GroupPanel(this._resource.getString(_section, "rotation-group-title"));
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)groupPanel, gridBagConstraints);
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        groupPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        groupPanel.add((Component)this._tfLogsPerDir, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        groupPanel.add(Box.createGlue(), gridBagConstraints);
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        groupPanel.add((Component)this._lLogSize, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        groupPanel.add((Component)this._tfLogSize, gridBagConstraints);
        JLabel jLabel5 = this.makeJLabel(_section, "mb");
        jLabel5.setLabelFor(this._tfLogSize);
        groupPanel.add((Component)jLabel5, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        groupPanel.add(Box.createGlue(), gridBagConstraints);
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets.bottom = UIFactory.getDifferentSpace();
        groupPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        groupPanel.add((Component)this._tfRotationTime, gridBagConstraints);
        groupPanel.add((Component)this._cbRotationUnits, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        groupPanel.add(Box.createGlue(), gridBagConstraints);
        groupPanel = new GroupPanel(this._resource.getString(_section, "expiration-group-title"));
        gridBagConstraints = this.getGBC();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)groupPanel, gridBagConstraints);
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        groupPanel.add((Component)this._lMaxDiskSpace, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        groupPanel.add((Component)this._tfMaxDiskSpace, gridBagConstraints);
        jLabel5 = this.makeJLabel(_section, "mb");
        jLabel5.setLabelFor(this._tfMaxDiskSpace);
        groupPanel.add((Component)jLabel5, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        groupPanel.add(Box.createGlue(), gridBagConstraints);
        int n = gridBagConstraints.insets.top;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        JLabel jLabel6 = this.makeJLabel(_section, "limit");
        jLabel6.setLabelFor(this._tfMaxDiskSpace);
        groupPanel.add((Component)jLabel6, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        groupPanel.add(Box.createGlue(), gridBagConstraints);
        gridBagConstraints.insets.top = 2 * n;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        groupPanel.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        groupPanel.add((Component)this._tfMinFreeSpace, gridBagConstraints);
        jLabel5 = this.makeJLabel(_section, "mb");
        jLabel5.setLabelFor(this._tfMinFreeSpace);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        groupPanel.add(Box.createGlue(), gridBagConstraints);
        gridBagConstraints.insets.top = n;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets.bottom = UIFactory.getDifferentSpace();
        groupPanel.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        groupPanel.add((Component)this._tfMaxDaysOld, gridBagConstraints);
        groupPanel.add((Component)this._cbExpirationUnits, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        groupPanel.add(Box.createGlue(), gridBagConstraints);
    }

    public boolean refresh() {
        boolean bl = super.refresh();
        if (this._tfLog.getText().trim().length() == 0) {
            String string = this.getInstanceDirectory() + File.separator + "logs" + File.separator + this.LOG_BASE_NAME;
            this._cbEnabled.setSelected(false);
            this._tfLog.setText(string);
            this.enableFields(false);
        }
        return bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this._cbEnabled)) {
            boolean bl = this._cbEnabled.isSelected();
            this.enableFields(bl);
            super.actionPerformed(actionEvent);
        } else if (actionEvent.getSource().equals(this._bLog)) {
            String string = this._tfLog.getText();
            if (File.separator.equals("\\")) {
                string = string.replace('/', '\\');
            }
            if ((string = DSFileDialog.getFileName(string, false)) != null) {
                this._tfLog.setText(string);
            }
        } else if (actionEvent.getSource().equals(this._bView)) {
            LogContentPanel logContentPanel = this.getViewerPanel();
            SimpleDialog simpleDialog = new SimpleDialog(this.getModel().getFrame(), 12, logContentPanel);
            ((Window)((Object)simpleDialog)).setLocationRelativeTo(this);
            ((JDialog)((Object)simpleDialog)).setDefaultCloseOperation(2);
            simpleDialog.setAutoInit(false);
            ((JDialog)((Object)simpleDialog)).getAccessibleContext().setAccessibleDescription(this._resource.getString(_section, "view-dialog-description"));
            logContentPanel.init();
            logContentPanel.refresh();
            simpleDialog.packAndShow();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    protected void enableFields(boolean bl) {
        if (this._tfLog != null) {
            this._tfLog.setEnabled(bl);
        }
        if (this._bLog != null && this.isLocal()) {
            this._bLog.setEnabled(bl);
        }
        if (this._tfLogsPerDir != null) {
            this._tfLogsPerDir.setEnabled(bl);
        }
        if (this._tfLogSize != null) {
            this._tfLogSize.setEnabled(bl);
        }
        if (this._tfRotationTime != null) {
            this._tfRotationTime.setEnabled(bl);
        }
        if (this._cbRotationUnits != null) {
            this._cbRotationUnits.setEnabled(bl);
        }
        if (this._tfMaxDiskSpace != null) {
            this._tfMaxDiskSpace.setEnabled(bl);
        }
        if (this._tfMinFreeSpace != null) {
            this._tfMinFreeSpace.setEnabled(bl);
        }
        if (this._tfMaxDaysOld != null) {
            this._tfMaxDaysOld.setEnabled(bl);
        }
        if (this._cbExpirationUnits != null) {
            this._cbExpirationUnits.setEnabled(bl);
        }
        this.repaint();
    }

    public void select(IResourceObject iResourceObject, IPage iPage) {
        super.select(iResourceObject, iPage);
        ContainerPanel containerPanel = this.getParentPanel();
        if (containerPanel != null) {
            containerPanel.getOKButton().setVisible(true);
            containerPanel.getCancelButton().setVisible(true);
            containerPanel.updateButtons();
        }
    }

    protected boolean processSaveErrors(LDAPException lDAPException) {
        JFrame jFrame = this.getModel().getFrame();
        if (lDAPException.getLDAPResultCode() == 53) {
            DSUtil.showErrorDialog((Component)jFrame, "invalid-filename", this._tfLog.getText().trim(), _section);
            return false;
        }
        String string = lDAPException.errorCodeToString();
        String string2 = lDAPException.getLDAPErrorMessage();
        if (string2 != null && string2.length() > 0) {
            string = string + ".\n" + string2;
        }
        String[] stringArray = new String[]{string};
        DSUtil.showErrorDialog((Component)jFrame, "save-error", stringArray, _section, this._resource);
        return false;
    }

    protected void validate(DocumentEvent documentEvent) {
        super.validate(documentEvent);
        if (this._tfLogSize != null && this._tfMaxDiskSpace != null) {
            String string = this._tfLogSize.getText();
            String string2 = this._tfMaxDiskSpace.getText();
            if (string != null && string2 != null) {
                try {
                    int n = Integer.parseInt(string);
                    int n2 = Integer.parseInt(string2);
                    if (n > n2) {
                        this.setChangeState(this._lLogSize, 3);
                        this.setChangeState(this._lMaxDiskSpace, 3);
                        this.clearValidFlag();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    Debug.println((String)("LogPanel.validate() " + numberFormatException));
                }
            }
        }
    }

    abstract LogContentPanel getViewerPanel();
}

