/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.DSEntrySet;
import com.netscape.admin.dirserv.panel.LDAPUrlDialog;
import com.netscape.admin.dirserv.panel.MappingUtils;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.Debug;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPUrl;

public class MappingNodeRefPanel
extends BlankPanel
implements SuiConstants {
    private IDSModel _model = null;
    private JLabel _refListLabel;
    private JTextField _refNewRefText;
    private JLabel _refNewRefLabel;
    private JList _refList;
    private String[] _saverefList;
    private JButton _bAddRef;
    private JButton _bDeleteRef;
    private JButton _bHelpRef;
    private DefaultListModel _refData;
    private boolean _refDirty = false;
    private JLabel _refNewHostLabel;
    private JTextField _refNewHostText;
    private JLabel _refNewPortLabel;
    private JTextField _refNewPortText;
    private JLabel _refNewLabel;
    private JLabel _refTargetDNLabel;
    private JTextField _refTargetDNText;
    private static final String _section = "mappingtree-referral";
    static final String CONFIG_BASEDN = "cn=plugins,cn=config";
    static final String CONFIG_MAPPING = "cn=mapping tree,cn=config";
    static final String ADD_REF = "addReferral";
    static final String DELETE_REF = "deleteReferral";
    static final String HELP_REF = "helpReferral";
    private final int ROWS = 4;
    static final int DEFAULT_PADDING = 6;
    static final Insets DEFAULT_EMPTY_INSETS = new Insets(0, 0, 0, 0);
    static final Insets BOTTOM_INSETS = new Insets(6, 6, 6, 6);
    private LDAPEntry _entry = null;

    public MappingNodeRefPanel(IDSModel iDSModel, LDAPEntry lDAPEntry) {
        super(iDSModel, _section);
        this._helpToken = "configuration-mapping-referral-help";
        this._model = iDSModel;
        this._entry = lDAPEntry;
        this._refreshWhenSelect = false;
    }

    public void init() {
        if (this._isInitialized) {
            return;
        }
        this._myPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = this.getGBC();
        DSEntrySet dSEntrySet = this.getDSEntrySet();
        this.createDataArea(this._myPanel, dSEntrySet);
        this.addBottomGlue();
        this._isInitialized = true;
    }

    protected void createDataArea(JPanel jPanel, DSEntrySet dSEntrySet) {
        GridBagConstraints gridBagConstraints = this.getGBC();
        JPanel jPanel2 = new JPanel();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.anchor = 10;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints2.ipadx = 0;
        gridBagConstraints2.ipady = 0;
        jPanel2.setLayout(gridBagLayout);
        this._refListLabel = this.makeJLabel(_section, "list");
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints2.anchor = 16;
        ++gridBagConstraints2.gridy;
        jPanel2.add((Component)this._refListLabel, gridBagConstraints2);
        this._refData = new DefaultListModel();
        this._refList = new JList(this._refData);
        this._refListLabel.setLabelFor(this._refList);
        this._refList.setVisibleRowCount(4);
        this._refList.setCellRenderer(new ReferralCellRenderer());
        this._saverefList = this.getReferralListInEntry();
        int n = 0;
        while (this._saverefList != null && n < this._saverefList.length) {
            this._refData.addElement(this._saverefList[n]);
            ++n;
        }
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().setView(this._refList);
        gridBagConstraints2.anchor = 10;
        gridBagConstraints2.gridx = 0;
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints2.weightx = 1.0;
        jPanel2.add((Component)jScrollPane, gridBagConstraints2);
        this._bDeleteRef = UIFactory.makeJButton(this, _section, "bdelete", null);
        this._bDeleteRef.setActionCommand(DELETE_REF);
        this._bDeleteRef.setEnabled(false);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.anchor = 11;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(0, 9, 0, 0);
        jPanel2.add((Component)this._bDeleteRef, gridBagConstraints2);
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.insets = new Insets(9, 0, 0, 0);
        this._refNewLabel = this.makeJLabel(_section, "new");
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.anchor = 16;
        jPanel2.add((Component)this._refNewLabel, gridBagConstraints2);
        this._refNewRefText = this.makeJTextField(_section, "new");
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.insets = new Insets(0, 0, 6, 0);
        jPanel2.add((Component)this._refNewRefText, gridBagConstraints2);
        this._refNewLabel.setLabelFor(this._refNewRefText);
        this._bAddRef = UIFactory.makeJButton(this, _section, "badd", null);
        this._bAddRef.setActionCommand(ADD_REF);
        this._bAddRef.setEnabled(false);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.insets = new Insets(0, 9, 6, 0);
        jPanel2.add((Component)this._bAddRef, gridBagConstraints2);
        this._bHelpRef = UIFactory.makeJButton(this, _section, "bhelp", null);
        this._bHelpRef.setActionCommand(HELP_REF);
        this._bHelpRef.setEnabled(true);
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.insets = new Insets(0, 9, 6, 0);
        jPanel2.add((Component)this._bHelpRef, gridBagConstraints2);
    }

    private String[] getBackendListInEntry() {
        Vector vector = new Vector(1);
        LDAPAttribute lDAPAttribute = this._entry.getAttribute("nsslapd-backend");
        if (lDAPAttribute != null) {
            return lDAPAttribute.getStringValueArray();
        }
        return null;
    }

    private String[] getReferralListInEntry() {
        Vector vector = new Vector(1);
        LDAPAttribute lDAPAttribute = this._entry.getAttribute("nsslapd-Referral");
        if (lDAPAttribute != null) {
            return lDAPAttribute.getStringValueArray();
        }
        return null;
    }

    private boolean isListEmpty(JList jList) {
        boolean bl = jList.getModel().getSize() == 0;
        return bl;
    }

    private void clearReferralsChanges() {
        this.clearListChanges(this._refListLabel, this._refData, this._saverefList);
        this._refDirty = false;
    }

    private void clearListChanges(JComponent jComponent, DefaultListModel defaultListModel, String[] stringArray) {
        int n = defaultListModel.getSize() - 1;
        while (n >= 0) {
            defaultListModel.removeElementAt(n);
            --n;
        }
        int n2 = 0;
        while (stringArray != null && n2 < stringArray.length) {
            defaultListModel.addElement(stringArray[n2]);
            ++n2;
        }
        this.setChangeState(jComponent, 1);
    }

    private String[] getReferralsInList() {
        Vector vector = new Vector();
        int n = 0;
        while (n < this._refList.getModel().getSize()) {
            vector.addElement(this._refList.getModel().getElementAt(n));
            ++n;
        }
        if (vector.size() == 0) {
            return null;
        }
        String[] stringArray = new String[vector.size()];
        vector.toArray(stringArray);
        return stringArray;
    }

    private void setOkay(boolean bl) {
        AbstractDialog abstractDialog = this.getAbstractDialog();
        if (abstractDialog != null) {
            abstractDialog.setOKButtonEnabled(bl);
        }
    }

    private void checkOkay() {
        this.setOkay(true);
        this.modelUpdate();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(ADD_REF)) {
            String string = this._refNewRefText.getText().trim();
            if (string != null) {
                int n;
                if (!DSUtil.isValidLDAPUrl(string) && (n = DSUtil.showConfirmationDialog((Component)this.getModel().getFrame(), "LDAPUrl-no-good", (String)null, _section)) != 0) {
                    return;
                }
                this._refData.addElement(string);
                this._refNewRefText.setText("");
                this._bAddRef.setEnabled(false);
                this.checkRefDirty();
            }
        } else if (actionEvent.getActionCommand().equals(DELETE_REF)) {
            int[] nArray = this._refList.getSelectedIndices();
            int n = nArray.length - 1;
            while (n >= 0) {
                this._refData.removeElementAt(nArray[n]);
                --n;
            }
            this._bDeleteRef.setEnabled(false);
            this.checkRefDirty();
        } else if (actionEvent.getActionCommand().equals(HELP_REF)) {
            String string = this.constructLDAPUrl();
            if (string != null) {
                this._refNewRefText.setText(string);
                this._bAddRef.setEnabled(true);
            }
        } else {
            Debug.println((String)" MappingNodeSettingPanel.actionPerformed() : wrong action performed");
        }
        this.checkOkay();
    }

    private void checkRefDirty() {
        String[] stringArray = this.getReferralsInList();
        String[] stringArray2 = MappingUtils.whatsMoreInThisList(this._saverefList, stringArray);
        String[] stringArray3 = MappingUtils.whatsMoreInThisList(stringArray, this._saverefList);
        boolean bl = this._refDirty = stringArray2 != null && stringArray2.length > 0 || stringArray3 != null && stringArray3.length > 0;
        if (this._refDirty) {
            this.setDirtyFlag();
            this.setChangeState(this._refListLabel, 2);
        } else {
            this.clearDirtyFlag();
            this.setChangeState(this._refListLabel, 1);
        }
    }

    public void resetCallback() {
        this.reloadEntry();
        this.clearReferralsChanges();
        this.clearDirtyFlag();
    }

    public boolean refresh() {
        this.resetCallback();
        return true;
    }

    public void reloadEntry() {
        if (this._entry == null) {
            return;
        }
        LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
        try {
            this._entry = lDAPConnection.read(this._entry.getDN());
            this._saverefList = this.getReferralListInEntry();
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("MappingNodeRefPanel.reloadEntry(): " + (Object)((Object)lDAPException)));
        }
    }

    public void okCallback() {
        if (this._refDirty) {
            LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
            this.saveRef(lDAPModificationSet);
            LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
            try {
                lDAPConnection.modify(this._entry.getDN(), lDAPModificationSet);
                this._saverefList = this.getReferralsInList();
                this.checkRefDirty();
            }
            catch (LDAPException lDAPException) {
                String[] stringArray = new String[]{this._entry.getDN(), lDAPException.toString()};
                DSUtil.showErrorDialog((Component)this.getModel().getFrame(), "update-error", stringArray, _section);
            }
        }
        this.clearDirtyFlag();
    }

    private void saveRef(LDAPModificationSet lDAPModificationSet) {
        String[] stringArray = this.getReferralsInList();
        if (this._saverefList == null || this._saverefList.length == 0) {
            if (stringArray != null) {
                lDAPModificationSet.add(0, new LDAPAttribute("nsslapd-Referral", stringArray));
            }
        } else {
            String[] stringArray2 = MappingUtils.whatsMoreInThisList(this._saverefList, stringArray);
            String[] stringArray3 = MappingUtils.whatsMoreInThisList(stringArray, this._saverefList);
            if (stringArray2 != null && stringArray2.length != 0) {
                lDAPModificationSet.add(0, new LDAPAttribute("nsslapd-Referral", stringArray2));
            }
            if (stringArray3 != null && stringArray3.length != 0) {
                lDAPModificationSet.add(1, new LDAPAttribute("nsslapd-Referral", stringArray3));
            }
        }
    }

    public boolean doDel() {
        boolean bl = true;
        LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
        if (this._refDirty && this.delRef(lDAPModificationSet)) {
            LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
            try {
                lDAPConnection.modify(this._entry.getDN(), lDAPModificationSet);
                this._saverefList = this.getReferralsInList();
                this.checkRefDirty();
            }
            catch (LDAPException lDAPException) {
                String[] stringArray = new String[]{this._entry.getDN(), lDAPException.toString()};
                DSUtil.showErrorDialog((Component)this.getModel().getFrame(), "update-error", stringArray, _section);
                bl = false;
            }
        }
        return bl;
    }

    private boolean delRef(LDAPModificationSet lDAPModificationSet) {
        String[] stringArray = this.getReferralsInList();
        if (this._saverefList == null || this._saverefList.length == 0) {
            return false;
        }
        String[] stringArray2 = MappingUtils.whatsMoreInThisList(stringArray, this._saverefList);
        if (stringArray2 != null && stringArray2.length != 0) {
            lDAPModificationSet.add(1, new LDAPAttribute("nsslapd-Referral", stringArray2));
            return true;
        }
        return false;
    }

    public boolean doAdd() {
        boolean bl = true;
        LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
        if (this._refDirty && this.addRef(lDAPModificationSet)) {
            LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
            try {
                lDAPConnection.modify(this._entry.getDN(), lDAPModificationSet);
                this._saverefList = this.getReferralsInList();
                this.checkRefDirty();
            }
            catch (LDAPException lDAPException) {
                String[] stringArray = new String[]{this._entry.getDN(), lDAPException.toString()};
                DSUtil.showErrorDialog((Component)this.getModel().getFrame(), "update-error", stringArray, _section);
                bl = false;
            }
        }
        return bl;
    }

    private boolean addRef(LDAPModificationSet lDAPModificationSet) {
        String[] stringArray = this.getReferralsInList();
        if (this._saverefList == null || this._saverefList.length == 0) {
            if (stringArray != null) {
                lDAPModificationSet.add(0, new LDAPAttribute("nsslapd-Referral", stringArray));
                return true;
            }
            return false;
        }
        String[] stringArray2 = MappingUtils.whatsMoreInThisList(this._saverefList, stringArray);
        if (stringArray2 != null && stringArray2.length != 0) {
            lDAPModificationSet.add(0, new LDAPAttribute("nsslapd-Referral", stringArray2));
            return true;
        }
        return false;
    }

    public int nbRef() {
        if (this._isInitialized) {
            return this._refList == null ? 0 : this._refList.getModel().getSize();
        }
        String[] stringArray = this.getReferralListInEntry();
        if (stringArray != null) {
            return stringArray.length;
        }
        return 0;
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        super.changedUpdate(documentEvent);
        this.checkOkay();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        super.removeUpdate(documentEvent);
        this.checkOkay();
    }

    private void modelUpdate() {
        if (this._refDirty) {
            this.setDirtyFlag();
            this.setValidFlag();
        }
    }

    private void addBackend() {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        boolean bl;
        boolean bl2 = bl = this._refNewRefText != null && this._refNewRefText.getText().trim().length() > 0;
        if (this._bAddRef != null) {
            this._bAddRef.setEnabled(bl);
        }
        super.insertUpdate(documentEvent);
        this.checkOkay();
    }

    protected String constructLDAPUrl() {
        LDAPUrlDialog lDAPUrlDialog = new LDAPUrlDialog(this.getModel().getFrame());
        lDAPUrlDialog.packAndShow();
        LDAPUrl lDAPUrl = lDAPUrlDialog.getLDAPUrl();
        if (lDAPUrl != null) {
            return lDAPUrl.getUrl();
        }
        return null;
    }

    class ReferralCellRenderer
    extends DefaultListCellRenderer {
        ReferralCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (jList.isSelectionEmpty()) {
                MappingNodeRefPanel.this._bDeleteRef.setEnabled(false);
            } else {
                MappingNodeRefPanel.this._bDeleteRef.setEnabled(true);
            }
            MappingNodeRefPanel.this.checkOkay();
            return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        }
    }
}

