/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.GroupPanel;
import com.netscape.admin.dirserv.panel.MonitorBasePanel;
import com.netscape.management.client.util.Debug;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Date;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;

public class MonitorServerPanel
extends MonitorBasePanel {
    private Vector _connections = new Vector();
    private String _notBound;
    private String _notApplicable;
    private String _notBlocked;
    private JLabel _currentTimeLabel;
    private String CONFIG_ENTRY = "cn=config";
    private String[] CONFIG_ATTRS = new String[]{"nsslapd-maxdescriptors", "nsslapd-reservedescriptors"};
    private String LDBM_MONITOR_ENTRY = "cn=monitor, cn=ldbm database, cn=plugins, cn=config";
    private LDAPEntry _configEntry = null;
    private LDAPEntry _ldbmEntry = null;
    private JTable _cacheTable = null;
    private JTable _connectionTable = null;
    private MonitorBasePanel.PerfTableModel _currentModel = null;
    private MonitorBasePanel.PerfTableModel _summaryModel = null;
    private static final String _section = "monitorserver";

    public MonitorServerPanel(IDSModel iDSModel) {
        super(iDSModel, _section);
        this._helpToken = "status-perfcounters-server-help";
    }

    public void init() {
        this._myPanel.setLayout(new GridBagLayout());
        this.resetGBC();
        this._entry = this.reload();
        this._configEntry = this.reload(this.CONFIG_ENTRY, this.CONFIG_ATTRS);
        this.createVersionArea(this._myPanel);
        JPanel jPanel = this.createRefreshArea();
        GridBagConstraints gridBagConstraints = this.getGBC();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 9, 0, 9);
        gridBagConstraints.gridwidth = 0;
        this._myPanel.add((Component)jPanel, gridBagConstraints);
        this.createSummaryResourceArea(this._myPanel);
        this.createCurrentResourceArea(this._myPanel);
        this.createConnectionResourceArea(this._myPanel);
        this._ldbmEntry = this.reload(this.LDBM_MONITOR_ENTRY);
        this.createCacheArea(this._myPanel);
        this.validate();
    }

    private LDAPEntry reload() {
        return this.reload(this._entryName);
    }

    private LDAPEntry reload(String string) {
        return this.reload(string, null);
    }

    private LDAPEntry reload(String string, String[] stringArray) {
        LDAPEntry lDAPEntry = null;
        if (this._ldc == null) {
            this._ldc = this.getModel().getServerInfo().getLDAPConnection();
        }
        try {
            lDAPEntry = stringArray == null ? this._ldc.read(string) : this._ldc.read(string, stringArray);
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("MonitorServerPanel.reload: " + this._entryName + ", " + (Object)((Object)lDAPException)));
        }
        return lDAPEntry;
    }

    public boolean refresh() {
        this._entry = this.reload();
        this._configEntry = this.reload(this.CONFIG_ENTRY, this.CONFIG_ATTRS);
        this.updateSummaryAndUsage();
        this.updateConnectionInfo();
        this.updateCacheInfo();
        return super.refresh();
    }

    private void updateConnectionInfo() {
        int n;
        LDAPAttribute lDAPAttribute;
        this._currentTimeLabel.setText(MonitorBasePanel._resource.getString(_section, "currentTime-label") + " " + DSUtil.formatDateTime(this.getAttrValue("currenttime")));
        this._connections.removeAllElements();
        String string = null;
        LDAPAttribute lDAPAttribute2 = lDAPAttribute = this._entry != null ? this._entry.getAttribute("connection") : null;
        if (lDAPAttribute != null) {
            Enumeration enumeration = lDAPAttribute.getStringValues();
            n = 0;
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
                n = 0;
                ConnectionInfo connectionInfo = new ConnectionInfo();
                try {
                    connectionInfo.setIndex(Integer.parseInt(stringTokenizer.nextToken()));
                    connectionInfo.setTime(stringTokenizer.nextToken());
                    connectionInfo.setStartedCount(Integer.parseInt(stringTokenizer.nextToken()));
                    connectionInfo.setCompletedCount(Integer.parseInt(stringTokenizer.nextToken()));
                    connectionInfo.setReadWriteState(stringTokenizer.nextToken());
                    connectionInfo.setBindDN(stringTokenizer.nextToken());
                }
                catch (NoSuchElementException noSuchElementException) {
                    connectionInfo.setBindDN(connectionInfo.getReadWriteState());
                    connectionInfo.setReadWriteState(null);
                }
                this._connections.addElement(connectionInfo);
            }
        }
        if (this._connectionTable != null) {
            int n2 = (this._connectionTable.getRowMargin() + this._connectionTable.getRowHeight()) * this._connectionTable.getRowCount();
            n = this._connectionTable.getPreferredScrollableViewportSize().width;
            this._connectionTable.setPreferredScrollableViewportSize(new Dimension(n, n2));
            this._connectionTable.revalidate();
            this._connectionTable.repaint();
        }
    }

    private void createVersionArea(JComponent jComponent) {
        GridBagConstraints gridBagConstraints = this.getGBC();
        GroupPanel groupPanel = new GroupPanel(MonitorBasePanel._resource.getString(_section, "versionGroup-title"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        jComponent.add((Component)groupPanel, gridBagConstraints);
        String string = MonitorBasePanel._resource.getString(_section, "serverVersion-label");
        string = string + " " + this.getAttrValue("version");
        JLabel jLabel = new JLabel(string);
        jLabel.setLabelFor(groupPanel);
        groupPanel.add((Component)jLabel, gridBagConstraints);
        string = MonitorBasePanel._resource.getString(_section, "configDN-label");
        string = string + " " + this.getAttrValue("ldapserverconfigdn");
        jLabel = new JLabel(string);
        jLabel.setLabelFor(groupPanel);
        groupPanel.add((Component)jLabel, gridBagConstraints);
        string = MonitorBasePanel._resource.getString(_section, "dataVersion-label");
        string = string + " " + this.getAttrValue("dataversion");
        jLabel = new JLabel(string);
        jLabel.setLabelFor(groupPanel);
        groupPanel.add((Component)jLabel, gridBagConstraints);
        string = MonitorBasePanel._resource.getString(_section, "startTime-label");
        string = string + " " + DSUtil.formatDateTime(this.getAttrValue("starttime"));
        jLabel = new JLabel(string);
        jLabel.setLabelFor(groupPanel);
        groupPanel.add((Component)jLabel, gridBagConstraints);
        string = MonitorBasePanel._resource.getString(_section, "currentTime-label");
        string = string + " " + DSUtil.formatDateTime(this.getAttrValue("currenttime"));
        this._currentTimeLabel = new JLabel(string);
        this._currentTimeLabel.setLabelFor(groupPanel);
        groupPanel.add((Component)this._currentTimeLabel, gridBagConstraints);
    }

    private void createSummaryResourceArea(JComponent jComponent) {
        String[] stringArray = new String[]{"totalconnections", "opsinitiated", "opscompleted", "entriessent", "bytessent"};
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray2[n2] = MonitorBasePanel._resource.getString(_section, "summaryTable" + n2 + "-label");
            ++n2;
        }
        int n3 = 3;
        String[] stringArray3 = new String[n3];
        int n4 = 0;
        while (n4 < n3) {
            stringArray3[n4] = MonitorBasePanel._resource.getString(_section, "summaryHeader" + n4 + "-label");
            ++n4;
        }
        MonitorBasePanel.PerfTableModel perfTableModel = new MonitorBasePanel.PerfTableModel(stringArray2, stringArray3, stringArray){

            public Object getValueAt(int n, int n2) {
                String string = (String)super.getValueAt(n, n2);
                if (string == null || string.length() < 1) {
                    return "";
                }
                if (n2 == 2) {
                    Date date = DSUtil.getDateTime(MonitorServerPanel.this.getAttrValue("starttime"));
                    Date date2 = DSUtil.getDateTime(MonitorServerPanel.this.getAttrValue("currenttime"));
                    long l = (date2.getTime() - date.getTime()) / 60000L;
                    if (l < 1L) {
                        l = 1L;
                    }
                    float f = Float.valueOf(string).floatValue() / (float)l;
                    f = (float)((double)((long)(((double)f + 0.05) * 10.0)) / 10.0);
                    string = Float.toString(f);
                }
                return string;
            }
        };
        JTable jTable = new JTable(perfTableModel);
        this._summaryModel = perfTableModel;
        this.rightAlignColumns(jTable, 1, n3 - 1);
        this._tables.addElement(jTable);
        int[] nArray = new int[]{150, 100, 100};
        this.setColumnWidths(jTable, nArray);
        this.addTable(jTable, jComponent, MonitorBasePanel._resource.getString(_section, "summaryGroup-title"));
        jTable.setAutoResizeMode(1);
        jTable.getAccessibleContext().setAccessibleDescription(MonitorBasePanel._resource.getString(_section, "summaryGroup-title"));
    }

    private void createCurrentResourceArea(JComponent jComponent) {
        this._notApplicable = MonitorBasePanel._resource.getString(_section, "notApplicable-label");
        String[] stringArray = new String[]{"threads", "currentconnections", "dtablesize", "readwaiters", "nbackends"};
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray2[n2] = MonitorBasePanel._resource.getString(_section, "resourceTable" + n2 + "-label");
            ++n2;
        }
        int n3 = 2;
        String[] stringArray3 = new String[n3];
        int n4 = 0;
        while (n4 < n3) {
            stringArray3[n4] = MonitorBasePanel._resource.getString(_section, "resourceHeader" + n4 + "-label");
            ++n4;
        }
        MonitorBasePanel.PerfTableModel perfTableModel = new MonitorBasePanel.PerfTableModel(stringArray2, stringArray3, stringArray){

            public Object getValueAt(int n, int n2) {
                String string = (String)super.getValueAt(n, n2);
                if (string == null || string.length() < 1) {
                    return "";
                }
                if (n2 == 1) {
                    if (n == 2) {
                        string = Integer.toString(MonitorServerPanel.this.computeRemainingConnections());
                    } else if (n == 5) {
                        if (string == null || string.length() < 1) {
                            string = MonitorServerPanel.this._notApplicable;
                        }
                    } else if (string == null || string.length() < 1) {
                        string = Integer.toString(0);
                    }
                }
                return string;
            }
        };
        JTable jTable = new JTable(perfTableModel);
        this._currentModel = perfTableModel;
        this.rightAlignColumns(jTable, 1, n3 - 1);
        this._tables.addElement(jTable);
        int[] nArray = new int[]{250, 100};
        this.setColumnWidths(jTable, nArray);
        this.setColumnHeaders(jTable, stringArray3);
        this.addTable(jTable, jComponent, MonitorBasePanel._resource.getString(_section, "resourceGroup-title"));
        jTable.getAccessibleContext().setAccessibleDescription(MonitorBasePanel._resource.getString(_section, "resourceGroup-title"));
    }

    int computeRemainingConnections() {
        String string = this.getAttrValue("dtablesize");
        String string2 = this.getAttrValue("currentconnections");
        String string3 = DSUtil.getAttrValue(this._configEntry, "nsslapd-maxdescriptors");
        String string4 = DSUtil.getAttrValue(this._configEntry, "nsslapd-reservedescriptors");
        int n = Integer.parseInt(string);
        int n2 = Integer.parseInt(string2);
        int n3 = string3.length() == 0 ? n : Integer.parseInt(string3);
        int n4 = string4.length() == 0 ? 0 : Integer.parseInt(string4);
        int n5 = n3 - n4 - n2;
        Debug.println((String)("MonitorServerPanel.computeRemainingConnections: dTableSizeStr = " + string));
        Debug.println((String)("MonitorServerPanel.computeRemainingConnections: currentConnStr = " + string2));
        Debug.println((String)("MonitorServerPanel.computeRemainingConnections: maxDescStr = " + string3));
        Debug.println((String)("MonitorServerPanel.computeRemainingConnections: reservedDescStr = " + string4));
        if (n5 < 0) {
            n5 = 0;
        }
        return n5;
    }

    private void createConnectionResourceArea(JComponent jComponent) {
        this.updateConnectionInfo();
        this._notBound = MonitorBasePanel._resource.getString(_section, "notBound-label");
        this._notBlocked = MonitorBasePanel._resource.getString(_section, "notBlocked-label");
        String[] stringArray = new String[]{"connection"};
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        stringArray2[0] = "";
        int n2 = 5;
        String[] stringArray3 = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            stringArray3[n3] = MonitorBasePanel._resource.getString(_section, "connectionHeader" + n3 + "-label");
            ++n3;
        }
        MonitorBasePanel.PerfTableModel perfTableModel = new MonitorBasePanel.PerfTableModel(stringArray2, stringArray3, stringArray){

            public int getRowCount() {
                LDAPAttribute lDAPAttribute = MonitorServerPanel.this._entry != null ? MonitorServerPanel.this._entry.getAttribute(this._dataNames[0]) : null;
                return lDAPAttribute != null ? lDAPAttribute.size() : 0;
            }

            public Object getValueAt(int n, int n2) {
                if (n >= MonitorServerPanel.this._connections.size()) {
                    return "";
                }
                String string = null;
                ConnectionInfo connectionInfo = (ConnectionInfo)MonitorServerPanel.this._connections.elementAt(n);
                if (n2 == 0) {
                    Date date = connectionInfo.getDate();
                    string = date.toString();
                } else if (n2 == 1) {
                    string = Integer.toString(connectionInfo.getStartedCount());
                } else if (n2 == 2) {
                    string = Integer.toString(connectionInfo.getCompletedCount());
                } else if (n2 == 3) {
                    string = connectionInfo.getBindDN();
                    if (string.equals("NULLDN")) {
                        string = MonitorServerPanel.this._notBound;
                    }
                } else if (n2 == 4 && (string = connectionInfo.getReadWriteState()) == null) {
                    string = MonitorServerPanel.this._notBlocked;
                }
                if (string == null) {
                    return "";
                }
                return string;
            }
        };
        this._connectionTable = new JTable(perfTableModel);
        this.rightAlignColumns(this._connectionTable, 1, 2);
        this._tables.addElement(this._connectionTable);
        int[] nArray = new int[]{100, 45, 60, 100, 75};
        this.setColumnWidths(this._connectionTable, nArray);
        this.setColumnHeaders(this._connectionTable, stringArray3);
        this.addTable(this._connectionTable, jComponent, MonitorBasePanel._resource.getString(_section, "connectionGroup-title"));
        this._connectionTable.getAccessibleContext().setAccessibleDescription(MonitorBasePanel._resource.getString(_section, "connectionGroup-title"));
        this._connectionTable.setAutoResizeMode(1);
    }

    private void createCacheArea(JComponent jComponent) {
        String[] stringArray = new String[]{"dbcachehits", "dbcachetries", "dbcachehitratio", "dbcachepagein", "dbcachepageout", "dbcacheroevict", "dbcacherwevict"};
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray2[n2] = MonitorBasePanel._resource.getString(_section, "cacheTable-" + stringArray[n2] + "-label");
            ++n2;
        }
        int n3 = 2;
        String[] stringArray3 = new String[n3];
        int n4 = 0;
        while (n4 < n3) {
            stringArray3[n4] = MonitorBasePanel._resource.getString(_section, "cacheHeader" + n4 + "-label");
            ++n4;
        }
        int[] nArray = new int[]{250, 100};
        this._cacheTable = this.makeTable(stringArray2, stringArray3, stringArray, nArray, this._ldbmEntry);
        this.rightAlignColumns(this._cacheTable, 1, n3 - 1);
        this.addTable(this._cacheTable, jComponent, MonitorBasePanel._resource.getString(_section, "cacheGroup-title"));
        this._cacheTable.getAccessibleContext().setAccessibleDescription(MonitorBasePanel._resource.getString(_section, "cacheGroup-title"));
    }

    private JTable makeTable(String[] stringArray, String[] stringArray2, String[] stringArray3, int[] nArray) {
        return this.makeTable(stringArray, stringArray2, stringArray3, nArray, this._entry);
    }

    private JTable makeTable(String[] stringArray, String[] stringArray2, String[] stringArray3, int[] nArray, LDAPEntry lDAPEntry) {
        MonitorBasePanel.PerfTableModel perfTableModel = new MonitorBasePanel.PerfTableModel(this, stringArray, stringArray2, stringArray3, lDAPEntry);
        JTable jTable = new JTable(perfTableModel);
        this._tables.addElement(jTable);
        this.setColumnWidths(jTable, nArray);
        this.setColumnHeaders(jTable, stringArray2);
        return jTable;
    }

    private void updateCacheInfo() {
        MonitorBasePanel.PerfTableModel perfTableModel = (MonitorBasePanel.PerfTableModel)this._cacheTable.getModel();
        this._ldbmEntry = this.reload(this.LDBM_MONITOR_ENTRY);
        perfTableModel.updEntry(this._ldbmEntry);
    }

    private void updateSummaryAndUsage() {
        Object var1_1 = null;
        if (this._summaryModel != null) {
            this._summaryModel.updEntry(this._entry);
        }
        if (this._currentModel != null) {
            this._currentModel.updEntry(this._entry);
        }
    }

    private class ConnectionInfo {
        private int _index = 0;
        String _time = null;
        int _started = 0;
        int _completed = 0;
        String _state = null;
        String _dn = null;
        Date _date = null;

        ConnectionInfo() {
        }

        void setIndex(int n) {
            this._index = n;
        }

        void setTime(String string) {
            this._time = string;
            this._date = DSUtil.getDateTime(string);
        }

        void setStartedCount(int n) {
            this._started = n;
        }

        void setCompletedCount(int n) {
            this._completed = n;
        }

        void setReadWriteState(String string) {
            this._state = string;
        }

        void setBindDN(String string) {
            this._dn = string;
        }

        int getIndex() {
            return this._index;
        }

        String getTime() {
            return this._time;
        }

        Date getDate() {
            return this._date;
        }

        int getStartedCount() {
            return this._started;
        }

        int getCompletedCount() {
            return this._completed;
        }

        String getReadWriteState() {
            return this._state;
        }

        String getBindDN() {
            return this._dn;
        }

        public String toString() {
            String string = "ConnectionInfo: ";
            string = string + this._index + ", start time = " + this._time + ", ops = " + this._started + ", completed = " + this._completed + ", state = " + this._state + ", bindDN = " + this._dn;
            return string;
        }
    }
}

