/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSEntryObject;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.DSEntryBoolean;
import com.netscape.admin.dirserv.panel.DSEntryTextStrict;
import com.netscape.admin.dirserv.panel.GroupPanel;
import com.netscape.admin.dirserv.panel.PluginPanel;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.text.JTextComponent;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;

class PluginStatusPanel
extends BlankPanel
implements FocusListener {
    private JPanel _attributesPanel;
    private JPanel _argumentsPanel;
    private JPanel _fieldsPanel;
    private JPanel _argumentsButtonsPanel;
    private JTextComponent _fieldWithFocus;
    private static final String ADD_ARGUMENT = "add argument";
    private static final String DELETE_ARGUMENT = "delete argument";
    private boolean _disableDocumentEvents = false;
    private Hashtable _htdsEntries = null;
    private Hashtable _htLabels = null;
    private Hashtable _htArguments = null;
    private Hashtable _htEnabled = null;
    private JButton _bAdd;
    private JButton _bDelete;
    private final String NO_ARGS = DSUtil._resource.getString("plugins", "noargs-label");
    private LDAPEntry _entry;
    private Hashtable _fields = null;
    private Hashtable _arguments = null;
    private Hashtable _dsEntryFields = null;
    private JCheckBox _cbEnabled = null;
    private DSEntryBoolean _dsEntryEnabled = null;
    private static boolean EDITABLE_FIELDS = true;
    private final String[] EDITABLE_ATTRNAMES = new String[]{"nsslapd-plugininitfunc", "nsslapd-pluginpath"};
    private final String[] NON_EDITABLE_ATTRNAMES = new String[]{"nsslapd-pluginid", "nsslapd-plugindescription", "nsslapd-pluginversion", "nsslapd-pluginvendor", "nsslapd-plugintype"};
    private final String[] ATTRNAMES = new String[]{"nsslapd-pluginid", "nsslapd-plugindescription", "nsslapd-pluginversion", "nsslapd-pluginvendor", "nsslapd-plugintype", "nsslapd-plugininitfunc", "nsslapd-pluginpath"};
    private final String[] NON_ENABLABLE_PLUGINS_INIT_FUNCTION = new String[]{"bin_init", "boolean_init", "ces_init", "cis_init", "cos_init", "country_init", "dn_init", "time_init", "int_init", "ldbm_back_init", "octetstring_init", "postal_init", "roles_init", "tel_init", "uri_init", "des_init", "clear_pwd_storage_scheme_init", "crypt_pwd_storage_scheme_init", "ns_mta_md5_pwd_storage_scheme_init", "sha_pwd_storage_scheme_init", "ssha_pwd_storage_scheme_init"};
    private static final String PATH = "nsslapd-pluginpath";
    private static final String ID = "nsslapd-pluginid";
    private static final String ENABLED = "nsslapd-pluginenabled";
    private static final String INITFUNC = "nsslapd-plugininitfunc";
    private static final String TYPE = "nsslapd-plugintype";
    private static final String VERSION = "nsslapd-pluginversion";
    private static final String VENDOR = "nsslapd-pluginvendor";
    private static final String DESCRIPTION = "nsslapd-plugindescription";
    private static final String ARG = "nsslapd-pluginarg";
    private static final String ARGS = "arguments";
    private static final String ATTRS = "attributes";
    private static final String DEPENDS_ON_NAMED = "nsslapd-plugin-depends-on-named";
    private static final String NAME_ATTR = "cn";
    private static final String ON = "on";
    private static final String _section = "plugins";

    public PluginStatusPanel(IDSModel iDSModel, LDAPEntry lDAPEntry) {
        super(iDSModel, _section);
        this._helpToken = "configuration-plugins-help";
        this._entry = lDAPEntry;
    }

    private String getAttrVal(String string) {
        Enumeration enumeration;
        LDAPAttribute lDAPAttribute;
        if (this._entry != null && (lDAPAttribute = this._entry.getAttribute(string)) != null && (enumeration = lDAPAttribute.getStringValues()) != null && enumeration.hasMoreElements()) {
            return (String)enumeration.nextElement();
        }
        return "";
    }

    void updateFromEntry(LDAPEntry lDAPEntry) {
        this._fieldWithFocus = null;
        this._disableDocumentEvents = true;
        this._entry = lDAPEntry;
        this.init();
        this.updatePanel();
        this._disableDocumentEvents = false;
    }

    public void refreshFromServer() {
        this.resetCallback();
    }

    public void init() {
        if (this._htEnabled == null) {
            this._htEnabled = new Hashtable();
            this._htLabels = new Hashtable();
            this._htdsEntries = new Hashtable();
            this._fields = new Hashtable();
            this._htArguments = new Hashtable();
            this.createPanel();
        }
    }

    public void createPanel() {
        this._cbEnabled = this.makeJCheckBox(_section, "enabled");
        GridBagConstraints gridBagConstraints = this.getGBC();
        this._attributesPanel = new GroupPanel(DSUtil._resource.getString(_section, "attributes-label"));
        this._attributesPanel.setLayout(new GridBagLayout());
        EDITABLE_FIELDS = false;
        this.addEntry(this._attributesPanel, "id", ID);
        this.addEntry(this._attributesPanel, "description", DESCRIPTION);
        this.addEntry(this._attributesPanel, "version", VERSION);
        this.addEntry(this._attributesPanel, "vendor", VENDOR);
        this.addEntry(this._attributesPanel, "type", TYPE);
        EDITABLE_FIELDS = true;
        this.addEntry(this._attributesPanel, "initfunc", INITFUNC);
        this.addEntry(this._attributesPanel, "path", PATH);
        this._argumentsButtonsPanel = this.createArgumentsButtonsPanel();
        this._fieldsPanel = new JPanel();
        this._fieldsPanel.setLayout(new GridBagLayout());
        this._argumentsPanel = new GroupPanel(DSUtil._resource.getString(_section, "arguments-label"));
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.bottom = UIFactory.getComponentSpace();
        this._argumentsPanel.add((Component)this._fieldsPanel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        this._argumentsPanel.add((Component)this._argumentsButtonsPanel, gridBagConstraints);
        this._myPanel.setLayout(new GridBagLayout());
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        int n = UIFactory.getDifferentSpace();
        int n2 = UIFactory.getSeparatedSpace();
        gridBagConstraints.insets = new Insets(0, n2, 0, n);
        this._myPanel.add((Component)this._cbEnabled, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        this._myPanel.add(Box.createGlue(), gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this._myPanel.add((Component)this._attributesPanel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this._myPanel.add((Component)this._argumentsPanel, gridBagConstraints);
        this.addBottomGlue();
        this.validate();
        this._isInitialized = true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this._cbEnabled)) {
            this.validateCheckBox();
            this.validateButtons();
            this._fieldWithFocus = null;
        } else if (actionEvent.getActionCommand().equals(ADD_ARGUMENT)) {
            int n = this._arguments.size();
            JTextComponent jTextComponent = null;
            DSEntryTextStrict dSEntryTextStrict = (DSEntryTextStrict)this._dsEntryFields.get(ARG + n);
            if (dSEntryTextStrict != null) {
                jTextComponent = (JTextComponent)dSEntryTextStrict.getView(0);
            }
            if (jTextComponent == null) {
                jTextComponent = this.makeCustomJTextField("");
            } else {
                jTextComponent.setText("");
            }
            this._arguments.put(ARG + n, jTextComponent);
            if (n == 0) {
                this._fieldsPanel.removeAll();
            }
            this.addEntryField(this._fieldsPanel, this.getLabelForArgument(n), jTextComponent);
            this.refresh();
            this.validateFields();
            this.validateButtons();
            this._fieldWithFocus = null;
        } else if (actionEvent.getActionCommand().equals(DELETE_ARGUMENT)) {
            int n = this._arguments.size();
            if (n < 1) {
                return;
            }
            if (n == 1) {
                this._fieldsPanel.removeAll();
                this._fieldsPanel.add(new JLabel(this.NO_ARGS));
                this._arguments.remove("nsslapd-pluginarg0");
                this.refresh();
                this._myPanel.revalidate();
                this._myPanel.repaint();
                this.validateFields();
                this.validateButtons();
            } else {
                int n2 = 0;
                boolean bl = false;
                if (this._fieldWithFocus != null) {
                    JTextComponent jTextComponent;
                    while ((jTextComponent = (JTextComponent)this._arguments.get(ARG + n2)) != null) {
                        if (jTextComponent.equals(this._fieldWithFocus)) {
                            while (n2 < n - 1) {
                                JTextComponent jTextComponent2 = (JTextComponent)this._arguments.get(ARG + ++n2);
                                this._disableDocumentEvents = true;
                                jTextComponent.setText(jTextComponent2.getText());
                                this._disableDocumentEvents = false;
                                jTextComponent = jTextComponent2;
                            }
                            bl = true;
                            break;
                        }
                        ++n2;
                    }
                    if (bl) {
                        this._fieldsPanel.remove(this.getLabelForArgument(n - 1));
                        this._fieldsPanel.remove((JTextComponent)this._arguments.get(ARG + (n - 1)));
                        this._arguments.remove(ARG + (n - 1));
                        this.refresh();
                        this.validateFields();
                        this.validateButtons();
                    }
                }
                this._fieldWithFocus = null;
            }
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void okCallback() {
        boolean bl = true;
        boolean bl2 = false;
        String string = this._entry.getDN();
        LDAPConnection lDAPConnection = this.getModel().getServerInfo().getLDAPConnection();
        if (this.isModified() && (bl &= this.saveEntry(lDAPConnection, string))) {
            bl2 |= DSUtil.requiresRestart(string, ENABLED);
        }
        if (bl2) {
            DSUtil.showInformationDialog((Component)this.getModel().getFrame(), "requires-restart", (String)null);
        }
        this.getModel().setWaitCursor(true);
        if (bl) {
            this.clearDirtyFlag();
            this.clearValidFlag();
        }
        this.updatePanel();
        this.getModel().setWaitCursor(false);
    }

    public void resetCallback() {
        this.getModel().setWaitCursor(true);
        boolean bl = true;
        String string = this._entry.getDN();
        LDAPConnection lDAPConnection = this.getModel().getServerInfo().getLDAPConnection();
        bl &= this.resetEntry(lDAPConnection, string);
        this.updateArgumentsPanel();
        this.validateFields();
        this.validateCheckBox();
        this.refresh();
        if (bl) {
            this.clearDirtyFlag();
            this.clearValidFlag();
        }
        this.getModel().setWaitCursor(false);
    }

    private void validateCheckBox() {
        JComponent jComponent = this._dsEntryEnabled.getView(this._dsEntryEnabled.getViewCount() - 1);
        switch (this._dsEntryEnabled.doValidate()) {
            case 2: {
                this.setChangeState(jComponent, 2);
                break;
            }
            case 3: {
                this.setChangeState(jComponent, 3);
                break;
            }
            case 0: {
                this.setChangeState(jComponent, 1);
                break;
            }
            case 1: {
                this.setChangeState(jComponent, 3);
            }
        }
    }

    private void validateButtons() {
        if (this.isModified()) {
            this.setDirtyFlag();
            if (this.isValid()) {
                this.setValidFlag();
            } else {
                this.clearValidFlag();
            }
        } else {
            this.clearDirtyFlag();
            this.clearValidFlag();
        }
        this.setDeleteButtonEnabled(false);
        if (this._fieldWithFocus != null && this._fieldWithFocus.hasFocus()) {
            this.setDeleteButtonEnabled(true);
        }
    }

    private void validateFields() {
        Serializable serializable;
        Object object;
        DSEntryTextStrict dSEntryTextStrict;
        int n = 0;
        while (n < this.EDITABLE_ATTRNAMES.length) {
            dSEntryTextStrict = (DSEntryTextStrict)this._dsEntryFields.get(this.EDITABLE_ATTRNAMES[n]);
            if (dSEntryTextStrict != null) {
                object = dSEntryTextStrict.getView(dSEntryTextStrict.getViewCount() - 1);
                switch (dSEntryTextStrict.doValidate()) {
                    case 2: {
                        this.setChangeState((JComponent)object, 2);
                        break;
                    }
                    case 3: {
                        this.setChangeState((JComponent)object, 3);
                        break;
                    }
                    case 0: {
                        this.setChangeState((JComponent)object, 1);
                        break;
                    }
                    case 1: {
                        this.setChangeState((JComponent)object, 3);
                    }
                }
            }
            ++n;
        }
        if (this.isLocal() && !(serializable = new File((String)(object = ((JTextComponent)this._fields.get(PATH)).getText().trim()))).isFile()) {
            this.setChangeState((JLabel)this._htLabels.get(PATH), 3);
        }
        int n2 = 0;
        while ((dSEntryTextStrict = (DSEntryTextStrict)this._dsEntryFields.get(ARG + n2)) != null) {
            serializable = dSEntryTextStrict.getView(dSEntryTextStrict.getViewCount() - 1);
            switch (dSEntryTextStrict.doValidate()) {
                case 2: {
                    this.setChangeState((JComponent)serializable, 2);
                    break;
                }
                case 3: {
                    this.setChangeState((JComponent)serializable, 3);
                    break;
                }
                case 0: {
                    this.setChangeState((JComponent)serializable, 1);
                    break;
                }
                case 1: {
                    this.setChangeState((JComponent)serializable, 3);
                }
            }
            ++n2;
        }
        n2 = this._dsEntryFields.size() - this.ATTRNAMES.length;
        while (n2 < this._arguments.size()) {
            JTextField jTextField = (JTextField)this._arguments.get(ARG + n2);
            if (jTextField.getText().trim().equals("")) {
                this.setChangeState(this.getLabelForArgument(n2), 3);
            } else {
                this.setChangeState(this.getLabelForArgument(n2), 2);
            }
            ++n2;
        }
    }

    private boolean saveEntry(LDAPConnection lDAPConnection, String string) {
        boolean bl = false;
        boolean bl2 = false;
        String string2 = "";
        LDAPModificationSet lDAPModificationSet = null;
        if (this._dsEntryEnabled.isModified()) {
            lDAPModificationSet = new LDAPModificationSet();
            lDAPModificationSet.add(2, new LDAPAttribute(ENABLED, this._dsEntryEnabled.localToRemote()));
        }
        while (!bl2) {
            Object object;
            try {
                String string3;
                DSEntryTextStrict dSEntryTextStrict;
                this._entry = lDAPConnection.read(string);
                int n = 0;
                while (n < this.EDITABLE_ATTRNAMES.length) {
                    string2 = ((JTextComponent)this._fields.get(this.EDITABLE_ATTRNAMES[n])).getText();
                    if (!string2.equals(this.getAttrVal(this.EDITABLE_ATTRNAMES[n]))) {
                        if (lDAPModificationSet == null) {
                            lDAPModificationSet = new LDAPModificationSet();
                        }
                        lDAPModificationSet.add(2, new LDAPAttribute(this.EDITABLE_ATTRNAMES[n], string2));
                        dSEntryTextStrict = (DSEntryTextStrict)this._dsEntryFields.get(this.EDITABLE_ATTRNAMES[n]);
                        if (dSEntryTextStrict != null) {
                            dSEntryTextStrict.reset();
                        }
                    }
                    ++n;
                }
                int n2 = 0;
                while ((object = (JTextComponent)this._arguments.get(ARG + n2)) != null) {
                    string2 = ((JTextComponent)object).getText();
                    if (!string2.equals(this.getAttrVal(ARG + n2))) {
                        if (lDAPModificationSet == null) {
                            lDAPModificationSet = new LDAPModificationSet();
                        }
                        lDAPModificationSet.add(2, new LDAPAttribute(ARG + n2, string2));
                    }
                    ++n2;
                }
                while (!this.getAttrVal(ARG + n2).equals("")) {
                    if (lDAPModificationSet == null) {
                        lDAPModificationSet = new LDAPModificationSet();
                    }
                    lDAPModificationSet.add(1, new LDAPAttribute(ARG + n2));
                    ++n2;
                }
                if (lDAPModificationSet != null) {
                    lDAPConnection.modify(string, lDAPModificationSet);
                }
                this._entry = lDAPConnection.read(string);
                n2 = 0;
                while (!(string3 = this.getAttrVal(ARG + n2)).equals("")) {
                    object = (JTextComponent)this._arguments.get(ARG + n2);
                    if (object == null) {
                        object = this.makeCustomJTextField(string3);
                    }
                    dSEntryTextStrict = new DSEntryTextStrict(string3, (JComponent)object, this.getLabelForArgument(n2));
                    this._dsEntryFields.put(ARG + n2, dSEntryTextStrict);
                    dSEntryTextStrict.show();
                    ++n2;
                }
                int n3 = n2;
                while (this._arguments.get(ARG + n2) != null) {
                    this._arguments.remove(ARG + n2);
                    ++n2;
                }
                n2 = n3;
                while (this._dsEntryFields.get(ARG + n2) != null) {
                    this._dsEntryFields.remove(ARG + n2);
                    ++n2;
                }
                if (this.isModified()) {
                    this._dsEntryEnabled.reset();
                }
                bl = true;
                bl2 = true;
            }
            catch (LDAPException lDAPException) {
                IDSModel iDSModel = this.getModel();
                Debug.println((String)("PluginPanel.saveEntry(): LDAP error code = " + lDAPException.getLDAPResultCode() + " error=" + (Object)((Object)lDAPException)));
                if (lDAPException.getLDAPResultCode() == 50) {
                    object = (String)iDSModel.getServerInfo().get("rootdn");
                    if (((String)object).equalsIgnoreCase(lDAPConnection.getAuthenticationDN())) {
                        bl2 = true;
                        continue;
                    }
                    DSUtil.showPermissionDialog((Component)iDSModel.getFrame(), lDAPConnection);
                    if (iDSModel.getNewAuthentication(false)) continue;
                    bl2 = true;
                    continue;
                }
                bl = this.processSaveErrors(lDAPException);
                bl2 = true;
            }
        }
        this.getModel().notifyAuthChangeListeners();
        return bl;
    }

    private boolean resetEntry(LDAPConnection lDAPConnection, String string) {
        boolean bl = false;
        boolean bl2 = false;
        while (!bl2) {
            Object object;
            try {
                DSEntryTextStrict dSEntryTextStrict;
                this._entry = lDAPConnection.read(string);
                if (this._entry == null) continue;
                String string2 = this.getAttrVal(ENABLED);
                if (string2 != null) {
                    this._dsEntryEnabled.remoteToLocal(string2);
                    this._dsEntryEnabled.show();
                    bl = true;
                }
                int n = 0;
                while (n < this.EDITABLE_ATTRNAMES.length) {
                    string2 = this.getAttrVal(this.EDITABLE_ATTRNAMES[n]);
                    if (string2 != null && (dSEntryTextStrict = (DSEntryTextStrict)this._dsEntryFields.get(this.EDITABLE_ATTRNAMES[n])) != null) {
                        dSEntryTextStrict.remoteToLocal(string2);
                        dSEntryTextStrict.show();
                        bl = true;
                    }
                    ++n;
                }
                int n2 = 0;
                while (!(string2 = this.getAttrVal(ARG + n2)).equals("")) {
                    dSEntryTextStrict = (DSEntryTextStrict)this._dsEntryFields.get(ARG + n2);
                    if (dSEntryTextStrict == null) {
                        object = this.makeCustomJTextField(string2);
                        dSEntryTextStrict = new DSEntryTextStrict(string2, (JComponent)object, this.getLabelForArgument(n2));
                        this._dsEntryFields.put(ARG + n2, dSEntryTextStrict);
                    }
                    dSEntryTextStrict.remoteToLocal(string2);
                    dSEntryTextStrict.show();
                    this._arguments.put(ARG + n2, dSEntryTextStrict.getView(0));
                    bl = true;
                    ++n2;
                }
                while ((object = (JTextComponent)this._arguments.get(ARG + n2)) != null) {
                    this._arguments.remove(ARG + n2);
                    ++n2;
                }
                bl2 = true;
            }
            catch (LDAPException lDAPException) {
                IDSModel iDSModel = this.getModel();
                Debug.println((String)("PluginPanel.resetEntry(): LDAP error code = " + lDAPException.getLDAPResultCode() + " error=" + (Object)((Object)lDAPException)));
                if (lDAPException.getLDAPResultCode() == 50) {
                    object = (String)iDSModel.getServerInfo().get("rootdn");
                    if (((String)object).equalsIgnoreCase(lDAPConnection.getAuthenticationDN())) {
                        bl2 = true;
                        continue;
                    }
                    DSUtil.showPermissionDialog((Component)iDSModel.getFrame(), lDAPConnection);
                    if (iDSModel.getNewAuthentication(false)) continue;
                    bl2 = true;
                    continue;
                }
                bl = this.processReadErrors(lDAPException);
                bl2 = true;
            }
        }
        this.getModel().notifyAuthChangeListeners();
        return bl;
    }

    private void addEntry(JPanel jPanel, String string, String string2) {
        JLabel jLabel = this.makeJLabel(_section, string);
        this.addEntry(jPanel, jLabel, string2);
    }

    private void addEntry(JPanel jPanel, JLabel jLabel, String string) {
        JTextComponent jTextComponent = EDITABLE_FIELDS ? this.makeCustomJTextField("") : UIFactory.makeMultiLineLabel(1, 26);
        this.addEntryField(jPanel, jLabel, jTextComponent);
        jTextComponent.setMargin(this.getTextInsets());
        jTextComponent.invalidate();
        this._fields.put(string, jTextComponent);
        if (jLabel instanceof JLabel && !jLabel.getText().equals("")) {
            this._htLabels.put(string, jLabel);
        }
    }

    protected void addEntryField(JPanel jPanel, JComponent jComponent, JComponent jComponent2, JLabel jLabel) {
        Component component;
        if (jComponent instanceof JLabel) {
            ((JLabel)jComponent).setLabelFor(jComponent2);
        }
        Component component2 = component = Box.createGlue();
        GridBagConstraints gridBagConstraints = this.getGBC();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 12;
        int n = UIFactory.getComponentSpace();
        gridBagConstraints.insets = new Insets(n, n, 0, n / 2);
        jPanel.add((Component)jComponent, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(n, 0, 0, 0);
        gridBagConstraints.gridwidth = component2 == jComponent2 ? 0 : 1;
        jPanel.add((Component)jComponent2, gridBagConstraints);
        if (jLabel != null) {
            ++gridBagConstraints.gridx;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(n, n / 2, 0, 0);
            gridBagConstraints.gridwidth = component2 == jLabel ? 0 : 1;
            jPanel.add((Component)jLabel, gridBagConstraints);
        }
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        jPanel.add(component, gridBagConstraints);
    }

    private JTextField makeCustomJTextField(String string) {
        JTextField jTextField = this.makeJTextField(string);
        jTextField.setColumns(26);
        jTextField.getDocument().addDocumentListener(this);
        jTextField.addFocusListener(this);
        return jTextField;
    }

    private void updateEnabledCheckBox() {
        Object object;
        String string = this.getAttrVal(INITFUNC).trim();
        this._cbEnabled.setEnabled(true);
        Debug.println((String)("PluginPanel.updateEnabledCheckBox(): The function is " + string));
        int n = 0;
        while (n < this.NON_ENABLABLE_PLUGINS_INIT_FUNCTION.length) {
            if (string.equals(this.NON_ENABLABLE_PLUGINS_INIT_FUNCTION[n])) {
                Debug.println((String)("PluginPanel.updateEnabledCheckBox(): The function is " + string + " and the function to compare to is " + this.NON_ENABLABLE_PLUGINS_INIT_FUNCTION[n]));
                this._cbEnabled.setEnabled(false);
                break;
            }
            ++n;
        }
        if (this._cbEnabled.isEnabled()) {
            object = this.getModel().getServerInfo().getLDAPConnection();
            try {
                String string2 = this.getAttrVal(NAME_ATTR);
                String string3 = "&(nsslapd-plugin-depends-on-named=" + string2 + ")(" + ENABLED + "=" + ON + ")";
                Debug.println((String)("PluginPanel.updateEnabledCheckBox: the filter is " + string3));
                String[] stringArray = new String[]{NAME_ATTR};
                boolean bl = false;
                LDAPSearchConstraints lDAPSearchConstraints = (LDAPSearchConstraints)object.getSearchConstraints().clone();
                lDAPSearchConstraints.setMaxResults(0);
                LDAPSearchResults lDAPSearchResults = object.search("cn=plugins,cn=config", 2, string3, stringArray, false, lDAPSearchConstraints);
                while (lDAPSearchResults.hasMoreElements()) {
                    LDAPEntry lDAPEntry = (LDAPEntry)lDAPSearchResults.nextElement();
                    LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(NAME_ATTR);
                    if (lDAPAttribute == null) continue;
                    bl = true;
                    Enumeration enumeration = lDAPAttribute.getStringValues();
                    String string4 = (String)enumeration.nextElement();
                    Debug.println((String)("PluginPanel.updateEnabledCheckBox: the plugin " + string4 + " depends on the plugin " + string2));
                }
                this._cbEnabled.setEnabled(!bl);
            }
            catch (LDAPException lDAPException) {
                Debug.println((String)("PluginPanel.updateEnabledCheckBox: could not load plugin dependencies from server " + DSUtil.format(object) + " exception: " + (Object)((Object)lDAPException)));
            }
        }
        this._dsEntryEnabled = (DSEntryBoolean)this._htEnabled.get(this._entry.getDN());
        if (this._dsEntryEnabled == null) {
            object = this.getAttrVal(ENABLED);
            this._dsEntryEnabled = new DSEntryBoolean((String)object, this._cbEnabled);
            this._htEnabled.put(this._entry.getDN(), this._dsEntryEnabled);
        }
        this._dsEntryEnabled.show();
        if (!this._cbEnabled.isSelected()) {
            this._cbEnabled.setEnabled(true);
        }
    }

    private void updateFields() {
        Object object;
        this._dsEntryFields = (Hashtable)this._htdsEntries.get(this._entry.getDN());
        this._arguments = (Hashtable)this._htArguments.get(this._entry.getDN());
        if (this._dsEntryFields == null) {
            String string;
            DSEntryTextStrict dSEntryTextStrict;
            this._dsEntryFields = new Hashtable();
            this._htdsEntries.put(this._entry.getDN(), this._dsEntryFields);
            this._arguments = new Hashtable();
            this._htArguments.put(this._entry.getDN(), this._arguments);
            int n = 0;
            while (n < this.ATTRNAMES.length) {
                object = (JTextComponent)this._fields.get(this.ATTRNAMES[n]);
                dSEntryTextStrict = new DSEntryTextStrict(this.getAttrVal(this.ATTRNAMES[n]), (JComponent)object, (JLabel)this._htLabels.get(this.ATTRNAMES[n]));
                this._dsEntryFields.put(this.ATTRNAMES[n], dSEntryTextStrict);
                ++n;
            }
            int n2 = 0;
            while (!(string = this.getAttrVal(ARG + n2)).equals("")) {
                object = (JTextComponent)this._arguments.get(ARG + n2);
                if (object == null) {
                    object = this.makeCustomJTextField(string);
                    this._arguments.put(ARG + n2, object);
                }
                dSEntryTextStrict = new DSEntryTextStrict(string, (JComponent)object, this.getLabelForArgument(n2));
                this._dsEntryFields.put(ARG + n2, dSEntryTextStrict);
                ++n2;
            }
        }
        object = this._dsEntryFields.keys();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            ((DSEntryTextStrict)this._dsEntryFields.get(string)).show();
        }
    }

    private void updatePanel() {
        this.updateEnabledCheckBox();
        this.updateFields();
        this.updateArgumentsPanel();
        this.refresh();
        this.validateCheckBox();
        this.validateFields();
        this.validateButtons();
    }

    /*
     * Unable to fully structure code
     */
    private void updateArgumentsPanel() {
        block1: {
            var2_1 = 0;
            this._fieldsPanel.removeAll();
            if (this._arguments.size() >= 1) ** GOTO lbl9
            this._fieldsPanel.add(new JLabel(this.NO_ARGS));
            break block1;
lbl-1000:
            // 1 sources

            {
                this.addEntryField(this._fieldsPanel, this.getLabelForArgument(var2_1), var1_2);
                ++var2_1;
lbl9:
                // 2 sources

                ** while ((var1_2 = (JTextComponent)this._arguments.get((Object)("nsslapd-pluginarg" + var2_1))) != null)
            }
        }
        this._fieldsPanel.setMaximumSize(this._fieldsPanel.getSize());
    }

    private boolean isModified() {
        if (this._dsEntryEnabled.isModified()) {
            return true;
        }
        Enumeration enumeration = this._dsEntryFields.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!((DSEntryTextStrict)this._dsEntryFields.get(string)).isModified()) continue;
            return true;
        }
        return this._arguments.size() != this._dsEntryFields.size() - this.ATTRNAMES.length;
    }

    public boolean isValid() {
        String string;
        Serializable serializable;
        int n = 0;
        while (n < this.EDITABLE_ATTRNAMES.length) {
            if (((DSEntryTextStrict)this._dsEntryFields.get(this.EDITABLE_ATTRNAMES[n])).validate() == 1) {
                return false;
            }
            ++n;
        }
        if (this.isLocal() && !((File)(serializable = new File(string = ((JTextComponent)this._fields.get(PATH)).getText().trim()))).isFile()) {
            return false;
        }
        int n2 = 0;
        while ((serializable = (JTextComponent)this._arguments.get(ARG + n2)) != null) {
            if (((JTextComponent)serializable).getText().trim().equals("")) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private JPanel createArgumentsButtonsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = this.getGBC();
        this._bAdd = this.makeJButton(_section, "badd", null);
        this.setMnemonic(this._bAdd, _section, "badd", DSUtil._resource);
        this._bAdd.setActionCommand(ADD_ARGUMENT);
        this._bDelete = this.makeJButton(_section, "bdelete", null);
        this.setMnemonic(this._bDelete, _section, "bdelete", DSUtil._resource);
        this._bDelete.setActionCommand(DELETE_ARGUMENT);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this._bAdd, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this._bDelete, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints.gridwidth = -1;
        jPanel2.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        jPanel2.add(Box.createHorizontalStrut(20), gridBagConstraints);
        return jPanel2;
    }

    private JLabel getLabelForArgument(int n) {
        JLabel jLabel = (JLabel)this._htLabels.get(ARG + n);
        if (jLabel == null) {
            jLabel = new JLabel(n + 1 + " ");
            this._htLabels.put(ARG + n, jLabel);
        }
        return jLabel;
    }

    private void setDeleteButtonEnabled(boolean bl) {
        this._bDelete.setEnabled(bl);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        if (!this._disableDocumentEvents) {
            this.validateFields();
            this.validateButtons();
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getComponent() instanceof JTextComponent) {
            this._fieldWithFocus = (JTextComponent)focusEvent.getComponent();
            if (this._fieldsPanel.isAncestorOf(this._fieldWithFocus)) {
                this.setDeleteButtonEnabled(true);
            } else {
                this.setDeleteButtonEnabled(false);
            }
        } else {
            this.setDeleteButtonEnabled(false);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!this.isShowing()) {
            this._fieldWithFocus = null;
            this.setDeleteButtonEnabled(false);
        }
    }

    public void advancedCallBack() {
        LDAPEntry lDAPEntry = this._entry;
        String string = this._entry.getDN();
        String string2 = this.getAttrVal(NAME_ATTR);
        DSEntryObject dSEntryObject = new DSEntryObject(this.getModel(), this._entry, true);
        if (dSEntryObject.editGeneric(true, true) == null) {
            return;
        }
        this._entry = dSEntryObject.getEntry();
        if (this._entry != null) {
            Debug.println((String)"PluginPanel.advancedCallBack(): calling to firePropertyChange");
            ((PluginPanel)this.getParent()).firePropertyChange(PluginPanel.ENTRY, lDAPEntry, this._entry);
            this._htEnabled.remove(string);
            this._htdsEntries.remove(string);
            this._htArguments.remove(string);
            this.updateFromEntry(this._entry);
            String string3 = this._entry.getDN();
            boolean bl = false;
            this.getModel().setWaitCursor(false);
            if (bl |= DSUtil.requiresRestart(string3, ENABLED)) {
                DSUtil.showInformationDialog((Component)this.getModel().getFrame(), "requires-restart", (String)null);
            }
        }
    }

    private void setMnemonic(JButton jButton, String string, String string2, ResourceSet resourceSet) {
        String string3 = resourceSet.getString(string, string2 + "-mnemonic");
        if (string3 != null && string3.length() > 0) {
            jButton.setMnemonic(string3.charAt(0));
        }
    }
}

