/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.GenericProgressDialog;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.ExceptionDisplayer;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.JTextComponent;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.util.DN;

public class ServerManagerPanel
extends BlankPanel
implements Runnable {
    private JLabel _lStorageScheme;
    private JComboBox _cbStorageScheme;
    private JLabel _lRootDN;
    private JTextField _tfRootDN;
    private JLabel _lNewPassword;
    private JPasswordField _pfNewPassword;
    private JLabel _lConfirmPassword;
    private JPasswordField _pfConfirmPassword;
    private String _rootDN = "";
    private Hashtable _serverValues = null;
    private boolean _isNameValid;
    private boolean _isPasswordValid;
    private boolean _isNameModified;
    private boolean _isPasswordModified;
    private boolean _isEncryptionTypeModified;
    private LDAPException _lde;
    private static final int _pwdMinLength = 8;
    private static final String MANAGER_DN = "cn=config";
    private static final String STORAGE_SCHEME_ATTR_NAME = "nsslapd-rootpwstoragescheme";
    private static final String ROOT_DN_ATTR_NAME = "nsslapd-rootdn";
    private static final String PASSWORD_ATTR_NAME = "nsslapd-rootpw";
    private static final String PLUGIN_TYPE_ATTR_NAME = "nsslapd-plugintype";
    private static final String DESCRIPTION_ATTR_NAME = "nsslapd-plugindescription";
    private static final String PWDSTORAGE = "pwdstoragescheme";
    private static final String CN_ATTR_NAME = "cn";
    private String[] COMBO_ENTRIES;
    private String[] COMBO_DESCRIPTION;
    private final String[] COMBO_ENTRIES_HARDCOPY = new String[]{"sha", "clear", "crypt"};
    private ResourceSet _resource = DSUtil._resource;
    private final String[] COMBO_DESCRIPTION_HARDCOPY = new String[]{this._resource.getString("manager-storageScheme", "1"), this._resource.getString("manager-storageScheme", "2"), this._resource.getString("manager-storageScheme", "3")};
    private GenericProgressDialog _dlg;
    private static final String _section = "manager";

    public ServerManagerPanel(IDSModel iDSModel) {
        super(iDSModel, _section);
        this._helpToken = "configuration-system-manager-help";
        this._refreshWhenSelect = false;
    }

    public void init() {
        Object object;
        if (this._isInitialized) {
            return;
        }
        this.initServerValues();
        this._cbStorageScheme = this.makeJComboBox();
        this._cbStorageScheme.removeActionListener(this);
        this._lStorageScheme = this.makeJLabel(_section, "storageScheme");
        this._lStorageScheme.setLabelFor(this._cbStorageScheme);
        this._tfRootDN = this.makeJTextField(_section, "rootdn");
        this._tfRootDN.getDocument().addDocumentListener(this);
        this._lRootDN = this.makeJLabel(_section, "rootdn");
        this._lRootDN.setLabelFor(this._tfRootDN);
        this._tfRootDN.setText((String)this._serverValues.get(ROOT_DN_ATTR_NAME));
        this._pfNewPassword = this.makeJPasswordField(20);
        this._pfNewPassword.getDocument().addDocumentListener(this);
        this._lNewPassword = this.makeJLabel(_section, "newPassword");
        this._lNewPassword.setLabelFor(this._pfNewPassword);
        ((JTextComponent)this._pfNewPassword).setText((String)this._serverValues.get(PASSWORD_ATTR_NAME));
        this._pfConfirmPassword = this.makeJPasswordField(20);
        this._pfConfirmPassword.getDocument().addDocumentListener(this);
        this._lConfirmPassword = this.makeJLabel(_section, "confirmPassword");
        this._lConfirmPassword.setLabelFor(this._pfConfirmPassword);
        ((JTextComponent)this._pfConfirmPassword).setText((String)this._serverValues.get(PASSWORD_ATTR_NAME));
        this.findPasswordPlugins();
        int n = 0;
        while (n < this.COMBO_ENTRIES.length) {
            object = this.COMBO_DESCRIPTION[n];
            if (((String)object).equals("")) {
                object = this.COMBO_ENTRIES[n];
            }
            this._cbStorageScheme.addItem(object);
            ++n;
        }
        object = this._myPanel;
        ((Container)object).setLayout(new GridBagLayout());
        this.addEntryField((JPanel)object, this._lRootDN, this._tfRootDN);
        this.addEntryField((JPanel)object, this._lStorageScheme, this._cbStorageScheme);
        this.addEntryField((JPanel)object, this._lNewPassword, this._pfNewPassword);
        this.addEntryField((JPanel)object, this._lConfirmPassword, this._pfConfirmPassword);
        this.addBottomGlue();
        this._isInitialized = true;
    }

    private void findPasswordPlugins() {
        try {
            String string;
            Object object;
            Object object2;
            LDAPEntry lDAPEntry;
            String string2 = "nsslapd-plugintype=pwdstoragescheme";
            String[] stringArray = new String[]{CN_ATTR_NAME, DESCRIPTION_ATTR_NAME};
            LDAPConnection lDAPConnection = this.getModel().getServerInfo().getLDAPConnection();
            if (lDAPConnection == null) {
                Debug.println((String)"ServerManagerPanel.findPasswordPlugins(): we are not creating the right thing (ldc is null)");
                this.COMBO_ENTRIES = this.COMBO_ENTRIES_HARDCOPY;
                this.COMBO_DESCRIPTION = this.COMBO_DESCRIPTION_HARDCOPY;
                return;
            }
            LDAPSearchConstraints lDAPSearchConstraints = (LDAPSearchConstraints)lDAPConnection.getSearchConstraints().clone();
            lDAPSearchConstraints.setMaxResults(0);
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search("cn=plugins,cn=config", 2, string2, stringArray, false, lDAPSearchConstraints);
            Vector<String> vector = new Vector<String>();
            Vector<String> vector2 = new Vector<String>();
            LDAPAttribute lDAPAttribute = null;
            while (lDAPSearchResults != null && lDAPSearchResults.hasMoreElements()) {
                lDAPEntry = (LDAPEntry)lDAPSearchResults.nextElement();
                if (lDAPEntry != null) {
                    lDAPAttribute = lDAPEntry.getAttribute(CN_ATTR_NAME);
                }
                if (lDAPAttribute == null || ((String)(object2 = (String)(object = lDAPAttribute.getStringValues()).nextElement())).equalsIgnoreCase("ns-mta-md5")) continue;
                vector.addElement(((String)object2).toLowerCase());
                string = "";
                lDAPAttribute = lDAPEntry.getAttribute(DESCRIPTION_ATTR_NAME);
                if (lDAPAttribute != null) {
                    object = lDAPAttribute.getStringValues();
                    string = (String)object.nextElement();
                }
                vector2.addElement(string);
            }
            object = new String[]{STORAGE_SCHEME_ATTR_NAME};
            lDAPEntry = DSUtil.readEntry(lDAPConnection, MANAGER_DN, (String[])object, lDAPSearchConstraints);
            if (lDAPEntry != null && (lDAPAttribute = lDAPEntry.getAttribute(STORAGE_SCHEME_ATTR_NAME)) != null) {
                object2 = lDAPAttribute.getStringValues();
                string = (String)object2.nextElement();
                int n = vector.indexOf(string = string.toLowerCase());
                if (n >= 0) {
                    Object e = vector.elementAt(0);
                    vector.set(n, (String)e);
                    vector.set(0, string);
                    Object e2 = vector2.elementAt(0);
                    Object e3 = vector2.elementAt(n);
                    vector2.set(n, (String)e2);
                    vector2.set(0, (String)e3);
                }
            }
            this.COMBO_ENTRIES = new String[vector.size()];
            vector.toArray(this.COMBO_ENTRIES);
            this.COMBO_DESCRIPTION = new String[vector2.size()];
            vector2.toArray(this.COMBO_DESCRIPTION);
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("ServerManagerPanel.findPasswordPlugins: " + (Object)((Object)lDAPException)));
        }
        if (this.COMBO_ENTRIES == null || this.COMBO_ENTRIES.length == 0) {
            Debug.println((String)"ServerManagerPanel.findPasswordPlugins(): we are not creating the right thing");
            this.COMBO_ENTRIES = this.COMBO_ENTRIES_HARDCOPY;
            this.COMBO_DESCRIPTION = this.COMBO_DESCRIPTION_HARDCOPY;
        }
    }

    private void initServerValues() {
        this._serverValues = new Hashtable();
        try {
            LDAPConnection lDAPConnection = this.getModel().getServerInfo().getLDAPConnection();
            if (lDAPConnection == null) {
                return;
            }
            LDAPSearchConstraints lDAPSearchConstraints = (LDAPSearchConstraints)lDAPConnection.getSearchConstraints().clone();
            lDAPSearchConstraints.setMaxResults(0);
            String[] stringArray = new String[]{STORAGE_SCHEME_ATTR_NAME, PASSWORD_ATTR_NAME, ROOT_DN_ATTR_NAME};
            LDAPEntry lDAPEntry = DSUtil.readEntry(lDAPConnection, MANAGER_DN, stringArray, lDAPSearchConstraints);
            int n = 0;
            while (n < stringArray.length) {
                String string = DSUtil.getAttrValue(lDAPEntry, stringArray[n]);
                this._serverValues.put(stringArray[n], string);
                ++n;
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("ServerManagerPanel.initServerValues(): " + (Object)((Object)lDAPException)));
        }
    }

    public void okCallback() {
        this._dlg = new GenericProgressDialog(this.getModel().getFrame(), true, 1, this._resource.getString(_section, "updating-title"), null, null);
        try {
            Thread thread = new Thread(this);
            thread.start();
            this._dlg.packAndShow();
        }
        catch (Exception exception) {
            Debug.println((String)("ServerManagerPanel.okCallback(): " + exception));
            exception.printStackTrace();
        }
        this.resetCallback();
    }

    public void run() {
        int n;
        String string;
        Object object;
        String string2;
        this.checkOkay();
        if (!this._isNameValid || !this._isPasswordValid) {
            this._dlg.closeCallBack();
            return;
        }
        String string3 = this.getModel().getConsoleInfo().getCurrentDN();
        LDAPConnection lDAPConnection = this.getModel().getConsoleInfo().getLDAPConnection();
        LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
        if (this._isNameModified) {
            string2 = (String)this._serverValues.get(ROOT_DN_ATTR_NAME);
            object = this._tfRootDN.getText();
            if (object.trim().equals("")) {
                lDAPModificationSet.add(2, new LDAPAttribute(ROOT_DN_ATTR_NAME, ""));
            } else {
                lDAPModificationSet.add(2, new LDAPAttribute(ROOT_DN_ATTR_NAME, (String)object));
            }
            string = new LDAPModification(2, new LDAPAttribute("nsbinddn", (String)object));
            try {
                if (this._dlg != null) {
                    this._dlg.setTextInLabel(this._resource.getString(_section, "updating-entry", DSUtil.abreviateString(string3, 40)));
                }
                lDAPConnection.modify(string3, (LDAPModification)string);
                Debug.println((String)("ServerManagerPanel.okCallback(): modified " + string + " for " + string3));
            }
            catch (LDAPException lDAPException) {
                Debug.println((String)("ServerManagerPanel.okCallback(): modified " + string + " to " + string3 + " " + (Object)((Object)lDAPException)));
                try {
                    SwingUtilities.invokeAndWait(new ExceptionDisplayer(lDAPException, this._dlg));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        string2 = null;
        if (this._isPasswordModified) {
            object = this._pfNewPassword.getPassword();
            if (object != null) {
                string2 = new String((char[])object);
            }
            if (string2 == null) {
                string2 = "";
            }
            if (string2.equals("")) {
                lDAPModificationSet.add(2, new LDAPAttribute(PASSWORD_ATTR_NAME, ""));
            } else {
                lDAPModificationSet.add(2, new LDAPAttribute(PASSWORD_ATTR_NAME, string2));
            }
            string = new LDAPModification(2, new LDAPAttribute("userPassword", string2));
            try {
                if (this._dlg != null) {
                    this._dlg.setTextInLabel(this._resource.getString(_section, "updating-entry", DSUtil.abreviateString(string3, 40)));
                }
                lDAPConnection.modify(string3, (LDAPModification)string);
                Debug.println((String)("ServerManagerPanel.okCallback(): modified " + string + " for " + string3));
                string2 = "20380119031407Z";
                string = new LDAPModification(2, new LDAPAttribute("passwordexpirationtime", string2));
                try {
                    lDAPConnection.modify(string3, (LDAPModification)string);
                    Debug.println((String)("ServerManagerPanel.okCallback(): modified " + string + " for " + string3));
                }
                catch (LDAPException lDAPException) {
                    Debug.println((int)0, (String)("ServerManagerPanel.okCallback(): failed to " + string + " for " + string3));
                }
                this.updateTaskAuthPWD(string2);
            }
            catch (LDAPException lDAPException) {
                Debug.println((String)("ServerManagerPanel.okCallback(): modified " + string + " to " + string3 + " " + (Object)((Object)lDAPException)));
                try {
                    SwingUtilities.invokeAndWait(new ExceptionDisplayer(lDAPException, this._dlg));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (this._isEncryptionTypeModified && (n = this._cbStorageScheme.getSelectedIndex()) < this.COMBO_ENTRIES.length && n >= 0 && (string = this.COMBO_ENTRIES[n]) != null) {
            lDAPModificationSet.add(2, new LDAPAttribute(STORAGE_SCHEME_ATTR_NAME, string));
        }
        if (lDAPModificationSet.size() > 0) {
            try {
                LDAPConnection lDAPConnection2 = this.getModel().getServerInfo().getLDAPConnection();
                lDAPConnection2.modify(MANAGER_DN, lDAPModificationSet);
                Debug.println((String)("ServerManagerPanel.okCallback(): " + lDAPModificationSet + " to " + MANAGER_DN));
            }
            catch (LDAPException lDAPException) {
                this._lde = lDAPException;
                Debug.println((String)("ServerManagerPanel.okCallback(): modified " + lDAPModificationSet + " to " + MANAGER_DN + " Exception " + (Object)((Object)lDAPException)));
                try {
                    SwingUtilities.invokeAndWait(new ExceptionDisplayer(lDAPException, this._dlg));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (!this._rootDN.equalsIgnoreCase(this._tfRootDN.getText().trim())) {
            this._rootDN = this._tfRootDN.getText().trim();
            this.getModel().rootDNChanged(this._rootDN);
        }
        this._dlg.closeCallBack();
    }

    void updateTaskAuthPWD(String string) {
        ConsoleInfo consoleInfo = this.getModel().getServerInfo();
        DN dN = new DN(consoleInfo.getCurrentDN());
        DN dN2 = new DN((String)consoleInfo.get("AdminUsername"));
        Debug.println((String)("ServerManagerPanel.updateTaskAuthPWD: bind DN is " + dN));
        Debug.println((String)("ServerManagerPanel.updateTaskAuthPWD: task DN is " + dN2));
        if (dN.equals(dN2)) {
            consoleInfo.put("AdminUserPassword", string);
            Debug.println((String)"ServerManagerPanel.updateTaskAuthPWD: password has been updated");
        }
    }

    public void refreshFromServer() {
        this.resetCallback();
    }

    private void checkOkay() {
        boolean bl;
        if (!this._isInitialized) {
            return;
        }
        this._isNameModified = false;
        this._isNameValid = true;
        String string = this._tfRootDN.getText();
        if (string == null) {
            string = "";
        }
        this._isNameValid = DSUtil.isValidDN(string);
        DN dN = new DN(string);
        DN dN2 = new DN((String)this._serverValues.get(ROOT_DN_ATTR_NAME));
        if (!dN.equals(dN2)) {
            this._isNameModified = true;
        }
        this._isPasswordModified = false;
        this._isPasswordValid = true;
        char[] cArray = this._pfNewPassword.getPassword();
        String string2 = null;
        if (cArray != null) {
            string2 = new String(cArray);
        }
        if (string2 == null) {
            string2 = "";
        }
        String string3 = null;
        cArray = this._pfConfirmPassword.getPassword();
        if (cArray != null) {
            string3 = new String(cArray);
        }
        if (string3 == null) {
            string3 = "";
        }
        if (!string2.equals((String)this._serverValues.get(PASSWORD_ATTR_NAME)) || !string3.equals((String)this._serverValues.get(PASSWORD_ATTR_NAME))) {
            this._isPasswordModified = true;
        }
        if (!string3.equals(string2)) {
            this._isPasswordValid = false;
        } else if (string2.length() < 8 && string2.length() != 0) {
            this._isPasswordValid = false;
        }
        this._isEncryptionTypeModified = false;
        int n = this._cbStorageScheme.getSelectedIndex();
        if (n < this.COMBO_ENTRIES.length && n >= 0) {
            String string4 = this.COMBO_ENTRIES[n];
            if (string4 == null) {
                string4 = "";
            }
            if (!string4.trim().equalsIgnoreCase((String)this._serverValues.get(STORAGE_SCHEME_ATTR_NAME))) {
                this._isEncryptionTypeModified = true;
            }
        }
        if (!this._isNameValid) {
            this.setChangeState(this._lRootDN, 3);
        } else if (this._isNameModified) {
            this.setChangeState(this._lRootDN, 2);
        } else {
            this.setChangeState(this._lRootDN, 1);
        }
        if (!this._isPasswordValid) {
            this.setChangeState(this._lNewPassword, 3);
            this.setChangeState(this._lConfirmPassword, 3);
        } else if (this._isPasswordModified) {
            this.setChangeState(this._lNewPassword, 2);
            this.setChangeState(this._lConfirmPassword, 2);
        } else {
            this.setChangeState(this._lNewPassword, 1);
            this.setChangeState(this._lConfirmPassword, 1);
        }
        if (this._isEncryptionTypeModified) {
            this.setChangeState(this._lStorageScheme, 2);
        } else {
            this.setChangeState(this._lStorageScheme, 1);
        }
        boolean bl2 = this._isNameValid && this._isPasswordValid;
        boolean bl3 = bl = this._isNameModified || this._isPasswordModified || this._isEncryptionTypeModified;
        if (!bl2) {
            this.clearValidFlag();
        } else {
            this.setValidFlag();
        }
        if (!bl) {
            this.clearDirtyFlag();
        } else {
            this.setDirtyFlag();
        }
    }

    public void resetCallback() {
        String string;
        this.initServerValues();
        this.findPasswordPlugins();
        this._cbStorageScheme.removeAllItems();
        int n = 0;
        while (n < this.COMBO_ENTRIES.length) {
            string = this.COMBO_DESCRIPTION[n];
            if (string.equals("")) {
                string = this.COMBO_ENTRIES[n];
            }
            this._cbStorageScheme.addItem(string);
            ++n;
        }
        this._tfRootDN.setText((String)this._serverValues.get(ROOT_DN_ATTR_NAME));
        ((JTextComponent)this._pfNewPassword).setText((String)this._serverValues.get(PASSWORD_ATTR_NAME));
        ((JTextComponent)this._pfConfirmPassword).setText((String)this._serverValues.get(PASSWORD_ATTR_NAME));
        string = (String)this._serverValues.get(STORAGE_SCHEME_ATTR_NAME);
        int n2 = 0;
        while (n2 < this.COMBO_ENTRIES.length) {
            if (string.equalsIgnoreCase(this.COMBO_ENTRIES[n2])) {
                this._cbStorageScheme.setSelectedIndex(n2);
                break;
            }
            ++n2;
        }
        this.checkOkay();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.checkOkay();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this._cbStorageScheme)) {
            this.checkOkay();
        }
    }
}

