/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel.replication;

import com.netscape.admin.dirserv.DSFileDialog;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.GlobalConstants;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.GroupPanel;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.admin.dirserv.panel.replication.ReplicationTool;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;

public class SupplierSettingPanel
extends BlankPanel {
    private IDSModel _model;
    private boolean _clogExists;
    private JLabel _dbLabel;
    private JLabel _ageLabel;
    private JLabel _recordLabel;
    private boolean _isValid;
    private boolean _isDirty;
    private JCheckBox _enableCheckbox;
    private JTextField _dbText;
    private JTextField _recordText;
    private JTextField _ageText;
    private JComboBox _timeUnit;
    private JCheckBox _recordCheckbox;
    private JCheckBox _ageCheckbox;
    private JButton _browseButton;
    private JButton _defaultButton;
    private Hashtable _originalEntryValues;
    private static int SECOND_AGE_UNIT = 0;
    private static int MINUTE_AGE_UNIT = 1;
    private static int HOUR_AGE_UNIT = 2;
    private static int DAY_AGE_UNIT = 3;
    private static int WEEK_AGE_UNIT = 4;
    private static int DEFAULT_AGE_UNIT = DAY_AGE_UNIT;
    private static final String REMOVE = "remove";
    private static final String DEFAULT_DBDIR = "changelogdb";
    private static ResourceSet _resource = new ResourceSet("com.netscape.admin.dirserv.panel.replication.replication");
    private static final String _section = "replication-supplier";
    private static final int LIMIT_MIN_VAL = 0;
    private static final int LIMIT_MAX_VAL = Integer.MAX_VALUE;
    private static final String CHANGELOG_CN = "changelog5";
    public static final String CHANGELOG_DN = "cn=changelog5,cn=config";
    private static final String CHANGELOG_DIR_ATTR_NAME = "nsslapd-changelogdir";
    private static final String CHANGELOG_MAX_RECORD_ATTR_NAME = "nsslapd-changelogmaxentries";
    private static final String CHANGELOG_MAX_AGE_ATTR_NAME = "nsslapd-changelogmaxage";
    private final String[] ATTRIBUTES = new String[]{"nsslapd-changelogdir", "nsslapd-changelogmaxentries", "nsslapd-changelogmaxage"};
    private final String CHANGELOG_MAX_AGE_UNIT = "unit";
    private static final String[] COMBO_ENTRIES = new String[]{"sec", "min", "hr", "day", "week"};
    private static final String[] DEFAULT_OBJECTCLASSES = new String[]{"top", "extensibleObject"};

    public SupplierSettingPanel(IDSModel iDSModel) {
        super(iDSModel, "replication");
        this.setTitle(_resource.getString("replication-supplier-setting", "title"));
        this._model = iDSModel;
        this._helpToken = "configuration-replication-suppliersettings-help";
        this._refreshWhenSelect = false;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void init() {
        block6: {
            if (this._isInitialized) {
                return;
            }
            this._clogExists = false;
            try {
                var1_1 /* !! */  = this._model.getServerInfo().getLDAPConnection();
                var2_3 /* !! */  = var1_1 /* !! */ .read("cn=changelog5,cn=config");
                if (var2_3 /* !! */  != null) {
                    this._clogExists = true;
                    this.updateOriginalEntryValues(var2_3 /* !! */ );
                }
                break block6;
            }
            catch (LDAPException var1_2) {
                this._originalEntryValues = new Hashtable<K, V>();
                var2_4 = 0;
                ** while (var2_4 < this.ATTRIBUTES.length)
            }
lbl-1000:
            // 1 sources

            {
                this._originalEntryValues.put(this.ATTRIBUTES[var2_4], "");
                ++var2_4;
                continue;
            }
lbl19:
            // 1 sources

            this._originalEntryValues.put("unit", String.valueOf(SupplierSettingPanel.unitToChar(SupplierSettingPanel.DEFAULT_AGE_UNIT)));
        }
        var1_1 /* !! */  = new GridBagLayout();
        var2_3 /* !! */  = this.getGBC();
        this._myPanel.setLayout((LayoutManager)var1_1 /* !! */ );
        this._myPanel.setBackground(this.getBackground());
        this._myPanel.setPreferredSize(ReplicationTool.DEFAULT_PANEL_SIZE);
        this._myPanel.setMaximumSize(ReplicationTool.DEFAULT_PANEL_SIZE);
        var3_5 = this.makeMultiLineLabel(2, 60, SupplierSettingPanel._resource.getString("replication-supplier", "setting-desc"));
        var2_3 /* !! */ .anchor = 18;
        var2_3 /* !! */ .gridwidth = 2;
        var2_3 /* !! */ .weightx = 1.0;
        var2_3 /* !! */ .fill = 2;
        this._myPanel.add((Component)var3_5, var2_3 /* !! */ );
        var2_3 /* !! */ .weightx = 0.0;
        var2_3 /* !! */ .fill = 2;
        var2_3 /* !! */ .gridwidth = 0;
        this._myPanel.add(Box.createGlue(), var2_3 /* !! */ );
        this._enableCheckbox = this.makeJCheckBox("replication-supplier", "enable", this._clogExists, SupplierSettingPanel._resource);
        this._enableCheckbox.setSelected(this._clogExists);
        var2_3 /* !! */ .gridwidth = 2;
        var2_3 /* !! */ .weightx = 0.0;
        var2_3 /* !! */ .fill = 0;
        this._myPanel.add((Component)this._enableCheckbox, var2_3 /* !! */ );
        var2_3 /* !! */ .weightx = 1.0;
        var2_3 /* !! */ .fill = 2;
        var2_3 /* !! */ .gridwidth = 0;
        this._myPanel.add(Box.createGlue(), var2_3 /* !! */ );
        var4_6 = SupplierSettingPanel._resource.getString("replication-supplier-changelog", "label");
        var5_7 = new GroupPanel(var4_6);
        ReplicationTool.resetGBC((GridBagConstraints)var2_3 /* !! */ );
        var2_3 /* !! */ .insets = (Insets)ReplicationTool.BOTTOM_INSETS.clone();
        var2_3 /* !! */ .anchor = 11;
        var2_3 /* !! */ .gridwidth = 0;
        var2_3 /* !! */ .weightx = 1.0;
        this._myPanel.add((Component)var5_7, var2_3 /* !! */ );
        this._dbLabel = this.makeJLabel("replication-supplier", "cLogDBDir", SupplierSettingPanel._resource);
        var3_5.setFont(this._dbLabel.getFont());
        ReplicationTool.resetGBC((GridBagConstraints)var2_3 /* !! */ );
        var2_3 /* !! */ .insets = (Insets)ReplicationTool.BOTTOM_INSETS.clone();
        var2_3 /* !! */ .anchor = 13;
        var2_3 /* !! */ .fill = 0;
        var5_7.add((Component)this._dbLabel, var2_3 /* !! */ );
        this._dbText = this.makeJTextField("replication-supplier", "cLogDBDir", SupplierSettingPanel._resource);
        this._dbLabel.setLabelFor(this._dbText);
        this._dbText.getDocument().addDocumentListener(this);
        ReplicationTool.resetGBC((GridBagConstraints)var2_3 /* !! */ );
        var2_3 /* !! */ .insets = (Insets)ReplicationTool.BOTTOM_INSETS.clone();
        var2_3 /* !! */ .gridwidth = 0;
        var2_3 /* !! */ .fill = 2;
        var2_3 /* !! */ .weightx = 0.5;
        var5_7.add((Component)this._dbText, var2_3 /* !! */ );
        this._browseButton = UIFactory.makeJButton(this, "replication-supplier", "browseButton", SupplierSettingPanel._resource);
        this._dbLabel.setLabelFor(this._browseButton);
        this._browseButton.setEnabled(this.isLocal());
        this._defaultButton = UIFactory.makeJButton(this, "replication-supplier", "defaultButton", SupplierSettingPanel._resource);
        this._dbLabel.setLabelFor(this._defaultButton);
        var6_8 = new JButton[]{this._browseButton, this._defaultButton};
        var7_9 = UIFactory.makeJButtonPanel(var6_8);
        ReplicationTool.resetGBC((GridBagConstraints)var2_3 /* !! */ );
        var2_3 /* !! */ .insets = (Insets)ReplicationTool.BOTTOM_INSETS.clone();
        var2_3 /* !! */ .gridwidth = 0;
        var2_3 /* !! */ .fill = 2;
        var2_3 /* !! */ .weightx = 1.0;
        var5_7.add((Component)var7_9, var2_3 /* !! */ );
        this._recordLabel = this.makeJLabel("replication-supplier", "cLogMaxRec", SupplierSettingPanel._resource);
        ReplicationTool.resetGBC((GridBagConstraints)var2_3 /* !! */ );
        var2_3 /* !! */ .insets = (Insets)ReplicationTool.BOTTOM_INSETS.clone();
        var2_3 /* !! */ .anchor = 13;
        var2_3 /* !! */ .fill = 0;
        var5_7.add((Component)this._recordLabel, var2_3 /* !! */ );
        this._recordText = this.makeNumericalJTextField("replication-supplier", "cLogMaxRec", SupplierSettingPanel._resource);
        this._recordLabel.setLabelFor(this._recordText);
        this._recordText.getDocument().addDocumentListener(this);
        ReplicationTool.resetGBC((GridBagConstraints)var2_3 /* !! */ );
        var2_3 /* !! */ .insets = (Insets)ReplicationTool.BOTTOM_INSETS.clone();
        var2_3 /* !! */ .gridwidth = 1;
        var2_3 /* !! */ .weightx = 0.5;
        var5_7.add((Component)this._recordText, var2_3 /* !! */ );
        this._recordCheckbox = this.makeJCheckBox(SupplierSettingPanel._resource.getString("replication-supplier-cUnlimited", "label"));
        var2_3 /* !! */ .anchor = 17;
        var2_3 /* !! */ .gridwidth = 0;
        var5_7.add((Component)this._recordCheckbox, var2_3 /* !! */ );
        this._ageLabel = this.makeJLabel("replication-supplier", "cLogMaxAge", SupplierSettingPanel._resource);
        ReplicationTool.resetGBC((GridBagConstraints)var2_3 /* !! */ );
        var2_3 /* !! */ .insets = (Insets)ReplicationTool.BOTTOM_INSETS.clone();
        var2_3 /* !! */ .gridwidth = 1;
        var2_3 /* !! */ .anchor = 13;
        var2_3 /* !! */ .fill = 0;
        var5_7.add((Component)this._ageLabel, var2_3 /* !! */ );
        this._ageText = this.makeNumericalJTextField("replication-supplier", "cLogMaxAge", SupplierSettingPanel._resource);
        this._ageLabel.setLabelFor(this._ageText);
        this._ageText.getDocument().addDocumentListener(this);
        ReplicationTool.resetGBC((GridBagConstraints)var2_3 /* !! */ );
        var2_3 /* !! */ .insets = (Insets)ReplicationTool.BOTTOM_INSETS.clone();
        var2_3 /* !! */ .gridwidth = 1;
        var2_3 /* !! */ .weightx = 0.5;
        var5_7.add((Component)this._ageText, var2_3 /* !! */ );
        this._timeUnit = this.makeJComboBox("replication-supplier", "cLogMaxAgeUnit", null, SupplierSettingPanel._resource);
        this._ageLabel.setLabelFor(this._timeUnit);
        this._timeUnit.addActionListener(this);
        ReplicationTool.resetGBC((GridBagConstraints)var2_3 /* !! */ );
        var2_3 /* !! */ .insets = (Insets)ReplicationTool.BOTTOM_INSETS.clone();
        var2_3 /* !! */ .gridwidth = -1;
        var5_7.add((Component)this._timeUnit, var2_3 /* !! */ );
        this._ageCheckbox = this.makeJCheckBox(SupplierSettingPanel._resource.getString("replication-supplier-cUnlimited", "label"));
        var2_3 /* !! */ .anchor = 17;
        var2_3 /* !! */ .gridwidth = 0;
        var5_7.add((Component)this._ageCheckbox, var2_3 /* !! */ );
        var8_10 = null;
        if (!this._clogExists) {
            var9_11 = new LDAPAttributeSet();
            var9_11.add(new LDAPAttribute("objectclass", SupplierSettingPanel.DEFAULT_OBJECTCLASSES));
            var9_11.add(new LDAPAttribute("cn", "changelog5"));
            var8_10 = new LDAPEntry("cn=changelog5,cn=config", var9_11);
        }
        this.updateFieldsFromOriginalValues();
        this.validateFields();
        this.addBottomGlue();
        this._isInitialized = true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this._recordCheckbox)) {
            this.validateFields();
        } else if (actionEvent.getSource().equals(this._ageCheckbox)) {
            this.validateFields();
        } else if (actionEvent.getSource().equals(this._browseButton)) {
            this.DisplayBrowseDialog();
            this.validateFields();
        } else if (actionEvent.getSource().equals(this._defaultButton)) {
            this.SetDefaultDir();
            this.validateFields();
        } else if (actionEvent.getSource().equals(this._timeUnit)) {
            this.validateFields();
        } else if (actionEvent.getSource().equals(this._enableCheckbox)) {
            this.validateFields();
        }
    }

    private void DisplayBrowseDialog() {
        String string = this._dbText.getText();
        if (File.separator.equals("\\")) {
            string = string.replace('/', '\\');
        }
        if ((string = DSFileDialog.getDirectoryName(string, true, this)) != null) {
            this._dbText.setText(string);
        }
    }

    private void SetDefaultDir() {
        String string = this.getInstanceDirectory() + "/" + DEFAULT_DBDIR;
        string = string.replace('\\', '/');
        this._dbText.setText(string);
    }

    private void RemoveChangelog() {
        int n;
        if (BlankPanel.requiresConfirmation(GlobalConstants.PREFERENCES_CONFIRM_MODIFY_CHANGELOG) && (n = DSUtil.showConfirmationDialog((Component)this, "remove-change", "", _section, _resource)) == 1) {
            return;
        }
        try {
            LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
            lDAPConnection.delete(CHANGELOG_DN);
            this._clogExists = false;
            LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
            lDAPAttributeSet.add(new LDAPAttribute("objectclass", DEFAULT_OBJECTCLASSES));
            lDAPAttributeSet.add(new LDAPAttribute("cn", CHANGELOG_CN));
            LDAPEntry lDAPEntry = new LDAPEntry(CHANGELOG_DN, lDAPAttributeSet);
            this.updateOriginalEntryValues(lDAPEntry);
            this.updateFieldsFromOriginalValues();
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("SupplierSettingPanel.removeChangelog() " + (Object)((Object)lDAPException)));
            if (lDAPException.getLDAPResultCode() == 32) {
                this._clogExists = false;
                LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
                lDAPAttributeSet.add(new LDAPAttribute("objectclass", DEFAULT_OBJECTCLASSES));
                lDAPAttributeSet.add(new LDAPAttribute("cn", CHANGELOG_CN));
                LDAPEntry lDAPEntry = new LDAPEntry(CHANGELOG_DN, lDAPAttributeSet);
                this.updateOriginalEntryValues(lDAPEntry);
                this.updateFieldsFromOriginalValues();
            }
            String string = lDAPException.errorCodeToString();
            String string2 = lDAPException.getLDAPErrorMessage();
            if (string2 != null && string2.length() > 0) {
                string = string + ". " + string2;
            }
            String[] stringArray = new String[]{string};
            DSUtil.showErrorDialog((Component)this._model.getFrame(), "error-del-changelog", stringArray, _section, _resource);
            this.validateFields();
            return;
        }
        this.validateFields();
    }

    public void refreshFromServer() {
        Debug.println((String)"SupplierSettingPanel.refreshFromServer()");
        this.resetCallback();
    }

    /*
     * Unable to fully structure code
     */
    public boolean refresh() {
        block4: {
            Debug.println((String)"SupplierSettingPanel.refresh()");
            this._clogExists = false;
            try {
                var1_1 = this._model.getServerInfo().getLDAPConnection();
                var2_3 = var1_1.read("cn=changelog5,cn=config");
                if (var2_3 != null) {
                    this._clogExists = true;
                    this.updateOriginalEntryValues(var2_3);
                }
                break block4;
            }
            catch (LDAPException var1_2) {
                this._originalEntryValues = new Hashtable<K, V>();
                var2_4 = 0;
                ** while (var2_4 < this.ATTRIBUTES.length)
            }
lbl-1000:
            // 1 sources

            {
                this._originalEntryValues.put(this.ATTRIBUTES[var2_4], "");
                ++var2_4;
                continue;
            }
lbl18:
            // 1 sources

            this._originalEntryValues.put("unit", String.valueOf(SupplierSettingPanel.unitToChar(SupplierSettingPanel.DEFAULT_AGE_UNIT)));
        }
        this.validateFields();
        return true;
    }

    public void okCallback() {
        if (!this._isValid || !this._isDirty) {
            return;
        }
        if (this._enableCheckbox.isSelected()) {
            if (this.confirmStore()) {
                super.okCallback();
                this.saveEntry();
            }
        } else if (this._clogExists) {
            this.RemoveChangelog();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void resetCallback() {
        block4: {
            this._clogExists = false;
            try {
                var1_1 = this._model.getServerInfo().getLDAPConnection();
                var2_3 = var1_1.read("cn=changelog5,cn=config");
                if (var2_3 != null) {
                    this._clogExists = true;
                    this.updateOriginalEntryValues(var2_3);
                }
                break block4;
            }
            catch (LDAPException var1_2) {
                this._originalEntryValues = new Hashtable<K, V>();
                var2_4 = 0;
                ** while (var2_4 < this.ATTRIBUTES.length)
            }
lbl-1000:
            // 1 sources

            {
                this._originalEntryValues.put(this.ATTRIBUTES[var2_4], "");
                ++var2_4;
                continue;
            }
lbl17:
            // 1 sources

            this._originalEntryValues.put("unit", String.valueOf(SupplierSettingPanel.unitToChar(SupplierSettingPanel.DEFAULT_AGE_UNIT)));
        }
        this.updateFieldsFromOriginalValues();
        this.validateFields();
        this.clearDirtyFlag();
    }

    public void updateFieldsFromOriginalValues() {
        if (this._originalEntryValues != null) {
            this._enableCheckbox.setSelected(this._clogExists);
            this._dbText.setText((String)this._originalEntryValues.get(CHANGELOG_DIR_ATTR_NAME));
            String string = (String)this._originalEntryValues.get(CHANGELOG_MAX_RECORD_ATTR_NAME);
            if (string.equals("0") || string.equals("")) {
                this._recordCheckbox.setSelected(true);
                this._recordText.setText("");
            } else {
                this._recordCheckbox.setSelected(false);
                this._recordText.setText(string);
            }
            this.enableRecord(!this._recordCheckbox.isSelected());
            String string2 = (String)this._originalEntryValues.get(CHANGELOG_MAX_AGE_ATTR_NAME);
            if (string2.equals("0") || string2.equals("")) {
                this._ageCheckbox.setSelected(true);
                this._ageText.setText("");
            } else {
                this._ageCheckbox.setSelected(false);
                this._ageText.setText(string2);
            }
            this.enableAge(!this._ageCheckbox.isSelected());
            String string3 = (String)this._originalEntryValues.get("unit");
            if (string3 != null && string3.length() > 0) {
                char c = string3.charAt(0);
                int n = SupplierSettingPanel.charToUnit(c);
                if (n >= 0) {
                    this._timeUnit.setSelectedIndex(SupplierSettingPanel.charToUnit(c));
                } else {
                    this._timeUnit.setSelectedIndex(DEFAULT_AGE_UNIT);
                }
            }
        }
    }

    private void saveEntry() {
        try {
            LDAPConnection lDAPConnection = this._model.getServerInfo().getLDAPConnection();
            LDAPEntry lDAPEntry = lDAPConnection.read(CHANGELOG_DN);
            this._clogExists = true;
            LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
            int n = 0;
            while (n < this.ATTRIBUTES.length) {
                String string;
                String string2;
                Object object;
                LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(this.ATTRIBUTES[n]);
                String string3 = null;
                if (lDAPAttribute != null && (object = lDAPAttribute.getStringValues()) != null) {
                    string3 = (String)object.nextElement();
                }
                if (string3 != null) {
                    if (this.ATTRIBUTES[n].equals(CHANGELOG_DIR_ATTR_NAME)) {
                        object = this._dbText.getText().trim();
                        if (!((String)object).equals(string3)) {
                            lDAPModificationSet.add(2, new LDAPAttribute(CHANGELOG_DIR_ATTR_NAME, (String)object));
                        }
                    } else if (this.ATTRIBUTES[n].equals(CHANGELOG_MAX_RECORD_ATTR_NAME)) {
                        if (this._recordCheckbox.isSelected()) {
                            if (!string3.equals("0")) {
                                lDAPModificationSet.add(2, new LDAPAttribute(CHANGELOG_MAX_RECORD_ATTR_NAME, "0"));
                            }
                        } else {
                            object = this._recordText.getText().trim();
                            if (!((String)object).equals(string3)) {
                                lDAPModificationSet.add(2, new LDAPAttribute(CHANGELOG_MAX_RECORD_ATTR_NAME, (String)object));
                            }
                        }
                    } else if (this.ATTRIBUTES[n].equals(CHANGELOG_MAX_AGE_ATTR_NAME)) {
                        if (this._ageCheckbox.isSelected()) {
                            if (!string3.equals("0")) {
                                lDAPModificationSet.add(2, new LDAPAttribute(CHANGELOG_MAX_AGE_ATTR_NAME, "0"));
                            }
                        } else {
                            object = this._ageText.getText().trim();
                            string2 = String.valueOf(SupplierSettingPanel.unitToChar(this._timeUnit.getSelectedIndex()));
                            string = (String)object + string2;
                            if (!string.equals(string3)) {
                                lDAPModificationSet.add(2, new LDAPAttribute(CHANGELOG_MAX_AGE_ATTR_NAME, string));
                            }
                        }
                    }
                } else if (this.ATTRIBUTES[n].equals(CHANGELOG_DIR_ATTR_NAME)) {
                    object = this._dbText.getText().trim();
                    if (!((String)object).equals("")) {
                        lDAPModificationSet.add(0, new LDAPAttribute(CHANGELOG_DIR_ATTR_NAME, (String)object));
                    }
                } else if (this.ATTRIBUTES[n].equals(CHANGELOG_MAX_RECORD_ATTR_NAME)) {
                    if (!this._recordCheckbox.isSelected() && !((String)(object = this._recordText.getText().trim())).equals("")) {
                        lDAPModificationSet.add(0, new LDAPAttribute(CHANGELOG_MAX_RECORD_ATTR_NAME, (String)object));
                    }
                } else if (this.ATTRIBUTES[n].equals(CHANGELOG_MAX_AGE_ATTR_NAME) && !this._ageCheckbox.isSelected() && !((String)(object = this._ageText.getText().trim())).equals("")) {
                    string2 = String.valueOf(SupplierSettingPanel.unitToChar(this._timeUnit.getSelectedIndex()));
                    string = (String)object + string2;
                    lDAPModificationSet.add(0, new LDAPAttribute(CHANGELOG_MAX_AGE_ATTR_NAME, string));
                }
                ++n;
            }
            if (lDAPModificationSet.size() > 0) {
                Debug.println((String)("SupplierSettingsPanel.saveEntry(): cn=changelog5,cn=config: " + lDAPModificationSet));
                lDAPConnection.modify(CHANGELOG_DN, lDAPModificationSet);
                lDAPEntry = lDAPConnection.read(CHANGELOG_DN);
                this._clogExists = true;
                this.updateOriginalEntryValues(lDAPEntry);
                this.updateFieldsFromOriginalValues();
                this.validateFields();
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("SupplierSettingsPanel.saveEntry(): " + (Object)((Object)lDAPException)));
            if (lDAPException.getLDAPResultCode() == 32) {
                Object object;
                Object object2;
                String string;
                this._clogExists = false;
                LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
                lDAPAttributeSet.add(new LDAPAttribute("objectclass", DEFAULT_OBJECTCLASSES));
                lDAPAttributeSet.add(new LDAPAttribute("cn", CHANGELOG_CN));
                lDAPAttributeSet.add(new LDAPAttribute(CHANGELOG_DIR_ATTR_NAME, this._dbText.getText().trim()));
                if (!this._recordCheckbox.isSelected()) {
                    lDAPAttributeSet.add(new LDAPAttribute(CHANGELOG_MAX_RECORD_ATTR_NAME, this._recordText.getText().trim()));
                }
                if (!this._ageCheckbox.isSelected() && !(string = this._ageText.getText().trim()).equals("")) {
                    object2 = String.valueOf(SupplierSettingPanel.unitToChar(this._timeUnit.getSelectedIndex()));
                    object = string + (String)object2;
                    lDAPAttributeSet.add(new LDAPAttribute(CHANGELOG_MAX_AGE_ATTR_NAME, (String)object));
                }
                string = new LDAPEntry(CHANGELOG_DN, lDAPAttributeSet);
                try {
                    object2 = this._model.getServerInfo().getLDAPConnection();
                    object2.add((LDAPEntry)string);
                    object = object2.read(CHANGELOG_DN);
                    this._clogExists = true;
                    this.updateOriginalEntryValues((LDAPEntry)object);
                    this.updateFieldsFromOriginalValues();
                    this.validateFields();
                }
                catch (LDAPException lDAPException2) {
                    Debug.println((String)("SupplierSettingsPanel.saveEntry() (2): " + (Object)((Object)lDAPException2)));
                    object = lDAPException2.errorCodeToString();
                    String string4 = lDAPException2.getLDAPErrorMessage();
                    if (string4 != null && string4.length() > 0) {
                        object = (String)object + ". " + string4;
                    }
                    String[] stringArray = new String[]{object};
                    DSUtil.showErrorDialog((Component)this._model.getFrame(), "error-add-changelog", stringArray, _section, _resource);
                    this.validateFields();
                    return;
                }
            }
            String string = lDAPException.errorCodeToString();
            String string5 = lDAPException.getLDAPErrorMessage();
            if (string5 != null && string5.length() > 0) {
                string = string + ". " + string5;
            }
            String[] stringArray = new String[]{string};
            DSUtil.showErrorDialog((Component)this._model.getFrame(), "error-mod-changelog", stringArray, _section, _resource);
            this.validateFields();
            return;
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.validateFields();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    private void checkEnable() {
        boolean bl = this._enableCheckbox.isSelected();
        this._dbLabel.setEnabled(bl);
        this._ageLabel.setEnabled(bl);
        this._recordLabel.setEnabled(bl);
        this._dbText.setEnabled(bl);
        this.enableRecord(!this._recordCheckbox.isSelected() && bl);
        this.enableAge(!this._ageCheckbox.isSelected() && bl);
        this._recordCheckbox.setEnabled(bl);
        this._ageCheckbox.setEnabled(bl);
        this._browseButton.setEnabled(bl);
        this._defaultButton.setEnabled(bl);
    }

    private void validateFields() {
        int n;
        this.checkEnable();
        this._isValid = true;
        this._isDirty = false;
        boolean bl = false;
        if (!this._enableCheckbox.isSelected()) {
            if (this._clogExists) {
                this._isDirty = true;
                this.setChangeState(this._enableCheckbox, 2);
                this.setDirtyFlag();
            } else {
                this.setChangeState(this._enableCheckbox, 1);
                this.clearDirtyFlag();
            }
            this.setValidFlag();
            return;
        }
        if (!this._clogExists) {
            bl = true;
            this.setChangeState(this._enableCheckbox, 2);
        } else {
            this.setChangeState(this._enableCheckbox, 1);
        }
        boolean bl2 = true;
        boolean bl3 = false;
        String string = this._dbText.getText().trim();
        if (!string.equals((String)this._originalEntryValues.get(CHANGELOG_DIR_ATTR_NAME))) {
            bl3 = true;
        }
        if (string.equals("")) {
            bl2 = false;
        }
        if (bl3 && bl2) {
            super.setChangeState(this._dbLabel, 2);
        } else if (!bl3 && bl2) {
            super.setChangeState(this._dbLabel, 1);
        } else if (!bl2) {
            super.setChangeState(this._dbLabel, 3);
        }
        this._isValid = this._isValid && bl2;
        this._isDirty = this._isDirty || bl3 || bl;
        boolean bl4 = true;
        boolean bl5 = false;
        String string2 = this._recordText.getText().trim();
        String string3 = (String)this._originalEntryValues.get(CHANGELOG_MAX_RECORD_ATTR_NAME);
        if (!this._recordCheckbox.isSelected()) {
            if (!string2.equals(string3) || string2.equals("") || string2.equals("0")) {
                bl5 = true;
            }
            try {
                n = Integer.parseInt(string2);
                if (n < 1 || n > Integer.MAX_VALUE) {
                    bl4 = false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                bl4 = false;
            }
        } else if (!string3.equals("") && !string3.equals("0")) {
            bl5 = true;
        }
        if (bl5 && bl4) {
            super.setChangeState(this._recordLabel, 2);
        } else if (!bl5 && bl4) {
            super.setChangeState(this._recordLabel, 1);
        } else if (!bl4) {
            super.setChangeState(this._recordLabel, 3);
        }
        this._isValid = this._isValid && bl4;
        this._isDirty = this._isDirty || bl5;
        n = 1;
        boolean bl6 = false;
        String string4 = this._ageText.getText().trim();
        String string5 = (String)this._originalEntryValues.get(CHANGELOG_MAX_AGE_ATTR_NAME);
        if (!this._ageCheckbox.isSelected()) {
            String string6;
            String string7 = (String)this._originalEntryValues.get("unit");
            if (!string7.equals(string6 = String.valueOf(SupplierSettingPanel.unitToChar(this._timeUnit.getSelectedIndex())))) {
                bl6 = true;
            }
            if (!string4.equals(string5) || string4.equals("") || string4.equals("0")) {
                bl6 = true;
            }
            try {
                int n2 = Integer.parseInt(string4);
                if (n2 < 1 || n2 > Integer.MAX_VALUE) {
                    n = 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
        } else if (!string5.equals("") && !string5.equals("0")) {
            bl6 = true;
        }
        if (bl6 && n != 0) {
            super.setChangeState(this._ageLabel, 2);
        } else if (!bl6 && n != 0) {
            super.setChangeState(this._ageLabel, 1);
        } else if (n == 0) {
            super.setChangeState(this._ageLabel, 3);
        }
        this._isValid = this._isValid && n != 0;
        boolean bl7 = this._isDirty = this._isDirty || bl6;
        if (this._isDirty) {
            this.setDirtyFlag();
        } else {
            this.clearDirtyFlag();
        }
        if (this._isValid) {
            this.setValidFlag();
        } else {
            this.clearValidFlag();
        }
    }

    private boolean confirmStore() {
        int n;
        String string = this._dbText.getText().trim();
        String string2 = (String)this._originalEntryValues.get(CHANGELOG_DIR_ATTR_NAME);
        return string2.equals("") || string2.equals(string) || (n = DSUtil.showConfirmationDialog((Component)this, "change-db", "", _section, _resource)) != 1;
    }

    private void enableRecord(boolean bl) {
        this._recordText.setEnabled(bl);
        this._recordText.repaint();
    }

    private void enableAge(boolean bl) {
        this._ageText.setEnabled(bl);
        this._ageText.repaint();
        this._timeUnit.setEnabled(bl);
        this._timeUnit.repaint();
    }

    private void updateOriginalEntryValues(LDAPEntry lDAPEntry) {
        this._originalEntryValues = new Hashtable();
        int n = 0;
        while (n < this.ATTRIBUTES.length) {
            Enumeration enumeration;
            LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(this.ATTRIBUTES[n]);
            String string = null;
            if (lDAPAttribute != null && (enumeration = lDAPAttribute.getStringValues()) != null) {
                string = (String)enumeration.nextElement();
            }
            if (string != null) {
                if (this.ATTRIBUTES[n].equals(CHANGELOG_MAX_AGE_ATTR_NAME)) {
                    if (string.length() > 0) {
                        char c = string.charAt(string.length() - 1);
                        int n2 = SupplierSettingPanel.charToUnit(c);
                        if (n2 == -1) {
                            n2 = DEFAULT_AGE_UNIT;
                        } else {
                            string = string.substring(0, string.length() - 1);
                            c = SupplierSettingPanel.unitToChar(n2);
                        }
                        int n3 = 0;
                        try {
                            n3 = Integer.parseInt(string);
                        }
                        catch (NumberFormatException numberFormatException) {
                            n3 = 0;
                        }
                        string = Integer.toString(n3);
                        this._originalEntryValues.put(CHANGELOG_MAX_AGE_ATTR_NAME, string);
                        this._originalEntryValues.put("unit", String.valueOf(c));
                    } else {
                        this._originalEntryValues.put(CHANGELOG_MAX_AGE_ATTR_NAME, "");
                        this._originalEntryValues.put("unit", String.valueOf(SupplierSettingPanel.unitToChar(DEFAULT_AGE_UNIT)));
                    }
                } else {
                    this._originalEntryValues.put(this.ATTRIBUTES[n], string);
                }
            } else {
                this._originalEntryValues.put(this.ATTRIBUTES[n], "");
                if (this.ATTRIBUTES[n].equals(CHANGELOG_MAX_AGE_ATTR_NAME)) {
                    this._originalEntryValues.put("unit", String.valueOf(SupplierSettingPanel.unitToChar(DEFAULT_AGE_UNIT)));
                }
            }
            ++n;
        }
    }

    private static int charToUnit(char c) {
        int n = -1;
        if (c == 'h') {
            n = HOUR_AGE_UNIT;
        } else if (c == 's') {
            n = SECOND_AGE_UNIT;
        } else if (c == 'm') {
            n = MINUTE_AGE_UNIT;
        } else if (c == 'd') {
            n = DAY_AGE_UNIT;
        } else if (c == 'w') {
            n = WEEK_AGE_UNIT;
        }
        return n;
    }

    private static char unitToChar(int n) {
        int n2 = 0;
        if (n == HOUR_AGE_UNIT) {
            n2 = 104;
        } else if (n == SECOND_AGE_UNIT) {
            n2 = 115;
        } else if (n == MINUTE_AGE_UNIT) {
            n2 = 109;
        } else if (n == DAY_AGE_UNIT) {
            n2 = 100;
        } else if (n == WEEK_AGE_UNIT) {
            n2 = 119;
        }
        return (char)n2;
    }
}

