/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel.replication;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.panel.GroupPanel;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.admin.dirserv.panel.replication.AgreementDestinationPanel;
import com.netscape.admin.dirserv.panel.replication.AgreementWizard;
import com.netscape.admin.dirserv.panel.replication.AgreementWizardInfo;
import com.netscape.admin.dirserv.panel.replication.CustomComboBox;
import com.netscape.admin.dirserv.panel.replication.CustomComboBoxModel;
import com.netscape.admin.dirserv.panel.replication.HostInfoDialog;
import com.netscape.admin.dirserv.panel.replication.LDAPUtil;
import com.netscape.admin.dirserv.panel.replication.ReplicaPanel;
import com.netscape.admin.dirserv.panel.replication.ReplicationAgreement;
import com.netscape.admin.dirserv.panel.replication.ReplicationTool;
import com.netscape.admin.dirserv.panel.replication.ServerInstance;
import com.netscape.admin.dirserv.panel.replication.WAgreementPanel;
import com.netscape.admin.dirserv.wizard.IWizardPanel;
import com.netscape.admin.dirserv.wizard.WizardInfo;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.JButtonFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPSearchResults;

public class WAgreementDestinationPanel
extends WAgreementPanel
implements IWizardPanel,
ActionListener,
DocumentListener {
    private Hashtable _dsInstances;
    private ConsoleInfo _serverInfo;
    private ConsoleInfo _consoleInfo;
    private boolean _isLEGACYR = false;
    private boolean _isCopy = false;
    private boolean _initialized = false;
    private ServerInstance _server;
    private ImageIcon _icon;
    private JLabel _fromText;
    private JLabel _toText;
    private JTextField _bindText;
    private JButton _toButton;
    private JComboBox _fromBox;
    private JComboBox _toBox;
    private JCheckBox _sslEncrypt;
    private JRadioButton _simpAuth;
    private JRadioButton _sslAuth;
    private JPasswordField _pwdText;
    private JLabel _bind;
    private JLabel _pwd;
    private CustomComboBoxModel _fromModel;
    private CustomComboBoxModel _toModel;
    private JPanel _toPanel;
    private JPanel _fromPanel;
    private ReplicaPanel _replicaPanel;
    private JButton _browseButton;
    protected AgreementWizard _wizard;
    private AgreementWizardInfo _wizardInfo = null;
    private ReplicationAgreement _copy = null;
    private String _error = "WAgreementDestinationPanel";
    private String _portAttr = "nsserverport";
    private static final int CONTINUE = 0;
    private static final int PROMPT = 1;
    private static final int SKIP = 3;
    private static final String DSClass = "nsDirectoryServer";
    private static final String ATTR_PORT = "nsserverport";
    private static final String ATTR_SECURE_PORT = "nssecureserverport";
    private static final String BACKEND_ATTR = "cn";
    private final String CONSUMER_LIST_NOT_AVAILABLE = WAgreementPanel._resource.getString("replication-destination-consumer-list-non-available", "label");

    public WAgreementDestinationPanel(AgreementWizard agreementWizard) {
        this._dsInstances = new Hashtable();
        this._icon = ReplicationTool.getImage("DirectoryServer.gif");
        this._helpToken = "replication-wizard-content-help";
        this._section = "replication-destination-dialog";
        this._wizard = agreementWizard;
    }

    public void init() {
        int n = UIFactory.getComponentSpace();
        int n2 = UIFactory.getDifferentSpace();
        int n3 = 40;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ReplicationTool.resetGBC(gridBagConstraints);
        this.setPreferredSize(ReplicationTool.DEFAULT_PANEL_SIZE);
        this.setMaximumSize(ReplicationTool.DEFAULT_PANEL_SIZE);
        JLabel jLabel = new JLabel(WAgreementPanel._resource.getString("replication-destination-ask", "label"));
        jLabel.setLabelFor(this);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = UIFactory.getBorderInsets();
        gridBagConstraints.insets.left = n;
        this.add((Component)jLabel, gridBagConstraints);
        String string = WAgreementPanel._resource.getString("replication-info-summary-from", "title");
        this._fromPanel = new GroupPanel(string);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this._fromPanel, gridBagConstraints);
        this._fromModel = new CustomComboBoxModel();
        this._fromBox = new CustomComboBox((ComboBoxModel)this._fromModel);
        this._fromBox.getAccessibleContext().setAccessibleDescription(WAgreementPanel._resource.getString("replication-info-summary-from", "title"));
        this._fromBox.setMaximumRowCount(4);
        this._fromText = new JLabel("", this._icon, 2);
        string = WAgreementPanel._resource.getString("replication-info-summary-to", "title");
        this._toPanel = new GroupPanel(string);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this._toPanel, gridBagConstraints);
        this._toModel = new CustomComboBoxModel();
        this._toBox = new CustomComboBox((ComboBoxModel)this._toModel);
        this._toBox.setToolTipText(WAgreementPanel._resource.getString("replication-info-summary-to", "combobox-ttip"));
        this._toBox.setMaximumRowCount(4);
        this._toButton = UIFactory.makeJButton(this, "replication-destination", "otherButton", WAgreementPanel._resource);
        JButtonFactory.resize((JButton)this._toButton);
        this._toText = new JLabel("", this._icon, 2);
        string = WAgreementPanel._resource.getString("replication-destination-connection", "label");
        GroupPanel groupPanel = new GroupPanel(string);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)groupPanel, gridBagConstraints);
        this._sslEncrypt = new JCheckBox(WAgreementPanel._resource.getString("replication-destination-sslEncrypt", "label"));
        this._sslEncrypt.addActionListener(this);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, n, n2, n2);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        groupPanel.add((Component)this._sslEncrypt, gridBagConstraints);
        JLabel jLabel2 = new JLabel(WAgreementPanel._resource.getString("replication-destination-authUsing", "label"));
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        groupPanel.add((Component)jPanel, gridBagConstraints);
        jLabel2.setLabelFor(jPanel);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, n3, n, n2);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        this._sslAuth = new JRadioButton(WAgreementPanel._resource.getString("replication-destination-sslClientAuth", "label"));
        this._sslAuth.addActionListener(this);
        buttonGroup.add(this._sslAuth);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, n3, 0, n2);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this._sslAuth, gridBagConstraints);
        this._simpAuth = new JRadioButton(WAgreementPanel._resource.getString("replication-destination-simpleAuth", "label"));
        this._simpAuth.addActionListener(this);
        buttonGroup.add(this._simpAuth);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, n3, 0, n2);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this._simpAuth, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.setBackground(this.getBackground());
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this._bind = new JLabel(WAgreementPanel._resource.getString("replication-destination-bindAs", "label"));
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 70, n, n2);
        gridBagConstraints.fill = 0;
        jPanel2.add((Component)this._bind, gridBagConstraints);
        this._bindText = UIFactory.makeJTextField(null, "");
        this._bind.setLabelFor(this._bindText);
        this._bindText.getDocument().addDocumentListener(this);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, n, n2);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this._bindText, gridBagConstraints);
        this._pwd = new JLabel(WAgreementPanel._resource.getString("replication-destination-bindPwd", "label"));
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 70, n, n2);
        gridBagConstraints.fill = 0;
        jPanel2.add((Component)this._pwd, gridBagConstraints);
        this._pwdText = UIFactory.makeJPasswordField(null, "");
        this._pwd.setLabelFor(this._pwdText);
        this._pwdText.getDocument().addDocumentListener(this);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, n, n2);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this._pwdText, gridBagConstraints);
        string = WAgreementPanel._resource.getString("replication-content-replicate", "label");
        GroupPanel groupPanel2 = new GroupPanel(string);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)groupPanel2, gridBagConstraints);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, n, n2, n2);
        Debug.println((int)8, (String)("WAgreementDestinationPanel.init: replica entry = " + this._wizardInfo.getReplicaEntry()));
        if (this._wizardInfo.getReplicaEntry() == null) {
            this._replicaPanel = new ReplicaPanel(this._serverInfo.getLDAPConnection(), this._wizardInfo.getReplicaEntry());
            groupPanel2.add((Component)this._replicaPanel, gridBagConstraints);
        } else {
            String string2 = this._wizardInfo.getSubtree();
            groupPanel2.add((Component)new JLabel(string2), gridBagConstraints);
        }
        this.populateData();
        if (!this._isCopy) {
            this.setSimpAuth();
        }
        this.checkNextButton();
        this.invalidate();
        this.validate();
        this.repaint(1L);
        this._initialized = true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Debug.println((String)("WAgreementDestinationPanel: actionPerformed()" + actionEvent.toString()));
        if (actionEvent.getSource().equals(this._toButton)) {
            String string = WAgreementPanel._resource.getString(this._section, "hostInfo-consumer-title");
            JFrame jFrame = null;
            Container container = this.getParent();
            while (container != null) {
                if (container instanceof JFrame) {
                    jFrame = (JFrame)container;
                    break;
                }
                container = container.getParent();
            }
            HostInfoDialog hostInfoDialog = new HostInfoDialog(jFrame, string);
            hostInfoDialog.pack();
            hostInfoDialog.show();
            if (!hostInfoDialog.isOk()) {
                hostInfoDialog = null;
                return;
            }
            ServerInstance serverInstance = new ServerInstance(hostInfoDialog.getHost(), hostInfoDialog.getPort());
            hostInfoDialog = null;
            if (this._server.equals(serverInstance)) {
                AgreementDestinationPanel.showErrorDialog(jFrame, "sameServer", this._section);
                return;
            }
            this._toModel.removeEntry(serverInstance.toString());
            this._toModel.addItem(serverInstance);
            this._toModel.removeEntry(this.CONSUMER_LIST_NOT_AVAILABLE);
            this._toBox.setSelectedIndex(this._toModel.getSize() - 1);
        }
        if (actionEvent.getSource().equals(this._sslAuth) && this._sslAuth.isSelected()) {
            this.enableSimpleAuth(false);
        }
        if (actionEvent.getSource().equals(this._simpAuth) && this._simpAuth.isSelected()) {
            this.enableSimpleAuth(true);
        }
        if (actionEvent.getSource().equals(this._sslEncrypt)) {
            if (this._sslEncrypt.isSelected()) {
                this._sslAuth.setEnabled(true);
                this._portAttr = ATTR_SECURE_PORT;
            } else {
                this._sslAuth.setEnabled(false);
                this._simpAuth.setSelected(true);
                this.enableSimpleAuth(true);
                this._portAttr = ATTR_PORT;
            }
            this.populateInstanceModel(this._consoleInfo);
            this._toText.setText(this._server.getKey());
        }
        this.checkNextButton();
    }

    public boolean initializePanel(WizardInfo wizardInfo) {
        boolean bl = this._isLEGACYR;
        Debug.println((String)("WAgreementDestinationPanel: Initialize() info = " + wizardInfo));
        this._wizardInfo = (AgreementWizardInfo)wizardInfo;
        this._serverInfo = this._wizardInfo.getServerInfo();
        this._consoleInfo = this._wizardInfo.getConsoleInfo();
        this._isLEGACYR = this._wizardInfo.getAgreementType().equals("LEGACYR");
        Debug.println((int)8, (String)("WAgreementDestinationPanel: is legacy = " + this._isLEGACYR));
        if (this._wizardInfo.getWizardType().equals("COPY")) {
            this._isCopy = true;
            this._copy = this._wizardInfo.getCopyAgreement();
        } else {
            this._isCopy = false;
        }
        if (!this._initialized) {
            this.init();
            return true;
        }
        if (!this._isCopy && bl != this._isLEGACYR) {
            this.populateData();
        }
        this.checkNextButton();
        this.invalidate();
        this.validate();
        this.repaint(1L);
        return true;
    }

    public boolean validatePanel() {
        Object object;
        Debug.println((String)"WAgreementDestinationPanel: validatePanel()");
        if (this._simpAuth.isSelected()) {
            object = this._bindText.getText();
            if (((String)object).equals("") || !DSUtil.isValidDN((String)object)) {
                this._error = WAgreementPanel._resource.getString(this._section, "bindDNEmpty-msg");
                return false;
            }
            if (this._pwdText.getText().equals("")) {
                this._error = WAgreementPanel._resource.getString(this._section, "bindPasswordEmpty-msg");
                return false;
            }
        }
        if ((object = (Hashtable)this._toBox.getSelectedItem()) == null || ((Hashtable)object).get("title").equals(this.CONSUMER_LIST_NOT_AVAILABLE)) {
            this._error = WAgreementPanel._resource.getString(this._section, "consumerEmpty-msg");
            return false;
        }
        return true;
    }

    public boolean concludePanel(WizardInfo wizardInfo) {
        String string;
        int n;
        Debug.println((String)"WAgreementDestinationPanel: conclude()");
        int n2 = this.checkCopiedFrom();
        if (n2 == 3) {
            return false;
        }
        return n2 != 1 || (n = DSUtil.showConfirmationDialog((Component)this, "warning", string = WAgreementPanel._resource.getString(this._section, "mismatchCopiedFrom"), "replication-dialog")) != 1;
    }

    public void getUpdateInfo(WizardInfo wizardInfo) {
        Debug.println((String)"WAgreementDestinationPanel: getUpdateInfo()");
        Hashtable hashtable = (Hashtable)this._toBox.getSelectedItem();
        ServerInstance serverInstance = (ServerInstance)hashtable.get("data");
        this._wizardInfo.setFromServer(this._server);
        this._wizardInfo.setToServer(serverInstance);
        if (this._sslEncrypt.isSelected()) {
            this._wizardInfo.setSSL(true);
            this._wizardInfo.setSSLAuth(this._sslAuth.isSelected());
        } else {
            this._wizardInfo.setSSL(false);
            this._wizardInfo.setSSLAuth(false);
        }
        if (this._sslEncrypt.isSelected() && this._sslAuth.isSelected()) {
            this._wizardInfo.setSSLAuth(true);
            this._wizardInfo.setBindDN("");
            this._wizardInfo.setBindPWD("");
        } else {
            this._wizardInfo.setSSLAuth(false);
            this._wizardInfo.setBindDN(this._bindText.getText());
            this._wizardInfo.setBindPWD(this._pwdText.getText());
        }
        if (this._replicaPanel != null) {
            this._wizardInfo.setReplicaEntry(this._replicaPanel.getReplicaEntry());
            this._wizardInfo.setSubtree(this._replicaPanel.getSuffix());
        }
    }

    public String getErrorMessage() {
        return this._error;
    }

    private void populateData() {
        Object object;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = UIFactory.getComponentSpace();
        int n2 = UIFactory.getDifferentSpace();
        int n3 = 40;
        this._fromPanel.removeAll();
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, n, n, n2);
        this._fromPanel.add((Component)this._fromText, gridBagConstraints);
        this._fromText.setLabelFor(this._fromPanel);
        this._toPanel.removeAll();
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, n, n, n2);
        gridBagConstraints.weightx = 1.0;
        this._toPanel.add((Component)this._toBox, gridBagConstraints);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, n, n2);
        this._toPanel.add((Component)this._toButton, gridBagConstraints);
        this._toModel.removeAll();
        if (this._isCopy) {
            this.copyData();
        }
        this._server = new ServerInstance(this._serverInfo.getHost(), this._serverInfo.getPort());
        this._fromText.setText(this._server.getKey());
        this.loadDSInstances(this._consoleInfo);
        if (this._dsInstances.size() == 0 && !this._isCopy) {
            this._toModel.addItem(this.CONSUMER_LIST_NOT_AVAILABLE);
            this._toBox.setSelectedIndex(0);
        } else {
            object = this._dsInstances.keys();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                ServerInstance serverInstance = (ServerInstance)this._dsInstances.get(string);
                this._toModel.addItem(serverInstance);
            }
            if (this._toModel.getSize() > 0) {
                if (this._wizardInfo.getToServer() != null && this._toModel.isPresent(this._wizardInfo.getToServer().getKey())) {
                    this._toBox.setSelectedItem(this._wizardInfo.getToServer());
                } else {
                    this._toBox.setSelectedIndex(0);
                }
            }
        }
        if (this._isCopy && !this._toModel.isPresent(((ServerInstance)(object = this._wizardInfo.getToServer())).getKey())) {
            this._toModel.addItem((ServerInstance)object);
            this._toBox.setSelectedItem(object);
        }
    }

    private void copyData() {
        ((JTextComponent)this._pwdText).setText(this._wizardInfo.getBindPWD());
        this._bindText.setText(this._wizardInfo.getBindDN());
        if (this._wizardInfo.getSSL()) {
            this._sslEncrypt.setSelected(true);
            if (this._wizardInfo.getSSLAuth()) {
                this.enableSimpleAuth(false);
                this._sslAuth.setEnabled(true);
                this._sslAuth.setSelected(true);
            } else {
                this._sslAuth.setEnabled(false);
                this._simpAuth.setSelected(true);
                this.enableSimpleAuth(true);
            }
        } else {
            this.setSimpAuth();
        }
    }

    private void setSimpAuth() {
        this._sslEncrypt.setSelected(false);
        this._sslAuth.setEnabled(false);
        this._simpAuth.setSelected(true);
        this.enableSimpleAuth(true);
    }

    private void enableSimpleAuth(boolean bl) {
        this._bind.setEnabled(bl);
        this._bindText.setEnabled(bl);
        this._pwd.setEnabled(bl);
        this._pwdText.setEnabled(bl);
        this._pwdText.setBackground(this._bindText.getBackground());
    }

    private void populateInstanceModel(ConsoleInfo consoleInfo) {
        Object object;
        Object object2;
        String string = null;
        CustomComboBoxModel customComboBoxModel = this._toModel;
        JComboBox jComboBox = this._toBox;
        int n = jComboBox.getSelectedIndex();
        if (n >= 0 && (object2 = (ServerInstance)((Hashtable)(object = (Hashtable)jComboBox.getSelectedItem())).get("data")) != null) {
            string = ((ServerInstance)object2).getKey();
        }
        boolean bl = string != null && this._dsInstances.containsKey(string);
        object = this._dsInstances.keys();
        while (object.hasMoreElements()) {
            string = (String)object.nextElement();
            customComboBoxModel.removeEntry(string);
        }
        this.loadDSInstances(consoleInfo);
        object2 = this._dsInstances.keys();
        while (object2.hasMoreElements()) {
            string = (String)object2.nextElement();
            ServerInstance serverInstance = (ServerInstance)this._dsInstances.get(string);
            customComboBoxModel.addItem(serverInstance);
        }
    }

    private void loadDSInstances(ConsoleInfo consoleInfo) {
        LDAPConnection lDAPConnection = consoleInfo.getLDAPConnection();
        if (lDAPConnection == null) {
            Debug.println((String)"ERROR: AgreementDestinationPanel: loadDSInstances()- Connection Failed");
            return;
        }
        this._dsInstances.clear();
        try {
            String string = "objectclass=nsDirectoryServer";
            String string2 = com.netscape.management.client.util.LDAPUtil.getConfigurationRoot();
            String[] stringArray = new String[]{"serverHostName", ""};
            String string3 = ServerInstance.getKey(this._server.getHost(), this.getPort());
            stringArray[1] = this._portAttr;
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(string2, 2, string, stringArray, false);
            if (!lDAPSearchResults.hasMoreElements()) {
                Debug.println((String)"ERROR: WAgreementDestinationPanel.loadDSInstances: could not get list of servers");
            }
            while (lDAPSearchResults.hasMoreElements()) {
                LDAPEntry lDAPEntry = lDAPSearchResults.next();
                String string4 = this.getKey(lDAPEntry);
                if (string4.equals(string3)) {
                    Debug.println((String)("ERROR: WAgreementDestinationPanel.loadDSInstances: server " + string4 + " equals server " + string3));
                    continue;
                }
                if (this._dsInstances.containsKey(string4)) {
                    Debug.println((String)("ERROR: WAgreementDestinationPanel.loadDSInstances: server " + string4 + " is already in the list"));
                    continue;
                }
                ServerInstance serverInstance = this.entry2DSInstance(lDAPEntry);
                if (serverInstance != null) {
                    this._dsInstances.put(serverInstance.getKey(), serverInstance);
                    Debug.println((int)9, (String)("WAgreementDestinationPanel.loadDSInstances: put server " + serverInstance.getKey() + " in the list"));
                    continue;
                }
                Debug.println((String)("ERROR: WAgreementDestinationPanel.loadDSInstances: could not convert entry " + lDAPEntry + " to a server"));
            }
            if (this._dsInstances.containsKey(string3)) {
                Debug.println((int)9, (String)("WAgreementDestinationPanel.loadDSInstances: removing " + string3 + " from the list"));
                this._dsInstances.remove(string3);
            }
        }
        catch (Exception exception) {
            Debug.println((String)("ERROR: AgreementDestinationPanel: loadDSSIE()" + exception.toString()));
        }
        Debug.println((int)9, (String)("WAgreementDestinationPanel.loadDSInstances: there are " + (this._dsInstances == null ? 0 : this._dsInstances.size()) + " entries in the list"));
    }

    private String getKey(LDAPEntry lDAPEntry) {
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("serverHostName");
        LDAPAttribute lDAPAttribute2 = lDAPEntry.getAttribute(this._portAttr);
        String string = lDAPAttribute != null ? (String)lDAPAttribute.getStringValues().nextElement() : "";
        int n = lDAPAttribute2 != null ? Integer.parseInt((String)lDAPAttribute2.getStringValues().nextElement()) : 0;
        return ServerInstance.getKey(string, n);
    }

    private ServerInstance entry2DSInstance(LDAPEntry lDAPEntry) {
        ServerInstance serverInstance = new ServerInstance();
        LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("serverHostName");
        if (lDAPAttribute != null) {
            serverInstance.setHost((String)lDAPAttribute.getStringValues().nextElement());
        }
        if ((lDAPAttribute = lDAPEntry.getAttribute(this._portAttr)) != null) {
            serverInstance.setPort(Integer.parseInt((String)lDAPAttribute.getStringValues().nextElement()));
        }
        return serverInstance;
    }

    private int getPort() {
        if (this._portAttr.equals(ATTR_PORT)) {
            return this._serverInfo.getPort();
        }
        return DSUtil.getSSLPort(this._serverInfo);
    }

    private int checkCopiedFrom() {
        block10: {
            int n;
            String string;
            ServerInstance serverInstance;
            Hashtable hashtable;
            String string2 = null;
            string2 = this._replicaPanel != null ? this._replicaPanel.getSuffix() : this._wizardInfo.getSubtree();
            if (this._isLEGACYR) {
                hashtable = (Hashtable)this._fromBox.getSelectedItem();
                serverInstance = (ServerInstance)hashtable.get("data");
                string = serverInstance.getHost();
                n = serverInstance.getPort();
            } else {
                string = this._serverInfo.getHost();
                n = this._serverInfo.getPort();
            }
            hashtable = (Hashtable)this._toBox.getSelectedItem();
            serverInstance = (ServerInstance)hashtable.get("data");
            LDAPConnection lDAPConnection = LDAPUtil.connectToServer(serverInstance.getHost(), serverInstance.getPort(), this._bindText.getText(), this._pwdText.getText(), this._sslEncrypt.isSelected());
            if (lDAPConnection == null) {
                String string3 = WAgreementPanel._resource.getString(this._section, "clientUnavail");
                int n2 = DSUtil.showConfirmationDialog((Component)this, "warning", string3, "replication-dialog");
                if (n2 == 0) {
                    return 0;
                }
                return 3;
            }
            String string4 = ReplicationAgreement.getCopiedFrom(lDAPConnection, string2);
            if (string4 != null) {
                try {
                    int n3 = string4.indexOf(58);
                    if (n3 == -1) break block10;
                    String string5 = string4.substring(0, n3);
                    int n4 = string4.indexOf(32);
                    if (n4 != -1) {
                        int n5 = Integer.parseInt(string4.substring(n3 + 1, n4));
                        if (!string5.equals(string) || n5 != n) {
                            Debug.println((String)("copiedFrom attribute mismatch: copiedFrom " + string5 + ":" + n5 + " != supplier " + string + ":" + n));
                            return 1;
                        }
                    }
                }
                catch (Exception exception) {
                    Debug.println((String)exception.toString());
                }
            } else {
                Debug.println((String)"WADP: getCopiedFrom() - return null");
            }
        }
        return 0;
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.checkNextButton();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    protected void checkNextButton() {
        boolean bl = true;
        Hashtable hashtable = (Hashtable)this._toBox.getSelectedItem();
        if (hashtable == null || hashtable.get("title").equals(this.CONSUMER_LIST_NOT_AVAILABLE)) {
            bl = false;
        } else if (this._simpAuth.isSelected() && (this._bindText.getText().trim().equals("") || !DSUtil.isValidDN(this._bindText.getText()) || this._pwdText.getText().trim().equals(""))) {
            bl = false;
        }
        this._wizard.getbNext_Done().setEnabled(bl);
    }
}

