/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel.replication;

import com.netscape.admin.dirserv.DSFileDialog;
import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.admin.dirserv.panel.replication.AgreementWizard;
import com.netscape.admin.dirserv.panel.replication.AgreementWizardInfo;
import com.netscape.admin.dirserv.panel.replication.ReplicationTool;
import com.netscape.admin.dirserv.panel.replication.WAgreementPanel;
import com.netscape.admin.dirserv.wizard.IWizardPanel;
import com.netscape.admin.dirserv.wizard.WizardInfo;
import com.netscape.management.client.util.Debug;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class WAgreementInitPanel
extends WAgreementPanel
implements IWizardPanel,
ActionListener,
DocumentListener {
    private AgreementWizard _wizard;
    private JLabel _nameLabel;
    private JTextField _nameTextField;
    private Color _activeColor;
    private JRadioButton _initConsumer;
    private JRadioButton _notInitConsumer;
    private JRadioButton _initFile;
    private JButton _browseButton;
    private AgreementWizardInfo _wizardInfo;
    private String _error = "WAgreementInitPanel: error message";
    private boolean _init = false;

    public WAgreementInitPanel(AgreementWizard agreementWizard) {
        this._section = "replication-initialize";
        this._helpToken = "replication-wizard-consumerinit-help";
        this._wizard = agreementWizard;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ReplicationTool.resetGBC(gridBagConstraints);
        int n = UIFactory.getComponentSpace();
        int n2 = UIFactory.getDifferentSpace();
        int n3 = 20;
        int n4 = 2;
        JLabel jLabel = UIFactory.makeJLabel(this._section, "select-init", WAgreementPanel._resource);
        jLabel.setLabelFor(this);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(n2, n, n2, n2);
        this.add((Component)jLabel, gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        this._notInitConsumer = UIFactory.makeJRadioButton(this, this._section, "notInitConsumer", false, WAgreementPanel._resource);
        buttonGroup.add(this._notInitConsumer);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, n2, 0, n2);
        this.add((Component)this._notInitConsumer, gridBagConstraints);
        this._initConsumer = UIFactory.makeJRadioButton(this, this._section, "initConsumer", false, WAgreementPanel._resource);
        buttonGroup.add(this._initConsumer);
        this.add((Component)this._initConsumer, gridBagConstraints);
        this._initFile = UIFactory.makeJRadioButton(this, this._section, "createInitFile", true, WAgreementPanel._resource);
        buttonGroup.add(this._initFile);
        this.add((Component)this._initFile, gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBackground(this.getBackground());
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jPanel, gridBagConstraints);
        this._nameLabel = UIFactory.makeJLabel(this._section, "ldifName", WAgreementPanel._resource);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(n2, n, 0, n);
        jPanel.add((Component)this._nameLabel, gridBagConstraints);
        this._nameTextField = UIFactory.makeJTextField(null, "");
        this._nameLabel.setLabelFor(this._nameTextField);
        this._nameTextField.getDocument().addDocumentListener(this);
        this._activeColor = this._nameTextField.getBackground();
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(n2, n, 0, n2);
        jPanel.add((Component)this._nameTextField, gridBagConstraints);
        this._browseButton = UIFactory.makeJButton(this, this._section, "browseButton", WAgreementPanel._resource);
        ReplicationTool.resetGBC(gridBagConstraints);
        gridBagConstraints.insets = new Insets(n2, n, 0, n);
        jPanel.add((Component)this._browseButton, gridBagConstraints);
        this.checkNextButton();
    }

    private void disableInitFile() {
        this._nameTextField.setEnabled(false);
        this._nameTextField.setEditable(false);
        this._nameTextField.setBackground(this.getBackground());
        this._browseButton.setEnabled(false);
        this._nameTextField.invalidate();
        this._nameTextField.validate();
        this._nameTextField.repaint(1L);
        this._wizardInfo.removeLDIFFilename();
    }

    private void enableInitFile() {
        this._nameTextField.setEnabled(true);
        this._nameTextField.setEditable(true);
        this._nameTextField.setBackground(this._activeColor);
        this._browseButton.setEnabled(true);
        this._nameTextField.invalidate();
        this._nameTextField.validate();
        this._nameTextField.repaint(1L);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String[] stringArray;
        String[] stringArray2;
        String string;
        Debug.println((String)("AgreementInitPanel: actionPerformed()" + actionEvent.toString()));
        if (actionEvent.getSource().equals(this._initFile)) {
            this.enableInitFile();
        } else if (actionEvent.getSource().equals(this._notInitConsumer) || actionEvent.getSource().equals(this._initConsumer)) {
            this.disableInitFile();
        } else if (actionEvent.getSource().equals(this._browseButton) && (string = DSFileDialog.getFileName(false, stringArray2 = new String[]{"ldif"}, stringArray = new String[]{DSUtil._resource.getString("filefilter", "ldif-label")}, this, "*.ldif", this.getDefaultPath())) != null) {
            this._nameTextField.setText(string);
        }
        this.checkNextButton();
    }

    protected String getDefaultPath() {
        return DSUtil.getDefaultLDIFPath(this._wizardInfo.getServerInfo());
    }

    public boolean initializePanel(WizardInfo wizardInfo) {
        Debug.println((String)"WAgreementInitPanel: initialize()");
        this._wizardInfo = (AgreementWizardInfo)wizardInfo;
        if (!this._init) {
            String string = this.getDefaultPath() + this._wizardInfo.getName() + WAgreementPanel._resource.getString("replication-initialize", "file-extension-label");
            this._nameTextField.setText(string);
            if (this._wizardInfo.getAgreementType().equals("LEGACYR")) {
                this.enableInitFile(false);
            } else {
                this.enableInitFile(true);
            }
            if (!DSUtil.isLocal(this._wizardInfo.getServerInfo().getHost())) {
                this._nameLabel.setText(WAgreementPanel._resource.getString(this._section, "not-local-ldifName-label"));
                this._browseButton.setEnabled(false);
            }
            this._init = true;
        }
        this.checkNextButton();
        return true;
    }

    public boolean validatePanel() {
        Debug.println((String)"AgreementInitPanel: validate()");
        if (this._initFile.isSelected() && !this.isValidLDIFFile()) {
            this._error = WAgreementPanel._resource.getString(this._section, "invalidLDIFFile-msg", this._nameTextField.getText().trim());
            return false;
        }
        return true;
    }

    public boolean concludePanel(WizardInfo wizardInfo) {
        Debug.println((String)"AgreementInitPanel: conclude()");
        return true;
    }

    public void getUpdateInfo(WizardInfo wizardInfo) {
        Debug.println((String)"AgreementInitPanel: getUpdateInfo()");
        if (this._initConsumer.isSelected()) {
            this._wizardInfo.setInitialize(true);
        } else {
            this._wizardInfo.setInitialize(false);
        }
        if (this._initFile.isSelected()) {
            this._wizardInfo.setLDIFFilename(this._nameTextField.getText());
        }
    }

    public String getErrorMessage() {
        return this._error;
    }

    protected void enableInitFile(boolean bl) {
        this._initFile.setVisible(bl);
        this._nameLabel.setVisible(bl);
        this._nameTextField.setVisible(bl);
        this._browseButton.setVisible(bl);
        if (bl) {
            this._initFile.setSelected(true);
            this.enableInitFile();
            this._wizardInfo.setInitialize(false);
        } else {
            this._notInitConsumer.setSelected(true);
            this._wizardInfo.removeLDIFFilename();
            this._wizardInfo.setInitialize(false);
        }
    }

    private boolean isValidLDIFFile() {
        String string = this._nameTextField.getText();
        if (string.equals("")) {
            return false;
        }
        if (!DSUtil.isLocal(this._wizardInfo.getServerInfo().getHost())) {
            return true;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            fileOutputStream.close();
            File file = new File(string);
            file.delete();
        }
        catch (IOException iOException) {
            Debug.println((String)("WAIP: Error trying to check file path " + iOException));
            return false;
        }
        return true;
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.checkNextButton();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    protected void checkNextButton() {
        if (this._initFile.isSelected() && this._nameTextField.getText().trim().equals("")) {
            this._wizard.getbNext_Done().setEnabled(false);
            return;
        }
        this._wizard.getbNext_Done().setEnabled(true);
    }
}

