/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.task;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.GenericProgressDialog;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.task.LDAPBasicProgressDialog;
import com.netscape.admin.dirserv.task.LDAPTask;
import com.netscape.management.client.util.Debug;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;

public class LDAPCreateIndex
extends LDAPTask {
    private final String INDEX = "index";
    public static final String INSTANCE = "nsInstance";
    public static final String INDEX_ATTRIBUTE = "nsIndexAttribute";
    public static final String INDEX_VLV_ATTRIBUTE = "nsIndexVLVAttribute";
    public String[] MANDATORY_ARGUMENTS = new String[]{"nsInstance"};
    public String[] OPTIONAL_ARGUMENTS = new String[]{"nsIndexAttribute", "nsIndexVLVAttribute"};
    boolean _isVLVIndex = false;
    boolean _dontWaitForClose = false;

    public LDAPCreateIndex(IDSModel iDSModel, Hashtable hashtable) {
        super(iDSModel, hashtable);
        this._taskType = "index";
        this._taskSection = "index";
        this.start();
    }

    public LDAPCreateIndex(IDSModel iDSModel) {
        this(iDSModel, null);
    }

    public LDAPCreateIndex(IDSModel iDSModel, Hashtable hashtable, GenericProgressDialog genericProgressDialog, LDAPBasicProgressDialog lDAPBasicProgressDialog, boolean bl) {
        super(iDSModel, hashtable);
        this._isVLVIndex = bl;
        this._taskType = "index";
        this._taskSection = "index";
        this._progressDialog = genericProgressDialog;
        ((GenericProgressDialog)this._progressDialog).addActionListener(this);
        this._statusProgressDialog = lDAPBasicProgressDialog;
        this._dontWaitForClose = true;
        if (this.initTask()) {
            this.run();
        }
    }

    protected boolean initTask() {
        String[] stringArray;
        Object object;
        String string;
        this._taskCancelled = false;
        this.createTaskDn();
        LDAPAttributeSet lDAPAttributeSet = this.createTaskEntryAttributes();
        if (lDAPAttributeSet == null) {
            Debug.println((String)("LDAPCreateIndex.initTask():  Error, insufficient arguments to perform the task " + this._taskType));
            ((GenericProgressDialog)this._progressDialog).setTextInLabel(DSUtil._resource.getString("general", "LDAPTaskError-notenoughargs-label"));
            return false;
        }
        this._entry = new LDAPEntry(this._taskDn, lDAPAttributeSet);
        LDAPConnection lDAPConnection = this.getLDAPConnection();
        Debug.println((String)("DN = " + this._entry.getDN()));
        Enumeration enumeration = lDAPAttributeSet.getAttributes();
        while (enumeration.hasMoreElements()) {
            LDAPAttribute lDAPAttribute = (LDAPAttribute)enumeration.nextElement();
            string = lDAPAttribute.getName();
            Debug.println((String)string);
            object = lDAPAttribute.getStringValues();
            while (object.hasMoreElements()) {
                stringArray = (String[])object.nextElement();
            }
        }
        try {
            Debug.println((String)("LDAPCreateIndex.initTask(): adding entry " + this._entry));
            lDAPConnection.add(this._entry);
        }
        catch (LDAPException lDAPException) {
            Debug.println((String)("LDAPCreateIndex.initTask(): LDAP error code = " + lDAPException.getLDAPResultCode() + " error=" + (Object)((Object)lDAPException)));
            string = lDAPException.errorCodeToString();
            object = lDAPException.getLDAPErrorMessage();
            if (object != null && ((String)object).length() > 0) {
                string = string + ". " + (String)object;
            }
            stringArray = new String[]{string};
            ((GenericProgressDialog)this._progressDialog).setTextInLabel(DSUtil._resource.getString("general", "LDAPTaskError-starting-label", stringArray));
            return false;
        }
        return true;
    }

    public void run() {
        if (!this._dontWaitForClose) {
            ((GenericProgressDialog)this._progressDialog).enableButtons(true);
        }
        ((GenericProgressDialog)this._progressDialog).disableCancelButton();
        this.updateProgressDialog();
    }

    protected LDAPAttributeSet createTaskEntryAttributes() {
        LDAPAttribute lDAPAttribute;
        LDAPAttributeSet lDAPAttributeSet = super.createTaskEntryAttributes();
        int n = 0;
        while (n < this.MANDATORY_ARGUMENTS.length) {
            lDAPAttribute = (LDAPAttribute)this._attributes.get(this.MANDATORY_ARGUMENTS[n]);
            if (lDAPAttribute == null) {
                return null;
            }
            lDAPAttributeSet.add(lDAPAttribute);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.OPTIONAL_ARGUMENTS.length) {
            lDAPAttribute = (LDAPAttribute)this._attributes.get(this.OPTIONAL_ARGUMENTS[n2]);
            if (lDAPAttribute != null) {
                lDAPAttributeSet.add(lDAPAttribute);
            }
            ++n2;
        }
        return lDAPAttributeSet;
    }

    protected void updateProgressDialog(Hashtable hashtable) {
        String string = (String)hashtable.get("nsTaskLog");
        if (this._isVLVIndex) {
            int n = string.lastIndexOf("Indexing VLV:");
            if (n >= 0) {
                String[] stringArray = new String[]{DSUtil.abreviateString(string.substring(n + 14), 40)};
                String string2 = DSUtil._resource.getString("CreateVLVIndex", "LDAPMode-addingVLVIndex-title", stringArray);
                ((GenericProgressDialog)this._progressDialog).setTextInLabel(string2);
            }
        } else {
            int n = string.lastIndexOf("Indexing attribute:");
            if (n >= 0) {
                String[] stringArray = new String[]{DSUtil.abreviateString(string.substring(n + 20), 40)};
                String string3 = DSUtil._resource.getString(this._taskSection, "LDAPMode-addingIndex-title", stringArray);
                ((GenericProgressDialog)this._progressDialog).setTextInLabel(string3);
            }
        }
        this._statusProgressDialog.update(hashtable);
    }

    public boolean cancelTask() {
        return super.cancelTask();
    }

    protected void waitForClose() {
        if (!this._dontWaitForClose) {
            ((GenericProgressDialog)this._progressDialog).waitForClose();
            if (this._statusProgressDialog.isVisible()) {
                this._statusProgressDialog.toFront();
            }
        }
        if (this.getResult() != 4 && this.getResult() != 3) {
            ((GenericProgressDialog)this._progressDialog).setTextInLabel(DSUtil._resource.getString(this._taskSection, "LDAPMode-endError-title"));
        } else {
            ((GenericProgressDialog)this._progressDialog).setTextInLabel(DSUtil._resource.getString(this._taskSection, "LDAPMode-finished-title"));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this._dontWaitForClose) {
            if (actionEvent.getActionCommand().equals("Cancel-GenericProgressDialog")) {
                Debug.println((String)"LDAPCreateIndex.actionPerformed: CANCEL");
                this.cancelTask();
            }
        } else {
            super.actionPerformed(actionEvent);
        }
    }
}

