/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.server;

import com.sun.management.viper.ComponentInfo;
import com.sun.management.viper.util.Debug;
import com.sun.management.viper.util.QuotedStringTokenizer;
import com.sun.management.viperimpl.LibInfoImpl;
import com.sun.management.viperimpl.console.config.toolInf;
import com.sun.management.viperimpl.server.RegistryProgress;
import com.sun.management.viperimpl.server.ViperServer;
import com.sun.management.viperimpl.server.repository.VRegistry;
import com.sun.management.viperimpl.util.SectionedProperties;
import com.sun.management.viperimpl.xml.viperbean.DescriptorManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class Registry {
    protected SectionedProperties reg;
    protected SectionedProperties prereg;
    protected SectionedProperties smcreg;
    protected SectionedProperties smcunreg;
    protected ArrayList addedSet;
    protected ArrayList removedSet;
    protected Vector classlistRemovals = new Vector();
    protected static String regPath;
    protected static String preregDir;
    protected static String STAMP;
    protected static String SUFFIX;
    protected static String VIPER_HOME;
    protected static String VIPER_RTHOME;
    protected static String STANDALONE;
    private ResourceBundle resource = null;
    protected static String SMCREG;
    protected static String SMCUNREG;
    protected static String LIB;
    protected static String CODEBASE;
    protected static String SCRIPTS;
    protected static String CLASSLIST;
    protected static String[] envArray;
    protected static SimpleDateFormat dateFmt;
    protected static int totalElements;
    protected static int elementsCompleted;
    protected static String currentTask;
    private boolean standalone = false;
    private static final String SMCREG_VERSION = "1.0";
    private String regPhase = null;
    private final int NO_REGLEVEL = 99999;
    private boolean bSetup = true;
    protected static final String NATIVELIB_KEY = "nativelib";
    protected static final String SRCJAR_KEY = "srcjar";
    protected static final String XMLFILE_KEY = "xmlfile";
    protected static final String JARFILE_KEY = "jarfile";
    protected static final String SCOPE_KEY = "scope";
    protected static final String CLASSLIST_KEY = "classlist";
    protected static final String KEY_KEY = "key";
    protected static final String VALUE_KEY = "value";
    protected static final String VERSION_KEY = "version";
    protected static final String RUN_KEY = "run";
    protected static final String PROPERTY = "property";
    protected static final String TOOL = "tool";
    protected static final String SERVICE = "service";
    protected static final String LIBRARY = "library";
    protected static final String RUNCOMMAND = "run";
    protected static final String TOOLBOX = "toolbox";
    protected static final int A_LIBRARY = 0;
    protected static final int A_TOOL = 1;
    protected static final int A_SERVICE = 2;
    protected static final int A_PROPERTY = 3;
    protected static final int A_RUN = 4;
    protected static final int A_TOOLBOX = 5;

    protected Registry(boolean bl) {
        try {
            this.resource = ResourceBundle.getBundle("com.sun.management.viperimpl.server.ViperServerResources");
        }
        catch (Exception exception) {
            System.out.println("Can't load server resource.");
        }
        regPath = VIPER_RTHOME + "/properties/registry.properties";
        preregDir = VIPER_HOME + "/prereg";
        this.reg = new SectionedProperties();
        this.prereg = new SectionedProperties();
        this.smcreg = new SectionedProperties();
        this.smcunreg = new SectionedProperties();
        this.addedSet = new ArrayList();
        this.removedSet = new ArrayList();
        dateFmt = new SimpleDateFormat("yyyyMMddHHmmss");
        dateFmt.setTimeZone(TimeZone.getTimeZone("GMT"));
        totalElements = 0;
        elementsCompleted = 0;
        this.bSetup = bl;
        this.regPhase = bl ? this.getMessage("RegisterSetup", null) : this.getMessage("RegisterComponents", null);
        if (STANDALONE != null && STANDALONE.equals("true")) {
            this.standalone = true;
        }
        envArray = new String[]{"VIPER_HOME=" + VIPER_HOME, "SMC_HOME=" + VIPER_HOME, "SMC_RTHOME=" + VIPER_RTHOME, "PATH=/usr/sbin:/usr/bin"};
    }

    private String getMessage(String string, Object[] objectArray) {
        if (string == null) {
            return null;
        }
        if (this.resource == null) {
            return string;
        }
        String string2 = string;
        try {
            string2 = this.resource.getString(string2);
            string2 = MessageFormat.format(string2, objectArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    protected void findNewFragments() {
        String string;
        Iterator iterator = this.prereg.blockNames();
        while (this.bSetup && iterator.hasNext()) {
            string = (String)iterator.next();
            if (this.reg.containsKey(string)) continue;
            this.addedSet.add(string);
        }
        iterator = this.smcreg.blockNames();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (this.reg.containsKey(string)) continue;
            this.addedSet.add(string);
        }
    }

    protected void findRemovedFragments() {
        String string;
        Iterator iterator = this.reg.blockNames();
        while (this.bSetup && iterator.hasNext()) {
            string = (String)iterator.next();
            if (this.reg.getProperty(string, "install") == null || this.reg.getProperty(string, "remove") == null || this.prereg.containsKey(string)) continue;
            this.removedSet.add(string);
        }
        iterator = this.reg.blockNames();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (!this.smcunreg.containsKey(string)) continue;
            this.removedSet.add(string);
        }
    }

    protected void findUpdatedFragments() {
        String string;
        String string2;
        String string3;
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.reg.blockNames();
        while (this.bSetup && iterator.hasNext()) {
            string3 = (String)iterator.next();
            string2 = this.reg.getProperty(string3, STAMP);
            if (!this.prereg.containsKey(string3)) continue;
            string = this.prereg.getProperty(string3, STAMP);
            if (string2 == null) {
                Debug.trace((String)"Registry", (int)Debug.WARNING, (String)("Bad registry block " + string3 + ": no timestamp"), null);
                continue;
            }
            try {
                if (Long.parseLong(string2) >= Long.parseLong(string)) continue;
                arrayList.add(string3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        iterator = this.reg.blockNames();
        while (iterator.hasNext()) {
            string3 = (String)iterator.next();
            string2 = this.reg.getProperty(string3, STAMP);
            if (!this.smcreg.containsKey(string3)) continue;
            string = this.smcreg.getProperty(string3, STAMP);
            if (string2 == null) {
                Debug.trace((String)"Registry", (int)Debug.WARNING, (String)("Bad registry block " + string3 + ": no timestamp"), null);
                continue;
            }
            try {
                if (Long.parseLong(string2) >= Long.parseLong(string)) continue;
                arrayList.add(string3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            string3 = (String)iterator.next();
            string2 = this.smcreg.getProperty(string3, STAMP);
            if (this.removedSet.contains(string3)) {
                string = this.smcunreg.getProperty(string3, STAMP);
                try {
                    if (Long.parseLong(string) > Long.parseLong(string2)) continue;
                    int n = this.removedSet.indexOf(string3);
                    this.removedSet.remove(n);
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
            }
            this.addedSet.add(string3);
        }
    }

    private int countEmptyRemoves() {
        int n = 0;
        Iterator iterator = this.removedSet.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = this.reg.getProperty(string, "remove");
            if (string2 == null || string2.trim().length() != 0) continue;
            ++n;
        }
        return n;
    }

    protected void addFragments() {
        Object[] objectArray = this.addedSet.toArray();
        Arrays.sort(objectArray, new Comparator(){

            public int compare(Object object, Object object2) {
                int n = 99999;
                int n2 = 99999;
                try {
                    n = Registry.this.prereg.getProperty((String)object, "install") != null ? Integer.parseInt(Registry.this.prereg.getProperty((String)object, "regLevel")) : Integer.parseInt(Registry.this.smcreg.getProperty((String)object, "regLevel"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    n2 = Registry.this.prereg.getProperty((String)object, "install") != null ? Integer.parseInt(Registry.this.prereg.getProperty((String)object2, "regLevel")) : Integer.parseInt(Registry.this.smcreg.getProperty((String)object2, "regLevel"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n != 99999 && n2 != 99999) {
                    return n - n2;
                }
                if (n != 99999 && n2 == 99999) {
                    return 1;
                }
                if (n == 99999 && n2 != 99999) {
                    return -1;
                }
                long l = 0L;
                long l2 = 0L;
                try {
                    l = Registry.this.prereg.getProperty((String)object, "install") != null ? Long.parseLong(Registry.this.prereg.getProperty((String)object, STAMP)) : Long.parseLong(Registry.this.smcreg.getProperty((String)object, STAMP));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    l2 = Registry.this.prereg.getProperty((String)object, "install") != null ? Long.parseLong(Registry.this.prereg.getProperty((String)object2, STAMP)) : Long.parseLong(Registry.this.smcreg.getProperty((String)object2, STAMP));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (l < l2) {
                    return -1;
                }
                if (l > l2) {
                    return 1;
                }
                return 0;
            }

            public boolean equals(Object object) {
                return false;
            }
        });
        int n = 0;
        while (n < objectArray.length) {
            String string = (String)objectArray[n];
            switch (this.whatIsIt(string)) {
                case 3: {
                    this.registerProperty(string);
                    break;
                }
                case 1: 
                case 2: {
                    this.registerToolOrService(string);
                    break;
                }
                case 0: {
                    this.registerLibrary(string);
                    break;
                }
                case 5: {
                    this.registerToolbox(string);
                    break;
                }
                case 4: {
                    this.runCommandFromProperties(this.smcreg.getBlock(string));
                    this.reg.setBlock(string, this.smcreg.getBlock(string));
                    this.reg.setProperty(string, STAMP, dateFmt.format(new Date()));
                    break;
                }
                default: {
                    this.runInstallCommand(string);
                }
            }
            ++n;
        }
        if (!this.bSetup) {
            VRegistry.deleteFile(SMCREG);
        }
    }

    protected void removeFragments() {
        Object[] objectArray = this.removedSet.toArray();
        Arrays.sort(objectArray, new Comparator(){

            public int compare(Object object, Object object2) {
                int n = 99999;
                int n2 = 99999;
                try {
                    n = Registry.this.prereg.getProperty((String)object, "remove") != null ? Integer.parseInt(Registry.this.prereg.getProperty((String)object, "regLevel")) : Integer.parseInt(Registry.this.smcunreg.getProperty((String)object, "regLevel"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    n2 = Registry.this.prereg.getProperty((String)object, "remove") != null ? Integer.parseInt(Registry.this.prereg.getProperty((String)object2, "regLevel")) : Integer.parseInt(Registry.this.smcunreg.getProperty((String)object2, "regLevel"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n != 99999 && n2 != 99999) {
                    return n - n2;
                }
                if (n != 99999 && n2 == 99999) {
                    return 1;
                }
                if (n == 99999 && n2 != 99999) {
                    return -1;
                }
                long l = 0L;
                long l2 = 0L;
                try {
                    l = Registry.this.prereg.getProperty((String)object, "remove") != null ? Long.parseLong(Registry.this.prereg.getProperty((String)object, STAMP)) : Long.parseLong(Registry.this.smcunreg.getProperty((String)object, STAMP));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    l2 = Registry.this.prereg.getProperty((String)object, "remove") != null ? Long.parseLong(Registry.this.prereg.getProperty((String)object2, STAMP)) : Long.parseLong(Registry.this.smcunreg.getProperty((String)object2, STAMP));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (l < l2) {
                    return 1;
                }
                if (l > l2) {
                    return -1;
                }
                return 0;
            }

            public boolean equals(Object object) {
                return false;
            }
        });
        int n = 0;
        while (n < objectArray.length) {
            String string = (String)objectArray[n];
            switch (this.whatIsIt(string)) {
                case 3: {
                    this.unRegisterProperty(string);
                    break;
                }
                case 1: 
                case 2: {
                    this.unRegisterToolOrService(string);
                    break;
                }
                case 0: {
                    this.unRegisterLibrary(string);
                    break;
                }
                case 5: {
                    this.registerToolbox(string);
                    break;
                }
                case 4: {
                    this.runCommandFromProperties(this.smcunreg.getBlock(string));
                    break;
                }
                default: {
                    this.runRemoveCommand(string);
                }
            }
            this.reg.remove(string);
            ++n;
        }
        if (!this.bSetup) {
            VRegistry.deleteFile(SMCUNREG);
            this.updateClasslist();
        }
    }

    protected void loadSmcreg() throws FileNotFoundException, IOException {
        this.smcreg.load(new FileInputStream(SMCREG));
    }

    protected void loadSmcunreg() throws FileNotFoundException, IOException {
        this.smcunreg.load(new FileInputStream(SMCUNREG));
    }

    protected void loadPrereg() throws FileNotFoundException, IOException {
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                File file2 = new File(file + "/" + string);
                return file2.isDirectory();
            }
        };
        FilenameFilter filenameFilter2 = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(SUFFIX);
            }
        };
        File[] fileArray = new File(preregDir).listFiles(filenameFilter);
        if (fileArray == null) {
            String string = ViperServer.getMessage("NoPreregDirs", null);
            throw new FileNotFoundException(string);
        }
        int n = 0;
        while (n < fileArray.length) {
            File[] fileArray2 = fileArray[n].listFiles(filenameFilter2);
            int n2 = 0;
            while (n2 < fileArray2.length) {
                this.prereg.load(new FileInputStream(fileArray2[n2]));
                ++n2;
            }
            ++n;
        }
    }

    protected void loadRegistry() throws FileNotFoundException, IOException {
        this.reg.load(new FileInputStream(regPath));
    }

    protected void storeRegistry() throws FileNotFoundException, IOException {
        this.reg.store(new FileOutputStream(regPath), null);
    }

    protected void updateRegistry() {
        this.findRemovedFragments();
        this.findNewFragments();
        this.findUpdatedFragments();
        totalElements = this.addedSet.size() + this.removedSet.size();
        this.removeFragments();
        this.addFragments();
        if ((totalElements -= this.countEmptyRemoves()) > 0) {
            System.err.println("");
        }
    }

    protected void outputProgress(boolean bl) {
        if (!bl) {
            System.err.println(this.regPhase + " " + (elementsCompleted + 1) + "/" + totalElements + " (" + currentTask + ")");
        } else {
            System.err.print("\r                                                                            ");
            System.err.print("\r" + this.regPhase + " " + (elementsCompleted + 1) + "/" + totalElements + " (" + currentTask + ")");
        }
    }

    public static RegistryProgress getProgress() {
        RegistryProgress registryProgress = new RegistryProgress();
        registryProgress.completed = elementsCompleted;
        registryProgress.total = totalElements;
        registryProgress.task = currentTask;
        return registryProgress;
    }

    protected int whatIsIt(String string) {
        if (string.startsWith(PROPERTY)) {
            return 3;
        }
        if (string.startsWith(TOOLBOX)) {
            return 5;
        }
        if (string.startsWith(TOOL)) {
            return 1;
        }
        if (string.startsWith(SERVICE)) {
            return 2;
        }
        if (string.startsWith(LIBRARY)) {
            return 0;
        }
        if (string.startsWith("run")) {
            return 4;
        }
        return -1;
    }

    protected boolean isValidVersionNumber(String string) {
        if (string == null) {
            return false;
        }
        return string.compareTo(SMCREG_VERSION) == 0;
    }

    protected void runInstallCommand(String string) {
        CharSequence charSequence;
        String string2 = this.prereg.getProperty(string, "install");
        if (string2 == null) {
            return;
        }
        Debug.trace((String)"Registry", (int)Debug.INFORMATION, (String)("fragment " + string + " with: " + string2), null);
        if (string2.trim().length() > 0) {
            currentTask = this.getMessage("Executing", new String[]{new File(string2).getName()});
            this.outputProgress(!this.standalone);
            ++elementsCompleted;
            if (!this.standalone) {
                charSequence = new StringBuffer();
                int n = this.runCommand(string2, (StringBuffer)charSequence);
                if (charSequence.length() > 0) {
                    System.out.println(charSequence);
                }
            }
        }
        this.reg.setBlock(string, this.prereg.getBlock(string));
        this.reg.setProperty(string, STAMP, dateFmt.format(new Date()));
        string2 = this.prereg.getProperty(string, "remove");
        if (string2 != null && string2.trim().length() > 0) {
            charSequence = SCRIPTS + "/" + string;
            File file = new File((String)charSequence);
            file.mkdirs();
            String string3 = (String)charSequence + "/" + new File(string2).getName();
            try {
                this.copyFile(string2, string3);
                this.runCommand("chmod +x " + string3, new StringBuffer());
                this.reg.setProperty(string, "remove", string3);
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        }
    }

    protected void runRemoveCommand(String string) {
        String string2 = this.reg.getProperty(string, "remove");
        if (string2 == null) {
            return;
        }
        Debug.trace((String)"Registry", (int)Debug.INFORMATION, (String)("Removing fragment " + string + " with: " + string2), null);
        if (string2.trim().length() > 0) {
            File file = new File(string2);
            int n = string2.indexOf("smcconf");
            if (n < 0) {
                n = 0;
            }
            currentTask = this.getMessage("Executing", new String[]{file.exists() ? file.getName() : string2.substring(n)});
            this.outputProgress(string2.indexOf(32) < 0);
            ++elementsCompleted;
            if (!this.standalone) {
                String[] stringArray;
                StringBuffer stringBuffer = new StringBuffer();
                int n2 = this.runCommand(string2, stringBuffer);
                if (stringBuffer.length() > 0 && string2.indexOf("smcconf") < 0 && string2.indexOf(TOOLBOX) < 0) {
                    System.out.println("\n" + stringBuffer);
                }
                if ((file = new File(string2)).exists()) {
                    file.delete();
                    if (file.getParentFile().exists()) {
                        file.getParentFile().delete();
                    }
                }
                if ((file = new File(SCRIPTS)).exists() && ((stringArray = file.list()) == null || stringArray.length <= 0)) {
                    file.delete();
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected int runCommand(String var1_1, StringBuffer var2_2) {
        if (!this.standalone) ** GOTO lbl4
        return 0;
lbl-1000:
        // 1 sources

        {
            var1_1 = var1_1.substring(0, var3_3) + Registry.VIPER_HOME + var1_1.substring(var3_3 + 9);
lbl4:
            // 2 sources

            ** while ((var3_3 = var1_1.indexOf((String)"$SMC_HOME")) != -1)
        }
lbl5:
        // 2 sources

        while ((var3_3 = var1_1.indexOf("$SMC_RTHOME")) != -1) {
            var1_1 = var1_1.substring(0, var3_3) + Registry.VIPER_RTHOME + var1_1.substring(var3_3 + 11);
        }
        var4_4 = QuotedStringTokenizer.toArray((String)var1_1);
        var5_5 = null;
        var6_6 = -1;
        try {
            var5_5 = Runtime.getRuntime().exec(var4_4, Registry.envArray);
        }
        catch (IOException var7_7) {
            var2_2.append(var7_7.getMessage());
            return var6_6;
        }
        try {
            var7_8 = new BufferedReader(new InputStreamReader(var5_5.getInputStream()));
            while ((var8_11 = var7_8.readLine()) != null) {
                var2_2.append("\n  " + var8_11);
            }
            var7_8.close();
        }
        catch (IOException var7_9) {
            Debug.trace((String)"Registry", (int)Debug.WARNING, (String)"Failed to read from process", (Throwable)var7_9);
        }
        var7_10 = false;
        while (!var7_10) {
            try {
                var6_6 = var5_5.waitFor();
                var7_10 = true;
            }
            catch (InterruptedException var8_12) {
                // empty catch block
            }
        }
        return var6_6;
    }

    protected void runCommandFromProperties(Properties properties) {
        if (properties == null) {
            return;
        }
        String string = properties.getProperty(VERSION_KEY);
        if (!this.isValidVersionNumber(string)) {
            System.out.println(this.getMessage("BadSmcregVersion", new String[]{"", SMCREG_VERSION}));
            System.out.println(this.getMessage("RegistryUpdateFailed", null));
            return;
        }
        String string2 = properties.getProperty("run");
        currentTask = "Running Command: " + string2;
        this.outputProgress(!this.standalone);
        ++elementsCompleted;
        if (!this.standalone) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = this.runCommand(string2, stringBuffer);
            if (stringBuffer.length() > 0) {
                System.out.println(stringBuffer);
            }
        }
    }

    protected void unRegisterProperty(String string) {
        int n;
        Properties properties = this.smcunreg.getBlock(string);
        if (properties == null) {
            return;
        }
        String string2 = properties.getProperty(VERSION_KEY);
        if (!this.isValidVersionNumber(string2)) {
            System.out.println(this.getMessage("BadSmcregVersion", new String[]{string, SMCREG_VERSION}));
            System.out.println(this.getMessage("RegistryUpdateFailed", null));
            return;
        }
        String string3 = properties.getProperty(KEY_KEY);
        String string4 = properties.getProperty(SCOPE_KEY);
        currentTask = "Unregistering property " + string3;
        this.outputProgress(!this.standalone);
        ++elementsCompleted;
        if (!this.standalone && (n = VRegistry.removeProperties(string3, string4, null)) != 0) {
            System.out.println(this.getMessage("CantUnRegisterProperty", new String[]{string3, String.valueOf(n)}));
            System.out.println(this.getMessage("RegistryUpdateFailed", null));
        }
    }

    protected void unRegisterToolOrService(String string) {
        String string2;
        Properties properties = this.smcunreg.getBlock(string);
        if (properties == null) {
            return;
        }
        String string3 = properties.getProperty(VERSION_KEY);
        if (!this.isValidVersionNumber(string3)) {
            System.out.println(this.getMessage("BadSmcregVersion", new String[]{string, SMCREG_VERSION}));
            System.out.println(this.getMessage("RegistryUpdateFailed", null));
            return;
        }
        String string4 = string2 = properties.getProperty(JARFILE_KEY);
        int n = string2.lastIndexOf(".jar");
        if (n >= 0 && (n = string2.lastIndexOf(46, n - 1)) >= 0) {
            string4 = string2.substring(n + 1);
        }
        currentTask = "Unregistering " + string4;
        this.outputProgress(!this.standalone);
        ++elementsCompleted;
        if (!this.standalone) {
            File file = new File(CODEBASE + "/" + string2);
            file.delete();
            this.classlistRemovals.add(string2);
            if (!VRegistry.removeEntry(string2)) {
                System.out.println(this.getMessage("CantUnRegister", new String[]{string2}));
                System.out.println(this.getMessage("RegistryUpdateFailed", null));
            }
        }
    }

    protected void unRegisterLibrary(String string) {
        Properties properties = this.smcunreg.getBlock(string);
        if (properties == null) {
            return;
        }
        String string2 = properties.getProperty(VERSION_KEY);
        if (!this.isValidVersionNumber(string2)) {
            System.out.println(this.getMessage("BadSmcregVersion", new String[]{string, SMCREG_VERSION}));
            System.out.println(this.getMessage("RegistryUpdateFailed", null));
            return;
        }
        String string3 = properties.getProperty(JARFILE_KEY);
        String string4 = properties.getProperty(SCOPE_KEY);
        String string5 = string3;
        int n = string3.lastIndexOf(".jar");
        if (n >= 0 && (n = string3.lastIndexOf(46, n - 1)) >= 0) {
            string5 = string3.substring(n + 1);
        }
        currentTask = "Unregistering " + string5;
        this.outputProgress(!this.standalone);
        ++elementsCompleted;
        if (!this.standalone) {
            File file = new File(CODEBASE + "/" + string4 + "@" + string3);
            file.delete();
            this.classlistRemovals.add(string4 + "@" + string3);
            String string6 = VRegistry.removeJarFromEntry(string4, string3);
            if (string6 == null) {
                System.out.println(this.getMessage("CantUnRegister", new String[]{string3}));
                System.out.println(this.getMessage("RegistryUpdateFailed", null));
            }
        }
    }

    protected void updateClasslist() {
        if (this.classlistRemovals.size() == 0) {
            return;
        }
        BufferedReader bufferedReader = null;
        PrintWriter printWriter = null;
        File file = new File(CLASSLIST + ".new");
        try {
            String string;
            bufferedReader = new BufferedReader(new FileReader(CLASSLIST));
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            while ((string = bufferedReader.readLine()) != null) {
                boolean bl = false;
                int n = 0;
                while (n < this.classlistRemovals.size()) {
                    String string2 = (String)this.classlistRemovals.elementAt(n);
                    if (string.indexOf(string2) >= 0) {
                        bl = true;
                        break;
                    }
                    ++n;
                }
                if (bl) continue;
                printWriter.println(string);
            }
            printWriter.flush();
            printWriter.close();
            bufferedReader.close();
            file.renameTo(new File(CLASSLIST));
        }
        catch (Exception exception) {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (printWriter != null) {
                    printWriter.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            file.delete();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void copyFile(String string, String string2) throws Exception {
        FileOutputStream fileOutputStream;
        block9: {
            int n = 8192;
            FileInputStream fileInputStream = null;
            fileOutputStream = null;
            try {
                try {
                    fileInputStream = new FileInputStream(string);
                    fileOutputStream = new FileOutputStream(string2);
                    byte[] byArray = new byte[n];
                    while (true) {
                        int n2;
                        if ((n2 = fileInputStream.read(byArray)) <= 0) {
                            fileOutputStream.flush();
                            break;
                        }
                        fileOutputStream.write(byArray, 0, n2);
                    }
                }
                catch (Exception exception) {
                    throw new Exception(this.getMessage("FileCopyFailed", new String[]{string, string2, exception.getMessage()}));
                }
                Object var9_9 = null;
                if (fileInputStream == null) break block9;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (fileOutputStream == null) throw throwable;
                fileOutputStream.close();
                throw throwable;
            }
            fileInputStream.close();
        }
        if (fileOutputStream == null) return;
        fileOutputStream.close();
    }

    protected void appendFile(String string, String string2) throws Exception {
        int n;
        int n2 = 8192;
        File file = new File(string2);
        if (!file.exists()) {
            this.copyFile(string, string2);
            return;
        }
        File file2 = new File(string2 + ".new");
        file2.createNewFile();
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        byte[] byArray = new byte[n2];
        try {
            fileInputStream = new FileInputStream(string2);
            fileOutputStream = new FileOutputStream(file2);
            while ((n = fileInputStream.read(byArray)) > 0) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileInputStream.close();
        }
        catch (Exception exception) {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            throw new Exception(this.getMessage("FileAppendFailed", new String[]{string, string2, exception.getMessage()}));
        }
        fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            while ((n = fileInputStream.read(byArray)) > 0) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.flush();
        }
        catch (Exception exception) {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            throw new Exception(this.getMessage("FileAppendFailed", new String[]{string, string2, exception.getMessage()}));
        }
        fileInputStream.close();
        fileOutputStream.close();
        file2.renameTo(new File(string2));
    }

    private String generateClasslist(String string, String string2, String string3, String string4) {
        String string5 = new File(string).getName();
        int n = string5.lastIndexOf(".jar");
        if (n >= 0) {
            string5 = string5.substring(0, n);
        }
        String string6 = VIPER_RTHOME + "/" + string5 + "_classlist.txt";
        JarFile jarFile = null;
        PrintWriter printWriter = null;
        try {
            jarFile = new JarFile(string);
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(new File(string6))));
        }
        catch (Exception exception) {
            return null;
        }
        String string7 = string2 + "@";
        string7 = string4 != null && string4.length() > 0 ? string7 + string4 : string7 + new File(string).getName();
        printWriter.println("# classes in " + string7);
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            if (jarEntry.getName().startsWith("META-INF")) continue;
            printWriter.println(jarEntry.getName() + ":" + string7 + ":" + string3);
        }
        printWriter.flush();
        printWriter.close();
        return string6;
    }

    protected void registerToolOrService(String string) {
        String string2;
        Properties properties = this.smcreg.getBlock(string);
        if (properties == null) {
            return;
        }
        String string3 = properties.getProperty(VERSION_KEY);
        if (!this.isValidVersionNumber(string3)) {
            System.out.println(this.getMessage("BadSmcregVersion", new String[]{string, SMCREG_VERSION}));
            System.out.println(this.getMessage("RegistryUpdateFailed", null));
            return;
        }
        String string4 = string2 = properties.getProperty(JARFILE_KEY);
        int n = string2.lastIndexOf(".jar");
        if (n >= 0 && (n = string2.lastIndexOf(46, n - 1)) >= 0) {
            string4 = string2.substring(n + 1);
        }
        currentTask = "Registering " + string4;
        this.outputProgress(!this.standalone);
        ++elementsCompleted;
        String string5 = properties.getProperty(XMLFILE_KEY);
        if (!this.standalone) {
            LibInfoImpl libInfoImpl;
            String string6;
            String string7 = "";
            String string8 = "";
            Vector<String> vector = new Vector<String>();
            n = 0;
            while (n < 4) {
                string7 = properties.getProperty(NATIVELIB_KEY + n);
                if (string7 != null && string7.length() != 0) {
                    string6 = new File(string7).getName();
                    vector.add(string6);
                    string8 = LIB + "/" + string6;
                    try {
                        this.copyFile(string7, string8);
                    }
                    catch (Exception exception) {
                        System.out.println(exception.getMessage());
                        System.out.println(this.getMessage("RegistryUpdateFailed", null));
                        return;
                    }
                }
                ++n;
            }
            try {
                string7 = properties.getProperty(SRCJAR_KEY);
                if (string7 == null || string7.length() == 0) {
                    throw new Exception(this.getMessage("CantFindJar", new String[]{string4}));
                }
                string8 = CODEBASE + "/" + string2;
                this.copyFile(string7, string8);
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                System.out.println(this.getMessage("RegistryUpdateFailed", null));
                return;
            }
            try {
                string7 = properties.getProperty(CLASSLIST_KEY);
                if (string7 == null || string7.length() == 0) {
                    throw new Exception(this.getMessage("CantFindClasslist", null));
                }
                this.appendFile(string7, CLASSLIST);
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                System.out.println(this.getMessage("RegistryUpdateFailed", null));
                return;
            }
            string6 = null;
            try {
                string6 = DescriptorManager.createDescriptor(new File(string5).toURL());
            }
            catch (Exception exception) {
                System.out.println(this.getMessage("CantParseDescriptor", new String[]{string2, exception.getMessage()}));
                System.out.println(this.getMessage("RegistryUpdateFailed", null));
                return;
            }
            Object[] objectArray = null;
            if (vector.size() > 0) {
                objectArray = new String[vector.size()];
                vector.copyInto(objectArray);
            }
            if ((libInfoImpl = VRegistry.addEntry((ComponentInfo)string6, objectArray)) == null) {
                System.out.println(this.getMessage("CantRegister", new String[]{string2}));
                System.out.println(this.getMessage("RegistryUpdateFailed", null));
                return;
            }
        }
        this.reg.setBlock(string, this.smcreg.getBlock(string));
        this.reg.setProperty(string, STAMP, dateFmt.format(new Date()));
    }

    protected void registerLibrary(String string) {
        Properties properties = this.smcreg.getBlock(string);
        if (properties == null) {
            return;
        }
        String string2 = properties.getProperty(VERSION_KEY);
        if (!this.isValidVersionNumber(string2)) {
            System.out.println(this.getMessage("BadSmcregVersion", new String[]{string, SMCREG_VERSION}));
            System.out.println(this.getMessage("RegistryUpdateFailed", null));
            return;
        }
        String string3 = properties.getProperty(JARFILE_KEY);
        String string4 = properties.getProperty(SCOPE_KEY);
        String string5 = string3;
        int n = string3.lastIndexOf(".jar");
        if (n >= 0 && (n = string3.lastIndexOf(46, n - 1)) >= 0) {
            string5 = string3.substring(n + 1);
        }
        currentTask = "Registering " + string5;
        this.outputProgress(!this.standalone);
        ++elementsCompleted;
        if (!this.standalone) {
            String string6;
            String string7 = "";
            String string8 = "";
            Vector<String> vector = new Vector<String>();
            n = 0;
            while (n < 4) {
                string7 = properties.getProperty(NATIVELIB_KEY + n);
                if (string7 != null && string7.length() != 0) {
                    String string9 = new File(string7).getName();
                    vector.add(string9);
                    string8 = LIB + "/" + string9;
                    try {
                        this.copyFile(string7, string8);
                    }
                    catch (Exception exception) {
                        System.out.println(exception.getMessage());
                        System.out.println(this.getMessage("RegistryUpdateFailed", null));
                        return;
                    }
                }
                ++n;
            }
            try {
                string7 = properties.getProperty(SRCJAR_KEY);
                if (string7 == null || string7.length() == 0) {
                    throw new Exception(this.getMessage("CantFindJar", new String[]{string5}));
                }
                string8 = CODEBASE + "/" + string4 + "@" + string3;
                this.copyFile(string7, string8);
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                System.out.println(this.getMessage("RegistryUpdateFailed", null));
                return;
            }
            boolean bl = false;
            try {
                string7 = properties.getProperty(CLASSLIST_KEY);
                if (string7 == null || string7.length() == 0) {
                    string7 = this.generateClasslist(properties.getProperty(SRCJAR_KEY), string4, LIBRARY, string3);
                    bl = true;
                }
                if (string7 == null || string7.length() == 0) {
                    throw new Exception(this.getMessage("CantFindClasslist", null));
                }
                this.appendFile(string7, CLASSLIST);
                if (bl) {
                    new File(string7).delete();
                }
            }
            catch (Exception exception) {
                if (bl) {
                    new File(string7).delete();
                }
                System.out.println(exception.getMessage());
                System.out.println(this.getMessage("RegistryUpdateFailed", null));
                return;
            }
            Object[] objectArray = null;
            if (vector.size() > 0) {
                objectArray = new String[vector.size()];
                vector.copyInto(objectArray);
            }
            if ((string6 = VRegistry.addJarToEntry(string4, string3, (String[])objectArray)) == null) {
                System.out.println(this.getMessage("CantRegister", new String[]{string3}));
                System.out.println(this.getMessage("RegistryUpdateFailed", null));
                return;
            }
        }
        this.reg.setBlock(string, this.smcreg.getBlock(string));
        this.reg.setProperty(string, STAMP, dateFmt.format(new Date()));
    }

    protected synchronized void registerToolbox(String string) {
        String string2;
        Properties properties = this.smcreg.getBlock(string);
        if (properties == null) {
            return;
        }
        String string3 = properties.getProperty(VERSION_KEY);
        if (!this.isValidVersionNumber(string3)) {
            System.out.println(this.getMessage("BadSmcregVersion", new String[]{string, SMCREG_VERSION}));
            System.out.println(this.getMessage("RegistryUpdateFailed", null));
            return;
        }
        String string4 = "???";
        String string5 = "???";
        if (properties.getProperty(TOOL) != null) {
            string5 = TOOL;
            string4 = properties.getProperty(TOOL);
        } else if (properties.getProperty("folderName") != null) {
            string5 = "folder";
            string4 = properties.getProperty("folderName");
        } else if (properties.getProperty(TOOLBOX) != null) {
            string5 = TOOLBOX;
            string4 = properties.getProperty(TOOLBOX);
        } else if (properties.getProperty("tbxUrl") != null) {
            string5 = "tbxUrl";
            string4 = properties.getProperty("tbxUrl");
        }
        String string6 = string4;
        int n = string4.lastIndexOf(46);
        if (n >= 0) {
            if (string4.endsWith(".tbx")) {
                n = string4.lastIndexOf(47);
            }
            string6 = n >= 0 ? string4.substring(n + 1) : string4.substring(n + 1);
        }
        currentTask = (string2 = properties.getProperty("action")).equals("add") ? this.getMessage("RegisterToolbox", new String[]{string6}) : (string2.equals("create") ? this.getMessage("RegisterToolbox", new String[]{string6}) : this.getMessage("UnregisterToolbox", new String[]{string6}));
        this.outputProgress(!this.standalone);
        ++elementsCompleted;
        boolean bl = false;
        String string7 = properties.getProperty("force");
        if (string7 != null && (string7 == "1" || string7 == "true")) {
            bl = true;
        }
        String[] stringArray = new String[]{"pre-operation", "operation"};
        n = 0;
        while (n < stringArray.length) {
            String string8 = properties.getProperty(stringArray[n]);
            if (string8 != null && string8.length() != 0) {
                String[] stringArray2 = QuotedStringTokenizer.toArray((String)string8);
                if (!this.standalone) {
                    toolInf toolInf2;
                    block19: {
                        toolInf2 = null;
                        try {
                            toolInf2 = (toolInf)Class.forName(stringArray2[0]).newInstance();
                            toolInf2.exec(stringArray2);
                        }
                        catch (Exception exception) {
                            if (exception.getMessage().length() <= 0) break block19;
                            System.out.println("\n" + exception.getMessage());
                            if (toolInf2 != null && toolInf2.getExecStatus() != 0) {
                                this.handleToolboxResult(string2, stringArray2, string5, bl, toolInf2.getExecStatus());
                            }
                            return;
                        }
                    }
                    if (this.handleToolboxResult(string2, stringArray2, string5, bl, toolInf2.getExecStatus()) != 0) {
                        return;
                    }
                }
            }
            ++n;
        }
    }

    private int handleToolboxResult(String string, String[] stringArray, String string2, boolean bl, int n) {
        if (string.equalsIgnoreCase("create")) {
            if (stringArray[0].indexOf("checktool") >= 0) {
                switch (n) {
                    case 0: {
                        String string3 = this.getArgValue(stringArray, "-o");
                        String string4 = string3.substring(0, string3.length() - 4);
                        File file = new File(string3);
                        File file2 = new File(string4);
                        file.renameTo(file2);
                        return 0;
                    }
                }
                String string5 = this.getArgValue(stringArray, "-o");
                String string6 = string5.substring(0, string5.length() - 4);
                File file = new File(string5);
                file.delete();
                String string7 = this.getArgValue(stringArray, "-T");
                if (string7 != null && string7.equals("urlLink")) {
                    System.out.println(this.getMessage("InvalidURL", new String[]{this.getArgValue(stringArray, "-t")}));
                } else {
                    System.out.println(this.getMessage("CantCreateToolbox", new String[]{string6}));
                }
                System.out.println(this.getMessage("RegistryUpdateFailed", null));
                return 1;
            }
            return 0;
        }
        if (string.equalsIgnoreCase("add")) {
            if (stringArray[0].indexOf("checktool") >= 0) {
                switch (n) {
                    case 0: {
                        if (!bl) {
                            System.out.println(this.getMessage("CantOverwriteToolbox", new String[]{this.getMessage(string2, null), this.getMessage(string2, null)}));
                            System.out.println(this.getMessage("RegistryUpdateFailed", null));
                            return 1;
                        }
                        File file = new File(this.getArgValue(stringArray, "-f"));
                        file.setLastModified(new Date().getTime());
                        return 0;
                    }
                    case 2: {
                        System.out.println(this.getMessage("CantLocate", new String[]{this.getMessage("folder", null), this.getArgValue(stringArray, "-F")}));
                        System.out.println(this.getMessage("RegistryUpdateFailed", null));
                        return 1;
                    }
                    case 3: {
                        System.out.println(this.getMessage("BadSmallIcon", new String[]{this.getArgValue(stringArray, "-m")}));
                        System.out.println(this.getMessage("RegistryUpdateFailed", null));
                        return 1;
                    }
                    case 4: {
                        System.out.println(this.getMessage("BadLargeIcon", new String[]{this.getArgValue(stringArray, "-L")}));
                        System.out.println(this.getMessage("RegistryUpdateFailed", null));
                        return 1;
                    }
                    case 5: {
                        System.out.println(this.getMessage("MultipleFolders", new String[]{this.getArgValue(stringArray, "-F")}));
                        System.out.println(this.getMessage("RegistryUpdateFailed", null));
                        return 1;
                    }
                }
                return 0;
            }
            if (stringArray[0].indexOf("addtool") >= 0) {
                switch (n) {
                    case 0: {
                        File file = new File(this.getArgValue(stringArray, "-o"));
                        File file3 = new File(this.getArgValue(stringArray, "-f"));
                        file.renameTo(file3);
                        return 0;
                    }
                }
                if (string2.equals(TOOL)) {
                    System.out.println(this.getMessage("AddToolFailed", new String[]{this.getMessage(string2, null), this.getArgValue(stringArray, "-c")}));
                } else {
                    System.out.println(this.getMessage("AddToolFailed", new String[]{this.getMessage(string2, null), this.getArgValue(stringArray, "-t")}));
                }
                System.out.println(this.getMessage("RegistryUpdateFailed", null));
                return 1;
            }
            return 0;
        }
        if (string.equalsIgnoreCase("remove")) {
            if (stringArray[0].indexOf("checktool") < 0) {
                return 0;
            }
            if (this.getArgValue(stringArray, "-O").equals("check")) {
                switch (n) {
                    case 0: {
                        return 0;
                    }
                    case 2: {
                        System.out.println(this.getMessage("CantLocate", new String[]{this.getMessage("folder", null), this.getArgValue(stringArray, "-F")}));
                        System.out.println(this.getMessage("RegistryUpdateFailed", null));
                        return 1;
                    }
                    case 3: {
                        System.out.println(this.getMessage("BadSmallIcon", new String[]{this.getArgValue(stringArray, "-m")}));
                        System.out.println(this.getMessage("RegistryUpdateFailed", null));
                        return 1;
                    }
                    case 4: {
                        System.out.println(this.getMessage("BadLargeIcon", new String[]{this.getArgValue(stringArray, "-L")}));
                        System.out.println(this.getMessage("RegistryUpdateFailed", null));
                        return 1;
                    }
                    case 5: {
                        System.out.println(this.getMessage("MultipleFolders", new String[]{this.getArgValue(stringArray, "-F")}));
                        System.out.println(this.getMessage("RegistryUpdateFailed", null));
                        return 1;
                    }
                }
                if (string2.equals(TOOL)) {
                    System.out.println(this.getMessage("CantLocate", new String[]{this.getMessage(string2, null), this.getArgValue(stringArray, "-c")}));
                } else if (string2.equals("tbxUrl")) {
                    System.out.println(this.getMessage("CantLocate", new String[]{this.getMessage(string2, null), this.getArgValue(stringArray, "-t")}));
                } else {
                    System.out.println(this.getMessage("CantLocate", new String[]{this.getMessage(string2, null), this.getArgValue(stringArray, "-n")}));
                }
                System.out.println(this.getMessage("RegistryUpdateFailed", null));
                return 1;
            }
            if (this.getArgValue(stringArray, "-O").equals("delete")) {
                switch (n) {
                    case 0: {
                        File file = new File(this.getArgValue(stringArray, "-o"));
                        File file4 = new File(this.getArgValue(stringArray, "-f"));
                        file.renameTo(file4);
                        return 0;
                    }
                }
                if (string2.equals(TOOL)) {
                    System.out.println(this.getMessage("DeleteToolFailed", new String[]{this.getMessage(string2, null), this.getArgValue(stringArray, "-c")}));
                } else {
                    System.out.println(this.getMessage("DeleteToolFailed", new String[]{this.getMessage(string2, null), this.getArgValue(stringArray, "-n")}));
                }
                System.out.println(this.getMessage("RegistryUpdateFailed", null));
                return 1;
            }
            return 0;
        }
        return 0;
    }

    private String getArgValue(String[] stringArray, String string) {
        String string2 = "";
        if (stringArray == null) {
            return string2;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                string2 = stringArray[n + 1];
                break;
            }
            ++n;
        }
        return string2;
    }

    protected void registerProperty(String string) {
        int n;
        Properties properties = this.smcreg.getBlock(string);
        if (properties == null) {
            return;
        }
        String string2 = properties.getProperty(VERSION_KEY);
        if (!this.isValidVersionNumber(string2)) {
            System.out.println(this.getMessage("BadSmcregVersion", new String[]{string, SMCREG_VERSION}));
            System.out.println(this.getMessage("RegistryUpdateFailed", null));
            return;
        }
        String string3 = properties.getProperty(KEY_KEY);
        String string4 = properties.getProperty(VALUE_KEY);
        String string5 = properties.getProperty(SCOPE_KEY);
        String string6 = string3 + "=" + string4;
        currentTask = "Registering " + string6;
        this.outputProgress(!this.standalone);
        ++elementsCompleted;
        if (!this.standalone && (n = VRegistry.addProperties(string6, string5, null)) != 0) {
            System.out.println(this.getMessage("CantRegisterProperty", new String[]{string6, String.valueOf(n)}));
            System.out.println(this.getMessage("RegistryUpdateFailed", null));
            return;
        }
        this.reg.setBlock(string, this.smcreg.getBlock(string));
        this.reg.setProperty(string, STAMP, dateFmt.format(new Date()));
    }

    protected void merge() {
        String[] stringArray = new String[]{SMCREG, SMCUNREG};
        if (this.bSetup) {
            int n = 0;
            while (n < stringArray.length) {
                File file = new File(stringArray[n]);
                File file2 = new File(stringArray[n] + ".bak");
                if (file.exists()) {
                    file.renameTo(file2);
                }
                ++n;
            }
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            block13: {
                File file = new File(stringArray[n] + ".bak");
                if (file.exists()) {
                    File file3 = new File(stringArray[n]);
                    if (!file3.exists()) {
                        file.renameTo(file3);
                    } else {
                        SectionedProperties sectionedProperties = new SectionedProperties();
                        SectionedProperties sectionedProperties2 = new SectionedProperties();
                        try {
                            sectionedProperties.load(new FileInputStream(stringArray[n]));
                            sectionedProperties2.load(new FileInputStream(stringArray[n] + ".bak"));
                        }
                        catch (Exception exception) {
                            Debug.trace((String)"Registry", (int)Debug.WARNING, null, (Throwable)exception);
                            break block13;
                        }
                        Iterator iterator = sectionedProperties.blockNames();
                        int n2 = 1;
                        n2 = 1;
                        while (iterator.hasNext()) {
                            ++n2;
                            iterator.next();
                        }
                        iterator = sectionedProperties2.blockNames();
                        while (iterator.hasNext()) {
                            String string = (String)iterator.next();
                            sectionedProperties.setBlock(string, sectionedProperties2.getBlock(string));
                            sectionedProperties.setProperty(string, "regLevel", String.valueOf(n2));
                            ++n2;
                        }
                        try {
                            sectionedProperties.store(new FileOutputStream(stringArray[n]), null);
                        }
                        catch (Exception exception) {
                            System.out.println(exception.getMessage());
                        }
                        file.delete();
                    }
                }
            }
            ++n;
        }
    }

    public static void doEverything() {
        Registry registry = new Registry(true);
        File file = new File(VIPER_HOME + "/bin/smcpreconfig");
        if (file.exists()) {
            registry.runCommand(file.getPath(), new StringBuffer());
        }
        registry.merge();
        try {
            registry.loadPrereg();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            Debug.trace((String)"Registry", (int)Debug.WARNING, null, (Throwable)iOException);
        }
        try {
            registry.loadRegistry();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            Debug.trace((String)"Registry", (int)Debug.WARNING, null, (Throwable)iOException);
        }
        registry.updateRegistry();
        try {
            registry.storeRegistry();
        }
        catch (Exception exception) {
            Debug.trace((String)"Registry", (int)Debug.WARNING, null, (Throwable)exception);
        }
        registry = new Registry(false);
        registry.merge();
        try {
            registry.loadSmcreg();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            Debug.trace((String)"Registry", (int)Debug.WARNING, null, (Throwable)iOException);
        }
        try {
            registry.loadSmcunreg();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            Debug.trace((String)"Registry", (int)Debug.WARNING, null, (Throwable)iOException);
        }
        try {
            registry.loadRegistry();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            Debug.trace((String)"Registry", (int)Debug.WARNING, null, (Throwable)iOException);
        }
        registry.updateRegistry();
        try {
            registry.storeRegistry();
        }
        catch (Exception exception) {
            Debug.trace((String)"Registry", (int)Debug.WARNING, null, (Throwable)exception);
        }
    }

    public static void main(String[] stringArray) {
        Registry.doEverything();
    }

    static {
        STAMP = "timestamp";
        SUFFIX = ".mcreg";
        VIPER_HOME = System.getProperty("viper.home");
        VIPER_RTHOME = System.getProperty("viper.rthome");
        STANDALONE = System.getProperty("standalone");
        SMCREG = VIPER_RTHOME + "/smcreg";
        SMCUNREG = VIPER_RTHOME + "/smcunreg";
        LIB = VIPER_RTHOME + "/lib";
        CODEBASE = VIPER_RTHOME + "/codebase";
        SCRIPTS = VIPER_RTHOME + "/scripts";
        CLASSLIST = VIPER_RTHOME + "/properties/classlist.txt";
    }
}

