/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.services.authentication.server;

import com.sun.management.viper.services.AuthenticationException;
import com.sun.management.viper.services.AuthenticationFlavor;
import com.sun.management.viper.util.Debug;
import com.sun.management.viperimpl.services.authentication.DigestAuthFlavor;
import com.sun.management.viperimpl.services.authentication.DigestSecurityUtil;
import com.sun.management.viperimpl.services.authentication.server.DigestServerSecurityContext;
import com.sun.management.viperimpl.services.authentication.server.ServerSecurityContext;
import com.sun.management.viperimpl.services.authentication.server.ServerSecurityFactory;
import java.security.Provider;
import java.security.Security;
import java.util.Properties;

public class DigestServerSecurityFactory
implements ServerSecurityFactory {
    private DigestAuthFlavor initDaf;
    private DigestServerSecurityContext initSsc;

    public void init(Properties properties) throws AuthenticationException {
        Provider provider;
        DigestAuthFlavor digestAuthFlavor = new DigestAuthFlavor();
        String string = "SUN";
        int n = 0;
        long l = -1L;
        boolean bl = false;
        boolean bl2 = false;
        if (properties != null) {
            String string2 = properties.getProperty("auth.digest.provider");
            if (string2 != null) {
                string = string2;
            }
            if ((string2 = properties.getProperty("auth.digest.digest.algo")) != null) {
                digestAuthFlavor.setDigestAlgorithm(string2);
            }
            if ((string2 = properties.getProperty("auth.digest.sign.algo")) != null) {
                digestAuthFlavor.setSignatureAlgorithm(string2);
            }
            if ((string2 = properties.getProperty("auth.digest.key.algo")) != null) {
                digestAuthFlavor.setKeyGenerationAlgorithm(string2);
            }
            if ((string2 = properties.getProperty("auth.digest.key.strength")) != null) {
                int n2 = 0;
                try {
                    n2 = new Integer(string2);
                }
                catch (Exception exception) {
                    n2 = 0;
                }
                if (n2 > 0) {
                    digestAuthFlavor.setKeyStrength(n2);
                }
            }
            if ((string2 = properties.getProperty("auth.retry.max")) != null) {
                try {
                    n = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((string2 = properties.getProperty("auth.heartbeat.period")) != null) {
                try {
                    l = Long.parseLong(string2) * 1000L;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((string2 = properties.getProperty("auth.msg.verify")) != null && string2.equalsIgnoreCase("on")) {
                bl = true;
            }
            if ((string2 = properties.getProperty("auth.digest.msg.integrity")) != null && string2.equalsIgnoreCase("on")) {
                bl2 = true;
            }
        }
        if ((provider = Security.getProvider(string)) == (Provider)null) {
            Debug.trace((String)"Authentication Service", (int)Debug.ERROR, (String)("Security provider not installed: " + string), null);
            throw new AuthenticationException("Security provider not installed: ", (Object)string);
        }
        DigestSecurityUtil.initialize(provider, digestAuthFlavor.getDigestAlgorithm(), digestAuthFlavor.getSignatureAlgorithm(), digestAuthFlavor.getKeyGenerationAlgorithm(), digestAuthFlavor.getKeyStrength());
        this.initDaf = digestAuthFlavor;
        this.initSsc = new DigestServerSecurityContext(digestAuthFlavor);
        this.initSsc.setVerify(bl);
        if (bl2) {
            this.initSsc.setIntegrity();
        }
        if (n > 0) {
            this.initSsc.setMaxRetries(n);
        }
        if (l > 0L) {
            this.initSsc.setHeartbeatPeriod(l);
        }
    }

    public AuthenticationFlavor getAuthFlavor() throws AuthenticationException {
        AuthenticationFlavor authenticationFlavor = null;
        if (this.initDaf != null) {
            authenticationFlavor = this.initDaf.newCopy();
        }
        return authenticationFlavor;
    }

    public ServerSecurityContext getServerSecurityContext() throws AuthenticationException {
        ServerSecurityContext serverSecurityContext = null;
        if (this.initSsc != null) {
            serverSecurityContext = this.initSsc.newCopy();
        }
        return serverSecurityContext;
    }
}

