/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.sasl;

import com.netscape.sasl.SaslClient;
import com.netscape.sasl.SaslClientFactory;
import com.netscape.sasl.SaslException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.security.auth.callback.CallbackHandler;

public class Sasl {
    private static SaslClientFactory clientFactory = null;
    static final boolean debug = false;
    public static final String CLIENTPKGS = "javax.security.sasl.client.pkgs";

    private Sasl() {
    }

    public static SaslClient createSaslClient(String[] stringArray, String string, String string2, String string3, Hashtable hashtable, CallbackHandler callbackHandler) throws SaslException {
        SaslClient saslClient = null;
        if (clientFactory != null) {
            saslClient = clientFactory.createSaslClient(stringArray, string, string2, string3, hashtable, callbackHandler);
        }
        if (saslClient == null) {
            String string4;
            String string5 = string4 = hashtable == null ? null : (String)hashtable.get(CLIENTPKGS);
            if (string4 != null) {
                saslClient = Sasl.loadFromPkgList(string4, stringArray, string, string2, string3, hashtable, callbackHandler);
            }
            if (saslClient == null && (string4 = System.getProperty(CLIENTPKGS)) != null) {
                saslClient = Sasl.loadFromPkgList(string4, stringArray, string, string2, string3, hashtable, callbackHandler);
            }
        }
        return saslClient;
    }

    private static SaslClient loadFromPkgList(String string, String[] stringArray, String string2, String string3, String string4, Hashtable hashtable, CallbackHandler callbackHandler) throws SaslException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        SaslClient saslClient = null;
        SaslClientFactory saslClientFactory = null;
        while (saslClient == null && stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken().trim();
            String string6 = String.valueOf(string5) + ".ClientFactory";
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string6);
            }
            catch (Exception exception) {
                System.err.println("Sasl.loadFromPkgList: " + exception);
            }
            if (clazz == null) continue;
            try {
                saslClientFactory = (SaslClientFactory)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new SaslException("Cannot instantiate " + string6);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SaslException("Cannot access constructor of " + string6);
            }
            saslClient = saslClientFactory.createSaslClient(stringArray, string2, string3, string4, hashtable, callbackHandler);
        }
        return saslClient;
    }

    public static void setSaslClientFactory(SaslClientFactory saslClientFactory) {
        if (clientFactory != null) {
            throw new IllegalStateException("SaslClientFactory already defined");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        clientFactory = saslClientFactory;
    }
}

