/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.Serializable;
import java.util.Vector;
import netscape.ldap.LDAPConnThread;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPInterruptedException;
import netscape.ldap.LDAPMessage;
import netscape.ldap.LDAPResponse;

class LDAPMessageQueue
implements Serializable {
    static final long serialVersionUID = -7163312406176592277L;
    private Vector m_messageQueue = new Vector(1);
    private Vector m_requestList = new Vector(1);
    private LDAPException m_exception;
    private boolean m_asynchOp;
    private boolean m_timeConstrained;

    LDAPMessageQueue(boolean bl) {
        this.m_asynchOp = bl;
    }

    synchronized void addMessage(LDAPMessage lDAPMessage) {
        this.m_messageQueue.addElement(lDAPMessage);
        if (this.isAsynchOp() && lDAPMessage.getType() == 1 && ((LDAPResponse)lDAPMessage).getResultCode() == 0) {
            this.getConnection(lDAPMessage.getMessageID()).markConnAsBound();
        }
        this.notifyAll();
    }

    synchronized void addRequest(int n, LDAPConnection lDAPConnection, LDAPConnThread lDAPConnThread, int n2) {
        this.m_requestList.addElement(new RequestEntry(n, lDAPConnection, lDAPConnThread, n2));
        if (n2 != 0) {
            this.m_timeConstrained = true;
        }
        this.notifyAll();
    }

    synchronized LDAPResponse completeRequest() throws LDAPException {
        while (true) {
            if (this.m_requestList.size() != 0 && this.m_exception == null && this.m_messageQueue.size() == 0) {
                this.waitForMessage();
                continue;
            }
            if (this.m_exception != null) {
                LDAPException lDAPException = this.m_exception;
                this.m_exception = null;
                throw lDAPException;
            }
            if (this.m_requestList.size() == 0) {
                return null;
            }
            int n = this.m_messageQueue.size() - 1;
            while (n >= 0) {
                LDAPMessage lDAPMessage = (LDAPMessage)this.m_messageQueue.elementAt(n);
                if (lDAPMessage instanceof LDAPResponse) {
                    this.m_messageQueue.removeElementAt(n);
                    return (LDAPResponse)lDAPMessage;
                }
                --n;
            }
            this.waitForMessage();
        }
    }

    synchronized Vector getAllMessages() {
        Vector vector = this.m_messageQueue;
        this.m_messageQueue = new Vector(1);
        return vector;
    }

    synchronized LDAPConnThread getConnThread(int n) {
        int n2 = 0;
        while (n2 < this.m_requestList.size()) {
            RequestEntry requestEntry = (RequestEntry)this.m_requestList.elementAt(n2);
            if (n == requestEntry.id) {
                return requestEntry.connThread;
            }
            ++n2;
        }
        return null;
    }

    synchronized LDAPConnection getConnection(int n) {
        int n2 = 0;
        while (n2 < this.m_requestList.size()) {
            RequestEntry requestEntry = (RequestEntry)this.m_requestList.elementAt(n2);
            if (n == requestEntry.id) {
                return requestEntry.connection;
            }
            ++n2;
        }
        return null;
    }

    public int getMessageCount() {
        return this.m_messageQueue.size();
    }

    synchronized int getMessageID() {
        int n = this.m_requestList.size();
        if (n == 0) {
            return -1;
        }
        RequestEntry requestEntry = (RequestEntry)this.m_requestList.elementAt(n - 1);
        return requestEntry.id;
    }

    synchronized int[] getMessageIDs() {
        int[] nArray = new int[this.m_requestList.size()];
        int n = 0;
        while (n < nArray.length) {
            RequestEntry requestEntry = (RequestEntry)this.m_requestList.elementAt(n);
            nArray[n] = requestEntry.id;
            ++n;
        }
        return nArray;
    }

    public int getRequestCount() {
        return this.m_requestList.size();
    }

    boolean isAsynchOp() {
        return this.m_asynchOp;
    }

    boolean isMessageReceived() {
        return this.m_messageQueue.size() != 0;
    }

    void merge(LDAPMessageQueue lDAPMessageQueue) {
        Thread.yield();
        LDAPMessageQueue lDAPMessageQueue2 = this;
        synchronized (lDAPMessageQueue2) {
            LDAPMessageQueue lDAPMessageQueue3 = lDAPMessageQueue;
            synchronized (lDAPMessageQueue3) {
                int n = 0;
                while (n < lDAPMessageQueue.m_messageQueue.size()) {
                    this.m_messageQueue.addElement(lDAPMessageQueue.m_messageQueue.elementAt(n));
                    ++n;
                }
                if (lDAPMessageQueue.m_exception != null) {
                    this.m_exception = lDAPMessageQueue.m_exception;
                }
                int n2 = 0;
                while (n2 < lDAPMessageQueue.m_requestList.size()) {
                    RequestEntry requestEntry = (RequestEntry)lDAPMessageQueue.m_requestList.elementAt(n2);
                    this.m_requestList.addElement(requestEntry);
                    requestEntry.connThread.changeListener(requestEntry.id, this);
                    ++n2;
                }
                lDAPMessageQueue.reset();
                this.notifyAll();
            }
            this.notifyAll();
        }
    }

    synchronized LDAPMessage nextMessage() throws LDAPException {
        while (this.m_requestList.size() != 0 && this.m_exception == null && this.m_messageQueue.size() == 0) {
            this.waitForMessage();
        }
        if (this.m_exception != null) {
            LDAPException lDAPException = this.m_exception;
            this.m_exception = null;
            throw lDAPException;
        }
        if (this.m_requestList.size() == 0) {
            return null;
        }
        LDAPMessage lDAPMessage = (LDAPMessage)this.m_messageQueue.elementAt(0);
        this.m_messageQueue.removeElementAt(0);
        if (lDAPMessage instanceof LDAPResponse) {
            this.removeRequest(lDAPMessage.getMessageID());
        }
        return lDAPMessage;
    }

    private int removeAllMessages(int n) {
        int n2 = 0;
        int n3 = this.m_messageQueue.size() - 1;
        while (n3 >= 0) {
            LDAPMessage lDAPMessage = (LDAPMessage)this.m_messageQueue.elementAt(n3);
            if (lDAPMessage.getMessageID() == n) {
                this.m_messageQueue.removeElementAt(n3);
                ++n2;
            }
            --n3;
        }
        return n2;
    }

    synchronized int removeAllRequests(LDAPConnThread lDAPConnThread) {
        int n = 0;
        int n2 = this.m_requestList.size() - 1;
        while (n2 >= 0) {
            RequestEntry requestEntry = (RequestEntry)this.m_requestList.elementAt(n2);
            if (lDAPConnThread == requestEntry.connThread) {
                this.m_requestList.removeElementAt(n2);
                ++n;
                this.removeAllMessages(requestEntry.id);
            }
            --n2;
        }
        this.notifyAll();
        return n;
    }

    synchronized boolean removeRequest(int n) {
        int n2 = 0;
        while (n2 < this.m_requestList.size()) {
            RequestEntry requestEntry = (RequestEntry)this.m_requestList.elementAt(n2);
            if (n == requestEntry.id) {
                this.m_requestList.removeElementAt(n2);
                this.removeAllMessages(n);
                this.notifyAll();
                return true;
            }
            ++n2;
        }
        return false;
    }

    void reset() {
        this.m_exception = null;
        this.m_messageQueue.removeAllElements();
        this.m_requestList.removeAllElements();
        this.m_timeConstrained = false;
    }

    synchronized void setException(LDAPConnThread lDAPConnThread, LDAPException lDAPException) {
        this.m_exception = lDAPException;
        this.removeAllRequests(lDAPConnThread);
        this.notifyAll();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("LDAPMessageQueue:");
        stringBuffer.append(" requestIDs={");
        int n = 0;
        while (n < this.m_requestList.size()) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(((RequestEntry)this.m_requestList.elementAt((int)n)).id);
            ++n;
        }
        stringBuffer.append("} messageCount=" + this.m_messageQueue.size());
        return stringBuffer.toString();
    }

    private synchronized void waitForMessage() throws LDAPException {
        if (!this.m_timeConstrained) {
            try {
                this.wait();
                return;
            }
            catch (InterruptedException interruptedException) {
                throw new LDAPInterruptedException("Interrupted LDAP operation");
            }
        }
        long l = Long.MAX_VALUE;
        long l2 = System.currentTimeMillis();
        int n = 0;
        while (n < this.m_requestList.size()) {
            RequestEntry requestEntry = (RequestEntry)this.m_requestList.elementAt(n);
            if (requestEntry.timeToComplete <= l2) {
                requestEntry.connection.abandon(requestEntry.id);
                throw new LDAPException("Time to complete operation exceeded", 85);
            }
            if (requestEntry.timeToComplete < l) {
                l = requestEntry.timeToComplete;
            }
            ++n;
        }
        long l3 = l == Long.MAX_VALUE ? 0L : l - l2;
        try {
            this.m_timeConstrained = l3 != 0L;
            this.wait(l3);
        }
        catch (InterruptedException interruptedException) {
            throw new LDAPInterruptedException("Interrupted LDAP operation");
        }
    }

    private static class RequestEntry {
        int id;
        LDAPConnection connection;
        LDAPConnThread connThread;
        long timeToComplete;

        RequestEntry(int n, LDAPConnection lDAPConnection, LDAPConnThread lDAPConnThread, int n2) {
            this.id = n;
            this.connection = lDAPConnection;
            this.connThread = lDAPConnThread;
            this.timeToComplete = n2 == 0 ? Long.MAX_VALUE : System.currentTimeMillis() + (long)n2;
        }
    }
}

