/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.certsrv.ug;

import com.netscape.admin.certsrv.CMSAdminUtil;
import com.netscape.admin.certsrv.CMSBasePanel;
import com.netscape.admin.certsrv.CMSBaseResourceModel;
import com.netscape.admin.certsrv.EAdminException;
import com.netscape.admin.certsrv.LabelCellRenderer;
import com.netscape.admin.certsrv.connection.AdminConnection;
import com.netscape.admin.certsrv.ug.CMSBaseUGTab;
import com.netscape.admin.certsrv.ug.CertManagementDialog;
import com.netscape.admin.certsrv.ug.UserDataModel;
import com.netscape.admin.certsrv.ug.UserEditor;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.JButtonFactory;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JTable;
import com.sun.java.swing.event.ListSelectionListener;
import com.sun.java.swing.table.TableCellRenderer;
import com.sun.java.swing.table.TableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;

public class UserTab
extends CMSBaseUGTab {
    private static final String PANEL_NAME = "USERTAB";
    private AdminConnection mConnection;
    protected JScrollPane mScrollPane;
    protected JTable mTable;
    protected UserDataModel mDataModel;
    protected UserEditor mEditor;
    protected UserEditor mAddEditor;
    protected CertManagementDialog mCertEditor;
    protected JButton mRefresh;
    protected JButton mEdit;
    protected JButton mAdd;
    protected JButton mDelete;
    protected JButton mHelp;
    protected JButton mCert;
    private static final String HELPINDEX = "usersgroups-certsrv-users-help";

    public UserTab(CMSBaseResourceModel model) {
        super(PANEL_NAME, model);
        this.mConnection = model.getServerInfo().getAdmin();
        this.mDataModel = new UserDataModel();
        this.mHelpToken = HELPINDEX;
    }

    public void refresh() {
        this.mDataModel.removeAllRows();
        this.updateUser();
        this.setButtons();
        this.mTable.invalidate();
        this.mTable.validate();
        this.mScrollPane.invalidate();
        this.mScrollPane.validate();
        this.mScrollPane.repaint(1L);
    }

    public void actionPerformed(ActionEvent e) {
        String userName;
        if (e.getSource().equals(this.mRefresh)) {
            Debug.println((String)"Refresh User");
            this.refresh();
        }
        if (e.getSource().equals(this.mEdit)) {
            if (this.mTable.getSelectedRow() < 0) {
                return;
            }
            Debug.println((String)"Edit User");
            userName = (String)this.mDataModel.getObjectValueAt(this.mTable.getSelectedRow());
            if (this.mEditor == null) {
                this.mEditor = new UserEditor(this.mModel.getFrame(), this.mConnection, false);
            }
            this.mEditor.showDialog(userName);
            this.refresh();
        }
        if (e.getSource().equals(this.mAdd)) {
            Debug.println((String)"Add User");
            if (this.mAddEditor == null) {
                this.mAddEditor = new UserEditor(this.mModel.getFrame(), this.mConnection, true);
            }
            this.mAddEditor.showDialog("");
            this.refresh();
        }
        if (e.getSource().equals(this.mDelete)) {
            Debug.println((String)"Delete User");
            if (this.mTable.getSelectedRow() < 0) {
                return;
            }
            int i = this.showConfirmDialog("DELETE");
            if (i == 0) {
                this.deleteUser();
                Debug.println((String)"User Deleted");
            }
        }
        if (e.getSource().equals(this.mHelp)) {
            this.helpCallback();
        }
        if (e.getSource().equals(this.mCert)) {
            userName = (String)this.mDataModel.getObjectValueAt(this.mTable.getSelectedRow());
            if (this.mCertEditor == null) {
                this.mCertEditor = new CertManagementDialog(this.mModel.getFrame(), this.mConnection);
            }
            this.mCertEditor.showDialog(userName);
            Debug.println((String)"Cert");
        }
    }

    public void mouseClicked(MouseEvent e) {
        this.setButtons();
        if (this.mTable.getSelectedRow() >= 0 && e.getClickCount() == 2) {
            Debug.println((String)"Edit User");
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.setButtons();
    }

    protected JPanel createUserButtonPanel() {
        this.mEdit = this.makeJButton("EDIT");
        this.mAdd = this.makeJButton("ADD");
        this.mDelete = this.makeJButton("DELETE");
        this.mCert = this.makeJButton("CERT");
        JButton[] buttons = new JButton[]{this.mAdd, this.mDelete, this.mEdit, this.mCert};
        JButtonFactory.resize((JButton[])buttons);
        return CMSAdminUtil.makeJButtonVPanel((JButton[])buttons);
    }

    protected JPanel createActionPanel() {
        this.mRefresh = this.makeJButton("REFRESH");
        this.mHelp = this.makeJButton("HELP");
        JButton[] buttons = new JButton[]{this.mRefresh, this.mHelp};
        return CMSBasePanel.makeJButtonPanel((JButton[])buttons, (boolean)true);
    }

    protected JPanel createListPanel() {
        this.mListPanel = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.mListPanel.setLayout(gb);
        this.mTable = new JTable((TableModel)this.mDataModel);
        this.mScrollPane = JTable.createScrollPaneForTable((JTable)this.mTable);
        this.mScrollPane.setHorizontalScrollBarPolicy(31);
        this.mScrollPane.setVerticalScrollBarPolicy(22);
        this.mTable.setAutoscrolls(true);
        this.mTable.sizeColumnsToFit(true);
        this.mTable.getSelectionModel().setSelectionMode(0);
        this.mTable.getSelectionModel().addListSelectionListener((ListSelectionListener)this);
        this.mTable.addMouseListener((MouseListener)((Object)this));
        this.mScrollPane.setBackground(Color.white);
        this.setLabelCellRenderer(this.mTable, 0);
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        gbc.anchor = 11;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.insets = CMSBasePanel.EMPTY_INSETS;
        gbc.fill = 1;
        gb.setConstraints((Component)this.mScrollPane, gbc);
        this.mListPanel.add((Component)this.mScrollPane);
        JPanel buttonPanel = this.createUserButtonPanel();
        CMSAdminUtil.resetGBC((GridBagConstraints)gbc);
        gbc.anchor = 11;
        gbc.gridwidth = 0;
        gbc.gridheight = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.insets = CMSBasePanel.EMPTY_INSETS;
        gb.setConstraints((Component)buttonPanel, gbc);
        this.mListPanel.add((Component)buttonPanel);
        this.refresh();
        return this.mListPanel;
    }

    protected void setLabelCellRenderer(JTable table, int index) {
        table.getColumnModel().getColumn(index).setCellRenderer((TableCellRenderer)new LabelCellRenderer(new JLabel()));
    }

    private void setButtons() {
        if (this.mTable.getSelectionModel().isSelectionEmpty()) {
            this.mDelete.setEnabled(false);
            this.mEdit.setEnabled(false);
            this.mCert.setEnabled(false);
            return;
        }
        if (this.mDataModel.getRowCount() < 0) {
            this.mDelete.setEnabled(false);
            this.mEdit.setEnabled(false);
            this.mCert.setEnabled(false);
            return;
        }
        this.mDelete.setEnabled(true);
        this.mEdit.setEnabled(true);
        this.mCert.setEnabled(true);
    }

    private void updateUser() {
        NameValuePairs response;
        this.mModel.progressStart();
        try {
            response = this.mConnection.search("ug", "users", new NameValuePairs());
        }
        catch (EAdminException e) {
            this.showErrorDialog(e.getMessage());
            this.mModel.progressStop();
            return;
        }
        Debug.println((String)response.toString());
        Vector<String> store = new Vector<String>();
        Enumeration e = response.getNames();
        while (e.hasMoreElements()) {
            String entry = ((String)e.nextElement()).trim();
            store.addElement(entry);
        }
        Object[] vals = new String[store.size()];
        store.copyInto(vals);
        CMSAdminUtil.bubbleSort((String[])vals);
        int y = 0;
        while (y < vals.length) {
            String value = response.getValue((String)vals[y]);
            this.mDataModel.processData((String)vals[y], value);
            ++y;
        }
        if (this.mDataModel.getRowCount() > 0) {
            this.mTable.setRowSelectionInterval(0, 0);
        }
        this.mModel.progressStop();
    }

    private void deleteUser() {
        String userName = (String)this.mDataModel.getObjectValueAt(this.mTable.getSelectedRow());
        this.mModel.progressStart();
        try {
            this.mConnection.delete("ug", "users", userName);
        }
        catch (EAdminException e) {
            this.showErrorDialog(e.getMessage());
            this.mModel.progressStop();
            return;
        }
        this.mModel.progressStop();
        this.refresh();
    }
}

