/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.server.http.servlet;

import com.iplanet.server.http.servlet.NSServletWrapper;
import com.iplanet.server.http.servlet.WServletConfig;
import com.iplanet.server.http.servlet.WebApplication;
import com.iplanet.server.http.util.LogUtil;
import com.iplanet.server.http.util.ResUtil;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;

public class WServletEntity {
    private WebApplication app;
    private WServletConfig sc;
    private String lExceptionMsg;
    public static ResUtil _res = ResUtil.getDefaultResUtil();

    public WServletEntity(WebApplication webApplication, WServletConfig wServletConfig) {
        this.sc = wServletConfig;
        this.app = webApplication;
    }

    public void destroy() {
        this.app = null;
        this.sc = null;
    }

    String getExceptionMsg() {
        return this.lExceptionMsg;
    }

    public WServletConfig getServletConfig() {
        return this.sc;
    }

    public String getServletName() {
        return this.sc.getServletName();
    }

    public synchronized NSServletWrapper loadAndInitServlet() throws ServletException {
        Class clazz = null;
        String string = this.sc.getClassName();
        if (string == null) {
            return null;
        }
        if (!this.sc.isAvailable()) {
            this.lExceptionMsg = _res.getProp("servlet.WServletEntity.msg_servletUnavailable", (Object)this.app.getContextPath(), (Object)this.sc.getServletName());
            throw new UnavailableException(this.lExceptionMsg);
        }
        NSServletWrapper nSServletWrapper = this.app.getServletWrapper(this.sc.getServletName());
        if (nSServletWrapper != null) {
            return nSServletWrapper;
        }
        Servlet servlet = null;
        try {
            clazz = this.app.getClassLoader().loadClass(string, true);
        }
        catch (Exception exception) {
            this.lExceptionMsg = _res.getProp("servlet.WServletEntity.msg_exceptionLoadClass", (Object)this.app.getContextPath(), (Object)this.sc.getServletName(), (Object)string, (Object)LogUtil.getStackTrace((Throwable)exception));
            LogUtil.logWarning((String)this.app.getVS().getVSId(), (String)this.lExceptionMsg);
            throw new ServletException(this.lExceptionMsg, (Throwable)exception);
        }
        try {
            servlet = (Servlet)clazz.newInstance();
            LogUtil.logInfo((String)this.app.getVS().getVSId(), (String)_res.getProp("servlet.WServletEntity.msg_servletLoaded", (Object)this.sc.getServletName(), (Object)string, (Object)this.app.getContextPath()));
        }
        catch (Exception exception) {
            this.lExceptionMsg = _res.getProp("servlet.WServletEntity.msg_exceptionNewInstance", (Object)this.app.getContextPath(), (Object)this.sc.getServletName(), (Object)string, (Object)LogUtil.getStackTrace((Throwable)exception));
            LogUtil.logWarning((String)this.app.getVS().getVSId(), (String)this.lExceptionMsg);
            clazz = null;
            this.app.getClassLoader().invalidate(string);
            throw new ServletException(this.lExceptionMsg, (Throwable)exception);
        }
        if (servlet != null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                try {
                    Thread.currentThread().setContextClassLoader(servlet.getClass().getClassLoader());
                    servlet.init((ServletConfig)this.sc);
                }
                catch (ServletException servletException) {
                    this.lExceptionMsg = _res.getProp("servlet.WServletEntity.msg_servletExceptionInitFunc", (Object)this.app.getContextPath(), (Object)this.sc.getServletName(), (Object)LogUtil.getStackTrace((Throwable)servletException), (Object)LogUtil.getStackTrace((Throwable)servletException.getRootCause()));
                    LogUtil.logWarning((String)this.app.getVS().getVSId(), (String)this.lExceptionMsg);
                    throw servletException;
                }
                catch (Exception exception) {
                    this.lExceptionMsg = _res.getProp("servlet.WServletEntity.msg_exceptionInitFunc", (Object)this.app.getContextPath(), (Object)this.sc.getServletName(), (Object)string, (Object)LogUtil.getStackTrace((Throwable)exception));
                    LogUtil.logWarning((String)this.app.getVS().getVSId(), (String)this.lExceptionMsg);
                    clazz = null;
                    servlet = null;
                    this.app.getClassLoader().invalidate(string);
                    throw new ServletException(this.lExceptionMsg, (Throwable)exception);
                }
                Object var7_10 = null;
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                Thread.currentThread().setContextClassLoader(classLoader);
                throw throwable;
            }
        }
        nSServletWrapper = this.app.addServletWrapper(this.sc.getServletName(), new NSServletWrapper(this.app, servlet, this.sc.getServletName()));
        nSServletWrapper.setServletConfig(this.sc);
        return nSServletWrapper;
    }
}

