/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.server.http.session;

import com.iplanet.server.http.session.IWSHttpSession;
import com.iplanet.server.http.session.IWSHttpSessionInputStream;
import com.iplanet.server.http.session.IWSHttpSessionManager;
import com.iplanet.server.http.session.SessionDataStore;
import com.iplanet.server.http.util.FileFilterImpl;
import com.iplanet.server.http.util.LogUtil;
import com.iplanet.server.http.util.ResUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Properties;
import javax.servlet.ServletContext;

class FileStore
extends SessionDataStore {
    private static final String _ext = ".iws";
    private static final String _timeoutSuffix = "-timeout";
    private String _dir = null;
    private FileFilterImpl _timeoutFilesFilter;
    private static ResUtil _res = ResUtil.getDefaultResUtil();

    public FileStore() {
        this._timeoutFilesFilter = new FileFilterImpl(null, _timeoutSuffix, _ext);
    }

    public FileStore(IWSHttpSessionManager iWSHttpSessionManager) {
        super(iWSHttpSessionManager);
    }

    private String getExistingSessionFile(String string) {
        File file;
        String string2 = this.getSessionFilename(string);
        if (string2 != null && !(file = new File(string2)).isFile()) {
            string2 = null;
        }
        return string2;
    }

    private String getSessionFilename(String string) {
        StringBuffer stringBuffer = new StringBuffer(this._dir);
        stringBuffer.append(string).append(_ext);
        return stringBuffer.toString();
    }

    private String getSessionId(String string) {
        int n = string.indexOf(_timeoutSuffix);
        if (n != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    private String getSessionTimeoutFilename(String string) {
        StringBuffer stringBuffer = new StringBuffer(this._dir);
        stringBuffer.append(string).append(_timeoutSuffix).append(_ext);
        return stringBuffer.toString();
    }

    private int getTimeout(String string) {
        int n = 0;
        if (string != null) {
            ObjectInputStream objectInputStream = null;
            try {
                try {
                    objectInputStream = new ObjectInputStream(new FileInputStream(string));
                    n = objectInputStream.readInt();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (LogUtil.enableTrace) {
                        LogUtil.TRACE((int)7, (String)_res.getProp("session.FileStore.msg_FileNotFound", (Object)string));
                    }
                }
                catch (SecurityException securityException) {
                    LogUtil.logInfo((String)_res.getProp("session.FileStore.msg_AccessError", (Object)string, (Object)LogUtil.getStackTrace((Throwable)securityException)));
                }
                catch (Exception exception) {
                    LogUtil.logInfo((String)LogUtil.getStackTrace((Throwable)exception));
                }
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    if (objectInputStream != null) {
                        objectInputStream.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return n;
    }

    public boolean init(Properties properties) {
        boolean bl = false;
        this._dir = properties.getProperty("session-data-dir");
        if (this._dir != null) {
            bl = true;
            File file = new File(this._dir);
            if (!file.isDirectory() && !file.mkdirs()) {
                LogUtil.logInfo((String)_res.getProp("session.FileStore.msg_MkdirError", (Object)this._dir));
                bl = false;
            }
            if (!(!bl || file.canWrite() && file.canRead())) {
                LogUtil.logInfo((String)_res.getProp("session.FileStore.msg_DirPermsError", (Object)this._dir));
                bl = false;
            }
            if (!bl) {
                this._dir = null;
            } else {
                if (!this._dir.endsWith(File.separator)) {
                    this._dir = this._dir.concat(File.separator);
                }
                if (LogUtil.enableTrace) {
                    LogUtil.TRACE((int)7, (String)("FileStore: dir=" + this._dir));
                }
            }
        } else {
            LogUtil.logWarning((String)_res.getProp("session.FileStore.msg_DirError"));
        }
        return bl;
    }

    public IWSHttpSession load(IWSHttpSession iWSHttpSession) {
        IWSHttpSession iWSHttpSession2 = null;
        String string = iWSHttpSession.getMangledId();
        String string2 = this.getExistingSessionFile(string);
        if (string2 != null) {
            ServletContext servletContext = iWSHttpSession.getServletContext();
            if (LogUtil.enableTrace) {
                LogUtil.TRACE((int)7, (String)("FileStore: loading from " + string2));
            }
            iWSHttpSession2 = this.loadFromFile(string2, servletContext);
        }
        return iWSHttpSession2;
    }

    private IWSHttpSession loadFromFile(String string, ServletContext servletContext) {
        IWSHttpSession iWSHttpSession = null;
        ObjectInputStream objectInputStream = null;
        try {
            try {
                if (servletContext != null) {
                    ClassLoader classLoader = (ClassLoader)servletContext.getAttribute("com.iplanet.server.http.servlet.classloader");
                    objectInputStream = new IWSHttpSessionInputStream(new BufferedInputStream(new FileInputStream(string)), classLoader);
                } else {
                    objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(string)));
                }
                iWSHttpSession = (IWSHttpSession)objectInputStream.readObject();
                if (LogUtil.enableTrace) {
                    LogUtil.TRACE((int)7, (String)("FileStore: loaded from " + string));
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (LogUtil.enableTrace) {
                    LogUtil.TRACE((int)7, (String)_res.getProp("session.FileStore.msg_FileNotFound", (Object)string));
                }
            }
            catch (SecurityException securityException) {
                LogUtil.logInfo((String)_res.getProp("session.FileStore.msg_AccessError", (Object)string, (Object)LogUtil.getStackTrace((Throwable)securityException)));
            }
            catch (Exception exception) {
                LogUtil.logInfo((String)LogUtil.getStackTrace((Throwable)exception));
            }
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (objectInputStream != null) {
                objectInputStream.close();
            }
        }
        catch (IOException iOException) {}
        return iWSHttpSession;
    }

    public void reap(long l) {
        if (this._dir == null) {
            return;
        }
        File file = new File(this._dir);
        File[] fileArray = file.listFiles((FileFilter)this._timeoutFilesFilter);
        int n = 0;
        while (n < fileArray.length) {
            String string = this.getSessionId(fileArray[n].getName());
            this._sessionMgr.lock(string);
            long l2 = l - fileArray[n].lastModified();
            long l3 = this.getTimeout(fileArray[n].getAbsolutePath()) * 1000;
            if (l2 > l3 && l3 != Integer.MAX_VALUE) {
                if (LogUtil.enableTrace) {
                    LogUtil.TRACE((int)7, (String)("FileStore: reaped " + string));
                }
                this.removeFiles(string);
                this._sessionMgr.unlock(string);
                this._sessionMgr.reaped(string);
            } else {
                this._sessionMgr.unlock(string);
            }
            ++n;
        }
    }

    public boolean remove(IWSHttpSession iWSHttpSession) {
        if (iWSHttpSession == null) {
            return false;
        }
        String string = iWSHttpSession.getMangledId();
        if (string == null || this._dir == null) {
            return false;
        }
        return this.removeFiles(string);
    }

    private boolean removeFiles(String string) {
        File file;
        boolean bl = false;
        String string2 = this.getSessionFilename(string);
        if (string2 != null) {
            file = new File(string2);
            if (file.isFile()) {
                bl = file.delete();
                if (LogUtil.enableTrace) {
                    LogUtil.TRACE((int)7, (String)("FileStore: deleted " + file.getAbsolutePath()));
                }
            } else {
                LogUtil.logInfo((String)_res.getProp("session.FileStore.msg_FileNotFound", (Object)file.getAbsolutePath()));
            }
        }
        if ((string2 = this.getSessionTimeoutFilename(string)) != null) {
            file = new File(string2);
            if (file.isFile()) {
                bl = file.delete();
                if (LogUtil.enableTrace) {
                    LogUtil.TRACE((int)7, (String)("FileStore: deleted " + file.getAbsolutePath()));
                }
            } else {
                LogUtil.logInfo((String)_res.getProp("session.FileStore.msg_FileNotFound", (Object)file.getAbsolutePath()));
            }
        }
        return bl;
    }

    public boolean save(IWSHttpSession iWSHttpSession) {
        if (iWSHttpSession == null) {
            return false;
        }
        if (this._dir == null) {
            return false;
        }
        String string = iWSHttpSession.getMangledId();
        String string2 = this.getSessionFilename(string);
        String string3 = this.getSessionTimeoutFilename(string);
        if (string2 == null) {
            return false;
        }
        ObjectOutputStream objectOutputStream = null;
        ObjectOutputStream objectOutputStream2 = null;
        boolean bl = false;
        try {
            try {
                objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(string2)));
                objectOutputStream.writeObject(iWSHttpSession);
                objectOutputStream2 = new ObjectOutputStream(new FileOutputStream(string3));
                objectOutputStream2.writeInt(iWSHttpSession.getTimeout());
                bl = true;
                if (LogUtil.enableTrace) {
                    LogUtil.TRACE((int)7, (String)("FileStore: saved to " + string2));
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                LogUtil.logInfo((String)_res.getProp("session.FileStore.msg_FileNotFound", (Object)string2));
            }
            catch (SecurityException securityException) {
                LogUtil.logInfo((String)_res.getProp("session.FileStore.msg_AccessError", (Object)string2, (Object)LogUtil.getStackTrace((Throwable)securityException)));
            }
            catch (Exception exception) {
                LogUtil.logInfo((String)LogUtil.getStackTrace((Throwable)exception));
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            try {
                if (objectOutputStream2 != null) {
                    objectOutputStream2.close();
                }
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (objectOutputStream2 != null) {
                objectOutputStream2.close();
            }
            if (objectOutputStream != null) {
                objectOutputStream.close();
            }
        }
        catch (IOException iOException) {}
        return bl;
    }
}

