/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.server.http.session;

import com.iplanet.server.http.util.LogUtil;
import com.iplanet.server.http.util.ResUtil;
import com.netscape.server.http.session.NSHttpSessionContext;
import com.netscape.server.http.session.NSHttpSessionManager;
import com.netscape.server.http.session.SimpleSession;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.http.HttpSession;

public class SimpleSessionManager
extends NSHttpSessionManager {
    private static NSHttpSessionContext _ctx = new NSHttpSessionContext();
    private Hashtable _sessions = null;
    private int _maxSessions = 1000;
    private int _reapCount = 0;
    private int _timeOut = 1800;
    private static ResUtil _res = ResUtil.getDefaultResUtil();
    private static final String prop_timeOut = "timeOut";
    private static final String prop_maxSessions = "maxSessions";

    public HttpSession createSession(String string) {
        SimpleSession simpleSession = new SimpleSession(string, this._timeOut, this, _res);
        simpleSession.setNew();
        if (this._sessions.size() < this._maxSessions) {
            this._sessions.put(string, simpleSession);
        } else {
            LogUtil.logWarning((String)_res.getProp("session.SimpleSessionManager.msg_limitReached", this._maxSessions));
            simpleSession = null;
        }
        return simpleSession;
    }

    public void deleteSession(HttpSession httpSession) {
        if (httpSession == null) {
            return;
        }
        if (httpSession instanceof SimpleSession) {
            ((SimpleSession)httpSession).removeAllObjects();
            this._sessions.remove(((SimpleSession)httpSession).getIdWithoutExceptions());
        } else {
            LogUtil.logWarning((String)_res.getProp("session.SimpleSessionManager.msg_sessionType"));
        }
    }

    public String generateSID() {
        return super.generateSID();
    }

    public NSHttpSessionContext getContext() {
        return _ctx;
    }

    public int getDefaultTimeOut() {
        return this._timeOut;
    }

    public int getMaxSession() {
        return this._maxSessions;
    }

    public HttpSession getSession(String string) {
        if (string == null) {
            return null;
        }
        SimpleSession simpleSession = (SimpleSession)this._sessions.get(string);
        if (simpleSession == null) {
            return null;
        }
        try {
            simpleSession.getSessionContext();
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
        simpleSession.unsetNew();
        return simpleSession;
    }

    public int getSessionCount() {
        return this._sessions.size();
    }

    public int getSessionReapCount() {
        return this._reapCount;
    }

    protected boolean hasPersistence() {
        return false;
    }

    public void init(Properties properties) {
        String string = null;
        if (properties != null) {
            string = properties.getProperty(prop_maxSessions);
            if (string != null) {
                try {
                    this._maxSessions = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    LogUtil.logWarning((String)_res.getProp("session.SimpleSessionManager.msg_maxSessionsNotValid", (Object)string));
                }
            }
            if ((string = properties.getProperty(prop_timeOut)) != null) {
                try {
                    this._timeOut = Integer.parseInt(string);
                    if (this._timeOut < 0) {
                        this._timeOut = -1;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    LogUtil.logWarning((String)_res.getProp("session.SimpleSessionManager.msg_timeoutNotValid", (Object)string));
                }
            }
        }
        this._sessions = new Hashtable(this._maxSessions);
        LogUtil.logInfo((String)_res.getProp("session.SimpleSessionManager.msg_simpleSessionManagerInit", (Object)new Integer(this._maxSessions), (Object)new Integer(this._timeOut)));
    }

    /*
     * Unable to fully structure code
     */
    public void reaper() {
        var1_1 = this._sessions.elements();
        if (var1_1 != null) ** GOTO lbl12
        return;
lbl-1000:
        // 1 sources

        {
            var2_2 = (HttpSession)var1_1.nextElement();
            try {
                var2_2.getSessionContext();
                continue;
            }
            catch (IllegalStateException v0) {
                this.deleteSession(var2_2);
                ++this._reapCount;
            }
lbl12:
            // 3 sources

            ** while (var1_1.hasMoreElements())
        }
lbl13:
        // 1 sources

    }

    public void update(HttpSession httpSession) {
    }
}

