/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client.users;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.CheckSyntax;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ContextHelpListener;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.FlowArea;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.JIntSpinBox;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.usermgr.client.UMgrContextHelpListener;
import com.sun.admin.usermgr.client.VUserMgr;
import com.sun.admin.usermgr.client.users.AdminMultiUserWiz;
import com.sun.management.viper.console.gui.wizard.VWizardCard;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.FocusListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AdminMultiUserUIDStep
extends VWizardCard {
    VUserMgr theApp;
    ResourceBundle bundle;
    private AdminMultiUserWiz wiz;
    private String uid = null;
    private JIntSpinBox uidSBox;
    private ActionString actionString;
    private static final int MIN_UID = 100;
    private static final int MAX_UID = Integer.MAX_VALUE;
    private GenInfoPanel infoPanel;
    private UMgrContextHelpListener overviewHelpListener;
    public static final int HELP_CACHE_SIZE = 2;

    public AdminMultiUserUIDStep(VUserMgr vUserMgr, AdminMultiUserWiz adminMultiUserWiz) {
        this.theApp = vUserMgr;
        this.bundle = vUserMgr.getResourceBundle();
        this.wiz = adminMultiUserWiz;
        super.setTitle(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"mu_wiz_uid_step"));
        this.constructStep();
    }

    public void constructStep() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        FlowArea flowArea = new FlowArea(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"mu_wiz_uid_explain"));
        Constraints.constrain((Container)((Object)this), (Component)flowArea, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)5, (int)5, (int)5, (int)5);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        Constraints.constrain((Container)((Object)this), (Component)jPanel, (int)0, (int)1, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)25, (int)20, (int)0, (int)5);
        this.actionString = new ActionString(this.bundle, "mu_wiz_uid_lbl");
        JLabel jLabel = new JLabel(this.actionString.getString());
        jLabel.setDisplayedMnemonic(this.actionString.getMnemonic());
        Constraints.constrain((Container)jPanel, (Component)jLabel, (int)0, (int)0, (int)1, (int)1, (int)1, (int)17, (double)0.0, (double)0.0, (int)0, (int)10, (int)0, (int)0);
        this.uidSBox = new JIntSpinBox(10, 100, Integer.MAX_VALUE);
        this.uidSBox.getTextField().setHorizontalAlignment(4);
        jLabel.setLabelFor(this.uidSBox.getTextField());
        this.uidSBox.setMinimumSize(this.uidSBox.getPreferredSize());
        Constraints.constrain((Container)jPanel, (Component)this.uidSBox, (int)1, (int)0, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)0, (int)5, (int)0, (int)0);
        JPanel jPanel2 = new JPanel();
        Constraints.constrain((Container)((Object)this), (Component)jPanel2, (int)0, (int)2, (int)1, (int)1, (int)1, (int)17, (double)1.0, (double)1.0, (int)0, (int)0, (int)0, (int)0);
    }

    public void loadHelp() {
        Vector vector = new Vector(2);
        this.infoPanel = this.wiz.getInfoPanel();
        UMgrContextHelpListener uMgrContextHelpListener = new UMgrContextHelpListener(this.theApp, vector, this.infoPanel, "uadd_multitemp_start_uid");
        this.uidSBox.getTextField().addFocusListener((FocusListener)((Object)uMgrContextHelpListener));
        this.uidSBox.getDownButton().addFocusListener((FocusListener)((Object)uMgrContextHelpListener));
        this.uidSBox.getUpButton().addFocusListener((FocusListener)((Object)uMgrContextHelpListener));
        this.overviewHelpListener = new UMgrContextHelpListener(this.theApp, vector, this.infoPanel, "uadd_multi_wiz_uid_step");
        ContextHelpListener.loadHelp(vector);
    }

    public void start() {
        super.start();
        if (this.uid == null) {
            try {
                this.uid = this.theApp.getUserMgr().getNextAvailableUID();
            }
            catch (Exception exception) {
                new ErrorDialog(null, ResourceStrings.getString((ResourceBundle)this.bundle, (String)"mu_wiz_bad_uid"));
                this.uid = String.valueOf(100);
            }
            this.uidSBox.getTextField().setText(this.uid);
        }
        this.setProperty("vwp.canmoveforward", "vwp.true");
        this.setProperty("vwp.canmovebackward", "vwp.true");
        this.setProperty("vwp.finishstate", "vwp.false");
        this.infoPanel.setFocusListener((FocusListener)((Object)this.overviewHelpListener), false);
    }

    public boolean stop(boolean bl) {
        if (!bl) {
            return true;
        }
        this.uid = this.uidSBox.getStringValue();
        if (!this.isUIDRangeOK()) {
            new ErrorDialog(null, ResourceStrings.getString((ResourceBundle)this.bundle, (String)"mu_wiz_bad_uid_range"));
            return false;
        }
        this.wiz.setUID(this.uid);
        this.wiz.getManager().setNext(this.getManager().getCurrent(), "groupCard");
        return true;
    }

    public boolean isSubStep() {
        return false;
    }

    public void reset() {
    }

    private boolean isUIDRangeOK() {
        long l = new Long(this.uid);
        if (l < 100L) {
            return false;
        }
        int n = this.wiz.getNumUsers();
        long l2 = l;
        int n2 = 0;
        while (n2 < n) {
            if (CheckSyntax.isUIDOK((String)String.valueOf(l2))) {
                ++n2;
                ++l2;
                continue;
            }
            if (CheckSyntax.getErrorString().equals(ResourceStrings.getString((String)"cs_uid_high"))) {
                return false;
            }
            ++l2;
        }
        return true;
    }
}

