/*
 * Decompiled with CFR 0.152.
 */
package crysec.ASN1;

import crysec.ASN1.ASN1Utils;
import crysec.Streamable;
import crysec.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ASN1Header
implements Streamable {
    public static final int UNIVERSAL = 0;
    public static final int APPLICATION = 1;
    public static final int CONTEXT_SPECIFIC = 2;
    public static final int PRIVATE = 3;
    public int tagClass;
    public static final int INTEGER = 2;
    public static final int BIT_STRING = 3;
    public static final int OCTET_STRING = 4;
    public static final int NULL = 5;
    public static final int OBJECT_IDENTIFIER = 6;
    public static final int SEQUENCE = 16;
    public static final int SET = 17;
    public static final int PRINTABLE_STRING = 19;
    public static final int T61STRING = 20;
    public static final int IA5STRING = 22;
    public static final int UTCTIME = 23;
    public int tag;
    public static final int PRIMITIVE = 0;
    public static final int CONSTRUCTED_DEFINITE = 1;
    public static final int CONSTRUCTED_INDEFINITE = 2;
    public int method;
    public int bodyLength;

    public ASN1Header() {
    }

    public ASN1Header(int t, int c) {
        this(t, c, 2, 0);
    }

    public ASN1Header(int t, int c, int m, int l) {
        this.tag = t;
        this.tagClass = c;
        this.method = m;
        this.bodyLength = l;
    }

    void outputTag(OutputStream os) throws IOException {
        int t = this.tag < 31 ? this.tag : 31;
        int tagOctet = this.tagClass << 6 | t;
        if (this.method != 0) {
            tagOctet |= 0x20;
        }
        os.write(tagOctet);
        if (this.tag >= 31) {
            ASN1Utils.outputBase128(this.tag, os);
        }
    }

    void outputLength(OutputStream os) throws IOException {
        if (this.method == 2) {
            os.write(128);
        } else if (this.bodyLength < 128) {
            os.write(this.bodyLength);
        } else {
            int l = this.bodyLength >= 0x1000000 ? 4 : (this.bodyLength >= 65536 ? 3 : (this.bodyLength >= 256 ? 2 : 1));
            os.write(0x80 | l);
            --l;
            while (l >= 0) {
                os.write(this.bodyLength >> 8 * l & 0xFF);
                --l;
            }
        }
    }

    public void output(OutputStream os) throws IOException {
        this.outputTag(os);
        this.outputLength(os);
    }

    public void input(InputStream is) throws IOException {
        this.inputTag(is);
        this.inputLength(is);
    }

    void inputTag(InputStream is) throws IOException {
        int tagOctet = Utils.inputByte(is) & 0xFF;
        this.tagClass = tagOctet >> 6;
        this.method = (tagOctet & 0x20) == 0 ? 0 : 1;
        this.tag = tagOctet & 0x1F;
        if (this.tag == 31) {
            this.tag = ASN1Utils.inputBase128(is);
        }
    }

    void inputLength(InputStream is) throws IOException {
        int octet = Utils.inputByte(is) & 0xFF;
        if (octet < 128) {
            this.bodyLength = octet;
        } else if (octet == 128) {
            this.method = 2;
            this.bodyLength = 0;
        } else {
            int l = octet & 0x7F;
            if (l > 4) {
                throw new IOException("Length is too big: takes " + l + " bytes");
            }
            this.bodyLength = 0;
            int i = 0;
            while (i < l) {
                this.bodyLength <<= 8;
                this.bodyLength |= Utils.inputByte(is) & 0xFF;
                ++i;
            }
        }
    }

    public int length() {
        return this.tagLength() + this.bodyLengthLength();
    }

    int tagLength() {
        return 1 + (this.tag < 31 ? 0 : ASN1Utils.lengthBase128(this.tag));
    }

    int bodyLengthLength() {
        return 1 + (this.bodyLength < 128 ? 0 : ASN1Utils.lengthBase256(this.bodyLength));
    }

    public int totalLength() {
        return this.length() + this.bodyLength;
    }

    public String toString() {
        String[] tcStrs = new String[]{"universal", "application", "context-specific", "private"};
        String[] tagStrs = new String[]{"", "", "INTEGER", "BIT STRING", "OCTET STRING", "NULL", "OBJECT IDENTIFIER", "", "", "", "", "", "", "", "", "", "SEQUENCE", "SET", "", "PrintableString", "T61String", "", "IA5String", "UTCTime"};
        String[] methodStrs = new String[]{"primitive", "constructed", "constructed"};
        return String.valueOf(tcStrs[this.tagClass]) + " " + (this.tagClass == 0 ? tagStrs[this.tag] : Integer.toString(this.tag)) + " " + methodStrs[this.method] + " length=" + (this.method == 2 ? "unknown" : Integer.toString(this.bodyLength));
    }

    public void skipBody(InputStream is) throws IOException {
        if (this.method != 2) {
            int i = 0;
            while (i < this.bodyLength) {
                Utils.inputByte(is);
                ++i;
            }
        } else {
            while (true) {
                ASN1Header h = new ASN1Header();
                h.input(is);
                if (h.tagClass == 0 && h.tag == 0 && h.bodyLength == 0) break;
                h.skipBody(is);
            }
        }
    }

    public byte[] readBody(InputStream is) throws IOException {
        if (this.method != 2) {
            byte[] buf = new byte[this.bodyLength];
            int i = 0;
            while (i < buf.length) {
                buf[i] = Utils.inputByte(is);
                ++i;
            }
            return buf;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        while (true) {
            ASN1Header h = new ASN1Header();
            h.input(is);
            h.output(os);
            if (h.tagClass == 0 && h.tag == 0 && h.bodyLength == 0) break;
            os.write(h.readBody(is));
        }
        return os.toByteArray();
    }
}

