/*
 * Decompiled with CFR 0.152.
 */
package crysec;

import crysec.Entity;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.PublicKey;

public abstract class Certificate {
    protected Entity holder;
    protected boolean validated;
    protected PublicKey key;

    public Certificate(InputStream is) throws Exception {
        this.initialize(is);
    }

    public Certificate(File file) throws Exception {
        this.initialize(file);
    }

    public Certificate(URL url) throws Exception {
        this.initialize(url);
    }

    public abstract void initialize(InputStream var1) throws Exception;

    public void initialize(File file) throws Exception {
        try {
            this.initialize(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new Exception(e.toString());
        }
    }

    public void initialize(URL url) throws Exception {
        try {
            this.initialize(url.openStream());
        }
        catch (IOException e) {
            throw new Exception(e.toString());
        }
        catch (Exception e) {
            throw e;
        }
    }

    public abstract void save(OutputStream var1);

    public abstract boolean verify() throws Exception;

    public boolean valid() {
        return this.validated;
    }

    public PublicKey getKey() {
        return this.key;
    }

    public Entity getHolder() {
        return this.holder;
    }
}

