/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.patchmgr.client;

import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.patchmgr.client.Content;
import com.sun.admin.patchmgr.client.ContentEvent;
import com.sun.admin.patchmgr.client.ContentListener;
import com.sun.admin.patchmgr.client.NavigationSelectionListener;
import com.sun.admin.patchmgr.client.PatchActionsListener;
import com.sun.admin.patchmgr.client.TreeNodeData;
import com.sun.admin.patchmgr.client.VPatchMgr;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VScopeNode;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;

public class MainToolBar
extends JToolBar {
    private ContentListener contentListener;
    private Content content;
    private VPatchMgr theApp;
    private ResourceBundle bundle;
    private ToolBarButton addPatchBtn;
    private ToolBarButton addMultiMPatchBtn;
    private boolean delete_allowed = true;
    PatchActionsListener buttonClickListener;
    GridBagConstraints gbc = new GridBagConstraints();

    public MainToolBar(VPatchMgr vPatchMgr) {
        this.theApp = vPatchMgr;
        this.buttonClickListener = new PatchActionsListener(vPatchMgr);
        this.setLayout(new GridBagLayout());
        this.addPatchBtn = new ToolBarButton("tbar_addpatch", "add_patch", "AddPatch");
        Constraints.constrain((Container)this, (Component)this.addPatchBtn, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)1.0, (int)0, (int)0, (int)0, (int)0);
        this.addMultiMPatchBtn = new ToolBarButton("tbar_addmmpatch", "add_multi_machine", "MultiMachineAdd");
        Constraints.constrain((Container)this, (Component)this.addMultiMPatchBtn, (int)1, (int)0, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)1.0, (int)0, (int)2, (int)0, (int)0);
        this.contentListener = new ContentListener(){

            public void itemPressed(ContentEvent contentEvent) {
                Content content = contentEvent.getSource();
                MainToolBar.this.notifySelectionChange(content.getNumSelections());
            }
        };
        vPatchMgr.addNavigationSelectionListener(new NavigationSelectionListener(){

            public void valueChanged(VScopeNode vScopeNode) {
                if (MainToolBar.this.content != null) {
                    MainToolBar.this.content.removeContentListener(MainToolBar.this.contentListener);
                }
                TreeNodeData treeNodeData = (TreeNodeData)vScopeNode.getPayload();
                MainToolBar.this.content = treeNodeData.getContent();
                MainToolBar.this.content.addContentListener(MainToolBar.this.contentListener);
                MainToolBar.this.notifySelectionChange(MainToolBar.this.content.getNumSelections());
            }
        });
    }

    private void notifySelectionChange(int n) {
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        if (n == 1) {
            vConsoleProperties.setProperty("vconsole.propertiesenabled", "true");
        } else {
            vConsoleProperties.setProperty("vconsole.propertiesenabled", "false");
        }
        boolean bl = true;
        if (n == 0 || !this.delete_allowed) {
            bl = false;
        }
        if (this.theApp.getpatchM().hasPatchWriteAuthorization()) {
            vConsoleProperties.setProperty("vconsole.deleteenabled", bl ? "true" : "false");
        } else {
            vConsoleProperties.setProperty("vconsole.deleteenabled", "false");
            this.addPatchBtn.setEnabled(false);
            this.addMultiMPatchBtn.setEnabled(false);
        }
    }

    void disableDelete() {
        this.delete_allowed = false;
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        vConsoleProperties.setProperty("vconsole.deleteenabled", "false");
    }

    void enableDelete() {
        this.delete_allowed = true;
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        vConsoleProperties.setProperty("vconsole.deleteenabled", "true");
    }

    class ToolBarButton
    extends JButton
    implements PropertyChangeListener {
        private ImageIcon enabledIcon;
        private String text;

        public ToolBarButton(String string, String string2, String string3) {
            MainToolBar.this.bundle = MainToolBar.this.theApp.getResourceBundle();
            this.enabledIcon = MainToolBar.this.theApp.loadImageIcon(string2 + ".gif");
            this.text = ResourceStrings.getString((ResourceBundle)MainToolBar.this.bundle, (String)string);
            if (this.enabledIcon != null && this.enabledIcon.getIconHeight() != -1) {
                this.setIcon(this.enabledIcon);
            } else {
                this.setText(this.text);
            }
            this.setBorderPainted(true);
            this.setFocusPainted(false);
            this.setActionCommand(string3);
            this.setToolTipText(ResourceStrings.getString((ResourceBundle)MainToolBar.this.bundle, (String)(string + "Tooltip")));
            this.setMargin(new Insets(0, 0, 0, 0));
            this.addActionListener(MainToolBar.this.buttonClickListener);
            MainToolBar.this.theApp.addPropertyChangeListener(this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("vconsole.buttondisplay")) {
                VConsoleProperties vConsoleProperties = MainToolBar.this.theApp.getProperties();
                String string2 = vConsoleProperties.getProperty("vconsole.buttondisplay");
                if (string2.equals("vconsole.textonly")) {
                    this.setIcon(null);
                    this.setText(this.text);
                    this.setMargin(new Insets(0, 0, 0, 0));
                } else if (string2.equals("vconsole.icononly")) {
                    this.setIcon(this.enabledIcon);
                    this.setText("");
                    this.setMargin(null);
                } else if (string2.equals("vconsole.textandicon")) {
                    this.setIcon(this.enabledIcon);
                    this.setText(this.text);
                    this.setMargin(new Insets(0, 0, 0, 0));
                }
            }
        }
    }
}

