/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.util.security;

import com.sun.management.viperimpl.util.ImplResourceManager;
import com.sun.management.viperimpl.util.security.DefaultActionListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class DialogFactory {
    public static final int ERROR_MESSAGE = 1;
    public static final int INFORMATION_MESSAGE = 2;
    public static final int WARNING_MESSAGE = 3;
    public static final int QUESTION_MESSAGE = 4;
    public static final int PLAIN_MESSAGE = 5;
    private static String confirmDialogTitle = ImplResourceManager.getString("usability.confirmDialogTitle");
    private static String inputDialogTitle = ImplResourceManager.getString("usability.inputDialogTitle");
    private static String messageDialogTitle = ImplResourceManager.getString("usability.messageDialogTitle");
    private static String exceptionDialogTitle = ImplResourceManager.getString("usability.exceptionDialogTitle");
    private static String optionDialogTitle = ImplResourceManager.getString("usability.optionDialogTitle");
    private static String aboutDialogTitle = ImplResourceManager.getString("usability.aboutDialogTitle");
    private static String javaHomeLink = ImplResourceManager.getString("usability.java.home.link");

    public static Icon loadIcon() {
        Icon icon = null;
        try {
            icon = (Icon)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    URL uRL = ClassLoader.getSystemResource("com/sun/management/viperimpl/util/security/logo.png");
                    ImageIcon imageIcon = new ImageIcon(uRL);
                    return imageIcon;
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return icon;
    }

    public static void showAboutPluginDialog() {
        AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                Object var1_1 = null;
                try {
                    JOptionPane jOptionPane = new JOptionPane();
                    jOptionPane.setMessageType(-1);
                    JButton jButton = new JButton(ImplResourceManager.getString("about.option.close"));
                    jButton.setMnemonic(67);
                    jOptionPane.setOptions(new Object[]{jButton});
                    jOptionPane.setWantsInput(false);
                    jOptionPane.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
                    jOptionPane.setInitialValue(jButton);
                    jOptionPane.updateUI();
                    DialogFactory.showDialog(jOptionPane, null, aboutDialogTitle, DialogFactory.createInfoPane(), false);
                    Object var4_4 = null;
                    Object var6_5 = null;
                    return var4_4;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    throw throwable;
                }
            }
        });
    }

    private static void launchLink(String string) {
    }

    private static JPanel createInfoPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setForeground(Color.WHITE);
        jPanel.setBackground(Color.WHITE);
        jPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        try {
            URL uRL = ClassLoader.getSystemResource("com/sun/management/viperimpl/util/security/aboutjava.png");
            ImageIcon imageIcon = new ImageIcon(uRL);
            JLabel jLabel = new JLabel(imageIcon);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.setForeground(Color.WHITE);
            jPanel2.setBackground(Color.WHITE);
            jPanel2.add((Component)jLabel, "Center");
            jPanel2.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            jPanel.add("North", jPanel2);
            int n = imageIcon.getIconWidth() - 8;
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 1));
            jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 8, 4, 8));
            jPanel3.setForeground(Color.WHITE);
            jPanel3.setBackground(Color.WHITE);
            String string = MessageFormat.format(ImplResourceManager.getString("about.java.version"), System.getProperty("java.version"), System.getProperty("java.runtime.version")) + '\n' + ImplResourceManager.getString("about.legal.note");
            JTextArea jTextArea = new JTextArea();
            jTextArea.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
            jTextArea.setEditable(false);
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setText(string);
            Font font = jTextArea.getFont();
            FontMetrics fontMetrics = jTextArea.getFontMetrics(font);
            int n2 = fontMetrics.stringWidth(ImplResourceManager.getString("about.legal.note"));
            int n3 = n2 / (n - 8) + 2;
            jTextArea.setRows(n3);
            jPanel3.add(jTextArea);
            jPanel3.add(Box.createVerticalStrut(30));
            String string2 = ImplResourceManager.getString("about.prompt.info");
            String string3 = ImplResourceManager.getString("about.home.link");
            final String string4 = "<font face=" + font.getFamily() + " size=-1>" + string2 + " <a style='color:blue' href=" + string3 + '>' + string3 + "</a></font>";
            final JEditorPane jEditorPane = new JEditorPane("text/html", string4);
            Insets insets = jEditorPane.getMargin();
            fontMetrics = jEditorPane.getFontMetrics(font);
            n2 = fontMetrics.stringWidth(string2 + ' ' + string3);
            n3 = n2 / (n - insets.left - insets.right) + 1;
            Dimension dimension = new Dimension(n, n3 * (fontMetrics.getHeight() + fontMetrics.getMaxDescent()) + insets.top + insets.bottom);
            jEditorPane.setPreferredSize(dimension);
            jEditorPane.setEditable(false);
            jEditorPane.addHyperlinkListener(new HyperlinkListener(){

                public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                    if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        DialogFactory.launchLink(hyperlinkEvent.getURL().toString());
                    } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                        jEditorPane.setText(string4.replaceFirst("'color:blue'", "'color:red'"));
                    } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.EXITED) {
                        jEditorPane.setText(string4);
                    }
                }
            });
            jPanel3.add(jEditorPane);
            jPanel.add((Component)jPanel3, "Center");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jPanel;
    }

    public static int showConfirmDialog(Object object) {
        return DialogFactory.showConfirmDialog(null, object, confirmDialogTitle);
    }

    public static int showConfirmDialog(Component component, Object object) {
        return DialogFactory.showConfirmDialog(component, object, confirmDialogTitle);
    }

    public static String showInputDialog(Object object) {
        return DialogFactory.showInputDialog(null, object, inputDialogTitle);
    }

    public static String showInputDialog(Component component, Object object) {
        return DialogFactory.showInputDialog(component, object, inputDialogTitle);
    }

    public static void showInformationDialog(Object object) {
        DialogFactory.showInformationDialog(null, object, messageDialogTitle);
    }

    public static void showInformationDialog(Component component, Object object) {
        DialogFactory.showInformationDialog(component, object, messageDialogTitle);
    }

    public static void showErrorDialog(String string) {
        DialogFactory.showErrorDialog(null, string, messageDialogTitle);
    }

    public static void showErrorDialog(Component component, String string) {
        DialogFactory.showErrorDialog(component, string, messageDialogTitle);
    }

    public static void showExceptionDialog(Throwable throwable) {
        DialogFactory.showExceptionDialog(null, throwable, throwable.toString(), exceptionDialogTitle);
    }

    public static void showExceptionDialog(Component component, Throwable throwable) {
        DialogFactory.showExceptionDialog(component, throwable, throwable.toString(), exceptionDialogTitle);
    }

    public static int showConfirmDialog(Object object, String string) {
        return DialogFactory.showConfirmDialog(null, object, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int showConfirmDialog(Component component, Object object, String string) {
        Object var3_3 = null;
        try {
            JButton jButton = new JButton(ImplResourceManager.getString("usability.confirm.yes"));
            JButton jButton2 = new JButton(ImplResourceManager.getString("usability.confirm.no"));
            jButton.setMnemonic(ImplResourceManager.getAcceleratorKey("usability.confirm.yes"));
            jButton2.setMnemonic(ImplResourceManager.getAcceleratorKey("usability.confirm.no"));
            Object[] objectArray = new Object[]{jButton, jButton2};
            if (string == null) {
                string = confirmDialogTitle;
            }
            int n = DialogFactory.showOptionDialog(component, 4, object, string, objectArray, objectArray[0]);
            Object var9_8 = null;
            return n;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            throw throwable;
        }
    }

    public static int showOptionDialog(Object object, String string, Object[] objectArray, Object object2) {
        return DialogFactory.showOptionDialog(null, object, string, objectArray, object2);
    }

    public static int showOptionDialog(Component component, Object object, String string, Object[] objectArray, Object object2) {
        return DialogFactory.showOptionDialog(component, 5, object, string, objectArray, object2);
    }

    public static int showOptionDialog(int n, Object object, String string, Object[] objectArray, Object object2) {
        return DialogFactory.showOptionDialog(null, n, object, string, objectArray, object2);
    }

    public static int showOptionDialog(Component component, int n, Object object, String string, Object[] objectArray, Object object2) {
        return DialogFactory.showOptionDialogImpl(component, n, object, string, objectArray, object2, false);
    }

    public static void preLoadDialog(int n, Object object, String string, Object[] objectArray, Object object2) {
        DialogFactory.showOptionDialogImpl(null, n, object, string, objectArray, objectArray[0], true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int showOptionDialogImpl(Component component, int n, Object object, String string, Object[] objectArray, Object object2, boolean bl) {
        Object var7_7 = null;
        try {
            Object object3;
            int n2 = -1;
            JOptionPane jOptionPane = new JOptionPane();
            switch (n) {
                case 1: {
                    jOptionPane.setMessageType(0);
                    break;
                }
                case 2: {
                    jOptionPane.setMessageType(1);
                    break;
                }
                case 3: {
                    jOptionPane.setMessageType(2);
                    break;
                }
                case 4: {
                    jOptionPane.setMessageType(3);
                    break;
                }
            }
            jOptionPane.setOptions(objectArray);
            jOptionPane.setInitialValue(object2);
            jOptionPane.setWantsInput(false);
            Object object4 = DialogFactory.extractMessage(jOptionPane, object);
            if (string == null) {
                string = optionDialogTitle;
            }
            if (DialogFactory.showDialog(jOptionPane, component, string, object4, true, bl) && (object3 = jOptionPane.getValue()) != null) {
                int n3 = 0;
                while (n3 < objectArray.length) {
                    if (objectArray[n3].equals(object3)) {
                        n2 = n3;
                        break;
                    }
                    ++n3;
                }
            }
            int n4 = n2;
            Object var14_14 = null;
            return n4;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            throw throwable;
        }
    }

    public static String showInputDialog(Object object, String string) {
        return DialogFactory.showInputDialog(null, object, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String showInputDialog(Component component, Object object, String string) {
        Object var3_3 = null;
        try {
            Object object2;
            Object object3 = null;
            JOptionPane jOptionPane = new JOptionPane();
            jOptionPane.setMessageType(3);
            jOptionPane.setOptionType(2);
            jOptionPane.setWantsInput(true);
            Object object4 = DialogFactory.extractMessage(jOptionPane, object);
            if (string == null) {
                string = inputDialogTitle;
            }
            if (DialogFactory.showDialog(jOptionPane, component, string, object4) && (object2 = jOptionPane.getInputValue()) != null && object2 instanceof String) {
                object3 = object2.toString();
            }
            object2 = object3;
            Object var9_8 = null;
            return object2;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            throw throwable;
        }
    }

    private static void showMessageDialog(int n, Object object, String string, boolean bl) {
        DialogFactory.showMessageDialog(null, n, object, string, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void showMessageDialog(Component component, int n, Object object, String string, boolean bl) {
        Object var5_5 = null;
        try {
            JOptionPane jOptionPane = new JOptionPane();
            switch (n) {
                case 1: {
                    jOptionPane.setMessageType(0);
                    break;
                }
                case 2: {
                    jOptionPane.setMessageType(1);
                    break;
                }
                case 3: {
                    jOptionPane.setMessageType(2);
                    break;
                }
                case 4: {
                    jOptionPane.setMessageType(3);
                    break;
                }
            }
            jOptionPane.setOptionType(-1);
            jOptionPane.setWantsInput(false);
            Object object2 = DialogFactory.extractMessage(jOptionPane, object);
            if (string == null) {
                string = messageDialogTitle;
            }
            DialogFactory.showDialog(jOptionPane, component, string, object2, bl);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            throw throwable;
        }
    }

    public static void showInformationDialog(Object object, String string) {
        DialogFactory.showInformationDialog(null, object, string);
    }

    public static void showInformationDialog(Component component, Object object, String string) {
        DialogFactory.showMessageDialog(component, 2, object, string, true);
    }

    public static void showErrorDialog(String string, String string2) {
        DialogFactory.showErrorDialog(null, string, string2);
    }

    public static void showErrorDialog(Component component, String string, String string2) {
        DialogFactory.showMessageDialog(component, 1, string, string2, true);
    }

    public static void showExceptionDialog(Throwable throwable, String string) {
        DialogFactory.showExceptionDialog(throwable, string, exceptionDialogTitle);
    }

    public static void showExceptionDialog(Component component, Throwable throwable, String string) {
        DialogFactory.showExceptionDialog(component, throwable, string, exceptionDialogTitle);
    }

    public static void showExceptionDialog(Throwable throwable, String string, String string2) {
        DialogFactory.showExceptionDialog(null, throwable, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showExceptionDialog(Component component, Throwable throwable, String string, String string2) {
        Object var4_4 = null;
        try {
            JOptionPane jOptionPane = new JOptionPane();
            jOptionPane.setMessageType(0);
            jOptionPane.setOptionType(-1);
            jOptionPane.setWantsInput(false);
            Component component2 = (Component)DialogFactory.extractMessage(jOptionPane, throwable);
            final JPanel jPanel = new JPanel();
            JButton jButton = new JButton(ImplResourceManager.getString("usability.moreInfo"));
            jButton.setMnemonic(ImplResourceManager.getAcceleratorKey("usability.moreInfo"));
            jPanel.setLayout(new FlowLayout(2));
            jPanel.add(jButton);
            final JPanel jPanel2 = new JPanel();
            JButton jButton2 = new JButton(ImplResourceManager.getString("usability.lessInfo"));
            jButton2.setMnemonic(ImplResourceManager.getAcceleratorKey("usability.lessInfo"));
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new FlowLayout(2));
            jPanel3.add(jButton2);
            jPanel2.setLayout(new BorderLayout());
            jPanel2.add((Component)jPanel3, "Center");
            jPanel2.add(component2, "South");
            final JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BorderLayout());
            jPanel4.add((Component)jPanel, "Center");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Component component = (Component)actionEvent.getSource();
                    Dialog dialog = null;
                    while (component.getParent() != null) {
                        if (component instanceof JDialog) {
                            dialog = (JDialog)component;
                        }
                        component = component.getParent();
                    }
                    if (dialog != null) {
                        dialog.setVisible(false);
                        dialog.setResizable(true);
                        jPanel4.remove(jPanel);
                        jPanel4.add((Component)jPanel2, "Center");
                        dialog.doLayout();
                        dialog.pack();
                        dialog.setResizable(false);
                        dialog.setVisible(true);
                    }
                }
            });
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Component component = (Component)actionEvent.getSource();
                    Dialog dialog = null;
                    while (component.getParent() != null) {
                        if (component instanceof JDialog) {
                            dialog = (JDialog)component;
                        }
                        component = component.getParent();
                    }
                    if (dialog != null) {
                        dialog.setVisible(false);
                        dialog.setResizable(true);
                        jPanel4.remove(jPanel2);
                        jPanel4.add((Component)jPanel, "Center");
                        dialog.doLayout();
                        dialog.pack();
                        dialog.setResizable(false);
                        dialog.setVisible(true);
                    }
                }
            });
            Object[] objectArray = new Object[]{DialogFactory.extractMessage(jOptionPane, string), jPanel4};
            if (string2 == null) {
                string2 = exceptionDialogTitle;
            }
            DialogFactory.showDialog(jOptionPane, component, string2, objectArray);
            Object var15_14 = null;
        }
        catch (Throwable throwable2) {
            Object var15_15 = null;
            throw throwable2;
        }
    }

    private static boolean showDialog(JOptionPane jOptionPane, Component component, String string, Object object) {
        return DialogFactory.showDialog(jOptionPane, component, string, object, true, false);
    }

    private static boolean showDialog(JOptionPane jOptionPane, Component component, String string, Object object, boolean bl) {
        return DialogFactory.showDialog(jOptionPane, component, string, object, bl, false);
    }

    private static boolean showDialog(final JOptionPane jOptionPane, final Component component, final String string, final Object object, final boolean bl, final boolean bl2) {
        boolean bl3 = true;
        try {
            jOptionPane.setValue(null);
            Runnable runnable = new Runnable(){

                public void run() {
                    Serializable serializable;
                    Object object2;
                    JDialog jDialog = jOptionPane.createDialog(component, string);
                    Object[] objectArray = jOptionPane.getOptions();
                    if (null != objectArray) {
                        object2 = new DefaultActionListener(jDialog, jOptionPane);
                        int n = 0;
                        while (n < objectArray.length) {
                            if (objectArray[n] instanceof JButton) {
                                serializable = (JButton)objectArray[n];
                                ActionListener[] actionListenerArray = ((AbstractButton)serializable).getActionListeners();
                                int n2 = 0;
                                while (n2 < actionListenerArray.length) {
                                    if (actionListenerArray[n2] instanceof DefaultActionListener) {
                                        ((AbstractButton)serializable).removeActionListener((DefaultActionListener)actionListenerArray[n2]);
                                    }
                                    ++n2;
                                }
                                if (((AbstractButton)serializable).getActionListeners().length == 0) {
                                    ((AbstractButton)serializable).addActionListener((ActionListener)object2);
                                }
                            }
                            ++n;
                        }
                    }
                    jOptionPane.setMessage(object);
                    jDialog.pack();
                    DialogFactory.fixSwingLayoutBug(object);
                    jDialog.pack();
                    jDialog.setResizable(false);
                    jDialog.setModal(bl);
                    object2 = jDialog.getSize();
                    serializable = Toolkit.getDefaultToolkit().getScreenSize();
                    ((Dimension)object2).width += 30;
                    jDialog.setLocation((((Dimension)serializable).width - ((Dimension)object2).width) / 2, (((Dimension)serializable).height - ((Dimension)object2).height) / 2);
                    if (!bl2) {
                        jDialog.show();
                        jDialog.pack();
                        jDialog.toFront();
                    }
                }
            };
            if (bl2 || SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else if (bl) {
                SwingUtilities.invokeAndWait(runnable);
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl3 = false;
        }
        return bl3;
    }

    private static Object extractMessage(JOptionPane jOptionPane, Throwable throwable) {
        return DialogFactory.formatExceptionMessage(jOptionPane, throwable);
    }

    private static Object extractMessage(JOptionPane jOptionPane, String string) {
        return DialogFactory.formatStringMessage(jOptionPane, string);
    }

    private static Object extractMessage(JOptionPane jOptionPane, Object[] objectArray) {
        Object[] objectArray2 = null;
        if (objectArray != null) {
            objectArray2 = new Object[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                objectArray2[n] = DialogFactory.extractMessage(jOptionPane, objectArray[n]);
                ++n;
            }
        }
        return objectArray2;
    }

    private static Object extractMessage(JOptionPane jOptionPane, Object object) {
        if (object instanceof Object[]) {
            return DialogFactory.extractMessage(jOptionPane, (Object[])object);
        }
        if (object instanceof String) {
            return DialogFactory.extractMessage(jOptionPane, (String)object);
        }
        if (object instanceof Exception) {
            return DialogFactory.extractMessage(jOptionPane, (Exception)object);
        }
        return object;
    }

    private static Object formatStringMessage(JOptionPane jOptionPane, String string) {
        int n;
        if (string == null) {
            string = "null";
        }
        if ((n = string.indexOf("</html>")) == -1) {
            JTextArea jTextArea = new JTextArea();
            jTextArea.setColumns(40);
            jTextArea.setAutoscrolls(true);
            jTextArea.setEditable(false);
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setBackground(jOptionPane.getBackground());
            jTextArea.setText(string);
            return jTextArea;
        }
        if (n + 7 == string.length()) {
            return new JLabel(string);
        }
        Object[] objectArray = new Object[]{new JLabel(string.substring(0, n + 7)), DialogFactory.formatStringMessage(jOptionPane, string.substring(n + 7))};
        return objectArray;
    }

    private static Object formatExceptionMessage(JOptionPane jOptionPane, Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        JTextArea jTextArea = new JTextArea("" + stringWriter.toString());
        jTextArea.setColumns(40);
        jTextArea.setRows(10);
        jTextArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jTextArea.setBackground(jOptionPane.getBackground());
        return jScrollPane;
    }

    private static void fixSwingLayoutBug(Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof JTextArea) {
            JTextArea jTextArea = (JTextArea)object;
            jTextArea.getUI().getPreferredSize(jTextArea);
            return;
        }
        if (object.getClass().isArray()) {
            int n = Array.getLength(object);
            int n2 = 0;
            while (n2 < n) {
                DialogFactory.fixSwingLayoutBug(Array.get(object, n2));
                ++n2;
            }
        }
    }
}

