/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.admin.dirserv.panel;

import com.netscape.admin.dirserv.DSUtil;
import com.netscape.admin.dirserv.DefaultResourceModel;
import com.netscape.admin.dirserv.GlobalConstants;
import com.netscape.admin.dirserv.IDSModel;
import com.netscape.admin.dirserv.panel.AttrTableModel;
import com.netscape.admin.dirserv.panel.AttributeDialog;
import com.netscape.admin.dirserv.panel.BlankPanel;
import com.netscape.admin.dirserv.panel.CenterAlignedHeaderRenderer;
import com.netscape.admin.dirserv.panel.CheckBoxTableCellRenderer;
import com.netscape.admin.dirserv.panel.ContainerPanel;
import com.netscape.admin.dirserv.panel.SimpleDialog;
import com.netscape.admin.dirserv.panel.UIFactory;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.UITools;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JSplitPane;
import com.sun.java.swing.JTable;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.border.EmptyBorder;
import com.sun.java.swing.event.ListSelectionEvent;
import com.sun.java.swing.event.ListSelectionListener;
import com.sun.java.swing.table.TableCellRenderer;
import com.sun.java.swing.table.TableColumn;
import com.sun.java.swing.table.TableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPAttributeSchema;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSchema;

public class SchemaAttributesPanel
extends BlankPanel
implements ListSelectionListener {
    private JButton _createButton;
    private JButton _deleteButton;
    private JButton _editButton;
    private JButton _helpButton;
    private JTable _userDefTable;
    private JTable _stdTable;
    private AttrTableModel _userDefTableModel;
    private AttrTableModel _stdTableModel;
    private Vector _attributes;
    private static int[] _widths = new int[]{130, 160, 115, 25};
    private static final int MULTI_INDEX = 3;
    String[] SyntaxStrings;
    private static final String _section = "schemaattributes";
    static final String ATTR_USERDEF_STRING = "User Defined Attribute";

    public SchemaAttributesPanel(IDSModel model, String section, boolean needsScrollbars) {
        super(model, section, needsScrollbars);
        this._helpToken = "configuration-schema-attr-help";
        this.SyntaxStrings = SchemaAttributesPanel.getSyntaxStrings();
    }

    public SchemaAttributesPanel(IDSModel model) {
        this(model, _section, false);
    }

    static String[] getSyntaxStrings() {
        Vector<String> v = new Vector<String>(7);
        String val = null;
        String SECTION = _section;
        val = DSUtil._resource.getString(SECTION, "newsyntax-unknown");
        if (val != null) {
            v.addElement(val);
        }
        int ii = 1;
        do {
            if ((val = DSUtil._resource.getString(SECTION, "newsyntax-" + ii)) != null) {
                v.addElement(val);
            }
            ++ii;
        } while (val != null);
        int newsize = v.size();
        Object[] syntax = new String[newsize];
        if (newsize > 0) {
            v.copyInto(syntax);
        }
        return syntax;
    }

    public void init() {
        this.getModel().setWaitCursor(true);
        int space = UIFactory.getComponentSpace();
        int different = UIFactory.getDifferentSpace();
        EmptyBorder border = new EmptyBorder(this.getBorderInsets());
        this._myPanel.setBorder((Border)border);
        this._myPanel.setLayout(new GridBagLayout());
        JLabel introLabel = this.makeJLabel(_section, "intro");
        this.resetGBC();
        this._gbc.gridwidth = 0;
        this._gbc.insets = new Insets(0, 0, different, 0);
        this._myPanel.add((Component)introLabel, this._gbc);
        JComponent splitPane = this.createAttributeListArea((Container)this._myPanel);
        this._gbc.weightx = 1.0;
        this._gbc.weighty = 1.0;
        this._gbc.fill = 1;
        this._myPanel.add((Component)splitPane, this._gbc);
        JComponent p = this.createButtonsPanel();
        this._gbc.weightx = 1.0;
        this._gbc.weighty = 0.0;
        this._gbc.fill = 2;
        this._gbc.insets.top = different;
        this._myPanel.add((Component)p, this._gbc);
        this.populateTables();
        this.getModel().setWaitCursor(false);
    }

    protected void setColumnWidths(JTable table, int[] widths) {
        Enumeration en = table.getColumnModel().getColumns();
        int i = 0;
        while (en.hasMoreElements()) {
            TableColumn col = (TableColumn)en.nextElement();
            col.setWidth(widths[i]);
            col.setResizable(true);
            ++i;
        }
    }

    protected void setColumnHeaders(JTable table, String[] headers) {
        Enumeration en = table.getColumnModel().getColumns();
        int i = 0;
        while (en.hasMoreElements()) {
            TableColumn col = (TableColumn)en.nextElement();
            col.setHeaderValue((Object)headers[i]);
            ++i;
        }
    }

    protected int getTotalColumnWidth(JTable table) {
        Enumeration en = table.getColumnModel().getColumns();
        int width = 0;
        while (en.hasMoreElements()) {
            TableColumn col = (TableColumn)en.nextElement();
            width += col.getWidth();
        }
        return width;
    }

    private Dimension getOptimalDimension(JTable table, Container container) {
        int width = this.getTotalColumnWidth(table);
        Dimension d = new Dimension(width, table.getRowHeight() * table.getRowCount() + 8);
        Insets ins = container.getInsets();
        width = ((JComponent)container).getWidth() - ins.left - ins.right;
        d.width = Math.max(d.width, width);
        return d;
    }

    private void setupTable(JTable table, Container container, Dimension dim) {
        table.setBackground(Color.white);
        table.setRowHeight(16);
        Dimension d = dim;
        if (d == null) {
            d = this.getOptimalDimension(table, container);
        }
        table.setMinimumSize(d);
        table.setSize(d);
        table.setPreferredScrollableViewportSize(d);
        table.getTableHeader().setReorderingAllowed(false);
        table.setRowSelectionAllowed(false);
        table.setColumnSelectionAllowed(false);
        table.setAutoResizeMode(2);
    }

    private void setupTable(JTable table, Container container) {
        this.setupTable(table, container, null);
    }

    protected JScrollPane addTableInScrollPane(JTable table, Container container, Dimension dim) {
        JScrollPane scrollpane = new JScrollPane((Component)table);
        scrollpane.setBackground(Color.white);
        scrollpane.setBorder(UITools.createLoweredBorder());
        this.resetGBC();
        this._gbc.anchor = 17;
        this._gbc.gridwidth = 0;
        this._gbc.weighty = 1.0;
        this._gbc.fill = 1;
        this._gbc.insets = new Insets(0, 0, 0, 0);
        container.add((Component)scrollpane, this._gbc);
        this.setupTable(table, container, dim);
        return scrollpane;
    }

    protected JScrollPane addTableInScrollPane(JTable table, Container container) {
        return this.addTableInScrollPane(table, container, null);
    }

    protected JComponent createAttributeListArea(Container myContainer) {
        int space = UIFactory.getComponentSpace();
        int different = UIFactory.getDifferentSpace();
        String[] colNames = new String[]{DSUtil._resource.getString(_section, "namecolumn-label"), DSUtil._resource.getString(_section, "oidcolumn-label"), DSUtil._resource.getString(_section, "syntaxcolumn-label"), DSUtil._resource.getString(_section, "multicolumn-label")};
        this._attributes = new Vector();
        JLabel label = this.makeJLabel(_section, "standard");
        JPanel stdPanel = new JPanel((LayoutManager)new GridBagLayout());
        stdPanel.setBorder((Border)new EmptyBorder(0, 0, 0, 0));
        this.resetGBC();
        this._gbc.gridwidth = 0;
        this._gbc.insets = new Insets(0, 0, 0, 0);
        stdPanel.add((Component)label, this._gbc);
        this._stdTableModel = new AttrTableModel(colNames);
        this._stdTable = new JTable((TableModel)this._stdTableModel);
        JScrollPane stdScrollPane = this.addTableInScrollPane(this._stdTable, (Container)stdPanel);
        this.setColumnWidths(this._stdTable, _widths);
        TableColumn col = this._stdTable.getColumnModel().getColumn(3);
        col.setMinWidth(_widths[3]);
        col.setHeaderRenderer((TableCellRenderer)new CenterAlignedHeaderRenderer());
        label = this.makeJLabel(_section, "userdefined");
        JPanel userPanel = new JPanel((LayoutManager)new GridBagLayout());
        userPanel.setBorder((Border)new EmptyBorder(0, 0, 0, 0));
        this.resetGBC();
        this._gbc.gridwidth = 0;
        this._gbc.insets = new Insets(0, 0, 0, 0);
        userPanel.add((Component)label, this._gbc);
        this._userDefTableModel = new AttrTableModel(colNames);
        this._userDefTable = new JTable((TableModel)this._userDefTableModel);
        JScrollPane userScrollPane = this.addTableInScrollPane(this._userDefTable, (Container)userPanel);
        this._userDefTable.setRowSelectionAllowed(true);
        this._userDefTable.getSelectionModel().addListSelectionListener((ListSelectionListener)this);
        this.setColumnWidths(this._userDefTable, _widths);
        col = this._userDefTable.getColumnModel().getColumn(3);
        col.setMinWidth(_widths[3]);
        col.setHeaderRenderer((TableCellRenderer)new CenterAlignedHeaderRenderer());
        col.setCellRenderer((TableCellRenderer)new CheckBoxTableCellRenderer());
        JSplitPane splitPane = new JSplitPane(0, (Component)stdPanel, (Component)userPanel);
        splitPane.setBorder((Border)new EmptyBorder(0, 0, 0, 0));
        int minHeight = 3 * this._stdTable.getRowHeight();
        stdScrollPane.setMinimumSize(new Dimension(100, minHeight));
        userScrollPane.setMinimumSize(stdScrollPane.getMinimumSize());
        int prefHeight = 8 * this._stdTable.getRowHeight();
        stdScrollPane.setPreferredSize(new Dimension(100, prefHeight));
        splitPane.setDividerSize(10);
        return splitPane;
    }

    public void select(IResourceObject parent, IPage viewInstance) {
        Debug.println((String)"SchemaAttributesPanel.select");
        if (!this._isInitialized) {
            this.init();
            this._isInitialized = true;
            this.clearDirtyFlag();
        }
    }

    public boolean refresh() {
        Debug.println((String)"SchemaAttributesPanel.refresh");
        this.getModel().setWaitCursor(true);
        try {
            LDAPSchema schema = new LDAPSchema();
            LDAPConnection ld = this.getModel().getServerInfo().getLDAPConnection();
            if (ld != null) {
                schema.fetchSchema(ld);
                this.getModel().setSchema(schema);
            }
        }
        catch (LDAPException e) {
            Debug.println((String)("SchemaAttributesPanel.refresh: " + (Object)((Object)e)));
            return false;
        }
        this.populateTables();
        this.getModel().setWaitCursor(false);
        return true;
    }

    protected void populateTables() {
        this._userDefTableModel.removeAllRows();
        this._stdTableModel.removeAllRows();
        LDAPSchema sch = this.getModel().getSchema();
        if (sch == null) {
            return;
        }
        LDAPSchema lDAPSchema = sch;
        synchronized (lDAPSchema) {
            Enumeration e = sch.getAttributes();
            while (e.hasMoreElements()) {
                LDAPAttributeSchema las = (LDAPAttributeSchema)e.nextElement();
                this.addAttributeRow(las);
            }
        }
        this.setColumnWidths(this._stdTable, _widths);
        this.setColumnWidths(this._userDefTable, _widths);
        this._stdTable.repaint();
        this._userDefTable.repaint();
    }

    private void addAttributeRow(LDAPAttributeSchema las) {
        Object[] row = new Object[]{las.getName(), las.getOID(), this.SyntaxStrings[las.getSyntax()], new Boolean(!las.isSingleValued())};
        if (las.getDescription().startsWith(ATTR_USERDEF_STRING)) {
            this._userDefTableModel.addRow(row);
            this._attributes.addElement(las);
        } else {
            this._stdTableModel.addRow(row);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (this._editButton == null) {
            return;
        }
        boolean enable = this._userDefTable.getSelectedRowCount() > 0;
        this._editButton.setEnabled(this._userDefTable.getSelectedRowCount() == 1);
        this._deleteButton.setEnabled(enable);
    }

    protected JComponent createButtonsPanel() {
        this._createButton = this.makeJButton(_section, "create");
        this._editButton = this.makeJButton(_section, "edit");
        this._deleteButton = this.makeJButton(_section, "delete");
        this._helpButton = this.makeJButton("general", "Help");
        JButton[] buttons = new JButton[]{this._createButton, this._editButton, this._deleteButton, this._helpButton};
        JPanel p = UIFactory.makeJButtonPanel((JButton[])buttons, (boolean)true);
        this._editButton.setEnabled(false);
        this._deleteButton.setEnabled(false);
        return p;
    }

    private boolean removeRowByName(String name) {
        int row = 0;
        while (row < this._userDefTableModel.getRowCount()) {
            String cell = (String)this._userDefTableModel.getValueAt(row, 0);
            if (name.equalsIgnoreCase(cell)) {
                this._userDefTableModel.removeRow(row);
                return true;
            }
            ++row;
        }
        return false;
    }

    public void actionPerformed(ActionEvent e) {
        block27: {
            Object source = e.getSource();
            AttributeDialog dialog = null;
            String name = "";
            LDAPSchema sch = this.getModel().getSchema();
            LDAPAttributeSchema las = null;
            if (source.equals(this._createButton)) {
                dialog = new AttributeDialog(this.getModel());
                dialog.setTitle(DSUtil._resource.getString(_section, "new-title"));
            } else if (source.equals(this._editButton)) {
                int row = this._userDefTable.getSelectedRow();
                if (row < 0) {
                    return;
                }
                name = (String)this._userDefTable.getValueAt(row, 0);
                las = sch.getAttribute(name);
                if (las == null) {
                    Debug.println((String)("SchemaAttributePanel.actionPerformed: No schema def for " + name));
                    return;
                }
                dialog = new AttributeDialog(this.getModel(), las);
                dialog.setTitle(DSUtil._resource.getString(_section, "edit-title"));
            } else if (source.equals(this._helpButton)) {
                this.helpCallback();
            } else if (source.equals(this._deleteButton)) {
                LDAPConnection ldc;
                int[] rows = this._userDefTable.getSelectedRows();
                String[] rowNames = new String[rows.length];
                LDAPAttributeSchema[] lases = new LDAPAttributeSchema[rows.length];
                int i = 0;
                while (i < rows.length) {
                    rowNames[i] = (String)this._userDefTable.getValueAt(rows[i], 0);
                    lases[i] = sch.getAttribute(rowNames[i]);
                    if (lases[i] == null) {
                        Debug.println((String)("SchemaAttributePanel.actionPerformed: No schema def for " + rowNames[i]));
                        return;
                    }
                    ++i;
                }
                boolean confirm = BlankPanel.requiresConfirmation(GlobalConstants.PREFERENCES_CONFIRM_DELETE_ATTRIBUTE);
                if (confirm) {
                    String str = rowNames[0];
                    int i2 = 1;
                    while (i2 < rowNames.length) {
                        str = String.valueOf(str) + " " + rowNames[i2];
                        ++i2;
                    }
                    int response = DSUtil.showConfirmationDialog((Component)this.getModel().getConsoleInfo().getFrame(), (String)"confirm-delete", (String)str, (String)_section);
                    if (response != 0) {
                        return;
                    }
                }
                if ((ldc = this.getModel().getServerInfo().getLDAPConnection()) == null) {
                    Debug.println((String)"SchemaAttributePanel.actionPerformed: No LDAPConnection");
                    return;
                }
                boolean done = false;
                boolean status = false;
                while (!done) {
                    try {
                        int i3 = 0;
                        while (i3 < rowNames.length) {
                            las = lases[i3];
                            if (las != null) {
                                Debug.println((String)("SchemaAttributesPanel.actionPerformed: delete " + las.getValue()));
                                las.remove(ldc);
                                lases[i3] = null;
                            }
                            ++i3;
                        }
                        done = true;
                        status = true;
                    }
                    catch (LDAPException lde) {
                        Debug.println((String)("SchemaAttributesPanel.actionPerformed: " + (Object)((Object)lde) + " attr = " + las.getValue()));
                        if (lde.getLDAPResultCode() == 50) {
                            DSUtil.showPermissionDialog((Component)this.getModel().getFrame(), (LDAPConnection)ldc);
                            if (this.getModel().getNewAuthentication(false)) continue;
                            done = true;
                            continue;
                        }
                        done = true;
                        DSUtil.showErrorDialog((Component)this.getModel().getFrame(), (String)"failed-delete", (String)lde.toString(), (String)_section);
                    }
                }
                this.getModel().notifyAuthChangeListeners();
                if (status) {
                    String names = rowNames[0];
                    this.removeRowByName(rowNames[0]);
                    int i4 = 1;
                    while (i4 < rows.length) {
                        names = String.valueOf(names) + "," + rowNames[i4];
                        this.removeRowByName(rowNames[i4]);
                        ++i4;
                    }
                    DSUtil.showInformationDialog((Component)this.getModel().getFrame(), (String)"successful-delete", (String)names, (String)_section);
                    this.getModel().setSchema(null);
                }
            }
            if (dialog == null) break block27;
            try {
                dialog.show();
                las = dialog.getAttribute();
                if (las != null) {
                    if (source.equals(this._editButton)) {
                        this.removeRowByName(name);
                    }
                    LDAPAttributeSchema las2 = new LDAPAttributeSchema(las.getName(), las.getOID(), ATTR_USERDEF_STRING, las.getSyntax(), las.isSingleValued());
                    this.addAttributeRow(las2);
                }
            }
            catch (NullPointerException nullPointerException) {}
        }
    }

    public static void main(String[] args) {
        Debug.setTrace((boolean)true);
        try {
            UIManager.setLookAndFeel((String)"com.netscape.management.nmclf.SuiLookAndFeel");
        }
        catch (Exception exception) {
            System.err.println("Cannot load nmc look and feel.");
        }
        DefaultResourceModel model = new DefaultResourceModel();
        try {
            int port = Integer.parseInt(args[1]);
            LDAPConnection ldc = new LDAPConnection();
            ldc.connect(3, args[0], port, args[2], args[3]);
            LDAPSchema schema = new LDAPSchema();
            schema.fetchSchema(ldc);
            model.setSchema(schema);
        }
        catch (Exception e) {
            System.err.println(e);
            System.err.println("Usage: SchemaAttributesPanel HOST PORT AUTHDN AUTHPASSWORD");
            System.exit(1);
        }
        1 child = new 1(model);
        ((BlankPanel)child).init();
        ContainerPanel container = new ContainerPanel((IDSModel)model, (BlankPanel)child, false);
        SimpleDialog dlg = BlankPanel.createDialog((JComponent)container, child);
        dlg.show();
    }

    private final class 1
    extends SchemaAttributesPanel {
        public void okCallback() {
            this.hideDialog();
            System.exit(0);
        }

        /* synthetic */ 1(DefaultResourceModel $0) {
            super((IDSModel)$0);
        }
    }
}

