/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.acleditor;

import com.netscape.management.client.acleditor.ACLEditorWindow;
import com.netscape.management.client.acleditor.CallbackAction;
import com.netscape.management.client.acleditor.DataModelAdapter;
import com.netscape.management.client.acleditor.SelectionListener;
import com.netscape.management.client.acleditor.Table;
import com.netscape.management.client.acleditor.UserGroupDataModel;
import com.netscape.management.client.acleditor.WindowFactory;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.ug.IRPCallBack;
import com.netscape.management.client.ug.ResourcePickerDlg;
import com.netscape.management.client.util.UtilConsoleGlobals;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPEntry;

public class PickerWindow
extends ACLEditorWindow
implements SelectionListener,
DocumentListener,
IRPCallBack {
    protected static final int addTextWidth = 10;
    protected static final int preferredHeight = 125;
    protected static Dimension ListSize = new Dimension(600, 200);
    ConsoleInfo info;
    Table list;
    UserGroupDataModel datamodel;
    JTextField text;
    JComboBox type;
    JTextField userdnattr;
    JComboBox authmethod;
    Vector methods = new Vector();

    public PickerWindow(String string, WindowFactory windowFactory, DataModelAdapter dataModelAdapter, ConsoleInfo consoleInfo) {
        super(windowFactory, string, windowFactory.getSessionIdentifier());
        this.info = consoleInfo;
        JPanel jPanel = this.createStandardLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.resetConstraints(gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.ipady = 0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new FlowLayout(0, 0, 5));
        this.type = this.createComboBox("selector", null);
        jPanel3.add(this.type);
        if (this.getWindowName().equals("hosts")) {
            this.text = this.createSingleByteTextField("addText", 10, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PickerWindow.this.addText();
                }
            });
            jPanel3.add(this.text);
        } else {
            this.text = this.createTextField("addText", 10, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PickerWindow.this.addText();
                }
            });
            jPanel3.add(this.text);
        }
        this.text.getDocument().addDocumentListener(this);
        jPanel3.add(this.createButton("add", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PickerWindow.this.addText();
            }
        }));
        jPanel3.add(this.createButton("remove", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PickerWindow.this.list.deleteRow();
            }
        }));
        this.resetConstraints(gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.gridwidth = 1;
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        this.getComponent("add").setBorder(new CompoundBorder(new EmptyBorder(0, 10, 0, 10), this.getComponent("add").getBorder()));
        jPanel3 = new JPanel(new FlowLayout(2, 0, 10));
        if (!this.getWindowName().equals("hosts")) {
            jPanel3.add(this.createButton("find", new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PickerWindow.this.find(actionEvent);
                }
            }));
        }
        this.resetConstraints(gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.gridx = 1;
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        this.resetConstraints(gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        this.datamodel = (UserGroupDataModel)dataModelAdapter;
        this.list = new Table(this.datamodel);
        jPanel.add((Component)this.list, gridBagConstraints);
        this.list.getJTable().setShowGrid(false);
        this.list.addSelectionListener(this);
        this.populateComboBox(this.type, this.datamodel);
        jPanel3 = new JPanel(new FlowLayout(0, 0, 5));
        jPanel3.add((Component)this.createCheckBox("all", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PickerWindow.this.toggleEquality(actionEvent);
            }
        }), gridBagConstraints);
        this.resetConstraints(gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.ipadx = 0;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        if (this.getWindowName().equals("userGroup")) {
            jPanel2 = new JPanel(new GridBagLayout());
            this.resetConstraints(gridBagConstraints);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.ipady = 5;
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.insets = new Insets(5, 0, 5, 0);
            jPanel.add((Component)jPanel2, gridBagConstraints);
            this.resetConstraints(gridBagConstraints);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.ipady = 0;
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.insets = new Insets(0, 0, 0, 5);
            jPanel2.add((Component)this.createInstruction("userdnattr"), gridBagConstraints);
            this.resetConstraints(gridBagConstraints);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.ipady = 0;
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 1;
            this.userdnattr = this.createTextField("userdnattrText", 10, null);
            jPanel2.add((Component)this.userdnattr, gridBagConstraints);
            this.resetConstraints(gridBagConstraints);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.ipady = 0;
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 2;
            gridBagConstraints.insets = new Insets(0, 20, 0, 5);
            jPanel2.add((Component)this.createInstruction("authmethod"), gridBagConstraints);
            this.resetConstraints(gridBagConstraints);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.ipady = 0;
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 3;
            this.authmethod = this.createComboBox("authmethodMenu", null);
            jPanel2.add((Component)this.authmethod, gridBagConstraints);
            this.populateAuthMethod();
        }
        this.getComponent("add").setEnabled(false);
        ((JCheckBox)this.getComponent("all")).setSelected(!this.datamodel.getAttributeEquality());
        this.list.getJTable().setPreferredScrollableViewportSize(ListSize);
        this.pack();
        this.selectionNotify(-1, -1, 0, null);
        if (this.getWindowName().equals("userGroup")) {
            this.userdnattr.setText(this.datamodel.getUserDnAttrValue());
            String string2 = this.datamodel.getAuthMethodValue();
            int n = this.methods.indexOf(string2);
            if (n != -1) {
                this.authmethod.setSelectedIndex(n);
                return;
            }
            this.authmethod.setSelectedIndex(0);
        }
    }

    protected void populateComboBox(JComboBox jComboBox, UserGroupDataModel userGroupDataModel) {
        int n = 0;
        while (n < userGroupDataModel.getTypeCount()) {
            jComboBox.addItem(this.resources.getString(this.windowName, "menuItem" + n));
            ++n;
        }
    }

    protected void populateAuthMethod() {
        String[] stringArray;
        int n = 0;
        while ((stringArray = this.resources.getString(this.windowName, "authMethod" + n)) != null) {
            this.authmethod.addItem(stringArray);
            this.methods.addElement(stringArray);
            ++n;
        }
        stringArray = this.datamodel.getAuthMethods();
        if (stringArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2] != null) {
                this.authmethod.addItem(stringArray[n2]);
                this.methods.addElement(stringArray[n2]);
            }
            ++n2;
        }
    }

    public void selectionNotify(int n, int n2, int n3, CallbackAction callbackAction) {
        this.getComponent("remove").setEnabled(n != -1 && n2 != -1);
        if (callbackAction != null) {
            callbackAction.go(null);
        }
    }

    protected void toggleEquality(ActionEvent actionEvent) {
        this.datamodel.setAttributeEquality(!((JCheckBox)this.getComponent("all")).isSelected());
    }

    protected void save(ActionEvent actionEvent) {
        if (this.getWindowName().equals("userGroup")) {
            this.datamodel.setUserDnAttrValue(this.userdnattr.getText());
            int n = this.authmethod.getSelectedIndex();
            if (n < 1) {
                this.datamodel.setAuthMethodValue("");
            } else {
                this.datamodel.setAuthMethodValue((String)this.methods.elementAt(n));
            }
        }
        this.datamodel.complete();
        super.save(actionEvent);
    }

    protected void find(ActionEvent actionEvent) {
        if (this.getWindowName().equals("hosts")) {
            this.unimplemented(actionEvent);
            return;
        }
        ResourcePickerDlg resourcePickerDlg = new ResourcePickerDlg(this.info, this, UtilConsoleGlobals.getRootFrame());
        resourcePickerDlg.setChangeDirectoryEnabled(true);
        resourcePickerDlg.show();
        resourcePickerDlg.dispose();
    }

    protected void addText() {
        String string = this.text.getText();
        if (string.equals("")) {
            return;
        }
        this.datamodel.addAttribute(string, this.type.getSelectedIndex());
        this.list.repaint(0L);
        this.text.setText("");
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.getComponent("add").setEnabled(this.text.getDocument().getLength() != 0);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.getComponent("add").setEnabled(this.text.getDocument().getLength() != 0);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.getComponent("add").setEnabled(this.text.getDocument().getLength() != 0);
    }

    public void getResults(Vector vector) {
        if (vector == null) {
            System.err.println("PickerWindow:getResults():null Vector returned from user/group picker.");
            return;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            LDAPEntry lDAPEntry = (LDAPEntry)enumeration.nextElement();
            String string = lDAPEntry.getDN();
            boolean bl = true;
            Enumeration enumeration2 = lDAPEntry.getAttributeSet().getAttributes();
            block1: while (enumeration2.hasMoreElements()) {
                LDAPAttribute lDAPAttribute = (LDAPAttribute)enumeration2.nextElement();
                if (!lDAPAttribute.getName().equalsIgnoreCase("objectclass")) continue;
                Enumeration enumeration3 = lDAPAttribute.getStringValues();
                while (enumeration3.hasMoreElements()) {
                    String string2 = (String)enumeration3.nextElement();
                    if (!string2.equalsIgnoreCase("groupofuniquenames")) continue;
                    bl = false;
                    continue block1;
                }
            }
            this.datamodel.addAttribute(string, bl ? 0 : 1);
            this.list.repaint(0L);
        }
    }
}

