/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.acleditor;

import com.netscape.management.client.acl.AttributeList;
import com.netscape.management.client.acl.Rule;
import com.netscape.management.client.acleditor.ACLEditorWindow;
import com.netscape.management.client.acleditor.WindowFactory;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TimeWindow
extends ACLEditorWindow {
    protected int textWidth = 10;
    Rule rule;
    AttributeList timecopy;
    AttributeList daycopy;
    JTextField begMenu;
    JTextField endMenu;
    JComboBox dayMenu;
    String[] _sLocalizeDay;
    static String[] _sEnglishDay = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};

    public TimeWindow(String string, WindowFactory windowFactory, Rule rule) {
        super(windowFactory, string, windowFactory.getSessionIdentifier());
        this.rule = rule;
        this.timecopy = new AttributeList(this.rule.getAttributeList("timeofday"));
        this.daycopy = new AttributeList(this.rule.getAttributeList("dayofweek"));
        JPanel jPanel = this.createStandardLayout();
        GridBagLayout gridBagLayout = (GridBagLayout)this.getContentPane().getLayout();
        GridBagConstraints gridBagConstraints = gridBagLayout.getConstraints(this.getComponent("main"));
        gridBagConstraints.insets = new Insets(10, 15, 0, 15);
        gridBagLayout.setConstraints(this.getComponent("main"), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        this.resetConstraints(gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 20, 10);
        gridBagConstraints.ipady = 0;
        jPanel.add((Component)this.createInstruction("main2"), gridBagConstraints);
        this.resetConstraints(gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.ipady = 5;
        jPanel.add((Component)this.createInstruction("beginning"), gridBagConstraints);
        this.resetConstraints(gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        this.begMenu = this.createTextField("beginningMenu", 4, null);
        jPanel.add((Component)this.begMenu, gridBagConstraints);
        this.resetConstraints(gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.ipady = 5;
        jPanel.add((Component)this.createInstruction("end"), gridBagConstraints);
        this.resetConstraints(gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        this.endMenu = this.createTextField("endMenu", 4, null);
        jPanel.add((Component)this.endMenu, gridBagConstraints);
        this.resetConstraints(gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.ipady = 5;
        jPanel.add((Component)this.createInstruction("day"), gridBagConstraints);
        this.resetConstraints(gridBagConstraints);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        this.dayMenu = this.createComboBox("dayMenu", null);
        jPanel.add((Component)this.dayMenu, gridBagConstraints);
        this.setResizable(false);
        this.populateMenus();
        this.populateData();
        this.pack();
    }

    protected void populateMenus() {
        int n = 0;
        while (n < 24) {
            String string = this.resources.getString("time", "hour" + n);
            if (string == null) {
                string = this.getTime24ForHour(n);
            }
            this.begMenu.setText(string);
            this.endMenu.setText(string);
            ++n;
        }
        this._sLocalizeDay = new String[7];
        int n2 = 0;
        while (n2 < 7) {
            String string = this.resources.getString("time", "day" + n2);
            this.dayMenu.addItem(string);
            this._sLocalizeDay[n2] = string;
            ++n2;
        }
        this.dayMenu.addItem("");
    }

    protected String getTime24ForHour(int n) {
        return new String((n < 10 ? "0" : "") + n + "00");
    }

    protected void populateData() {
        String string;
        Enumeration enumeration;
        int n = this.timecopy.size();
        if (n == 1 || n == 2) {
            enumeration = this.timecopy.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                String string2 = (String)this.timecopy.get(string);
                if (string2.charAt(0) == '>') {
                    this.begMenu.setText(string);
                    continue;
                }
                if (string2.charAt(0) != '<') continue;
                this.endMenu.setText(string);
            }
        }
        if (this.daycopy.size() > 0) {
            enumeration = this.daycopy.keys();
            string = (String)enumeration.nextElement();
            int n2 = 0;
            while (n2 < 7) {
                if (string.equalsIgnoreCase(_sEnglishDay[n2])) break;
                ++n2;
            }
            this.dayMenu.setSelectedIndex(n2);
        }
    }

    protected String packageTime(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < 4 - n) {
            string = "0" + string;
            ++n2;
        }
        return string;
    }

    protected void save(ActionEvent actionEvent) {
        this.timecopy.removeAll();
        this.daycopy.removeAll();
        String string = this.begMenu.getText();
        if (!string.equals("")) {
            string = this.packageTime(string);
            this.timecopy.setAttribute(string, ">");
        }
        if (!(string = this.endMenu.getText()).equals("")) {
            string = this.packageTime(string);
            this.timecopy.setAttribute(string, "<");
        }
        this.rule.updateAttributeList("timeofday", this.timecopy);
        string = (String)this.dayMenu.getSelectedItem();
        if (!string.equals("")) {
            int n = 0;
            while (n < 7) {
                if (string.equalsIgnoreCase(this._sLocalizeDay[n])) {
                    string = _sEnglishDay[n];
                    break;
                }
                ++n;
            }
            this.daycopy.setAttribute(string);
        }
        this.rule.updateAttributeList("dayofweek", this.daycopy);
        super.save(actionEvent);
    }
}

