/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.acleditor;

import com.netscape.management.client.acl.AttributeList;
import com.netscape.management.client.acl.LdapACL;
import com.netscape.management.client.acl.Rule;
import com.netscape.management.client.acleditor.DataModelAdapter;
import com.netscape.management.client.util.RemoteImage;
import com.netscape.management.client.util.ResourceSet;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class UserGroupDataModel
extends DataModelAdapter {
    protected static final int iconWidth = 16;
    protected int dataColumn = 1;
    protected int numColumns = 2;
    protected static String[] attributeNames = new String[]{"userdn", "groupdn"};
    protected static final String UserDnAttr = "userdnattr";
    protected static final String AuthMethod = "authmethod";
    protected static final String ldapPrefix = "ldap:///";
    protected static final String ldapAnyone = "ldap:///anyone";
    protected Rule rule;
    protected AttributeList userdnattr;
    protected AttributeList authmethod;
    protected AttributeList[] attributeLists = new AttributeList[this.getTypeCount()];
    protected RemoteImage[] icons = new RemoteImage[this.getTypeCount()];

    public UserGroupDataModel(ResourceSet resourceSet, String string, Rule rule) {
        super(resourceSet, string);
        this.setHeaderVisible(false);
        this.rule = rule;
        this.userdnattr = new AttributeList(this.rule.getAttributeList(UserDnAttr));
        this.authmethod = new AttributeList(this.rule.getAttributeList(AuthMethod));
        int n = 0;
        while (n < this.getTypeCount()) {
            this.attributeLists[n] = new AttributeList(this.rule.getAttributeList(this.getTypeName(n)));
            this.icons[n] = new RemoteImage(this.resources.getString(string, "iconType" + n));
            ++n;
        }
    }

    public TableCellRenderer getColumnCellRenderer(int n) {
        switch (n) {
            case 0: {
                DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

                    protected void setValue(Object object) {
                        this.setIcon((Icon)object);
                    }
                };
                defaultTableCellRenderer.setToolTipText(this.getColumnToolTip(n));
                return defaultTableCellRenderer;
            }
        }
        return null;
    }

    public TableCellEditor getColumnCellEditor(int n) {
        switch (n) {
            case 0: {
                return null;
            }
        }
        JTextField jTextField = new JTextField("");
        jTextField.setToolTipText(this.getColumnToolTip(n));
        return new DefaultCellEditor(jTextField);
    }

    public int getColumnWidth(int n) {
        switch (n) {
            case 0: {
                return 16;
            }
        }
        return -1;
    }

    public int getRowCount() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.getTypeCount()) {
            n += this.attributeLists[n2].size();
            ++n2;
        }
        return n;
    }

    public int getColumnCount() {
        return this.numColumns;
    }

    public int getTypeCount() {
        return attributeNames.length;
    }

    public String getTypeName(int n) {
        return attributeNames[n];
    }

    protected int getAttributeIndex(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.getTypeCount()) {
            if (n - n2 < this.attributeLists[n3].size()) {
                return n3;
            }
            n2 += this.attributeLists[n3].size();
            ++n3;
        }
        System.err.println("UserGroupDataModel:getAttributeIndex:invalid index");
        return -1;
    }

    protected int getAttributeOffset(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.getTypeCount()) {
            if (n - n2 < this.attributeLists[n3].size()) {
                return n - n2;
            }
            n2 += this.attributeLists[n3].size();
            ++n3;
        }
        System.err.println("UserGroupDataModel:getAttributeOffset:invalid index");
        return -1;
    }

    protected Object processOutputValue(Object object) {
        if (!(object instanceof String)) {
            return object;
        }
        if (((String)object).startsWith(ldapPrefix)) {
            return ((String)object).substring(ldapPrefix.length());
        }
        return object;
    }

    protected Object processInputValue(Object object) {
        if (!(object instanceof String)) {
            return object;
        }
        if (!((String)object).startsWith(ldapPrefix)) {
            return ldapPrefix + (String)object;
        }
        return object;
    }

    public Object getValueAt(int n, int n2) {
        if (n2 == this.dataColumn) {
            return this.processOutputValue(this.attributeLists[this.getAttributeIndex(n)].getElementAt(this.getAttributeOffset(n)));
        }
        return this.icons[this.getAttributeIndex(n)];
    }

    public String getUserDnAttrValue() {
        return this.userdnattr.generateList(",");
    }

    public String getAuthMethodValue() {
        return this.authmethod.generateList(",");
    }

    public void setUserDnAttrValue(String string) {
        this.userdnattr.removeAll();
        if (!string.equals("")) {
            this.userdnattr.setAttribute(string);
        }
    }

    public void setAuthMethodValue(String string) {
        this.authmethod.removeAll();
        if (!string.equals("")) {
            this.authmethod.setAttribute(string);
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n2 != this.dataColumn) {
            return;
        }
        this.updateValue(this.attributeLists[this.getAttributeIndex(n)], this.getAttributeOffset(n), object);
    }

    protected void updateValue(AttributeList attributeList, int n, Object object) {
        String string = (String)attributeList.getElementAt(n);
        if (string == null) {
            System.err.println("UserGroupDataModel:setValueAt():Unable to find value, no change.");
            return;
        }
        attributeList.removeAttribute(string);
        attributeList.setAttribute(this.processInputValue(object));
        this.validate();
    }

    protected void addRow(int n) {
    }

    protected void addAttribute(String string, int n) {
        if (n >= this.getTypeCount()) {
            System.err.println("UserGroupDataModel:addAttribute():invalid type");
            return;
        }
        this.attributeLists[n].setAttribute(this.processInputValue(string));
        this.validate();
    }

    protected void validate() {
        int n = this.getRowCount();
        if (n == 1) {
            return;
        }
        if (n == 0) {
            this.attributeLists[0].setAttribute(ldapAnyone);
            return;
        }
        boolean bl = false;
        int n2 = 0;
        while (n2 < this.getTypeCount()) {
            if (this.attributeLists[n2].containsAttribute(ldapAnyone)) {
                bl = true;
                this.attributeLists[n2].removeAttribute(ldapAnyone);
            }
            ++n2;
        }
        if (!bl || this.getRowCount() != 0) {
            return;
        }
        this.attributeLists[0].setAttribute(ldapAnyone);
    }

    protected void setAttributeEquality(boolean bl) {
        int n = 0;
        while (n < this.getTypeCount()) {
            this.attributeLists[n].setOperatorAll(!bl ? "!=" : "=");
            ++n;
        }
    }

    protected boolean getAttributeEquality() {
        boolean bl = true;
        int n = 0;
        while (n < this.getTypeCount()) {
            if (this.attributeLists[n].getOperator().equals("!=")) {
                bl = false;
            }
            ++n;
        }
        return bl;
    }

    protected void deleteRow(int n) {
        this.deleteValue(this.attributeLists[this.getAttributeIndex(n)], this.getAttributeOffset(n));
    }

    protected void deleteValue(AttributeList attributeList, int n) {
        String string = (String)attributeList.getElementAt(n);
        if (string != null) {
            attributeList.removeAttribute(string);
        }
        this.validate();
    }

    protected void moveRow(int n, boolean bl) {
    }

    protected void complete() {
        this.rule.updateAttributeList(UserDnAttr, this.userdnattr);
        this.rule.updateAttributeList(AuthMethod, this.authmethod);
        int n = 0;
        while (n < this.getTypeCount()) {
            this.rule.updateAttributeList(this.getTypeName(n), this.attributeLists[n]);
            ++n;
        }
    }

    protected String[] getAuthMethods() {
        LdapACL ldapACL = (LdapACL)this.getCallerData();
        if (ldapACL == null) {
            return null;
        }
        return ldapACL.getAuthMethodsSASL();
    }
}

