/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.components;

import com.netscape.management.client.components.GenericDialog;
import com.netscape.management.client.console.ConsoleHelp;
import com.netscape.management.client.util.GridBagUtil;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.UITools;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FontChooserDialog
extends GenericDialog {
    private static int[] fontSizes = new int[]{8, 10, 11, 12, 16, 18, 24, 28};
    private JTextField fontField;
    private JTextField sizeField;
    private String[] fontArray;
    private String[] sizeArray;
    private JList fontList;
    private JList sizeList;
    private JCheckBox boldCheckbox;
    private JCheckBox italicCheckbox;
    private JLabel sampleLabel = new JLabel();
    private String selectedName;
    private int selectedSize;
    private int fontStyle;
    private static ResourceSet resource = new ResourceSet("com.netscape.management.client.components.components");

    static String i18n(String string) {
        return resource.getString("fontChooser", string);
    }

    public FontChooserDialog(JFrame jFrame, String string, int n, int n2) {
        super(jFrame, FontChooserDialog.i18n("select"), 11);
        Vector<String> vector = new Vector<String>();
        int n3 = 0;
        while (n3 < fontSizes.length) {
            vector.addElement(String.valueOf(fontSizes[n3]));
            ++n3;
        }
        this.sizeArray = new String[vector.size()];
        vector.copyInto(this.sizeArray);
        this.sizeList = new JList<String>(this.sizeArray);
        this.sizeList.setToolTipText(FontChooserDialog.i18n("size_tt"));
        this.sizeList.setSelectionMode(0);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        this.fontArray = toolkit.getFontList();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.fontArray = graphicsEnvironment.getAvailableFontFamilyNames();
        this.fontList = new JList<String>(this.fontArray);
        this.fontList.setToolTipText(FontChooserDialog.i18n("font_tt"));
        this.fontList.setSelectionMode(0);
        this.getContentPane().add(this.createDialogPanel());
        this.sizeField.setText(String.valueOf(n2));
        this.fontField.setText(string);
        this.boldCheckbox.setSelected((n & 1) == 1);
        this.italicCheckbox.setSelected((n & 2) == 2);
        this.updateFontList();
        this.updateSizeList();
        ChangeEventListener changeEventListener = new ChangeEventListener();
        this.fontField.getDocument().addDocumentListener(changeEventListener);
        this.sizeField.getDocument().addDocumentListener(changeEventListener);
        this.fontList.addListSelectionListener(changeEventListener);
        this.sizeList.addListSelectionListener(changeEventListener);
        this.italicCheckbox.addChangeListener(changeEventListener);
        this.boldCheckbox.addChangeListener(changeEventListener);
    }

    public String getFontName() {
        return this.selectedName;
    }

    public int getFontSize() {
        return this.selectedSize;
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    protected void okInvoked() {
        this.selectedName = (String)this.fontList.getSelectedValue();
        String string = this.sizeField.getText();
        if (string == "") {
            string = "11";
        }
        Integer n = Integer.valueOf(string);
        this.selectedSize = n;
        this.fontStyle = 0;
        this.fontStyle += this.italicCheckbox.isSelected() ? 2 : 0;
        this.fontStyle += this.boldCheckbox.isSelected() ? 1 : 0;
        super.okInvoked();
    }

    protected JPanel createDialogPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel(UITools.getDisplayLabel(FontChooserDialog.i18n("font")));
        this.fontField = new JTextField(12);
        jLabel.setLabelFor(this.fontField);
        GridBagUtil.constrain(jPanel, jLabel, 0, 0, 1, 1, 0.0, 0.0, 18, 0, 0, 0, 0, 12);
        GridBagUtil.constrain(jPanel, this.fontField, 0, 1, 1, 1, 1.0, 0.0, 18, 2, 0, 0, 1, 12);
        JScrollPane jScrollPane = new JScrollPane(this.fontList);
        GridBagUtil.constrain(jPanel, jScrollPane, 0, 2, 1, 1, 1.0, 1.0, 18, 1, 0, 0, 0, 12);
        JLabel jLabel2 = new JLabel(UITools.getDisplayLabel(FontChooserDialog.i18n("size")));
        this.sizeField = new JTextField(3);
        jLabel2.setLabelFor(this.sizeField);
        GridBagUtil.constrain(jPanel, jLabel2, 1, 0, 1, 1, 0.0, 0.0, 18, 0, 0, 0, 0, 0);
        GridBagUtil.constrain(jPanel, this.sizeField, 1, 1, 1, 1, 0.0, 0.0, 18, 0, 0, 0, 1, 0);
        JScrollPane jScrollPane2 = new JScrollPane(this.sizeList);
        GridBagUtil.constrain(jPanel, jScrollPane2, 1, 2, 1, 1, 0.0, 1.0, 18, 3, 0, 0, 0, 0);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, FontChooserDialog.i18n("sample")), BorderFactory.createEmptyBorder(2, 6, 6, 4));
        this.sampleLabel.setBorder(compoundBorder);
        this.sampleLabel.setText(FontChooserDialog.i18n("sampleText"));
        this.sampleLabel.setToolTipText(FontChooserDialog.i18n("sample_tt"));
        this.sampleLabel.setMaximumSize(new Dimension(100, 50));
        this.sampleLabel.setPreferredSize(new Dimension(100, 50));
        GridBagUtil.constrain(jPanel, this.sampleLabel, 0, 3, 2, 1, 0.0, 0.0, 18, 2, 6, 0, 0, 0);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.boldCheckbox = new JCheckBox(UITools.getDisplayLabel(FontChooserDialog.i18n("bold")));
        this.italicCheckbox = new JCheckBox(UITools.getDisplayLabel(FontChooserDialog.i18n("italic")));
        GridBagUtil.constrain(jPanel2, this.boldCheckbox, 0, 0, 1, 1, 0.0, 0.0, 18, 0, 24, 0, 0, 0);
        GridBagUtil.constrain(jPanel2, this.italicCheckbox, 0, 1, 1, 1, 1.0, 1.0, 18, 0, 0, 0, 0, 0);
        this.setButtonComponent(jPanel2);
        return jPanel;
    }

    private void setRegisterKeyboardAction(char c, JComponent jComponent, ActionListener actionListener) {
        char c2 = Character.toUpperCase(c);
        char c3 = Character.toLowerCase(c);
        jComponent.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(Character.getNumericValue(c2), 18), 2);
        jComponent.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(Character.getNumericValue(c3), 18), 2);
    }

    public void updateFontList() {
        String string = this.fontField.getText();
        int n = -1;
        if (string.length() > 0) {
            int n2 = this.fontArray.length - 1;
            while (n2 >= 0) {
                String string2 = string.toLowerCase();
                String string3 = this.fontArray[n2].toLowerCase();
                if (string3.startsWith(string2)) {
                    n = n2;
                }
                --n2;
            }
        }
        if (n != -1) {
            this.fontList.setSelectedIndex(n);
            this.fontList.ensureIndexIsVisible(n);
            this.updateFontSample();
        } else {
            ListSelectionModel listSelectionModel = this.fontList.getSelectionModel();
            listSelectionModel.clearSelection();
        }
    }

    public void updateSizeList() {
        String string = this.sizeField.getText();
        String string2 = "";
        int n = this.sizeArray.length - 1;
        while (n >= 0) {
            String string3 = this.sizeArray[n];
            String string4 = string;
            if (string3.equals(string4)) {
                string2 = string3;
            }
            --n;
        }
        this.sizeList.setSelectedValue(string2, true);
    }

    void updateFontSample() {
        String string = (String)this.fontList.getSelectedValue();
        String string2 = (String)this.sizeList.getSelectedValue();
        if (string2 == null) {
            string2 = "11";
        }
        Integer n = Integer.valueOf(string2);
        int n2 = 0;
        n2 += this.italicCheckbox.isSelected() ? 2 : 0;
        this.sampleLabel.setFont(new Font(string, n2 += this.boldCheckbox.isSelected() ? 1 : 0, n));
    }

    public void helpInvoked() {
        ConsoleHelp.showContextHelp("fontChooser");
    }

    class ChangeEventListener
    implements ListSelectionListener,
    ChangeListener,
    DocumentListener {
        int oldFontListSelection = -1;
        int oldSizeListSelection = -1;

        ChangeEventListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (this.oldFontListSelection != FontChooserDialog.this.fontList.getSelectedIndex()) {
                FontChooserDialog.this.updateFontSample();
                FontChooserDialog.this.fontField.getDocument().removeDocumentListener(this);
                FontChooserDialog.this.fontField.setText((String)FontChooserDialog.this.fontList.getSelectedValue());
                FontChooserDialog.this.fontField.getDocument().addDocumentListener(this);
                this.oldFontListSelection = FontChooserDialog.this.fontList.getSelectedIndex();
            }
            if (this.oldSizeListSelection != FontChooserDialog.this.sizeList.getSelectedIndex()) {
                FontChooserDialog.this.updateFontSample();
                FontChooserDialog.this.sizeField.getDocument().removeDocumentListener(this);
                FontChooserDialog.this.sizeField.setText((String)FontChooserDialog.this.sizeList.getSelectedValue());
                FontChooserDialog.this.sizeField.getDocument().addDocumentListener(this);
                this.oldSizeListSelection = FontChooserDialog.this.sizeList.getSelectedIndex();
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            FontChooserDialog.this.updateFontSample();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            FontChooserDialog.this.fontList.removeListSelectionListener(this);
            FontChooserDialog.this.sizeList.removeListSelectionListener(this);
            FontChooserDialog.this.updateFontList();
            FontChooserDialog.this.updateSizeList();
            FontChooserDialog.this.fontList.addListSelectionListener(this);
            FontChooserDialog.this.sizeList.addListSelectionListener(this);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            FontChooserDialog.this.fontList.removeListSelectionListener(this);
            FontChooserDialog.this.sizeList.removeListSelectionListener(this);
            FontChooserDialog.this.updateFontList();
            FontChooserDialog.this.updateSizeList();
            FontChooserDialog.this.fontList.addListSelectionListener(this);
            FontChooserDialog.this.sizeList.addListSelectionListener(this);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            FontChooserDialog.this.fontList.removeListSelectionListener(this);
            FontChooserDialog.this.sizeList.removeListSelectionListener(this);
            FontChooserDialog.this.updateFontList();
            FontChooserDialog.this.updateSizeList();
            FontChooserDialog.this.fontList.addListSelectionListener(this);
            FontChooserDialog.this.sizeList.addListSelectionListener(this);
        }
    }
}

