/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.legacy.plugin;

import com.netscape.management.client.ResourceObject;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.legacy.plugin.LegacyAdminGroupNode;
import com.netscape.management.client.legacy.plugin.LegacyServerLocNode;
import com.netscape.management.client.legacy.plugin.LegacyServerNode;
import com.netscape.management.client.legacy.plugin.LegacyServiceLocator;
import com.netscape.management.client.topology.DomainNode;
import com.netscape.management.client.topology.ITopologyPlugin;
import com.netscape.management.client.topology.ServerLocNode;
import com.netscape.management.client.util.Debug;
import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;

public class LegacyPlugin
implements ITopologyPlugin {
    ConsoleInfo _consInfo;
    LDAPConnection _ldc;
    LegacyServiceLocator _sl;

    public void initialize(ConsoleInfo consoleInfo) {
        this._consInfo = consoleInfo;
        try {
            this._ldc = this._consInfo.getLDAPConnection();
            if (!this._ldc.isConnected()) {
                this._ldc.connect(this._consInfo.getHost(), this._consInfo.getPort(), this._consInfo.getAuthenticationDN(), this._consInfo.getAuthenticationPassword());
            }
        }
        catch (LDAPException lDAPException) {
            Debug.println("Cannot connect to: " + this._consInfo.getHost() + " " + this._consInfo.getAuthenticationDN());
        }
        this._sl = new LegacyServiceLocator(this._consInfo);
    }

    public Vector getTopNodes() {
        return null;
    }

    public Vector getAdditionalChildren(ResourceObject resourceObject) {
        String string = null;
        if (resourceObject instanceof DomainNode) {
            return null;
        }
        if (!(resourceObject instanceof ServerLocNode)) {
            return null;
        }
        string = ((ServerLocNode)resourceObject).getDN();
        Vector<LegacyAdminGroupNode> vector = new Vector<LegacyAdminGroupNode>();
        LDAPSearchResults lDAPSearchResults = this.getServiceLocator().getAdminGroup(string);
        if (lDAPSearchResults != null) {
            try {
                while (lDAPSearchResults.hasMoreElements()) {
                    LDAPEntry lDAPEntry = lDAPSearchResults.next();
                    LegacyAdminGroupNode legacyAdminGroupNode = new LegacyAdminGroupNode(this.getServiceLocator(), lDAPEntry);
                    legacyAdminGroupNode.reload();
                    vector.addElement(legacyAdminGroupNode);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return vector;
    }

    private LegacyServiceLocator getServiceLocator() {
        return this._sl;
    }

    public String getIDByResourceObject(ResourceObject resourceObject) {
        String string = null;
        if (resourceObject instanceof LegacyAdminGroupNode) {
            string = ((LegacyAdminGroupNode)resourceObject).getDN();
        } else if (resourceObject instanceof LegacyServerNode) {
            string = ((LegacyServerNode)resourceObject).getDN();
        }
        return string;
    }

    public ResourceObject getResourceObjectByID(String string) {
        LegacyServerLocNode legacyServerLocNode;
        block5: {
            legacyServerLocNode = null;
            try {
                LDAPConnection lDAPConnection = this._consInfo.getLDAPConnection();
                LDAPEntry lDAPEntry = lDAPConnection.read(string);
                if (lDAPEntry == null) break block5;
                LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("objectclass");
                Enumeration enumeration = lDAPAttribute.getStringValues();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    if (string2.equalsIgnoreCase("nsLegacyAdminGroup")) {
                        legacyServerLocNode = new LegacyAdminGroupNode(this.getServiceLocator(), lDAPEntry);
                    } else {
                        if (!string2.equalsIgnoreCase("nsLegacyServer")) continue;
                        legacyServerLocNode = new LegacyServerNode(this.getServiceLocator(), lDAPEntry);
                    }
                    break;
                }
            }
            catch (LDAPException lDAPException) {
                Debug.println("LegacyPlugin cannot create node for: " + string);
            }
        }
        return legacyServerLocNode;
    }
}

