/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.preferences;

import com.netscape.management.client.preferences.FilePreferenceManager;
import com.netscape.management.client.preferences.Preferences;
import com.netscape.management.client.util.Debug;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FilePreferences
extends Preferences {
    String _filename;

    public FilePreferences(String string) {
        this._filename = FilePreferenceManager.getHomePath() + "/" + string;
    }

    protected InputStream getInputStream() {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this._filename);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return fileInputStream;
    }

    protected OutputStream getOutputStream() {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this._filename);
        }
        catch (IOException iOException) {
            Debug.println("Cannot create preference file: " + this._filename);
        }
        return fileOutputStream;
    }

    public void clear() {
        super.clear();
    }

    public void delete() {
        File file = new File(this._filename);
        file.delete();
    }

    public static void main(String[] stringArray) {
        FilePreferences filePreferences = new FilePreferences("testPreferences");
        int n = filePreferences.getInt("integer", 0);
        Debug.println("read: " + n);
        boolean bl = filePreferences.getBoolean("boolean");
        Debug.println("read: " + bl);
        String string = filePreferences.getString("string", "A long string of a's...");
        Debug.println("read: " + string);
        filePreferences.set("integer", ++n);
        filePreferences.set("boolean", !bl);
        filePreferences.set("string", string + "a");
        filePreferences.save();
        System.exit(0);
    }
}

