/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.security;

import com.netscape.management.client.components.ErrorDialog;
import com.netscape.management.client.components.WizardDataCollectionModel;
import com.netscape.management.client.components.WizardPage;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.preferences.LDAPPreferences;
import com.netscape.management.client.preferences.Preferences;
import com.netscape.management.client.security.CertInstallWizard;
import com.netscape.management.client.security.CertificateList;
import com.netscape.management.client.security.KeyCertUtility;
import com.netscape.management.client.security.SecurityUtil;
import com.netscape.management.client.security.csr.ICAPlugin;
import com.netscape.management.client.util.AdmTask;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.GridBagUtil;
import com.netscape.management.client.util.JButtonFactory;
import com.netscape.management.client.util.LocalJarClassLoader;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class CertInstallCertPage
extends WizardPage
implements SuiConstants,
ActionListener,
DocumentListener {
    JRadioButton certInText;
    JRadioButton certInFile;
    JRadioButton certFromCAPlugin;
    JTextField certFilename = new JTextField();
    JTextArea certText = new JTextArea();
    JButton paste;
    JButton browse;
    ResourceSet resource;
    ICAPlugin ic;

    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument().equals(this.certFilename.getDocument()) || documentEvent.getDocument().equals(this.certText.getDocument())) {
            this.setEnableNextButton();
        }
    }

    void setEnableNextButton() {
        this.m_canMoveForward = this.certInFile.isSelected() && this.certFilename.getText().length() > 0 || this.certInText.isSelected() && this.certText.getText().length() > 0 || this.certFromCAPlugin.isSelected();
        ((WizardDataCollectionModel)this.getDataModel()).fireChangeEvent();
    }

    public boolean nextInvoked() {
        Object object;
        Serializable serializable;
        int n;
        boolean bl = true;
        if (this.certInText.isSelected()) {
            this.getDataModel().setValue("dercert", this.certText.getText());
        } else if (this.certFromCAPlugin.isSelected()) {
            n = this.ic.checkPendingRequest();
            Debug.println("Check request status:" + n);
            if (n == 2) {
                this.getDataModel().setValue("dercert", this.ic.getCertificateData());
            } else {
                if (n == 1) {
                    return false;
                }
                if (n == 0) {
                    return false;
                }
            }
        } else if (this.certInFile.isSelected()) {
            n = 0;
            try {
                serializable = new File(this.certFilename.getText());
                object = new RandomAccessFile((File)serializable, "rw");
                byte[] byArray = new byte[(int)((RandomAccessFile)object).length()];
                ((RandomAccessFile)object).readFully(byArray, 0, (int)((RandomAccessFile)object).length());
                String string = new String(byArray);
                if (string.indexOf("-----BEGIN CERTIFICATE-----") == -1 || string.indexOf("-----END CERTIFICATE-----") == -1) {
                    n = 1;
                }
                this.getDataModel().setValue("dercert", new String(byArray));
            }
            catch (Exception exception) {
                n = 1;
            }
            if (n != 0) {
                serializable = new ErrorDialog(null, this.resource.getString("CertInstallCertPage", "invalidFileTitle"), this.resource.getString("CertInstallCertPage", "invalidFileExplain"));
                ((ErrorDialog)serializable).hideDetail();
                ((Dialog)serializable).show();
                return false;
            }
        }
        try {
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("formop", "INSTALL_CERT");
            hashtable.put("sie", this.getDataModel().getValue("sie"));
            hashtable.put("tokenname", this.getDataModel().getValue("tokenname"));
            hashtable.put("dercert", this.getDataModel().getValue("dercert"));
            hashtable.put("certtype", this.getDataModel().getValue("certtype"));
            hashtable.put("trust_flag", "0");
            serializable = (ConsoleInfo)this.getDataModel().getValue("consoleInfo");
            object = new AdmTask(new URL(serializable.getAdminURL() + "admin-serv/tasks/configuration/SecurityOp"), serializable.getAuthenticationDN(), serializable.getAuthenticationPassword());
            ((AdmTask)object).setArguments(hashtable);
            ((AdmTask)object).exec();
            Debug.println(((AdmTask)object).getResultString().toString());
            if (!SecurityUtil.showError((AdmTask)object)) {
                this.getDataModel().setValue("certlist", new CertificateList(((AdmTask)object).getResultString().toString()));
            } else {
                bl = false;
            }
        }
        catch (Exception exception) {
            SecurityUtil.printException("CertInstallCertPage::nextInvoked()", exception);
            bl = false;
        }
        return bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("PASTE")) {
            this.certText.paste();
        } else if (actionEvent.getActionCommand().equals("BROWSE")) {
            JFileChooser jFileChooser = new JFileChooser();
            if (jFileChooser.showOpenDialog(this) == 0) {
                try {
                    this.certFilename.setText(jFileChooser.getSelectedFile().getCanonicalPath());
                    this.validate();
                    this.repaint();
                }
                catch (Exception exception) {
                    SecurityUtil.printException("CertInstallCertPage::actionPerformed(...)", exception);
                }
            }
        } else if (actionEvent.getSource().equals(this.certFromCAPlugin)) {
            this.certText.setEnabled(false);
            this.certFilename.setEnabled(false);
            this.setEnableNextButton();
        } else if (actionEvent.getSource().equals(this.certInFile)) {
            this.certFilename.setEnabled(true);
            this.certText.setEnabled(false);
            this.setEnableNextButton();
        } else if (actionEvent.getSource().equals(this.certInText)) {
            this.certFilename.setEnabled(false);
            this.certText.setEnabled(true);
            this.setEnableNextButton();
        }
    }

    public void pageShown() {
        if (this.getDataModel().getValue("certtype").equals(Integer.toString(CertInstallWizard.CA))) {
            this.certFromCAPlugin.setEnabled(false);
        }
    }

    public void helpInvoked() {
        KeyCertUtility.getHelp().contextHelp("CertInstallCertPage", "help");
    }

    public CertInstallCertPage(ConsoleInfo consoleInfo) {
        super(KeyCertUtility.getResourceSet().getString("CertInstallCertPage", "pageTitle"));
        Object object;
        Object object2;
        Serializable serializable;
        Object object3;
        this.setLayout(new GridBagLayout());
        this.resource = KeyCertUtility.getResourceSet();
        String string = this.resource.getString("CertInstallCertPage", "certFromCAPluginLabel");
        this.certFromCAPlugin = new JRadioButton("", false);
        this.certFromCAPlugin.setText(string);
        this.certFromCAPlugin.addActionListener(this);
        try {
            object3 = consoleInfo.getLDAPConnection().search("cn=LiveSession, cn=CSRSession," + consoleInfo.getCurrentDN(), 2, "(objectclass=*)", null, false);
            if (object3.hasMoreElements()) {
                serializable = new LDAPPreferences(consoleInfo.getLDAPConnection(), "LiveSessionPluginJar", "cn=CSRSession," + consoleInfo.getCurrentDN());
                String string2 = ((Preferences)serializable).getString("jarname");
                object2 = new JarFile(string2);
                object = ((JarFile)object2).getManifest();
                Map<String, Attributes> map = ((Manifest)object).getEntries();
                Set<String> set = ((Manifest)object).getEntries().keySet();
                Iterator<String> iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string3 = iterator.next();
                    Attributes attributes = ((Manifest)object).getAttributes(string3);
                    this.certFromCAPlugin.setText(string + " " + attributes.getValue("Description"));
                    try {
                        Debug.println("Loading plugin");
                        LocalJarClassLoader localJarClassLoader = new LocalJarClassLoader(string2);
                        Class clazz = localJarClassLoader.loadClass(string3.substring(0, string3.indexOf(".class")));
                        this.ic = (ICAPlugin)clazz.newInstance();
                        serializable = new LDAPPreferences(consoleInfo.getLDAPConnection(), "LiveSession", "cn=CSRSession," + consoleInfo.getCurrentDN());
                        Debug.println("Restore session data");
                        Enumeration enumeration = ((Preferences)serializable).getNames();
                        while (enumeration.hasMoreElements()) {
                            String string4 = enumeration.nextElement().toString();
                            this.ic.setProperty(string4, ((Preferences)serializable).getString(string4));
                        }
                    }
                    catch (Exception exception) {
                        SecurityUtil.printException("CertInstallCertPage::CertInstallCertPage(...)", exception);
                        Debug.println("CertInstallCertPage: unable to restore session data");
                    }
                }
            } else {
                this.certFromCAPlugin.setEnabled(false);
            }
        }
        catch (Exception exception) {
            Debug.println("CertInstallCertPage: error in retriving session data");
            this.certFromCAPlugin.setEnabled(false);
        }
        this.certInFile = new JRadioButton(this.resource.getString("CertInstallCertPage", "certInFileLabel"), false);
        this.certInFile.addActionListener(this);
        this.certInText = new JRadioButton(this.resource.getString("CertInstallCertPage", "certInTextLabel"), true);
        this.certInText.addActionListener(this);
        object3 = new ButtonGroup();
        ((ButtonGroup)object3).add(this.certFromCAPlugin);
        ((ButtonGroup)object3).add(this.certInFile);
        ((ButtonGroup)object3).add(this.certInText);
        this.browse = JButtonFactory.create(this.resource.getString("CertInstallCertPage", "browseLabel"), this, "BROWSE");
        this.browse.setToolTipText(this.resource.getString("CertInstallCertPage", "browse_tt"));
        this.paste = JButtonFactory.create(this.resource.getString("CertInstallCertPage", "pasteFromClipboardLabel"), this, "PASTE");
        this.paste.setToolTipText(this.resource.getString("CertInstallCertPage", "pasteFromClipboard_tt"));
        serializable = new JLabel(this.resource.getString("CertInstallCertPage", "whereIsCert"));
        this.certText.getDocument().addDocumentListener(this);
        this.certFilename.getDocument().addDocumentListener(this);
        int n = 0;
        GridBagUtil.constrain(this, (Component)serializable, 0, ++n, 3, 1, 1.0, 0.0, 17, 2, 0, 0, 6, 0);
        GridBagUtil.constrain(this, this.certFromCAPlugin, 0, ++n, 3, 1, 1.0, 0.0, 11, 2, 0, 0, 6, 0);
        object2 = new JPanel();
        ((Container)object2).setLayout(new GridBagLayout());
        GridBagUtil.constrain((Container)object2, this.certInFile, 0, 0, 1, 1, 0.0, 0.0, 17, 0, 0, 0, 0, 0);
        GridBagUtil.constrain((Container)object2, this.certFilename, 1, 0, 1, 1, 1.0, 0.0, 17, 2, 0, 0, 0, 6);
        GridBagUtil.constrain((Container)object2, this.browse, 2, 0, 1, 1, 0.0, 0.0, 13, 0, 0, 0, 0, 0);
        GridBagUtil.constrain(this, (Component)object2, 0, ++n, 3, 1, 1.0, 0.0, 13, 1, 0, 0, 6, 0);
        GridBagUtil.constrain(this, this.certInText, 0, ++n, 2, 1, 1.0, 0.0, 11, 2, 0, 0, 6, 6);
        GridBagUtil.constrain(this, this.paste, 2, n, 1, 1, 0.0, 0.0, 13, 0, 0, 0, 6, 0);
        object = new JScrollPane(this.certText, 20, 30);
        ((JComponent)object).setBorder(UIManager.getBorder("TextField"));
        GridBagUtil.constrain(this, (Component)object, 0, ++n, 3, 1, 1.0, 1.0, 17, 1, 0, 0, 0, 0);
        this.certFilename.getAccessibleContext().setAccessibleDescription(this.resource.getString("CertInstallCertPage", "certInFile_tt"));
        this.certText.getAccessibleContext().setAccessibleDescription(this.resource.getString("CertInstallCertPage", "certInText_tt"));
    }
}

