/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.security;

import com.netscape.management.client.components.IDataCollectionModel;
import com.netscape.management.client.components.IWizardSequenceManager;
import com.netscape.management.client.components.Wizard;
import com.netscape.management.client.components.WizardDataCollectionModel;
import com.netscape.management.client.components.WizardPage;
import com.netscape.management.client.components.WizardSequenceManager;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.security.CertInstallCertInfoPage;
import com.netscape.management.client.security.CertInstallCertNamePage;
import com.netscape.management.client.security.CertInstallCertPage;
import com.netscape.management.client.security.CertInstallSetTrustPage;
import com.netscape.management.client.security.CertificateList;
import com.netscape.management.client.security.KeyCertUtility;
import com.netscape.management.client.security.SecurityUtil;
import com.netscape.management.client.security.TokenPasswordPage;
import com.netscape.management.client.util.AdmTask;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.GridBagUtil;
import com.netscape.management.client.util.ModalDialogUtil;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.net.URL;
import java.util.Hashtable;

public class CertInstallWizard {
    Wizard wizardDialog;
    IWizardSequenceManager sequenceManager = new WizardSequenceManager();
    IDataCollectionModel dataCollectionModel = new WizardDataCollectionModel();
    public static int SERVER = 0;
    public static int CA = 1;

    public CertInstallWizard(Component component, ConsoleInfo consoleInfo, String string, String string2, int n, String string3) {
        this.wizardDialog = new Wizard(component instanceof Frame ? (Frame)component : null, KeyCertUtility.getResourceSet().getString("CertInstallWizard", "title"), true, this.sequenceManager, this.dataCollectionModel);
        if (component != null) {
            this.wizardDialog.setLocationRelativeTo(component);
        }
        this.dataCollectionModel.setValue("tokenname", string2);
        this.dataCollectionModel.setValue("sie", string.toLowerCase());
        this.dataCollectionModel.setValue("consoleInfo", consoleInfo);
        this.dataCollectionModel.setValue("certtype", Integer.toString(n));
        if (string3.length() > 0) {
            this.dataCollectionModel.setValue("certname", string3);
        }
        try {
            this.wizardDialog.addPage("CertInstallCertPage", new CertInstallCertPage(consoleInfo));
            this.wizardDialog.addPage("CertInstallCertInfoPage", new CertInstallCertInfoPage());
            this.wizardDialog.addPage("CertInstallCertNamePage", new CertInstallCertNamePage());
            if (n == SERVER) {
                this.wizardDialog.addPage("TrustDBPasswordPage", new TokenPwdPage());
            } else if (n == CA) {
                this.wizardDialog.addPage("CertInstallSetTrustPage", new CertInstallSetTrustPage());
            }
        }
        catch (Exception exception) {
            SecurityUtil.printException("CertInstallWizard::CertInstallWizard(...)", exception);
        }
        ((Component)this.wizardDialog).setSize(500, 350);
        if (!(component instanceof Frame)) {
            ModalDialogUtil.setDialogLocation(this.wizardDialog, component);
        }
    }

    public CertInstallWizard(Component component, ConsoleInfo consoleInfo, String string, String string2, int n) {
        this(component, consoleInfo, string, string2, n, "");
    }

    public void setVisible(boolean bl) {
        ((Component)this.wizardDialog).setVisible(bl);
    }

    class TokenPwdPage
    extends WizardPage {
        TokenPasswordPage pwdPage;

        public TokenPwdPage() {
            super(KeyCertUtility.getResourceSet().getString("TokenPasswordPage", "pageTitle"));
            this.pwdPage = new TokenPasswordPage(CertInstallWizard.this.dataCollectionModel);
            this.setLayout(new GridBagLayout());
            GridBagUtil.constrain(this, this.pwdPage, 0, 0, 1, 1, 1.0, 1.0, 11, 1, 0, 0, 0, 0);
        }

        public boolean canMoveForward() {
            return this.pwdPage.isPageValidated();
        }

        public void helpInvoked() {
            KeyCertUtility.getHelp().contextHelp("TokenPasswordPage", "help");
        }

        public boolean nextInvoked() {
            boolean bl = false;
            try {
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                hashtable.put("formop", "INSTALL_CERT");
                hashtable.put("installmethod", "1");
                hashtable.put("sie", CertInstallWizard.this.dataCollectionModel.getValue("sie"));
                hashtable.put("tokenname", CertInstallWizard.this.dataCollectionModel.getValue("tokenname"));
                hashtable.put("dercert", CertInstallWizard.this.dataCollectionModel.getValue("dercert"));
                hashtable.put("certtype", CertInstallWizard.this.dataCollectionModel.getValue("certtype"));
                hashtable.put("keypwd", CertInstallWizard.this.dataCollectionModel.getValue("keypwd"));
                hashtable.put("certname", CertInstallWizard.this.dataCollectionModel.getValue("certname"));
                hashtable.put("trust_flag", "0");
                ConsoleInfo consoleInfo = (ConsoleInfo)CertInstallWizard.this.dataCollectionModel.getValue("consoleInfo");
                AdmTask admTask = new AdmTask(new URL(consoleInfo.getAdminURL() + "admin-serv/tasks/configuration/SecurityOp"), consoleInfo.getAuthenticationDN(), consoleInfo.getAuthenticationPassword());
                admTask.setArguments(hashtable);
                admTask.exec();
                Debug.println(admTask.getResultString().toString());
                if (!SecurityUtil.showError(admTask)) {
                    CertInstallWizard.this.dataCollectionModel.setValue("certlist", new CertificateList(admTask.getResultString().toString()));
                    bl = true;
                }
            }
            catch (Exception exception) {
                SecurityUtil.printException("CertInstallWizard::nextInvoked()", exception);
            }
            return bl;
        }
    }
}

