/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.security;

import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.security.EncryptionOptions;
import com.netscape.management.client.security.IEncryptionOptions;
import com.netscape.management.client.security.Parser;
import com.netscape.management.client.security.SecurityUtil;
import com.netscape.management.client.util.AdmTask;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.GridBagUtil;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.plaf.BorderUIResource;

public class EncryptionPanel
extends JPanel {
    JCheckBox securityEnabled;
    ConsoleInfo _consoleInfo;
    String _sie;
    Hashtable cipherFamilyList = new Hashtable();
    ResourceSet resource = new ResourceSet("com.netscape.management.client.security.securityResource");
    boolean setupComplete = false;
    IEncryptionOptions _encryptionOptions;
    Vector settings = new Vector();
    boolean initialSecurityEnabled;

    public void reset() {
        int n = 0;
        while (n < this.settings.size()) {
            ((CipherFamilyPane)this.settings.elementAt(n)).reset();
            ++n;
        }
        this.securityEnabled.setSelected(this.initialSecurityEnabled);
        this.enableAllCipherFamily(this.securityEnabled.isSelected());
    }

    public void setSaved() {
        int n = 0;
        while (n < this.settings.size()) {
            ((CipherFamilyPane)this.settings.elementAt(n)).setSaved();
            ++n;
        }
        this.initialSecurityEnabled = this.securityEnabled.isSelected();
        this.enableAllCipherFamily(this.securityEnabled.isSelected());
    }

    private void enableAllCipherFamily(boolean bl) {
        int n = 0;
        while (n < this.settings.size()) {
            ((CipherFamilyPane)this.settings.elementAt(n)).setEnabled(bl);
            ++n;
        }
    }

    public EncryptionPanel(ConsoleInfo consoleInfo, String string, EncryptionOptions encryptionOptions) {
        this(consoleInfo, string, (IEncryptionOptions)encryptionOptions);
    }

    public EncryptionPanel(ConsoleInfo consoleInfo, String string, IEncryptionOptions iEncryptionOptions) {
        this.setLayout(new GridBagLayout());
        this._consoleInfo = consoleInfo;
        this._sie = string;
        this._encryptionOptions = iEncryptionOptions;
        this.securityEnabled = new JCheckBox(this.resource.getString("EncryptionPanel", "sslEnabledLabel"));
        this.securityEnabled.setSelected(this._encryptionOptions.isSecurityEnabled());
        this.securityEnabled.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (EncryptionPanel.this.setupComplete) {
                    EncryptionPanel.this._encryptionOptions.securityEnabledChanged(EncryptionPanel.this.securityEnabled.isSelected());
                }
                EncryptionPanel.this.enableAllCipherFamily(EncryptionPanel.this.securityEnabled.isSelected());
            }
        });
        int n = 0;
        GridBagUtil.constrain(this, this.securityEnabled, 0, n, 1, 1, 1.0, 0.0, 11, 2, 0, 8, 0, 0);
        try {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("formop", "LIST_TOKEN");
            hashtable.put("sie", (String)(string == null ? consoleInfo.get("SIE") : string));
            AdmTask admTask = new AdmTask(new URL(consoleInfo.getAdminURL() + "admin-serv/tasks/configuration/SecurityOp"), consoleInfo.getAuthenticationDN(), consoleInfo.getAuthenticationPassword());
            admTask.setArguments(hashtable);
            admTask.exec();
            Debug.println(admTask.getResultString().toString());
            if (!SecurityUtil.showError(admTask)) {
                Parser parser = new Parser(admTask.getResultString().toString());
                Hashtable hashtable2 = new Hashtable();
                while (parser.hasMoreElement()) {
                    String string2 = parser.nextToken();
                    if (!string2.equals("<TOKENLIST>")) continue;
                    hashtable2 = parser.getTokenObject(string2);
                    break;
                }
                Enumeration enumeration = hashtable2.keys();
                while (enumeration.hasMoreElements()) {
                    Hashtable hashtable3;
                    String string3 = (String)enumeration.nextElement();
                    if (string3.endsWith("_TOKEN")) {
                        hashtable3 = (Hashtable)hashtable2.get(string3);
                        CipherFamilyPane cipherFamilyPane = new CipherFamilyPane(string3.substring(0, string3.indexOf("_TOKEN")), hashtable3);
                        this.cipherFamilyList.put(string3.substring(0, string3.indexOf("_TOKEN")), cipherFamilyPane);
                        this.settings.addElement(cipherFamilyPane);
                        GridBagUtil.constrain(this, cipherFamilyPane, 0, ++n, 1, 1, 1.0, 0.0, 18, 2, 0, 0, 6, 0);
                    } else if (string3.equals("SECURITY")) {
                        hashtable3 = hashtable2.get("SECURITY");
                        this._encryptionOptions.setSecurityIsDomestic(hashtable3 != null && ((Object)hashtable3).equals("domestic"));
                    }
                    this.setSaved();
                }
            }
        }
        catch (Exception exception) {
            SecurityUtil.printException("EncryptionPanel::EncryptionPanel(...)", exception);
        }
    }

    class ToggleBorder
    extends EtchedBorder {
        private JComponent _switchPanel;
        private int _switchAlign;

        public ToggleBorder(JComponent jComponent, int n) {
            this._switchPanel = jComponent;
            this._switchAlign = n;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            int n5 = n2 + (this._switchPanel.getHeight() >> 1);
            int n6 = n4 - n5;
            BorderUIResource.getEtchedBorderUIResource().paintBorder(component, graphics, n, n5, n3, n6);
        }
    }

    class CipherFamilyPane
    extends JPanel {
        JCheckBox on;
        JComboBox device;
        JComboBox cert;
        String _cipherFamily;
        Hashtable _secDevice;
        JButton cipherButton;
        boolean initialOn;
        Object initialDevice;
        Object initialCert;

        public void reset() {
            Debug.println("Reset:" + (this.initialOn ? "on" : "off") + " : " + this.initialDevice + " : " + this.initialCert);
            this.on.setSelected(this.initialOn);
            this.device.setSelectedItem(this.initialDevice);
            this.cert.setSelectedItem(this.initialCert);
        }

        public void setEnabled(boolean bl) {
            this.on.setEnabled(bl);
            this.device.setEnabled(bl);
            this.cert.setEnabled(bl);
            this.cipherButton.setEnabled(bl);
        }

        public void setSaved() {
            Debug.println("Initialize reset value:" + (this.initialOn ? "on" : "off") + " : " + this.initialDevice + " : " + this.initialCert);
            this.initialOn = this.on.isSelected();
            this.initialDevice = this.device.getSelectedItem();
            this.initialCert = this.cert.getSelectedItem();
        }

        public CipherFamilyPane(String string, Hashtable hashtable) {
            this.setLayout(new GridBagLayout());
            this._cipherFamily = string;
            this._secDevice = hashtable;
            this.on = new JCheckBox(EncryptionPanel.this.resource.getString("EncryptionPanel", "enableCipherFamilyLabel") + " " + this._cipherFamily);
            this.on.addActionListener(new ActionListener(this){
                private final /* synthetic */ CipherFamilyPane this$1;
                {
                    this.this$1 = cipherFamilyPane;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (CipherFamilyPane.access$100((CipherFamilyPane)this.this$1).setupComplete) {
                        CipherFamilyPane.access$100((CipherFamilyPane)this.this$1)._encryptionOptions.cipherFamilyEnabledChanged(this.this$1._cipherFamily, this.this$1.on.isSelected());
                    }
                }
            });
            this.on.setSelected(EncryptionPanel.this._encryptionOptions.isCipherFamilyEnabled(this._cipherFamily));
            JPanel jPanel = new JPanel();
            jPanel.setAlignmentX(0.0f);
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.add(this.on);
            CompoundBorder compoundBorder = new CompoundBorder(new ToggleBorder(jPanel, 1), new EmptyBorder(0, 6, 6, 6));
            this.setBorder(compoundBorder);
            GridBagUtil.constrain(this, jPanel, 0, 0, 1, 1, 0.0, 0.0, 18, 0, 0, 0, 0, 0);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new GridBagLayout());
            JLabel jLabel = new JLabel(EncryptionPanel.this.resource.getString("EncryptionPanel", "securityDeviceLabel"), 2);
            JLabel jLabel2 = new JLabel(EncryptionPanel.this.resource.getString("EncryptionPanel", "certificateLabel"), 2);
            JLabel jLabel3 = new JLabel(EncryptionPanel.this.resource.getString("EncryptionPanel", "cipherLabel"), 2);
            this.cert = new JComboBox();
            jLabel2.setLabelFor(this.cert);
            this.cert.setActionCommand("EVENT_HANDLE_ENABLED");
            this.cert.addActionListener(new ActionListener(this){
                private final /* synthetic */ CipherFamilyPane this$1;
                {
                    this.this$1 = cipherFamilyPane;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Object object = this.this$1.cert.getSelectedItem();
                    if (CipherFamilyPane.access$100((CipherFamilyPane)this.this$1).setupComplete && actionEvent.getActionCommand().equals("EVENT_HANDLE_ENABLED")) {
                        CipherFamilyPane.access$100((CipherFamilyPane)this.this$1)._encryptionOptions.selectedCertificateChanged(this.this$1._cipherFamily, object == null ? "" : object.toString());
                    }
                }
            });
            Enumeration enumeration = hashtable.keys();
            Vector vector = new Vector();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
            this.device = new JComboBox(vector);
            jLabel.setLabelFor(this.device);
            this.device.addActionListener(new ActionListener(this){
                private final /* synthetic */ CipherFamilyPane this$1;
                {
                    this.this$1 = cipherFamilyPane;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    Object object = this.this$1.device.getSelectedItem();
                    if (CipherFamilyPane.access$100((CipherFamilyPane)this.this$1).setupComplete) {
                        CipherFamilyPane.access$100((CipherFamilyPane)this.this$1)._encryptionOptions.selectedDeviceChanged(this.this$1._cipherFamily, object == null ? "" : object.toString());
                    }
                    try {
                        String string;
                        this.this$1.cert.setActionCommand("EVENT_HANDLE_DISABLED");
                        this.this$1.cert.removeAllItems();
                        Hashtable hashtable = (Hashtable)this.this$1._secDevice.get((String)this.this$1.device.getSelectedItem());
                        Enumeration<K> enumeration = hashtable.keys();
                        while (enumeration.hasMoreElements()) {
                            string = (String)enumeration.nextElement();
                            if (!string.startsWith("CERT")) continue;
                            this.this$1.cert.addItem((String)hashtable.get(string));
                        }
                        this.this$1.cert.validate();
                        this.this$1.cert.repaint();
                        string = CipherFamilyPane.access$100((CipherFamilyPane)this.this$1)._encryptionOptions.getSelectedCertificate(this.this$1._cipherFamily);
                        this.this$1.cert.setSelectedItem(string == null ? "" : string);
                        if (string == null || string.toString().length() == 0) {
                            CipherFamilyPane.access$100((CipherFamilyPane)this.this$1)._encryptionOptions.selectedCertificateChanged(this.this$1._cipherFamily, this.this$1.cert.getSelectedItem().toString());
                        }
                        this.this$1.cert.setActionCommand("EVENT_HANDLE_ENABLED");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            try {
                String string2 = EncryptionPanel.this._encryptionOptions.getSelectedDevice(this._cipherFamily);
                this.device.setSelectedItem(string2 == null ? "" : string2);
                if (string2 == null || string2.toString().length() == 0) {
                    EncryptionPanel.this._encryptionOptions.selectedDeviceChanged(this._cipherFamily, this.device.getSelectedItem().toString());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.cipherButton = new JButton(EncryptionPanel.this.resource.getString("EncryptionPanel", "settingsLabel"));
            this.cipherButton.setToolTipText(EncryptionPanel.this.resource.getString("EncryptionPanel", "settings_tt"));
            this.cipherButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ CipherFamilyPane this$1;
                {
                    this.this$1 = cipherFamilyPane;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    CipherFamilyPane.access$100((CipherFamilyPane)this.this$1)._encryptionOptions.showCipherPreferenceDialog(this.this$1._cipherFamily);
                }
            });
            int n = 1;
            GridBagUtil.constrain(jPanel2, jLabel, 0, n, 1, 1, 0.0, 0.0, 13, 0, 0, 0, 6, 0);
            GridBagUtil.constrain(jPanel2, this.device, 1, n, 1, 1, 1.0, 1.0, 17, 2, 0, 6, 6, 0);
            GridBagUtil.constrain(jPanel2, jLabel2, 0, ++n, 1, 1, 0.0, 1.0, 13, 0, 0, 0, 6, 0);
            GridBagUtil.constrain(jPanel2, this.cert, 1, n, 1, 1, 1.0, 1.0, 17, 2, 0, 6, 6, 0);
            GridBagUtil.constrain(jPanel2, jLabel3, 0, ++n, 1, 1, 0.0, 0.0, 13, 0, 0, 0, 0, 0);
            GridBagUtil.constrain(jPanel2, this.cipherButton, 1, n, 1, 1, 0.0, 0.0, 17, 0, 0, 6, 0, 0);
            GridBagUtil.constrain(this, jPanel2, 0, 1, 1, 1, 1.0, 1.0, 17, 1, 0, 6, 0, 0);
            EncryptionPanel.this.setupComplete = true;
        }

        static /* synthetic */ EncryptionPanel access$100(CipherFamilyPane cipherFamilyPane) {
            return cipherFamilyPane.EncryptionPanel.this;
        }
    }
}

