/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.security;

import com.netscape.management.client.security.SecurityUtil;
import com.netscape.management.client.security.ViewCertificateDialog;
import com.netscape.management.client.util.AbstractDialog;
import com.netscape.management.client.util.Browser;
import com.netscape.management.client.util.GridBagUtil;
import com.netscape.management.client.util.JButtonFactory;
import com.netscape.management.client.util.ModalDialogUtil;
import com.netscape.management.client.util.MultilineLabel;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.nmclf.SuiConstants;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.security.cert.X509Certificate;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;

public class PromptForTrustDialog
extends AbstractDialog
implements SuiConstants {
    private static boolean certIsAccepted = false;
    private static boolean acceptedForSingleSession = false;
    private UserConfirmationActionListener buttonActionListener = new UserConfirmationActionListener();
    static ResourceSet _resource = new ResourceSet("com.netscape.management.client.security.ServerAuthResource");
    ViewCertificateDialog viewCertDialog;
    JCheckBox oneSession;
    JButton accept;

    public PromptForTrustDialog(Frame frame, X509Certificate x509Certificate, SSLCertificateApprovalCallback.ValidityStatus validityStatus) {
        super(frame, "", true);
        this.setTitle(_resource.getString("PromptForTrustDialog", "title"));
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagUtil.constrain(this.getContentPane(), this.createActionButtons(), 0, 1, 1, 1, 0.0, 0.0, 14, 0, 0, 0, 0, 0);
        GridBagUtil.constrain(this.getContentPane(), this.siteAlert(), 0, 0, 1, 1, 1.0, 1.0, 11, 1, 9, 9, 0, 0);
        this.viewCertDialog = new ViewCertificateDialog(frame, x509Certificate, validityStatus);
        this.setMinimumSize(400, 250);
        if (frame == null) {
            ModalDialogUtil.setCenteredDialog(this);
        }
        this.pack();
    }

    public boolean isCertAccepted() {
        return certIsAccepted;
    }

    public boolean isAcceptedForOneSession() {
        return this.oneSession.isSelected();
    }

    public void setCertificateInfo(X509Certificate x509Certificate, SSLCertificateApprovalCallback.ValidityStatus validityStatus) {
        this.viewCertDialog.setCertificate(x509Certificate, validityStatus);
    }

    private JPanel siteAlert() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(UIManager.getIcon("OptionPane.warningIcon"));
        MultilineLabel multilineLabel = new MultilineLabel(_resource.getString("PromptForTrustDialog", "warningMessage"));
        this.oneSession = new JCheckBox(_resource.getString("PromptForTrustDialog", "acceptForOneSession"));
        GridBagUtil.constrain(jPanel, jLabel, 0, 0, 1, 1, 0.0, 0.0, 18, 0, 0, 0, 0, 9);
        GridBagUtil.constrain(jPanel, multilineLabel, 1, 0, 1, 1, 1.0, 0.0, 18, 1, 0, 0, 9, 9);
        GridBagUtil.constrain(jPanel, this.oneSession, 1, 1, 1, 1, 0.0, 0.0, 16, 0, 0, 0, 0, 9);
        GridBagUtil.constrain(jPanel, Box.createVerticalGlue(), 1, 2, 2, 1, 1.0, 1.0, 11, 1, 0, 0, 0, 0);
        return jPanel;
    }

    public void setVisible(boolean bl) {
        this.accept.grabFocus();
        super.setVisible(bl);
    }

    private JPanel createActionButtons() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.accept = JButtonFactory.create(_resource.getString("PromptForTrustDialog", "accept"), this.buttonActionListener, "ACCEPT");
        this.accept.setToolTipText(_resource.getString("PromptForTrustDialog", "accept_tt"));
        this.accept.registerKeyboardAction(this.buttonActionListener, "ACCEPT", KeyStroke.getKeyStroke(10, 0), 2);
        JButton jButton = JButtonFactory.create(_resource.getString("PromptForTrustDialog", "reject"), this.buttonActionListener, "REJECT");
        jButton.setToolTipText(_resource.getString("PromptForTrustDialog", "reject_tt"));
        jButton.registerKeyboardAction(this.buttonActionListener, "REJECT", KeyStroke.getKeyStroke(82, 0), 2);
        JButton jButton2 = JButtonFactory.create(_resource.getString("PromptForTrustDialog", "viewCert"), this.buttonActionListener, "VIEWCERT");
        jButton2.registerKeyboardAction(this.buttonActionListener, "VIEWCERT", KeyStroke.getKeyStroke(86, 0), 2);
        jButton2.setToolTipText(_resource.getString("PromptForTrustDialog", "viewCert_tt"));
        JButton jButton3 = JButtonFactory.createHelpButton(this.buttonActionListener);
        JButtonFactory.resizeGroup(this.accept, jButton, jButton3);
        int n = 0;
        GridBagUtil.constrain(jPanel, this.accept, n, 0, 1, 1, 0.0, 0.0, 11, 1, 9, 0, 0, 6);
        GridBagUtil.constrain(jPanel, jButton, ++n, 0, 1, 1, 0.0, 0.0, 11, 1, 9, 0, 0, 6);
        GridBagUtil.constrain(jPanel, jButton2, ++n, 0, 1, 1, 0.0, 0.0, 11, 1, 9, 0, 0, 9);
        GridBagUtil.constrain(jPanel, jButton3, ++n, 0, 1, 1, 0.0, 0.0, 11, 1, 9, 0, 0, 0);
        return jPanel;
    }

    class UserConfirmationActionListener
    implements ActionListener {
        UserConfirmationActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            if (actionEvent.getActionCommand().equals("ACCEPT")) {
                certIsAccepted = true;
                PromptForTrustDialog.this.setVisible(false);
            } else if (actionEvent.getActionCommand().equals("REJECT")) {
                certIsAccepted = false;
                PromptForTrustDialog.this.setVisible(false);
            } else if (actionEvent.getActionCommand().equals("VIEWCERT")) {
                PromptForTrustDialog.this.viewCertDialog.show();
            } else if (actionEvent.getActionCommand().equals("HELP") && (string = _resource.getString("PromptForTrustDialog", "help")).length() > 0) {
                File file = new File("..");
                try {
                    URL uRL = file.toURL();
                    Browser browser = new Browser();
                    browser.open(uRL.toString() + string, 4);
                }
                catch (Exception exception) {
                    SecurityUtil.printException("PromptForTrustDialog", exception);
                }
            }
        }
    }
}

